package com.tydic.dyc.oc.service.importorder.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 标题：UocImportOrderAddReqBo
 * 描述：导入订单记录新增入参
 */
@Data
public class UocImportOrderAddReqBo extends BaseReqBo {

    private static final long serialVersionUID = -7303508750972586277L;

    /**
     * 用户Id
     */
    private Long userId;

    /**
     * 用户名称
     */
    private String name;

    /**
     * 机构ID
     */
    private Long orgId;

    /**
     * 机构名称
     */
    private String orgName;

    /**
     * 机构树路径
     */
    private String orgPath;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 公司名称
     */
    private String companyName;

    /*----------------------------------------------------------------------------------------------------*/

    /**
     * 记录ID
     */
    private Long importOrderId;

    /**
     * 附件名称
     */
    private String accessoryName;

    /**
     * 附件链接
     */
    private String accessoryUrl;

    /**
     * 状态 1入库 2执行中 3待下单 4已下单
     */
    private Integer status;

    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 销售单ID
     */
    private Long saleOrderId;

    /**
     * 商品总金额
     */
    private BigDecimal totalGoodsFee;

    /**
     * 总运费
     */
    private BigDecimal totalTransFee;

    /**
     * 总金额
     */
    private BigDecimal totalFee;

    /**
     * 失败描述
     */
    private String failReason;

    /**
     * 备注
     */
    private String remark;

    /**
     * 导入订单记录明细集合
     */
    private List<UocImportOrderItemBo> importOrderItemList;

}


