package com.tydic.dyc.oc.service.order.bo;

import com.tydic.dyc.oc.service.common.bo.UocBaseExtCrossBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：
 *
 * @author tgy
 * @date 2022/2/14 13:40
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocGetOrderAllDetailServiceRspOrderCommInfoBo implements Serializable {

    private static final long serialVersionUID = -3959323768802083281L;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 订单id
     */
    private Long saleOrderId;

    /**
     * 商品id
     */
    private String commodityId;

    /**
     * 商品名称
     */
    private String commodityName;

    /**
     * 商品类型ID
     */
    private String commodityTypeId;

    /**
     * 商品类型名称
     */
    private String commodityTypeName;

    /**
     * 外部单品ID
     */
    private String skuExtSkuId;

    /**
     * 单品ID
     */
    private String skuId;

    /**
     * 单品名称
     */
    private String skuName;

    /**
     * 供应商ID
     */
    private String supplierId;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 店铺ID
     */
    private String supplierShopId;

    /**
     * 店铺名称
     */
    private String supplierShopName;

    /**
     * 采购价
     */
    private String purPrice;

    /**
     * 销售价
     */
    private String salePrice;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建工号
     */
    private String createOperId;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新工号
     */
    private String updateOperId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 供应商编码
     */
    private String supNo;

    /**
     * 供应商名称
     */
    private String supName;

    /**
     * 供应商账户名称
     */
    private String supAccountName;

    /**
     * 供应商账户
     */
    private String supAccount;

    /**
     * 供应商账户持有人编码
     */
    private String supAccountOwnId;

    /**
     * 供应商账户持有人名称
     */
    private String supAccountOwnName;

    /**
     * 供应商联系人
     */
    private String supRelaName;

    /**
     * 供应商联系电话
     */
    private String supRelaMobile;

    /**
     * 专业机构编码
     */
    private String proNo;

    /**
     * 专业机构名称
     */
    private String proName;

    /**
     * 专业机构账户
     */
    private String proAccountName;

    /**
     * 专业机构账户
     */
    private String proAccount;

    /**
     * 专业机构账户持有人编码
     */
    private String proAccountOwnId;

    /**
     * 专业机构账户持有人名称
     */
    private String proAccountOwnName;

    /**
     * 专业机构联系人
     */
    private String proRelaName;

    /**
     * 专业机构联系电话
     */
    private String proRelaMobile;

    /**
     * 专业机构配送员编码
     */
    private String proDeliveryId;

    /**
     * 专业机构配送员名称
     */
    private String proDeliveryName;

    /**
     * 订单明细id
     */
    private Long orderItemId;

    /**
     * 明细类型             1 商品sku             2 物资             3 项目
     */
    private Integer itemType;

    /**
     * 明细状态
     */
    private String orderItemState;

    /**
     * 采购金额
     */
    private BigDecimal purchasePrice;

    /**
     * 采购数量
     */
    private BigDecimal purchaseCount;

    /**
     * 运费
     */
    private BigDecimal transFee;

    /**
     * 采购金额
     */
    private BigDecimal purchaseFee;

    /**
     * 销售金额
     */
    private BigDecimal saleFee;

    /**
     * 应付金额
     */
    private BigDecimal payFee;

    /**
     * 积分优惠金额
     */
    private BigDecimal integralDisFee;

    /**
     * 活动优惠金额
     */
    private BigDecimal actDisFee;

    /**
     * 其它优惠金额
     */
    private BigDecimal otherDisFee;

    /**
     * 实付金额
     */
    private BigDecimal usedFee;

    /**
     * 实付积分
     */
    private BigDecimal usedIntegral;

    /**
     * 币种
     */
    private String currencyType;

    /**
     * 税金
     */
    private String taxPrice;

    /**
     * 税率
     */
    private String tax;

    /**
     * 预计发货时间
     */
    private Date preSendTime;

    /**
     * 预计交货时间
     */
    private Date preOfferTime;

    /**
     * 计量单位
     */
    private String unitName;

    /**
     * 结算计量单位
     */
    private String settleUnit;

    /**
     * 外部电商主订单id
     */
    private String imOrderId;

    /**
     * 外部电商子订单id
     */
    private String imSubOrderId;

    /**
     * 到货周期
     */
    private String arrivalTime;

    /**
     * 加价率
     */
    private Double markUpRate;

    /**
     * 商品服务费 
     */
    private String serPrice;

    /**
     * 计划编号
     */
    private String planNo;

    /**
     * 计划明细编号
     */
    private String planItemNo;

    /**
     * 超验百分比，下单时保存（协议、无协议）
     */
    private Integer inspectionExcessPercent;

    /**
     * 税务编码
     */
    private String taxId;

    /**
     * 比选单号
     */
    private String cmpOrderNo;

    /**
     * 主图信息
     */
    private String skuMainPicUrl;

    /**
     * 订单明细横向扩展
     */
    private UocBaseExtCrossBo orderItemExtCrossBo;

    /**
     * 订单明细纵向扩展
     */
    private List<UocBaseExtParallelBo> orderItemExtParallelBo;

    /**
     * 三方横向扩展
     */
    private UocBaseExtCrossBo thirdExtCrossBo;

    /**
     * 明细商品纵向扩展
     */
    private List<UocBaseExtParallelBo> commExtParallelBo;

    /**
     * 订单详情延保信息
     */
    private List<UocGetOrderAllDetailServiceRspItemEwBo> itemEwBos;
    
    /**
     * 未比选原因
     */
    private String noCmpReason;
    
    /**
     * 物料分类名称
     */
    private String skuMaterialTypeName;

    /**
     * sku物料类型id
     */
    private String skuMaterialTypeId;
    private String model;

    private String spec;
    private String skuCode;

    //商品来源，区分电商、协议、无协议", required = true, valArg = "商品来源")
    private Integer skuSource;
    /**
     * 调价前销售单价
     */
    private BigDecimal adjustSalePrice;

    /**
     * 销售单价调价幅度
     */
    private BigDecimal adjustSalePriceRange;

    /**
     * 销售价调价原因
     */
    private String adjustSaleReason;

    /**
     * 调价前采购单价
     */
    private BigDecimal adjustPurchasePrice;

    /**
     * 采购单价调价幅度
     */
    private BigDecimal adjustPurchasePriceRange;

    /**
     * 采购价调价原因
     */
    private String adjustPurchaseReason;
    /**
     * 成交服务费类型 1账期折扣 2返点
     */
    private Integer tranServFeeType;

    /**
     * 成交服务费比率
     */
    private BigDecimal tranServFeeRatio;

    /**
     * 四级类目编码
     */
    private String l4Catalog;

    /**
     * 四级类目名称
     */
    private String l4CatalogName;
    //一级类目")
    private String l1Catalog;

    //二级类目")
    private String l2Catalog;

    //三级类目")
    private String l3Catalog;

    //一级类目名称")
    private String l1CatalogName;

    //二级类目名称")
    private String l2CatalogName;

    //三级类目名称")
    private String l3CatalogName;
}


