package com.tydic.dyc.oc.service.saleorder.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 描述: 〈领域服务-销售单分配（单条）入参〉
 * @author : yuhao
 * @date : 2022/7/22 16:13
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocAdjustPriceReqBO extends BaseReqBo {
    private static final long serialVersionUID = -4695393777226986101L;
    /**
     * 订单id
     */
    private Long orderId;
    /**
     * 销售单id
     */
    private Long saleOrderId;
    /**
     * 任务ID
     */
    private String taskId;
    /**
     * 当前登录人id
     */
    private Long userId;
    /**
     * 当前登录人名称
     */
    private String name;
    /**
     * 操作类型
     * 1.供应商调价
     * 2.运营侧调价
     * 3.采购方调价
     */
    private Integer operType;
    /**
     * 调价结果
     * 1.通过
     * 0.驳回
     */
    private Integer adjustResult;
    /**
     * 调价明细
     */
    private List<UocAdjustPriceItemBO> uocAdjustPriceItemBOList;
    /**
     * 调价前运费
     */
    private BigDecimal adjustTransFee;

    /**
     * 运费调价幅度
     */
    private BigDecimal adjustTransFeeRange;

    /**
     * 运费调价原因
     */
    private String adjustTransReason;
}
