package com.tydic.dyc.oc.service.saleorder.bo;

import com.tydic.dyc.base.bo.BaseExtendBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocGetSaleOrderDetailServiceRspItemBo
 * 说明:销售单明细信息
 * 时间:2022/2/14 13:46
 * 作者:罗有
 */

@Data
@EqualsAndHashCode(callSuper=false)
public class UocGetSaleOrderDetailServiceRspItemBo extends BaseExtendBo {
    private static final long serialVersionUID = 319502339823043680L;

    /**订单id*/
    private Long orderId;
    
    /**销售订单id*/
    private Long saleOrderId;

    /**销售明细id*/
    private Long saleOrderItemId;

    /**订单明细id*/
    private Long orderItemId;

    /**明细类型             1 商品sku             2 物资             3 项目*/
    private Integer itemType;

    /**明细类型翻译*/
    private String itemTypeStr;

    /**单品ID*/
    private String skuId;

    /**单品编码*/
    private String skuCode;

    /**单品名称*/
    private String skuName;

    /**商品id*/
    private String commodityId;

    /**商品编码*/
    private String commodityCode;

    /**商品名称*/
    private String commodityName;
    /**
     * 商品类型id
     */
    private String commodityTypeId;

    /**供应商ID*/
    private String supplierId;

    /**店铺ID*/
    private String supplierShopId;

    /**采购价格*/
    private BigDecimal purchasePrice;

    /**调价后采购单价*/
    private BigDecimal purchasePriceRear;

    /**销售价格*/
    private BigDecimal salePrice;

    /**调价后销售单价*/
    private BigDecimal salePriceRear;

    /**调价率*/
    private BigDecimal adjustPriceRate;

    /**加价率*/
    private Double markUpRate;

    /**调价后加价率*/
    private Double markUpRateRear;

    /**采购数量*/
    private BigDecimal purchaseCount;

    /**运费*/
    private BigDecimal transFee;

    /**采购金额*/
    private BigDecimal purchaseFee;

    /**销售金额*/
    private BigDecimal saleFee;

    /**应付金额*/
    private BigDecimal payFee;

    /**积分优惠金额*/
    private BigDecimal integralDisFee;

    /**活动优惠金额*/
    private BigDecimal actDisFee;

    /**其它优惠金额*/
    private BigDecimal otherDisFee;

    /**实付金额*/
    private BigDecimal usedFee;

    /**实付积分*/
    private BigDecimal usedIntegral;

    /**币种*/
    private String currencyType;

    /**税金*/
    private String taxPrice;

    /**税率*/
    private String tax;

    /**税务编码*/
    private String taxId;

    /**预计发货时间*/
    private Date preSendTime;

    /**预计交货时间*/
    private Date preOfferTime;

    /**计量单位*/
    private String unitName;

    /**结算计量单位*/
    private String settleUnit;

    /**售后在途数量*/
    private BigDecimal afterServingCount;

    /**外部电商主订单id*/
    private String lmOrderId;

    /**外部电商子订单id*/
    private String lmSubOrderId;

    /**到货周期*/
    private String arrivalTime;

    /**商品服务费 */
    private String serPrice;

    /**计划id*/
    private String planId;

    /**计划明细id */
    private String planItemId;

    /**计划明细编号*/
    private String planItemNo;

    /**超验百分比，下单时保存（协议、无协议）*/
    private Integer inspectionExcessPercent;
    /**
     * 超验数量
     */
    private BigDecimal inspSuperCount;

    /**销售单明细拓展信息*/
    private List<UocBaseExtParallelBo> itemExtParallelBos;

    /**商品明细拓展信息*/
    private List<UocBaseExtParallelBo> commExtParallelBos;

    /**sku物料编码*/
    private String skuMaterialId;

    /**sku外部单品id*/
    private String skuExtSkuId;

    /**sku品牌id*/
    private Long skuBrandId;

    /**单品品牌名称*/
    private String skuBrandName;

    /**sku明细id*/
    private String skuItemId;

    /**sku物料名称*/
    private String skuMaterialName;
    /**sku物料编码*/
    private String skuMaterialCode;

    /**sku物料类型名称*/
    private String skuMaterialTypeName;

    /**sku物料类型id*/
    private String skuMaterialTypeId;

    /**型号*/
    private String model;

    /**规格*/
    private String spec;

    /**材质*/
    private String texture;

    /**图号*/
    private String figure;

    /**一级类目*/
    private String l1Catalog;

    /**二级类目*/
    private String l2Catalog;

    /**三级类目*/
    private String l3Catalog;

    /**一级类目名称*/
    private String l1CatalogName;

    /**二级类目名称*/
    private String l2CatalogName;

    /**三级类目名称*/
    private String l3CatalogName;

    /**退货时间，空代表不支持*/
    private Integer rejectAllowDate;

    /**换货时间，空代表不支持*/
    private Integer exchangeAllowDate;

    /**维修时间，空代表不支持*/
    private Integer maintainAllowDate;

    /**sku单品主图url*/
    private String skuMainPicUrl;

    /**比选单号id*/
    private Long cmpOrderId;

    /**比选单号*/
    private String cmpOrderNo;

    /**铺货单位id*/
    private String distirbutionId;

    /**铺货单位名称*/
    private String distirbutionName;

    /**发货数量*/
    private BigDecimal sendCount;

    /**验收数量*/
    private BigDecimal acceptanceCount;

    /**退货数量*/
    private BigDecimal returnCount;

    /**到货数量*/
    private BigDecimal arriveCount;

    /**拒收数量*/
    private BigDecimal refuseCount;

    /**异常变更在途数量*/
    private BigDecimal chngingCount;

    /**未比选原因*/
    private String noCmpReason;

    /**供货周期*/
    private String deliveryTimeDate;
    /**计量单位*/
    private String unitDigit;

    /**
     * 议价单id
     */
    private Long bargainingId;
    /**
     * 议价单编码
     */
    private String bargainingNo;
    
    /**
     * 销售单编码
     */
    private String saleOrderNo;


    /**
     * 采购用途id(商品明细)
     */
    private String purchasePurposeId;
    /**
     * 采购用途名称(商品明细)
     */
    private String purchasePurposeName;

    /**
     * 1物资类 2服务类
     */
    private String commodityClass;
    
    
    /**
     * 收支项目id
     */
    private String incomeAndExpProjectId;
    /**
     * 收支项目名称
     */
    private String incomeAndExpProjectName;
    /**预计到货时间*/
    private Date estimateArrivalTime;
//    @DocField("供应商名称")
    private String supplierName;
    /**
     * 协议编号
     */
    private String agreementNo;
    /**
     * 协议名称
     */
    private String agreementName;
    /**
     * 协议id(用于翻译)
     **/
    private String agreementId;
    //单品来源      1 自营单品   2 电商导入   3 协议生成    ")
    private Integer skuSource;
    /**
     * 商品重量
     */
    private BigDecimal goodsWeight;
    /**
     * 商品总重量
     */
    private BigDecimal totalGoodsWeight;
    /**
     * 加价比例
     */
    private String addPriceRatio;
    /**
     * 是否加价
     */
    private String isAddPrice;
    /**
     * 是否加价翻译
     */
    private String isAddPriceStr;
    /**
     * 电商预订单下单失败原因
     */
    private String failReason;
    /**
     * 调价前销售单价
     */
    private BigDecimal adjustSalePrice;

    /**
     * 销售单价调价幅度
     */
    private BigDecimal adjustSalePriceRange;

    /**
     * 销售价调价原因
     */
    private String adjustSaleReason;

    /**
     * 调价前采购单价
     */
    private BigDecimal adjustPurchasePrice;

    /**
     * 采购单价调价幅度
     */
    private BigDecimal adjustPurchasePriceRange;

    /**
     * 采购价调价原因
     */
    private String adjustPurchaseReason;
    /**
     * 成交服务费类型 1账期折扣 2返点
     */
    private Integer tranServFeeType;

    /**
     * 成交服务费比率
     */
    private BigDecimal tranServFeeRatio;

    /**
     * 四级类目编码
     */
    private String l4Catalog;

    /**
     * 四级类目名称
     */
    private String l4CatalogName;
    /**
     * 调价前商品销售总价
     */
    private BigDecimal adjustSaleFee;
    /**
     * 调价前商品采购总价
     */
    private BigDecimal adjustPurchaseFee;
}
