package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 描述: 〈领域服务-销售单取消申请提交入参〉
 * @author : yuhao
 * @date : 2022/7/29 16:02
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocCancelApplySaleOrderReqBo extends BaseReqBo {
    private static final long serialVersionUID = -8847843675171093748L;
	/**
	 * 当前登录人id
	 */
	private Long userId;
	/**
	 * 当前登录人名称
	 */
    private String name;

	/**
	 *销售单id
	 */
	private Long saleOrderId;
	/**
	 *订单id
	 */
	private Long orderId;
	/**
	 *取消原因
	 */
	private String cancelReason;
	/**
	 *附件
	 */
	private List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList;
	/**
	 * 取消申请身份（1.采购方取消，2.供应方取消）
	 */
	private Integer cancelFlag;
}
