package com.tydic.dyc.oc.service.importorder.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 标题：UocImportOrderItemBo
 * 描述：导入订单记录明细BO
 **/
@Data
public class UocImportOrderItemBo implements Serializable {

	private static final long serialVersionUID =  7641723650791193139L;

	/**
	 * 记录明细ID
	 */
	private Long importOrderItemId;

	/**
	 * 记录ID
	 */
	private Long importOrderId;

	/**
	 * 商品编码
	 */
	private String skuCode;

	/**
	 * 商品名称
	 */
	private String skuName;

	/**
	 * 采购数量
	 */
	private BigDecimal purchaseCount;

	/**
	 * 供应商ID
	 */
	private String supplierId;

	/**
	 * 供应商名称
	 */
	private String supplierName;

	/**
	 * 明细信息JSON
	 */
	private String dataJson;

	/**
	 * 失败描述
	 */
	private String failReason;

	/**
	 * 备注
	 */
	private String remark;

}
