/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderItemMapQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderMapQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderItemMap;
import com.tydic.dyc.oc.model.order.sub.UocOrderMap;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UocEsSyncOrder
implements IUocEsSync {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncOrder.class);
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    protected static final List<String> pCodeList = ListUtil.list((boolean)false);
    public static final String DEFAULT_STATE = "1";
    public static final String DEFAULT_PAY_TYPE = "2";
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    private static void initialize() {
        pCodeList.add("WHOLE_ORDER_STATE");
        pCodeList.add("UOC_SALE_ORDER_PAY_TYPE");
    }

    @Override
    public String indexName() {
        return this.uocIndexConfig.getOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        log.info("\u6574\u5355\u540c\u6b65ES\u5165\u53c2,{}", (Object)JSON.toJSONString((Object)reqBo));
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getOrderId());
        UocOrderDo uocOrderDo = this.getOrder(reqBo);
        if (Objects.isNull((Object)uocOrderDo)) {
            return rspBo;
        }
        Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        List<UocOrderMap> orderMapList = this.getOrderMapList(reqBo.getOrderId());
        UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = this.getProcInst(reqBo, false, UocDicConstant.OBJ_TYPE.ORDER);
        UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = this.getAuditProcInst(reqBo, UocDicConstant.OBJ_TYPE.ORDER);
        List<UocAuditOrderDo> auditOrderList = this.getAuditOrderList(reqBo);
        List<UocSaleOrderItem> uocOrderItemList = this.getOrderInfoList(reqBo);
        List<UocOrderItemMap> uocOrderItemMapList = this.getOrderInfoExtList(reqBo);
        List<UocOrderStakeholderQryBo> stakeholderList = this.getStakeholderList(reqBo.getOrderId());
        List<UocSaleOrderDo> saleOrderSubjectList = this.getSaleOrderSubject(uocOrderItemList.get(0));
        UocSaleOrderDo saleOrderSubject = saleOrderSubjectList.get(0);
        JSONObject orderObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)uocOrderDo)));
        if (ObjectUtil.isNotEmpty(orderMapList)) {
            orderMapList.forEach(each -> orderObj.put(each.getFieldCode(), (Object)each.getFieldValue()));
        }
        orderObj.put("applicationName", (Object)saleOrderSubject.getApplicationName());
        orderObj.put("applicationTheme", (Object)saleOrderSubject.getApplicationName());
        orderObj.put("applicationType", (Object)saleOrderSubject.getApplicationName());
        orderObj.put("applicationDept", (Object)saleOrderSubject.getApplicationName());
        orderObj.put("purchaseAppType", (Object)saleOrderSubject.getApplicationName());
        orderObj.put("reduceAccount", (Object)saleOrderSubject.getApplicationName());
        orderObj.put("applicationCode", (Object)saleOrderSubject.getApplicationName());
        orderObj.put("auditFlowKey", (Object)saleOrderSubject.getApplicationName());
        BigDecimal totalSaleMoney = saleOrderSubjectList.stream().map(UocSaleOrderDo::getTotalSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalPurchaseMoney = saleOrderSubjectList.stream().map(UocSaleOrderDo::getTotalPurchaseFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        orderObj.put("totalGoodsSaleFee", (Object)totalSaleMoney);
        orderObj.put("totalGoodsPurchaseFee", (Object)totalPurchaseMoney);
        BigDecimal totalTransFee = saleOrderSubjectList.stream().map(UocSaleOrderDo::getTotalTransFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        orderObj.put("totalTransFee", (Object)totalTransFee);
        orderObj.put("totalSaleFee", (Object)totalSaleMoney.add(totalTransFee));
        orderObj.put("totalPurchaseFee", (Object)totalPurchaseMoney.add(totalTransFee));
        orderObj.put("stakeholders", (Object)JSON.parseArray((String)JSON.toJSONString(stakeholderList)));
        orderObj.put("purchaseOrgName", (Object)stakeholderList.get(0).getPurOrgName());
        orderObj.put("purchaseOrgId", (Object)stakeholderList.get(0).getPurOrgId());
        orderObj.put("purchaseCompanyName", (Object)stakeholderList.get(0).getPurCompanyName());
        orderObj.put("purchaseCompanyId", (Object)stakeholderList.get(0).getPurCompanyId());
        orderObj.put("purName", (Object)stakeholderList.get(0).getPurName());
        orderObj.put("purUserName", (Object)stakeholderList.get(0).getPurUserName());
        orderObj.put("purUserId", (Object)stakeholderList.get(0).getPurUserId());
        List supIdList = stakeholderList.stream().map(UocOrderStakeholderQryBo::getSupId).distinct().collect(Collectors.toList());
        orderObj.put("supplierIdList", supIdList);
        orderObj.put("auditOrderBoList", auditOrderList);
        if (!CollectionUtils.isEmpty(uocOrderItemList)) {
            for (UocSaleOrderItem saleOrderItem : uocOrderItemList) {
                if (!UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrderItem.getSkuSource())) continue;
                saleOrderItem.setSkuCode(saleOrderItem.getSkuExtSkuId());
            }
            orderObj.put("commodityInfos", (Object)JSON.parseArray((String)JSON.toJSONString(uocOrderItemList)));
        }
        orderObj.put("busiProcInstId", (Object)busiProcInst.getProcInstId());
        orderObj.put("busiTaskList", (Object)busiProcInst.getTaskList());
        orderObj.put("auditProcInstId", (Object)auditProcInst.getProcInstId());
        orderObj.put("auditProcDefId", (Object)auditProcInst.getProcDefId());
        orderObj.put("auditTaskList", (Object)auditProcInst.getTaskList());
        orderObj.put("orderTotal", (Object)uocOrderDo.getTotalSaleFee());
        Map<String, String> payTypeDicMap = dictionaryMap.get("UOC_SALE_ORDER_PAY_TYPE");
        orderObj.put("payType", (Object)DEFAULT_PAY_TYPE);
        orderObj.put("payTypeStr", (Object)payTypeDicMap.get(DEFAULT_PAY_TYPE));
        Integer dealResult = 1;
        List auditTaskList = auditProcInst.getTaskList();
        for (UocGetSaleOrderDetailServiceRspTaskBo taskBo : auditTaskList) {
            if (ObjectUtil.isNotEmpty((Object)taskBo.getDealResult()) && taskBo.getDealResult().equals(0)) {
                dealResult = 0;
            }
            if (!ObjectUtil.isEmpty((Object)taskBo.getDealResult())) continue;
            dealResult = 2;
        }
        this.setState(orderObj, busiProcInst, uocOrderDo.getOrderState(), dictionaryMap, dealResult);
        rspBo.setJsonObj(orderObj);
        log.info("\u6574\u5355\u540c\u6b65ES\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)rspBo));
        return rspBo;
    }

    private List<UocSaleOrderDo> getSaleOrderSubject(UocSaleOrderItem uocSaleOrderItem) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(uocSaleOrderItem.getOrderId());
        return this.iUocSaleOrderModel.getSaleOrderList(uocSaleOrderQryBo);
    }

    private void setState(JSONObject orderObj, UocGetSaleOrderDetailServiceRspPorcBo busiProcInst, String orderState, Map<String, Map<String, String>> dictionaryMap, Integer dealResult) {
        Map<String, String> orderStateMap = dictionaryMap.get("WHOLE_ORDER_STATE");
        orderObj.put("orderState", (Object)dealResult);
        orderObj.put("orderStateStr", (Object)orderStateMap.get(dealResult.toString()));
    }

    private List<UocOrderStakeholderQryBo> getStakeholderList(Long orderId) {
        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
        uocOrderStakeholderQryBo.setOrderId(orderId);
        return this.iUocOrderModel.qryStakeholderList(uocOrderStakeholderQryBo);
    }

    private List<UocOrderMap> getOrderMapList(Long orderId) {
        UocOrderMapQryBo uocOrderMapQryBo = new UocOrderMapQryBo();
        uocOrderMapQryBo.setOrderId(orderId);
        return this.iUocOrderModel.qryOrderMapList(uocOrderMapQryBo);
    }

    private List<UocOrderItemMap> getOrderInfoExtList(IUocEsSyncQryReqBo reqBo) {
        UocOrderItemMapQryBo uocOrderItemMapQryBo = new UocOrderItemMapQryBo();
        uocOrderItemMapQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocOrderModel.qryOrderItemMapList(uocOrderItemMapQryBo);
    }

    private List<UocSaleOrderItem> getOrderInfoList(IUocEsSyncQryReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    private UocOrderDo getOrder(IUocEsSyncQryReqBo reqBo) {
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        return this.iUocOrderModel.qryOrderBy(uocOrderDo);
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getAuditProcInst(IUocEsSyncQryReqBo reqBo, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setObjId(reqBo.getObjId() + "");
        uocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (CollectionUtil.isNotEmpty(uocApprovalObjs)) {
            List<Long> auditOrderIds = uocApprovalObjs.stream().map(UocApprovalObj::getAuditOrderId).collect(Collectors.toList());
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setOrderId(reqBo.getOrderId());
            taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            taskInstQryBo.setObjIdList(auditOrderIds);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocApprovalObjQryBo uocApprovalObjQryBo1 = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo1.setAuditOrderId(each.getObjId());
                    List<UocApprovalObj> uocApprovalObjs1 = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo1);
                    Integer objBusiType = uocApprovalObjs1.get(0).getObjBusiType();
                    each.setObjBusiType(objBusiType);
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    if (CollectionUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDeal = uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDeal.getDealId();
                        String dealName = uocOrderTaskDeal.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    String auditDealResultQryKey = each.getDealId() + "_" + each.getObjBusiType();
                    if (each.getDealResult() != null) {
                        auditDealResultQryKey = auditDealResultQryKey + "_" + each.getDealResult();
                    }
                    each.setAuditDealResultQryKey(auditDealResultQryKey);
                    each.setTaskDealBo(CollectionUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                    Date finishTime = each.getFinishTime();
                    String dealId = each.getDealId();
                    if (ObjectUtil.isNotEmpty((Object)finishTime) && ObjectUtil.isNotEmpty((Object)dealId)) {
                        each.setFinishTimeStr(dealId + objBusiType + finishTime.getTime());
                    }
                });
                procInst.setTaskList(taskBoList);
                procInst.setProcInstId(uocOrderTaskInsts.get(0).getProcInstId());
            }
        }
        return procInst;
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(IUocEsSyncQryReqBo reqBo, Boolean isAudit, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit.booleanValue()) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjId(reqBo.getObjId());
            procInstQryBo.setObjType(objType);
        }
        procInstQryBo.setOrderId(reqBo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            ArrayList<Integer> finishTagList = new ArrayList<Integer>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            taskInstQryBo.setFinishTagList(finishTagList);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                });
                procInst.setProcState(uocOrderTaskInsts.get(0).getProcState());
                procInst.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }

    private List<UocAuditOrderDo> getAuditOrderList(IUocEsSyncQryReqBo reqBo) {
        UocApprovalObjQryBo obj = new UocApprovalObjQryBo();
        obj.setOrderId(reqBo.getOrderId());
        obj.setObjId(reqBo.getObjId().toString());
        obj.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(obj);
        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
            return new ArrayList<UocAuditOrderDo>();
        }
        ArrayList<Long> auditOrderIdList = new ArrayList<Long>();
        uocApprovalObjs.forEach(uocApprovalObj -> auditOrderIdList.add(uocApprovalObj.getAuditOrderId()));
        List<UocAuditOrderDo> uocAuditOrderDoList = new ArrayList<UocAuditOrderDo>();
        UocAuditOrderQryBo auditOrderQryBo = new UocAuditOrderQryBo();
        auditOrderQryBo.setOrderId(reqBo.getOrderId());
        auditOrderQryBo.setAuditOrderIdList(auditOrderIdList);
        List<UocAuditOrder> uocAuditOrders = this.iUocAuditOrderModel.qryAuditOrderList(auditOrderQryBo);
        if (ObjectUtil.isNotEmpty(uocAuditOrders)) {
            uocAuditOrders.forEach(uocAuditOrder -> {
                UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
                procInstQryBo.setObjId(uocAuditOrder.getAuditOrderId());
                procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
                procInstQryBo.setOrderId(reqBo.getOrderId());
                List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
                if (!CollectionUtils.isEmpty(uocOrderProcInsts)) {
                    uocAuditOrder.setProcInstId(uocOrderProcInsts.get(0).getProcInstId());
                }
            });
            uocAuditOrderDoList = UocRu.jsl(uocAuditOrders, UocAuditOrderDo.class);
            Map approvalObjMap = uocApprovalObjs.stream().collect(Collectors.groupingByConcurrent(UocApprovalObj::getAuditOrderId));
            uocAuditOrderDoList.forEach(each -> each.setApprovalObjs((List)approvalObjMap.get(each.getAuditOrderId())));
        }
        return uocAuditOrderDoList;
    }

    static {
        UocEsSyncOrder.initialize();
    }
}

