/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocNumChngOrderCreateForInspService;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateForInspReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateForInspRspBo;
import com.tydic.dyc.oc.transactionservice.UocNumChngOrderCreateForInspTransaction;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocNumChngOrderCreateForInspService"})
public class UocNumChngOrderCreateForInspServiceImpl
implements UocNumChngOrderCreateForInspService {
    @Autowired
    private UocNumChngOrderCreateForInspTransaction uocNumChngOrderCreateForInspTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"createNumChng"})
    public UocNumChngOrderCreateForInspRspBo createNumChng(@RequestBody UocNumChngOrderCreateForInspReqBo reqBo) {
        UocNumChngOrderCreateForInspRspBo rspBo = this.uocNumChngOrderCreateForInspTransaction.createNumChng(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocNumChngOrderCreateForInspReqBo reqBo, UocNumChngOrderCreateForInspRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo chngBo = new SyncEsRunnableBo();
        chngBo.setIndexName(this.uocIndexConfig.getChngOrderIndex());
        chngBo.setOrderId(reqBo.getOrderId());
        chngBo.setObjId(rspBo.getChngOrderId());
        chngBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(chngBo);
        List inspOrderIdList = rspBo.getInspOrderIdList();
        for (Long inspOrderId : inspOrderIdList) {
            SyncEsRunnableBo saleOrderBo = new SyncEsRunnableBo();
            saleOrderBo.setIndexName(this.uocIndexConfig.getInspOrderIndex());
            saleOrderBo.setOrderId(reqBo.getOrderId());
            saleOrderBo.setObjId(inspOrderId);
            saleOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(saleOrderBo);
        }
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

