/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.insporder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.insporder.UocInspUploadPicService;
import com.tydic.dyc.oc.service.insporder.bo.UocInspUploadPicServiceReqBO;
import com.tydic.dyc.oc.service.insporder.bo.UocInspUploadPicServiceRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.insporder.UocInspUploadPicService"})
public class UocInspUploadPicServiceImpl
implements UocInspUploadPicService {
    private static final Logger log = LoggerFactory.getLogger(UocInspUploadPicServiceImpl.class);
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"uploadInspPicture"})
    public UocInspUploadPicServiceRspBO uploadInspPicture(@RequestBody UocInspUploadPicServiceReqBO reqBo) {
        UocInspUploadPicServiceRspBO rspBO = UocRu.success(UocInspUploadPicServiceRspBO.class);
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(reqBo.getOrderId());
        uocInspOrderQryBo.setInspOrderId(reqBo.getObjId());
        log.info("\u9a8c\u6536\u5355\u8868\u5165\u53c2\u67e5\u8be2", (Object)uocInspOrderQryBo);
        List<UocInspOrderDo> inspOrderList = this.iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
        log.info("\u9a8c\u6536\u5355\u8868\u51fa\u53c2\u67e5\u8be2", (Object)uocInspOrderQryBo);
        if (ObjectUtil.isNotEmpty(inspOrderList)) {
            List otherAccessoryAddBoList = reqBo.getAttachBOList().stream().filter(e -> UocAttachementTypeConstants.ACCEPTANCE_OTHER.equals(e.getAttachmentType())).collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(otherAccessoryAddBoList)) {
                UocOrderAccessory needDelAccessory = new UocOrderAccessory();
                needDelAccessory.setObjId(reqBo.getObjId());
                needDelAccessory.setAttachmentType(UocAttachementTypeConstants.ACCEPTANCE_OTHER);
                needDelAccessory.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
                this.iUocOrderModel.deleteOrderAccessory(needDelAccessory);
            }
            ArrayList<UocOrderAccessory> uocOrderAccessoryList = new ArrayList<UocOrderAccessory>();
            for (UocBaseOrderAccessoryAddBo each : reqBo.getAttachBOList()) {
                UocOrderAccessory needAddAccessory = UocRu.js(each, UocOrderAccessory.class);
                needAddAccessory.setId(IdUtil.nextId());
                needAddAccessory.setOrderId(reqBo.getOrderId());
                needAddAccessory.setObjId(reqBo.getObjId());
                needAddAccessory.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
                needAddAccessory.setAttachmentType(each.getAttachmentType());
                uocOrderAccessoryList.add(needAddAccessory);
            }
            this.iUocOrderModel.createOrderAccessory(UocRu.jsl(uocOrderAccessoryList, UocOrderAccessory.class));
            UocInspOrderDo inspOrderDo = new UocInspOrderDo();
            inspOrderDo.setOrderId(reqBo.getOrderId());
            inspOrderDo.setInspOrderId(reqBo.getObjId());
            inspOrderDo.setRemark(reqBo.getRemark());
            this.iUocInspOrderModel.updateInspRemark(inspOrderDo);
            if (inspOrderList.get(0).getSaleOrderId() != null) {
                UocSaleOrderDo qryDo = new UocSaleOrderDo();
                qryDo.setSaleOrderId(inspOrderList.get(0).getSaleOrderId());
                List<UocSaleOrderDo> uocSaleOrderDos = this.iUocSaleOrderModel.qrySaleOrderList(qryDo);
                if (!CollectionUtils.isEmpty(uocSaleOrderDos)) {
                    rspBO.setSaleOrderNo(uocSaleOrderDos.get(0).getSaleOrderNo());
                }
            }
        } else {
            throw new BaseBusinessException("100100", "\u5165\u53c2\u3010objId\u3011+\u3010orderId\u3011\u67e5\u8be2\u9a8c\u6536\u5355\u4e3a\u7a7a");
        }
        return rspBO;
    }
}

