/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.order;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.order.UocGetOrderAllDetailService;
import com.tydic.dyc.oc.service.order.bo.UocGetOrderAllDetailServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocGetOrderAllDetailServiceRspAccessoryBo;
import com.tydic.dyc.oc.service.order.bo.UocGetOrderAllDetailServiceRspBo;
import com.tydic.dyc.oc.service.order.bo.UocGetOrderAllDetailServiceRspOrderCommInfoBo;
import com.tydic.dyc.oc.service.order.bo.UocGetOrderAllDetailServiceRspOrderLogisticsBo;
import com.tydic.dyc.oc.service.order.bo.UocGetOrderAllDetailServiceRspSaleStakeBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderAuditBO;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.order.UocGetOrderAllDetailService"})
public class UocGetOrderAllDetailServiceImpl
implements UocGetOrderAllDetailService {
    private static final Logger log = LoggerFactory.getLogger(UocGetOrderAllDetailServiceImpl.class);
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    private static final String DEFAULT_PAY_TYPE = "2";
    private static final String DEFAULT_PAY_TYPE_STR = "\u5e10\u671f\u652f\u4ed8";

    @PostMapping(value={"getOrderAllDetail"})
    public UocGetOrderAllDetailServiceRspBo getOrderAllDetail(@RequestBody UocGetOrderAllDetailServiceReqBo reqBo) {
        this.val(reqBo);
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        UocOrderDo orderDo = this.iUocOrderModel.qryOrderBy(uocOrderDo);
        if (orderDo == null) {
            throw new BaseBusinessException("101014", "\u672a\u67e5\u8be2\u5230 [ orderId = " + reqBo.getOrderId() + " ]\uff0c\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        UocGetOrderAllDetailServiceRspBo rspBo = UocRu.js((Object)orderDo, UocGetOrderAllDetailServiceRspBo.class);
        UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = this.getAuditProcInst(orderDo, UocDicConstant.OBJ_TYPE.ORDER);
        rspBo.setAuditProcInst(auditProcInst);
        List<UocAuditOrderDo> auditOrderList = this.getAuditOrderList(orderDo.getOrderId(), orderDo.getOrderId(), UocDicConstant.OBJ_TYPE.ORDER);
        rspBo.setAuditOrderBoList(UocRu.jsl(auditOrderList, UocSaleOrderAuditBO.class));
        rspBo.setPayType(DEFAULT_PAY_TYPE);
        rspBo.setPayTypeStr(DEFAULT_PAY_TYPE_STR);
        UocOrdLogisticsRelaQryBo uocOrdLogisticsRelaQryBo = new UocOrdLogisticsRelaQryBo();
        uocOrdLogisticsRelaQryBo.setOrderId(reqBo.getOrderId());
        uocOrdLogisticsRelaQryBo.setContactId(orderDo.getContactId());
        log.info("\u67e5\u8be2\u6536\u8d27\u5730\u5740\u4fe1\u606f\u5165\u53c2,{}", (Object)uocOrdLogisticsRelaQryBo.toString());
        UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(uocOrdLogisticsRelaQryBo);
        rspBo.setLogisticsBo(UocRu.js(uocOrdLogisticsRela, UocGetOrderAllDetailServiceRspOrderLogisticsBo.class));
        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
        uocOrderStakeholderQryBo.setOrderId(reqBo.getOrderId());
        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = this.iUocOrderModel.qryStakeholderList(uocOrderStakeholderQryBo);
        rspBo.setSaleStakeBos(UocRu.jsl(uocOrderStakeholderQryBos, UocGetOrderAllDetailServiceRspSaleStakeBo.class));
        UocOrderAccessoryQryBo accessoryQryBo = new UocOrderAccessoryQryBo();
        accessoryQryBo.setObjId(reqBo.getOrderId());
        accessoryQryBo.setOrderId(reqBo.getOrderId());
        accessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        List<UocOrderAccessory> orderAccessoryList = this.iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        rspBo.setAccessoryBos(UocRu.jsl(orderAccessoryList, UocGetOrderAllDetailServiceRspAccessoryBo.class));
        UocSaleOrderItemQryBo uocOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocOrderItemQryBo.setOrderId(reqBo.getOrderId());
        List<UocSaleOrderItem> uocOrderItems = this.iUocSaleOrderModel.getSaleOrderItemList(uocOrderItemQryBo);
        List<UocGetOrderAllDetailServiceRspOrderCommInfoBo> commInfoBos = UocRu.jsl(uocOrderItems, UocGetOrderAllDetailServiceRspOrderCommInfoBo.class);
        Map<String, String> supMap = rspBo.getSaleStakeBos().stream().collect(Collectors.toMap(UocGetOrderAllDetailServiceRspSaleStakeBo::getSupId, UocGetOrderAllDetailServiceRspSaleStakeBo::getSupName));
        for (UocGetOrderAllDetailServiceRspOrderCommInfoBo commInfoBo : commInfoBos) {
            commInfoBo.setSupplierName(supMap.get(commInfoBo.getSupplierId()));
            if (!UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(commInfoBo.getSkuSource())) continue;
            commInfoBo.setSkuCode(commInfoBo.getSkuExtSkuId());
        }
        rspBo.setCommInfoBos(commInfoBos);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
        List<UocSaleOrderDo> saleOrderList = this.iUocSaleOrderModel.getSaleOrderList(uocSaleOrderQryBo);
        rspBo.setTotalGoodsSaleFee(saleOrderList.stream().map(UocSaleOrderDo::getTotalGoodsSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add));
        rspBo.setTotalGoodsPurchaseFee(saleOrderList.stream().map(UocSaleOrderDo::getTotalGoodsPurchaseFee).reduce(BigDecimal.ZERO, BigDecimal::add));
        rspBo.setTotalTransFee(saleOrderList.stream().map(UocSaleOrderDo::getTotalTransFee).reduce(BigDecimal.ZERO, BigDecimal::add));
        rspBo.setTotalSaleFee(rspBo.getTotalGoodsSaleFee().add(rspBo.getTotalTransFee()));
        rspBo.setTotalPurchaseFee(rspBo.getTotalGoodsPurchaseFee().add(rspBo.getTotalTransFee()));
        if (CollectionUtil.isNotEmpty(saleOrderList)) {
            UocSaleOrderDo saleOrderMain = saleOrderList.get(0);
            rspBo.setPayState(saleOrderMain.getPayState().toString());
            rspBo.setPurchaseMode(saleOrderMain.getPurchaseMode());
            rspBo.setCancelOperName(saleOrderMain.getCancelOperName());
            rspBo.setCancelTime(saleOrderMain.getCancelTime());
            rspBo.setCancelReason(saleOrderMain.getCancelReason());
            rspBo.setApplicationName(saleOrderMain.getApplicationName());
            rspBo.setApplicationTheme(saleOrderMain.getApplicationTheme());
            rspBo.setApplicationType(saleOrderMain.getApplicationType());
            rspBo.setApplicationDept(saleOrderMain.getApplicationDept());
            rspBo.setPurchaseAppType(saleOrderMain.getPurchaseAppType());
            rspBo.setReduceAccount(saleOrderMain.getReduceAccount());
            rspBo.setApplicationCode(saleOrderMain.getApplicationCode());
            rspBo.setAuditFlowKey(saleOrderMain.getAuditFlowKey());
            rspBo.setOldParentOrderCode(saleOrderMain.getOldParentOrderCode());
            rspBo.setTotalOccupyTransFee(saleOrderMain.getTotalOccupyTransFee());
        }
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        List<UocApprovalObj> approvalObjList = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (ObjectUtil.isNotEmpty(approvalObjList)) {
            UocAuditOrderQryBo auditOrderQryBo = new UocAuditOrderQryBo();
            auditOrderQryBo.setAuditOrderId(approvalObjList.get(0).getAuditOrderId());
            UocAuditOrderDo uocAuditOrderDo = this.iUocAuditOrderModel.qryAuditOrder(auditOrderQryBo);
            rspBo.setAuditOrderStatus(uocAuditOrderDo.getAuditOrderStatus());
        }
        this.transelate(rspBo);
        return rspBo;
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getAuditProcInst(UocOrderDo orderDo, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(orderDo.getOrderId());
        if (UocDicConstant.OBJ_TYPE.SALE.equals(objType)) {
            uocApprovalObjQryBo.setObjType(objType);
        } else {
            uocApprovalObjQryBo.setObjId(orderDo.getOrderId() + "");
            uocApprovalObjQryBo.setObjType(objType);
        }
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (ObjectUtil.isNotEmpty(uocApprovalObjs)) {
            List<Long> auditOrderIds = uocApprovalObjs.stream().map(UocApprovalObj::getAuditOrderId).collect(Collectors.toList());
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setOrderId(orderDo.getOrderId());
            taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            taskInstQryBo.setObjIdList(auditOrderIds);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                String procInstId;
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocApprovalObjQryBo uocApprovalObjQryBo1 = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo1.setAuditOrderId(each.getObjId());
                    List<UocApprovalObj> uocApprovalObjs1 = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo1);
                    Integer objBusiType = uocApprovalObjs1.get(0).getObjBusiType();
                    each.setObjBusiType(objBusiType);
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    if (ObjectUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDeal = uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDeal.getDealId();
                        String dealName = uocOrderTaskDeal.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    String auditDealResultQryKey = each.getDealId() + "_" + each.getObjBusiType();
                    if (each.getDealResult() != null) {
                        auditDealResultQryKey = auditDealResultQryKey + "_" + each.getDealResult();
                    }
                    each.setAuditDealResultQryKey(auditDealResultQryKey);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                });
                procInst.setTaskList(taskBoList);
                String string = procInstId = CollectionUtils.isEmpty(uocOrderTaskInsts) ? "" : uocOrderTaskInsts.get(0).getProcInstId();
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)procInstId)) {
                    procInst.setProcInstId(procInstId);
                }
            }
        }
        return procInst;
    }

    private List<UocAuditOrderDo> getAuditOrderList(Long orderId, Long objId, Integer objType) {
        UocApprovalObjQryBo obj = new UocApprovalObjQryBo();
        obj.setOrderId(orderId);
        obj.setObjId(Convert.toStr((Object)objId));
        obj.setObjType(objType);
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(obj);
        log.info("\u67e5\u8be2uocApprovalObjs\uff1a{}", (Object)JSON.toJSONString(uocApprovalObjs));
        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
            return new ArrayList<UocAuditOrderDo>();
        }
        ArrayList<Long> auditOrderIdList = new ArrayList<Long>();
        uocApprovalObjs.forEach(uocApprovalObj -> auditOrderIdList.add(uocApprovalObj.getAuditOrderId()));
        List<UocAuditOrderDo> uocAuditOrderDoList = new ArrayList<UocAuditOrderDo>();
        UocAuditOrderQryBo auditOrderQryBo = new UocAuditOrderQryBo();
        auditOrderQryBo.setOrderId(orderId);
        auditOrderQryBo.setAuditOrderIdList(auditOrderIdList);
        List<UocAuditOrder> uocAuditOrders = this.iUocAuditOrderModel.qryAuditOrderList(auditOrderQryBo);
        log.info("\u67e5\u8be2uocAuditOrders\uff1a{}", (Object)JSON.toJSONString(uocAuditOrders));
        if (ObjectUtil.isNotEmpty(uocAuditOrders)) {
            uocAuditOrders.forEach(uocAuditOrder -> {
                UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
                procInstQryBo.setObjId(uocAuditOrder.getAuditOrderId());
                procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
                procInstQryBo.setOrderId(orderId);
                procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
                log.info("\u67e5\u8be2uocOrderProcInsts\uff1a{}", (Object)JSON.toJSONString(uocOrderProcInsts));
                if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
                    uocAuditOrder.setProcInstId(uocOrderProcInsts.get(0).getProcInstId());
                }
            });
            uocAuditOrderDoList = UocRu.jsl(uocAuditOrders, UocAuditOrderDo.class);
            Map approvalObjMap = uocApprovalObjs.stream().collect(Collectors.groupingByConcurrent(UocApprovalObj::getAuditOrderId));
            uocAuditOrderDoList.forEach(each -> each.setApprovalObjs((List)approvalObjMap.get(each.getAuditOrderId())));
        }
        return uocAuditOrderDoList;
    }

    private void transelate(UocGetOrderAllDetailServiceRspBo rspBo) {
        Map<String, Map<String, String>> dic = this.getDic();
        if (rspBo.getPayState() != null) {
            String payStateStr = dic.get("UOC_SALE_ORDER_PAY_STATE").get(rspBo.getPayState());
            rspBo.setPayStateStr(payStateStr);
        }
        if (rspBo.getOrderState() != null) {
            String orderStateStr = dic.get("UOC_COMMON_ORDER_STATE").get(rspBo.getOrderState());
            rspBo.setOrderStateStr(orderStateStr);
        }
        if (rspBo.getPurchaseMode() != null) {
            String purchaseModeStr = dic.get("UOC_COMMON_PURCHASE_MODE").get(rspBo.getPurchaseMode().toString());
            rspBo.setPurchaseModeStr(purchaseModeStr);
        }
        if (rspBo.getPayType() != null) {
            String payTypeStr = dic.get("UOC_SALE_ORDER_PAY_TYPE").get(rspBo.getPayType());
            rspBo.setPayTypeStr(payTypeStr);
        }
        if (rspBo.getAuditOrderStatus() != null) {
            String auditOrderStatusStr = dic.get("UOC_COMMON_ORDER_STATE").get(rspBo.getAuditOrderStatus());
            rspBo.setAuditOrderStatusStr(auditOrderStatusStr);
        }
        if (StringUtils.hasText((String)rspBo.getApplicationType())) {
            String applicationTypeStr = dic.get("UOC_APPLICATION_TYPE").get(rspBo.getApplicationType());
            rspBo.setApplicationTypeStr(applicationTypeStr);
        }
        if (StringUtils.hasText((String)rspBo.getPurchaseAppType())) {
            String purchaseAppTypeStr = dic.get("UOC_PURCHASE_APP_TYPE").get(rspBo.getPurchaseAppType());
            rspBo.setPurchaseAppTypeStr(purchaseAppTypeStr);
        }
        if (StringUtils.hasText((String)rspBo.getReduceAccount())) {
            String reduceAccountStr = dic.get("UOC_REDUCE_ACCOUNT").get(rspBo.getReduceAccount());
            rspBo.setReduceAccountStr(reduceAccountStr);
        }
    }

    private void val(UocGetOrderAllDetailServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e0d\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("UOC_SALE_ORDER_PAY_STATE");
        pCodes.add("UOC_COMMON_PURCHASE_MODE");
        pCodes.add("UOC_COMMON_ORDER_STATE");
        pCodes.add("UOC_SALE_ORDER_PAY_TYPE");
        pCodes.add("UOC_PURCHASE_APP_TYPE");
        pCodes.add("UOC_APPLICATION_TYPE");
        pCodes.add("UOC_REDUCE_ACCOUNT");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }
}

