/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocPasteCancelApplySaleOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocPasteCancelApplySaleOrderRspBo;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UocPasteCancelApplySaleOrderTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocPasteCancelApplySaleOrderTransaction.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Value(value="${uoc.dealPasteCancelApply.cancelApplyStatusAgr:XS_FH_DFH}")
    private String cancelApplyStatusAgr;
    @Value(value="${uoc.dealPasteCancelApply.cancelApplyStatusEs:XS_FH_DFH}")
    private String cancelApplyStatusEs;
    @Value(value="${uoc.dealPasteCancelApply.cancelApplyStatusNoAgr:XS_FH_DFH}")
    private String cancelApplyStatusNoAgr;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocPasteCancelApplySaleOrderRspBo dealPasteCancelApply(UocPasteCancelApplySaleOrderReqBo reqBo) {
        this.verifyParam(reqBo);
        this.deleteCancelApplyChangeOrder(reqBo);
        this.updateSaleOrder(reqBo);
        UocPasteCancelApplySaleOrderRspBo rspBo = new UocPasteCancelApplySaleOrderRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void updateSaleOrder(UocPasteCancelApplySaleOrderReqBo reqBo) {
        UocSaleOrderQryBo qrySale = new UocSaleOrderQryBo();
        qrySale.setOrderId(reqBo.getOrderId());
        qrySale.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(qrySale);
        if (ObjectUtil.isEmpty((Object)((Object)uocSaleOrderDo))) {
            throw new BaseBusinessException("100001", "\u8be5\u9500\u552e\u5355\u5355\u4e0d\u5b58\u5728\uff1a" + reqBo.getSaleOrderId());
        }
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateSaleOrderDo.setOrderId(reqBo.getOrderId());
        updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        updateSaleOrderDo.setUpdateTime(new Date());
        updateSaleOrderDo.setUpdateOperName(reqBo.getName());
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(uocSaleOrderDo.getOrderSource())) {
            updateSaleOrderDo.setSaleOrderState(this.cancelApplyStatusAgr);
            this.iUocSaleOrderModel.modifySaleOrderMain(updateSaleOrderDo);
        } else if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(uocSaleOrderDo.getOrderSource())) {
            updateSaleOrderDo.setSaleOrderState(this.cancelApplyStatusEs);
            this.iUocSaleOrderModel.modifySaleOrderMain(updateSaleOrderDo);
        } else if (UocDicConstant.ORDER_SOURCE.SELF_SUPPORT_PRODUCT.equals(uocSaleOrderDo.getOrderSource())) {
            updateSaleOrderDo.setSaleOrderState(this.cancelApplyStatusNoAgr);
            this.iUocSaleOrderModel.modifySaleOrderMain(updateSaleOrderDo);
        }
    }

    private void deleteCancelApplyChangeOrder(UocPasteCancelApplySaleOrderReqBo reqBo) {
        UocChngOrderDo deleteChngOrderDo = new UocChngOrderDo();
        if (null == reqBo.getChngOrderId()) {
            UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
            uocChngOrderQryBo.setOrderId(reqBo.getOrderId());
            uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL);
            uocChngOrderQryBo.setChngOrderState("CHNG_XS_QXSQZ");
            uocChngOrderQryBo.setOrderBy("create_time");
            List<UocChngOrderDo> listChngOrder = this.iUocChngOrderModel.getListChngOrder(uocChngOrderQryBo);
            if (ObjectUtil.isEmpty(listChngOrder)) {
                throw new BaseBusinessException("100001", "\u8be5\u9500\u552e\u5355\u5355[" + reqBo.getSaleOrderId() + "]\u4e0d\u5b58\u5728\u53d8\u66f4\u5355");
            }
            reqBo.setChngOrderId(listChngOrder.get(0).getChngOrderId());
        }
        deleteChngOrderDo.setOrderId(reqBo.getOrderId());
        deleteChngOrderDo.setChngOrderState("CHNG_XS_YCX");
        deleteChngOrderDo.setChngOrderId(reqBo.getChngOrderId());
        deleteChngOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        deleteChngOrderDo.setUpdateTime(new Date());
        deleteChngOrderDo.setUpdateOperName(reqBo.getName());
        this.iUocChngOrderModel.updateChngOrderMain(deleteChngOrderDo);
    }

    private void verifyParam(UocPasteCancelApplySaleOrderReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBo.getName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

