package com.tydic.dyc.oc.model.importorder.impl;

import com.tydic.dyc.oc.model.importorder.IUocImportOrderModel;
import com.tydic.dyc.oc.model.importorder.UocImportOrderDo;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderQryListReqBo;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderQryListRspBo;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderQryDetailReqBo;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderQryDetailRspBo;
import com.tydic.dyc.oc.repository.UocImportOrderRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 标题：IUocImportOrderModelImpl
 * 描述：导入订单记录领域方法服务实现类
 */
@Slf4j
@Service
public class IUocImportOrderModelImpl implements IUocImportOrderModel {

    /**
     * 导入订单记录基建服务
     */
    @Autowired
    private UocImportOrderRepository uocImportOrderRepository;

    /**
     * 导入订单记录新增
     */
    @Override
    public UocImportOrderDo addImportOrder(UocImportOrderDo uocImportOrderDo) {
        //调用导入订单记录基建服务，导入订单记录新增
        return this.uocImportOrderRepository.addImportOrder(uocImportOrderDo);
    }

    /**
     * 校验导入订单记录阈值量
     */
    @Override
    public UocImportOrderDo checkImportOrderThreshold(UocImportOrderDo uocImportOrderDo) {
        //调用导入订单记录基建服务，导入订单记录新增
        return this.uocImportOrderRepository.checkImportOrderThreshold(uocImportOrderDo);
    }

    /**
     * 导入订单记录状态修改
     */
    @Override
    public void updateImportOrderInfoStatus(UocImportOrderDo uocImportOrderDo) {
        //调用导入订单记录基建服务，导入订单记录状态修改
        this.uocImportOrderRepository.updateImportOrderInfoStatus(uocImportOrderDo);
    }

    /**
     * 导入订单记录更新
     */
    @Override
    public void updateImportOrder(UocImportOrderDo uocImportOrderDo) {
        //调用导入订单记录基建服务，导入订单记录更新
        this.uocImportOrderRepository.updateImportOrder(uocImportOrderDo);
    }

    /**
     * 导入订单记录详情查询
     */
    @Override
    public UocImportOrderQryDetailRspBo qryImportOrderDetail(UocImportOrderQryDetailReqBo uocImportOrderQryDetailReqBo) {
        //调用导入订单记录基建服务，导入订单记录详情查询
        return this.uocImportOrderRepository.qryImportOrderDetail(uocImportOrderQryDetailReqBo);
    }

    /**
     * 导入订单记录列表分页查询
     */
    @Override
    public UocImportOrderQryListRspBo qryImportOrderList(UocImportOrderQryListReqBo uocImportOrderQryListReqBo) {
        //调用导入订单记录基建服务，导入订单记录列表分页查询
        return this.uocImportOrderRepository.qryImportOrderList(uocImportOrderQryListReqBo);
    }
}
