package com.tydic.dyc.oc.model.importorder.qrybo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题：UocImportOrderQryDetailRspBo
 * 描述：导入订单记录详情查询
 **/
@Data
public class UocImportOrderQryDetailRspBo implements Serializable {

	private static final long serialVersionUID =  -8497029770704291297L;

	/**
	 * 记录ID
	 */
	private Long importOrderId;

	/**
	 * 附件名称
	 */
	private String accessoryName;

	/**
	 * 附件链接
	 */
	private String accessoryUrl;

	/**
	 * 状态 1入库 2执行中 3待下单 4已下单
	 */
	private Integer status;

	/**
	 * 订单ID
	 */
	private Long orderId;

	/**
	 * 销售单ID
	 */
	private Long saleOrderId;

	/**
	 * 商品总金额
	 */
	private BigDecimal totalGoodsFee;

	/**
	 * 总运费
	 */
	private BigDecimal totalTransFee;

	/**
	 * 总金额
	 */
	private BigDecimal totalFee;

	/**
	 * 失败描述
	 */
	private String failReason;

	/**
	 * 创建人ID
	 */
	private String createUserId;

	/**
	 * 创建人名称
	 */
	private String createUserName;

	/**
	 * 创建时间
	 */
	private Date createTime;

	/**
	 * 创建人机构ID
	 */
	private String createOrgId;

	/**
	 * 创建人机构名称
	 */
	private String createOrgName;

	/**
	 * 创建人公司ID
	 */

	private String createCompanyId;
	/**
	 * 创建人公司名称
	 */
	private String createCompanyName;

	/**
	 * 创建人机构树
	 */
	private String createOrgPath;

	/**
	 * 更新人ID
	 */
	private String updateUserId;

	/**
	 * 更新人名称
	 */
	private String updateUserName;

	/**
	 * 更新时间
	 */
	private Date updateTime;

	/**
	 * 备注
	 */
	private String remark;

	/**
	 * 导入订单记录明细集合
	 */
	private List<UocImportOrderItemQryDetailBo> importOrderItemList;

	/**
	 * 导入订单记录协议信息集合
	 */
	private List<UocImportOrderAgreementInfoQryDetailBo> importOrderAgreementInfoList;

}
