package com.tydic.dyc.oc.repository;

import com.tydic.dyc.oc.model.importorder.UocImportOrderDo;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderQryListReqBo;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderQryListRspBo;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderQryDetailReqBo;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderQryDetailRspBo;

/**
 * 标题：UocImportOrderRepository
 * 描述：导入订单记录基建服务
 */
public interface UocImportOrderRepository {

    /**
     * 导入订单记录新增
     */
    UocImportOrderDo addImportOrder(UocImportOrderDo uocImportOrderDo);

    /**
     * 校验导入订单记录阈值量
     */
    UocImportOrderDo checkImportOrderThreshold(UocImportOrderDo uocImportOrderDo);

    /**
     * 导入订单记录状态修改
     */
    void updateImportOrderInfoStatus(UocImportOrderDo uocImportOrderDo);

    /**
     * 导入订单记录更新
     */
    void updateImportOrder(UocImportOrderDo uocImportOrderDo);

    /**
     * 导入订单记录详情查询
     */
    UocImportOrderQryDetailRspBo qryImportOrderDetail(UocImportOrderQryDetailReqBo uocImportOrderQryDetailReqBo);

    /**
     * 导入订单记录列表分页查询
     */
    UocImportOrderQryListRspBo qryImportOrderList(UocImportOrderQryListReqBo reqBo);

}
