package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.oc.model.bargaining.IUocBargainingModel;
import com.tydic.dyc.oc.model.bargaining.qrybo.UocBargainingQryBo;
import com.tydic.dyc.oc.model.bargaining.sub.UocBargaining;
import com.tydic.dyc.oc.service.bargaining.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题:UocQryExpireBargainingListServiceImpl
 * 说明:
 * 时间:2023/9/5 15:44
 * 作者:Dum
 */
@HTServiceImpl
public class UocQryExpireBargainingListServiceImpl implements UocQryExpireBargainingListService {

    @Autowired
    private IUocBargainingModel uocBargainingModel;
    @Override
    public UocQryExpireBargainingListRspBo qryExpireBargainingList(UocQryExpireBargainingListReqBo reqBo) {
        UocQryExpireBargainingListRspBo rspBo = new UocQryExpireBargainingListRspBo();
        //查询满足条件的议价单：议价单状态已报价，报价单已报价，允许下单时间小于当前时间
        UocBargainingQryBo qryBo= UocRu.js(reqBo, UocBargainingQryBo.class);
        List<UocBargaining> uocBargainingList = uocBargainingModel.qryExpireBargainingList(qryBo);
        List<UocQryExpireBargainingBo> rspList = UocRu.jsl(uocBargainingList, UocQryExpireBargainingBo.class);
        rspBo.setRows(rspList);
        return rspBo;
    }
}
