package com.tydic.dyc.oc.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.transactionservice.UocCreateOrderProcInsUpdateStatusDomainServiceTransaction;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述: 〈领域服务-销售单任务提交（单条）实现〉
 *
 * @author : yuhao
 * @date : 2022/7/26 18:42
 */
@HTServiceImpl
@Slf4j
public class UocCreateOrderProcInsUpdateStatusDomainServiceImpl implements UocCreateOrderProcInsUpdateStatusDomainService {

    @Autowired
    private UocCreateOrderProcInsUpdateStatusDomainServiceTransaction uocCreateOrderProcInsUpdateStatusDomainServiceTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocCreateOrderProcInsUpdateStatusDomainServiceRspBo createOrderProcIns(UocCreateOrderProcInsUpdateStatusDomainServiceReqBo reqBo) {
        UocCreateOrderProcInsUpdateStatusDomainServiceRspBo rspBo = uocCreateOrderProcInsUpdateStatusDomainServiceTransaction.createOrderProcIns(reqBo);
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocCreateOrderProcInsUpdateStatusDomainServiceReqBo reqBo, UocCreateOrderProcInsUpdateStatusDomainServiceRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        //同步销售单
        if (!CollectionUtils.isEmpty(rspBo.getSyncSaleOrderList())) {
            for (UocEsSyncBO bo : rspBo.getSyncSaleOrderList()) {
                SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
                saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
                saleBo.setOrderId(bo.getOrderId());
                saleBo.setObjId(bo.getSaleOrderId());
                saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(saleBo);
            }
        }
        //同步变更单
        if (!CollectionUtils.isEmpty(rspBo.getSyncChngOrderList())) {
            for (UocEsSyncBO bo : rspBo.getSyncChngOrderList()) {
                SyncEsRunnableBo chngBo = new SyncEsRunnableBo();
                chngBo.setIndexName(uocIndexConfig.getChngOrderIndex());
                chngBo.setOrderId(bo.getOrderId());
                chngBo.setObjId(bo.getChngOrderId());
                chngBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(chngBo);
            }
        }
        //同步发货单
        if (!CollectionUtils.isEmpty(rspBo.getSyncShipOrderList())) {
            for (UocEsSyncBO bo : rspBo.getSyncShipOrderList()) {
                SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
                shipBo.setIndexName(uocIndexConfig.getShipOrderIndex());
                shipBo.setOrderId(bo.getOrderId());
                shipBo.setObjId(bo.getShipOrderId());
                shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(shipBo);
            }
        }
        //同步验收单
        if (!CollectionUtils.isEmpty(rspBo.getSyncInspOrderList())) {
            for (UocEsSyncBO bo : rspBo.getSyncInspOrderList()) {
                SyncEsRunnableBo inspBo = new SyncEsRunnableBo();
                inspBo.setIndexName(uocIndexConfig.getInspOrderIndex());
                inspBo.setOrderId(bo.getOrderId());
                inspBo.setObjId(bo.getInspOrderId());
                inspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(inspBo);
            }
        }
        //同步售后单
        if (!CollectionUtils.isEmpty(rspBo.getSyncAfterOrderList())) {
            for (UocEsSyncBO bo : rspBo.getSyncAfterOrderList()) {
                SyncEsRunnableBo inspBo = new SyncEsRunnableBo();
                inspBo.setIndexName(uocIndexConfig.getAfOrderIndex());
                inspBo.setOrderId(bo.getOrderId());
                inspBo.setObjId(bo.getAfterOrderId());
                inspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(inspBo);
            }
        }
        //同步订单
        if (!CollectionUtils.isEmpty(rspBo.getSyncOrderList())) {
            for (UocEsSyncBO bo : rspBo.getSyncOrderList()) {
                SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
                orderBo.setIndexName(uocIndexConfig.getOrderIndex());
                orderBo.setOrderId(bo.getOrderId());
                orderBo.setObjId(bo.getOrderId());
                orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(orderBo);
            }
        }

        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}


