package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleItemMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 描述: 〈领域服务-发货单详情查询实现〉
 * @author : yuhao
 * @date : 2022/9/10 16:08
 */
@HTServiceImpl
public class UocQryShipOrderDetailsServiceImpl implements UocQryShipOrderDetailsService {

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Autowired
    private IUocOrderModel orderModel;
    @Override
    public UocQryShipOrderDetailsRspBo qryShipOrderDetails(UocQryShipOrderDetailsReqBo reqBo) {
        //参数校验
        this.validateArg(reqBo);
        //获取字典
        Map<String, Map<String, String>> dicMap = getDic();
        //查询发货单主体及明细信息
        UocQryShipOrderDetailsRspDetailBo shipOrderDetailsInfo = this.queryShipOrderInfo(reqBo, dicMap);
        //查询订单收货地址信息
        UocQryShipOrderDetailsLogisticsRelaBo orderLogisicsInfo = this.queryLogisticsInfo(reqBo.getOrderId());

        UocQryShipOrderDetailsRspBo rspBo = new UocQryShipOrderDetailsRspBo();
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        rspBo.setShipOrderInfo(shipOrderDetailsInfo);
        rspBo.setOrdLogisticsRela(orderLogisicsInfo);
        return rspBo;
    }

    /**
     * 查询发货单明细信息
     * @param shipOrderId
     * @param orderId
     * @return
     */
    private List<UocShipOrderItem> getShipOrderItemInfos(Long shipOrderId,Long orderId){
        UocShipOrderItemQryBo qryItemListBo = new UocShipOrderItemQryBo();
        qryItemListBo.setShipOrderId(shipOrderId);
        qryItemListBo.setOrderId(orderId);
        UocShipOrderDo shipOrderItems = this.iUocShipOrderModel.getListShipOrderItem(qryItemListBo);
        if(null != shipOrderItems){
            return shipOrderItems.getShipOrderItemBoList();
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询发货单明细信息失败");
        }
    }


    /**
     * 查询发货单相关信息
     * @param reqBo
     */
    private UocQryShipOrderDetailsRspDetailBo queryShipOrderInfo(UocQryShipOrderDetailsReqBo reqBo,Map<String, Map<String, String>> dicMap){
        //查询发货单主体信息
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        UocShipOrderDo shipOrderInfo = this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
        if(null != shipOrderInfo){
            //组装发货单主体信息
            UocQryShipOrderDetailsRspDetailBo uocQryShipOrderDetailsRspDetailBo = JSONObject.parseObject(JSON.toJSONString(shipOrderInfo),UocQryShipOrderDetailsRspDetailBo.class);
            //设置发货单状态翻译
            uocQryShipOrderDetailsRspDetailBo.setShipOrderStateStr(dicMap.get(UocStateConstants.ShipOrder.P_CODE).get(shipOrderInfo.getShipOrderState()));

            //查询销售单主体信息
            UocSaleOrderDo saleOrderInfo = getSaleOrderDo(shipOrderInfo.getSaleOrderId(),shipOrderInfo.getOrderId());
            if (ObjectUtil.isNotEmpty(saleOrderInfo.getStakeholder())) {
                //设置三方信息
                BeanUtils.copyProperties(saleOrderInfo.getStakeholder(), uocQryShipOrderDetailsRspDetailBo);
                //设置销售单编号
                uocQryShipOrderDetailsRspDetailBo.setSaleOrderNo(saleOrderInfo.getSaleOrderNo());
            }

            //查询销售单明细信息
            List<UocSaleOrderItem> saleOrderItemInfos = this.getSaleOrderItemInfos(shipOrderInfo.getSaleOrderId(), shipOrderInfo.getOrderId());
            //将销售单明细List转化为map
            Map<Long, UocSaleOrderItem> saleOrderItemMap = saleOrderItemInfos.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
            //查询发货单明细信息
            List<UocShipOrderItem> shipOrderItemInfos = this.getShipOrderItemInfos(reqBo.getShipOrderId(), reqBo.getOrderId());

            //组装发货单明细信息
            List<UocQryShipOrderDetailsRspDetailItemBo> shipOrderItemBoList = new ArrayList<>();
            for (UocShipOrderItem shipOrderItem : shipOrderItemInfos) {
                UocQryShipOrderDetailsRspDetailItemBo rspItemBo = new UocQryShipOrderDetailsRspDetailItemBo();
                BeanUtils.copyProperties(shipOrderItem, rspItemBo);
                if (saleOrderItemMap.containsKey(shipOrderItem.getSaleOrderItemId())) {
                    UocSaleOrderItem saleOrderItem = saleOrderItemMap.get(shipOrderItem.getSaleOrderItemId());
                    if (shipOrderItem.getSendCount() != null && shipOrderItem.getReturnCount() != null && saleOrderItem.getAfterServingCount() != null) {
                        //计算可售后数量
                        BigDecimal afterCountEnable = shipOrderItem.getSendCount().subtract(shipOrderItem.getReturnCount()).subtract(shipOrderItem.getAfterServingCount());
                        //设置可售后数量
                        rspItemBo.setAvailableAfServCount(afterCountEnable);
                    }
                    BeanUtils.copyProperties(saleOrderItem, rspItemBo);
                    rspItemBo.setRefuseCount(shipOrderItem.getRefuseCount());
                    rspItemBo.setSendCount(shipOrderItem.getSendCount());
                    rspItemBo.setReturnCount(shipOrderItem.getReturnCount());
                    rspItemBo.setAfterServingCount(shipOrderItem.getAfterServingCount());
                    rspItemBo.setInspCount(shipOrderItem.getInspCount());
                    rspItemBo.setArriveCount(shipOrderItem.getArriveCount());
                    rspItemBo.setChngingCount(shipOrderItem.getChngingCount());
                    rspItemBo.setUnitDigit(StringUtils.isEmpty(saleOrderItem.getUnitDigit()) ? "" : saleOrderItem.getUnitDigit());
                    //计算验收销售金额
                    if(shipOrderItem.getInspCount() != null){
                        //计算验收销售金额
                        rspItemBo.setInspSaleFee(shipOrderItem.getInspCount().multiply(saleOrderItem.getSalePrice()));
                    }
                }
                //翻译发货单明细状态
                if (ObjectUtil.isNotEmpty(shipOrderItem.getShipItemState())) {
                    rspItemBo.setShipItemStateStr(dicMap.get(UocStateConstants.ShipOrder.P_CODE).get(shipOrderItem.getShipItemState()));
                } else {
                    rspItemBo.setShipItemStateStr(dicMap.get(UocStateConstants.ShipOrder.P_CODE).get(shipOrderInfo.getShipOrderState()));
                }
                shipOrderItemBoList.add(rspItemBo);
            }
            //设置发货单明细
            uocQryShipOrderDetailsRspDetailBo.setShipOrderItemBoList(shipOrderItemBoList);

            //获取发货单附件信息
            this.getShipOrderAccessoryQry(reqBo, uocQryShipOrderDetailsRspDetailBo);

            return uocQryShipOrderDetailsRspDetailBo;
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询发货单信息失败");
        }
    }

    /**
     * 获取发货单附件信息
     * @param reqBo 发货单详情查询入参
     */
    private void getShipOrderAccessoryQry(UocQryShipOrderDetailsReqBo reqBo, UocQryShipOrderDetailsRspDetailBo uocQryShipOrderDetailsRspDetailBo) {
        //定义发货单附件集合
        List<UocBaseOrderAccessoryDetailBo> orderDeliveryAccessoryBoList = new ArrayList<>(1);

        //定义发货单附件查询参数
        UocOrderAccessoryQryBo shipOrderAccessoryQry = new UocOrderAccessoryQryBo();
        //设置单据类型
        shipOrderAccessoryQry.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        //设置单据ID
        shipOrderAccessoryQry.setObjId(reqBo.getShipOrderId());
        //设置附件类型
        shipOrderAccessoryQry.setAttachmentType(UocAttachementTypeConstants.DELIVERY);
        //调用查询订单附件
        List<UocOrderAccessory> shipOrderAccessoryList = this.orderModel.getOrderAccessoryList(shipOrderAccessoryQry);

        if (!CollectionUtils.isEmpty(shipOrderAccessoryList)) {
            //附件明细数据转换
            orderDeliveryAccessoryBoList = JSON.parseArray(JSON.toJSONString(shipOrderAccessoryList), UocBaseOrderAccessoryDetailBo.class);
        }

        //设置发货单附件集合
        uocQryShipOrderDetailsRspDetailBo.setOrderDeliveryAccessoryBoList(orderDeliveryAccessoryBoList);
    }


    /**
     * 查询订单收货地址信息
     * @param orderId
     * @return
     */
    private UocQryShipOrderDetailsLogisticsRelaBo queryLogisticsInfo(Long orderId) {
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(orderId);
        uocOrderDo = orderModel.qryOrderBy(uocOrderDo);
        UocOrdLogisticsRelaQryBo uocOrdLogisticsRelaQryBo = new UocOrdLogisticsRelaQryBo();
        uocOrdLogisticsRelaQryBo.setOrderId(orderId);
        uocOrdLogisticsRelaQryBo.setContactId(uocOrderDo.getContactId());
        UocOrdLogisticsRela uocOrdLogisticsRela = this.orderModel.qryOrderLogisticsRela(uocOrdLogisticsRelaQryBo);
        if (null != uocOrdLogisticsRela) {
            UocQryShipOrderDetailsLogisticsRelaBo uocQryShipOrderDetailsLogisticsRelaBo = new UocQryShipOrderDetailsLogisticsRelaBo();
            BeanUtils.copyProperties(uocOrdLogisticsRela,uocQryShipOrderDetailsLogisticsRelaBo);
            return uocQryShipOrderDetailsLogisticsRelaBo;
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询订单收货地址信息失败");
        }
    }

    /**
     * 参数校验
     * @param reqBo
     */
    private void validateArg(UocQryShipOrderDetailsReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocQryShipOrderDetailsReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getShipOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[发货单ID]不能为空");
        }


    }

    /**
     * 查询销售单主体信息
     * @return
     */
    private UocSaleOrderDo getSaleOrderDo(Long saleOrderId,Long orderId) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(saleOrderId);
        uocSaleOrderQryBo.setOrderId(orderId);
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        if(null != uocSaleOrderDo){
            return uocSaleOrderDo;
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询销售单主体信息失败");
        }
    }

    /**
     * 查询销售单明细信息
     * @param saleOrderId
     * @param orderId
     * @return
     */
    private List<UocSaleOrderItem> getSaleOrderItemInfos(Long saleOrderId,Long orderId) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(saleOrderId);
        uocSaleOrderItemQryBo.setOrderId(orderId);
        UocSaleOrderDo saleOrderItems = this.iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
        if(null != saleOrderItems){
            return saleOrderItems.getSaleOrderItems();
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询销售单明细信息失败");
        }
    }

    /**
     * 获取字典
     * @return
     */
    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocStateConstants.ShipOrder.P_CODE);
        Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
        if(CollectionUtil.isNotEmpty(dictionaryMap)){
            return dictionaryMap;
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询字典失败");
        }
    }
}
