package com.tydic.dyc.oc.service.importorder;

import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.importorder.IUocImportOrderModel;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderQryDetailReqBo;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderQryDetailRspBo;
import com.tydic.dyc.oc.service.importorder.bo.UocImportOrderDetailQryReqBo;
import com.tydic.dyc.oc.service.importorder.bo.UocImportOrderDetailQryRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：UocImportOrderDetailQryServiceImpl
 * 描述：导入订单记录详情查询接口实现类
 */
@Slf4j
@HTServiceImpl
public class UocImportOrderDetailQryServiceImpl implements UocImportOrderDetailQryService {

    /**
     * 导入订单记录领域方法服务
     */
    @Autowired
    private IUocImportOrderModel iUocImportOrderModel;

    /**
     * 导入订单记录详情查询
     */
    @Override
    public UocImportOrderDetailQryRspBo qryImportOrderDetail(UocImportOrderDetailQryReqBo reqBo) {
        //定义导入订单记录详情查询参数，参数转换
        UocImportOrderQryDetailReqBo uocImportOrderQryDetailReqBo = UocRu.js(reqBo, UocImportOrderQryDetailReqBo.class);

        //调用导入订单记录领域方法服务，导入订单记录详情查询
        UocImportOrderQryDetailRspBo uocImportOrderQryDetailRspBo = this.iUocImportOrderModel.qryImportOrderDetail(uocImportOrderQryDetailReqBo);

        //定义出参对象，参数转换
        UocImportOrderDetailQryRspBo rspBo = UocRu.js(uocImportOrderQryDetailRspBo, UocImportOrderDetailQryRspBo.class);

        //出参
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBo;
    }

}
