package com.tydic.dyc.oc.service.importorder;

import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.importorder.IUocImportOrderModel;
import com.tydic.dyc.oc.model.importorder.UocImportOrderDo;
import com.tydic.dyc.oc.service.importorder.bo.UocImportOrderUpdateReqBo;
import com.tydic.dyc.oc.service.importorder.bo.UocImportOrderUpdateRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：UocImportOrderUpdateServiceImpl
 * 描述：导入订单记录更新接口实现类
 */
@Slf4j
@HTServiceImpl
public class UocImportOrderUpdateServiceImpl implements UocImportOrderUpdateService {

    /**
     * 导入订单记录领域方法服务
     */
    @Autowired
    private IUocImportOrderModel iUocImportOrderModel;

    /**
     * 导入订单记录更新
     */
    @Override
    public UocImportOrderUpdateRspBo updateImportOrder(UocImportOrderUpdateReqBo reqBo) {
        //定义出参对象
        UocImportOrderUpdateRspBo rspBo = new UocImportOrderUpdateRspBo();

        //定义快照单DO，参数转换
        UocImportOrderDo uocImportOrderDo = UocRu.js(reqBo, UocImportOrderDo.class);
        //设置状态 3待下单
        uocImportOrderDo.setStatus(UocConstant.IMPORT_ORDER_STATUS.TO_CREATE_ORDER);
        //设置更新人ID
        uocImportOrderDo.setUpdateUserId(String.valueOf(reqBo.getUserId()));
        //设置更新人名称
        uocImportOrderDo.setUpdateUserName(reqBo.getName());

        //调用导入订单记录领域方法服务，导入订单记录更新
        this.iUocImportOrderModel.updateImportOrder(uocImportOrderDo);

        //出参
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBo;
    }

}
