package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.oc.service.common.bo.UocProRspConstants;
import com.tydic.dyc.oc.service.order.bo.UocQryOrderSettlementReqBO;
import com.tydic.dyc.oc.service.order.bo.UocQryOrderSettlementRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Value;

/**
 * 描述：
 *
 * @author liao xing jun
 * @date 2020/11/11
 **/
@HTServiceImpl
public class UocQryOrderSettlementServiceImpl implements UocQryOrderSettlementService {
//    @Autowired
//    private PebIntfQueryContractSupplierService pebIntfQueryContractSupplierService;
//
//    @Autowired
//    private PebIntfSettlementModeExceptQryListService pebIntfSettlementModeExceptQryListService;
    @Value("${busiMode:0}")
    private String initBusiMode;
    @Value("${uoc.saveJdOrgId:false}")
    private Boolean saveJdOrgId;

    /**
     * 京东订单交易模式查询
     *
     * @param reqBO
     * @return
     */
    @Override
    public UocQryOrderSettlementRspBO qryOrderSettlement(UocQryOrderSettlementReqBO reqBO) {
        UocQryOrderSettlementRspBO rspBO = new UocQryOrderSettlementRspBO();

        rspBO.setRespCode(UocProRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocProRspConstants.RSP_DESC_SUCCESS);
        rspBO.setValPin(saveJdOrgId);
        if (saveJdOrgId == null || !saveJdOrgId) {
            return rspBO;
        }

        String busiMode = initBusiMode;

        rspBO.setBusiMode(busiMode);
        return rspBO;
    }
}
