package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelApplySaleOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelApplySaleOrderRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocCancelApplySaleOrderTransaction
 * 说明:
 * 时间:2023/8/29 10:18
 * 作者:田桂银
 */
@Component
@Slf4j
public class UocCancelApplySaleOrderTransaction {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocCancelApplySaleOrderRspBo cancelApplySaleOrder(UocCancelApplySaleOrderReqBo reqBo) {
        //参数校验
        this.verifyParam(reqBo);
        //查询销售单主体信息
        UocSaleOrderDo queryUocSaleOrderDo = new UocSaleOrderDo();
        queryUocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        queryUocSaleOrderDo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo saleOrderInfo = this.iUocSaleOrderModel.getSaleOrderMain(queryUocSaleOrderDo);
        if (null != saleOrderInfo) {
            //生成取消申请变更单
            Long changeOrderId = this.createCancelApplyChangeOrder(reqBo,saleOrderInfo);
            //更新销售单主体信息
            this.updateSaleOrderInfo(reqBo);

            UocCancelApplySaleOrderRspBo rspBo = new UocCancelApplySaleOrderRspBo();
            rspBo.setChngOrderId(changeOrderId);
            rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
            return rspBo;
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CANCEL_APPLY_ERROR, "该销售单不存在");
        }
    }

    /**
     * 生成取消申请变更单
     * @param reqBo
     * @param saleOrderInfo
     */
    private Long createCancelApplyChangeOrder(UocCancelApplySaleOrderReqBo reqBo,UocSaleOrderDo saleOrderInfo){
        //获取销售单明细
        List<UocSaleOrderItem> saleOrderItemList = this.getSaleOrderItemList(reqBo);
        //取消申请变更单id
        Long changeOrderId = IdUtil.nextId();
        //取消申请变更单号
        String changeOrderNo = this.getChngOrderNo(saleOrderInfo.getOrderSource());
        //组装要生成的申请变更单
        UocChngOrderDo createChngOrderDo = new UocChngOrderDo();
        createChngOrderDo.setOrderId(reqBo.getOrderId());
        createChngOrderDo.setChngOrderId(changeOrderId);
        createChngOrderDo.setChngOrderNo(changeOrderNo);
        createChngOrderDo.setChngOrderState(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.CHNG_XS_QXSQZ);
        createChngOrderDo.setCancelReason(reqBo.getCancelReason());
        createChngOrderDo.setCancelOperId(String.valueOf(reqBo.getUserId()));
        createChngOrderDo.setCancelOperName(reqBo.getName());
        createChngOrderDo.setCancelTime(new Date());
        createChngOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        createChngOrderDo.setCreateOperName(reqBo.getName());
        createChngOrderDo.setCreateTime(new Date());
        createChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL);
        //组装要生成的变更对象
        Long changeOrderObjectId = IdUtil.nextId();
        List<UocChngOrderObj> createChngOrderObjList = new ArrayList<>();
        UocChngOrderObj createChngOrderObj = new UocChngOrderObj();
        createChngOrderObj.setOrderId(reqBo.getOrderId());
        createChngOrderObj.setChngOrderObjId(changeOrderObjectId);
        createChngOrderObj.setChngOrderId(changeOrderId);
        createChngOrderObj.setChngType(UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL);
        createChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
        createChngOrderObj.setCreateTime(new Date());
        createChngOrderObj.setCreateOperId(String.valueOf(reqBo.getUserId()));
        createChngOrderObj.setOtherChngValue(saleOrderInfo.getSaleOrderState());
        //组装要生成的变更明细
        List<UocChngOrderItemObj> createChngOrderItemObjList = new ArrayList<>();
        for(UocSaleOrderItem saleOrderItem:saleOrderItemList){
            UocChngOrderItemObj createChngOrderItem = new UocChngOrderItemObj();
            createChngOrderItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            createChngOrderItem.setId(IdUtil.nextId());
            createChngOrderItem.setChngOrderId(changeOrderId);
            createChngOrderItem.setChngOrderObjId(changeOrderObjectId);
            createChngOrderItem.setOrderId(reqBo.getOrderId());
            createChngOrderItem.setCreateTime(new Date());
            createChngOrderItem.setCreateOperId(String.valueOf(reqBo.getUserId()));
            createChngOrderItemObjList.add(createChngOrderItem);
        }
        createChngOrderObj.setUocChngOrderItemObjList(createChngOrderItemObjList);
        createChngOrderObjList.add(createChngOrderObj);
        createChngOrderDo.setUocChngOrderObjList(createChngOrderObjList);
        //如果有附件，生成需要保存的附件信息
        if (!CollectionUtils.isEmpty(reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> saveOrderAccessoryList = new ArrayList<>();
            for(UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo:reqBo.getOrderAccessoryBoList()){
                UocOrderAccessory createUocOrderAccessory = new UocOrderAccessory();
                BeanUtils.copyProperties(uocBaseOrderAccessoryAddBo,createUocOrderAccessory);
                createUocOrderAccessory.setOrderId(reqBo.getOrderId());
                createUocOrderAccessory.setId(IdUtil.nextId());
                createUocOrderAccessory.setObjId(changeOrderId);
                createUocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
                createUocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.CANCEL_APPLY_SALE_ORDER);
                createUocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                createUocOrderAccessory.setCreateTime(new Date());
                saveOrderAccessoryList.add(createUocOrderAccessory);
            }
            createChngOrderDo.setOrderAccessoryBoList(saveOrderAccessoryList);
        }
        //生成取消申请变更单
        this.iUocChngOrderModel.createChngOrder(createChngOrderDo);

        return changeOrderId;
    }


    /**
     * 获取销售单明细
     * @param reqBo
     * @return
     */
    private List<UocSaleOrderItem> getSaleOrderItemList(UocCancelApplySaleOrderReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(saleOrderItemList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CANCEL_APPLY_ERROR, "查询销售单明细为空");
        }else{
            return saleOrderItemList;
        }
    }


    /**
     * 获取取消申请变更单号
     * @param orderSource
     * @return
     */
    private String getChngOrderNo(Integer orderSource) {
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL);
        uocChngOrderQryBo.setOrderSource(orderSource);
        UocChngOrderDo uocChngOrderResultDo = this.iUocChngOrderModel.getChngOrderNo(uocChngOrderQryBo);
        if(null != uocChngOrderResultDo){
            return uocChngOrderResultDo.getChngOrderNo();
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CANCEL_APPLY_ERROR, "生成取消申请变更单号失败");
        }
    }

    /**
     * 更新销售单主体信息
     * @param reqBo
     */
    private void updateSaleOrderInfo(UocCancelApplySaleOrderReqBo reqBo){
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        BeanUtils.copyProperties(reqBo,updateSaleOrderDo);
        updateSaleOrderDo.setCancelOperId(String.valueOf(reqBo.getUserId()));
        updateSaleOrderDo.setCancelOperName(reqBo.getName());
        updateSaleOrderDo.setCancelRequestTime(new Date());
        updateSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_QX_QXSQ);
        updateSaleOrderDo.setCancelFlag(reqBo.getCancelFlag());
        this.iUocSaleOrderModel.modifySaleOrderMain(updateSaleOrderDo);
    }

    /**
     * 参数校验
     * @param reqBo
     */
    private void verifyParam(UocCancelApplySaleOrderReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[销售单id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUserId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[用户ID]不能为空");
        }
        if (StringUtils.isEmpty(reqBo.getName())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[用户名称]不能为空");
        }
    }
}


