package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.venus.extension.Extension;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ext.oc.constants.UocExtRspConstant;
import com.tydic.dyc.ext.oc.service.UocSplitOrderServiceExtPt;
import com.tydic.dyc.ext.oc.service.bo.UocSplitOrderServiceItemBo;
import com.tydic.dyc.ext.oc.service.bo.UocSplitOrderServiceReqBo;
import com.tydic.dyc.ext.oc.service.bo.UocSplitOrderServiceRspBo;
import com.tydic.dyc.ext.oc.service.bo.UocSplitOrderServiceSaleOrderBo;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessor;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessorManager;
import com.tydic.dyc.oc.config.UocSystemConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalLog;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.*;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceRef;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 标题:UocCreateOrderServiceTransaction
 * 说明:
 * 时间:2023/8/28 15:25
 * 作者:田桂银
 */
@Component
@Slf4j
public class UocCreateOrderServiceTransaction {
    //订单领域方法对象
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private UocOrderSourceProcessorManager uocOrderSourceProcessorManager;

    @Autowired
    private UocSystemConfig uocSystemConfig;

    @Value("${uoc.rpcSplitSwitch:false}")
    private boolean rpcSplitSwitch;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @HTServiceRef
    @Extension
    private UocSplitOrderServiceExtPt uocSplitOrderServiceExtPt;

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocCreateOrderServiceRspBo createOrder(UocCreateOrderServiceReqBo reqBo) {
        log.info("订单创建入参：{}", JSON.toJSONString(reqBo));
        //参数校验
//        this.verifyParam(reqBo);
        //主订单创建
        UocOrderDo createOrderDo = JSONObject.parseObject(JSON.toJSONString(reqBo), UocOrderDo.class);
        createOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        createOrderDo.setCreateOperName(reqBo.getName());
        createOrderDo.setCreateTime(new Date());
        //设置下单人名称
        createOrderDo.setUsername(reqBo.getUserName());
        UocOrderDo orderResult = this.iUocOrderModel.createOrder(createOrderDo);
        log.info("下单结果：{}", JSON.toJSONString(orderResult));
        //销售单拆单
        List<UocSaleOrderItem> saleOrderItemList = JSONArray.parseArray(JSON.toJSONString(orderResult.getOrderItems())).toJavaList(UocSaleOrderItem.class);
        //将供应商id和结算模式组成一个全新的key值，用于按照供应商+结算模式拆单(只针对于无协议和电商模式)
        //this.createSplitKey(saleOrderItemList, reqBo.getSupplierBos());
        List<UocSaleOrderDo> createSaleOrderList = this.splitSaleOrderNew(reqBo, orderResult, saleOrderItemList);
        //销售单创建
        List<UocCreateOrderServiceRspSaleOrderBo> saleOrderResultList = new ArrayList<>();
        for (UocSaleOrderDo saleOrderDo : createSaleOrderList) {
            // 设置销售名单名称等于订单名称
            saleOrderDo.setSaleOrderName(createOrderDo.getOrderName());
            //创建销售单
            UocSaleOrderDo saleOrder = this.iUocSaleOrderModel.createSaleOrder(saleOrderDo);
            //设置出参
            UocCreateOrderServiceRspSaleOrderBo orderItemRspData = new UocCreateOrderServiceRspSaleOrderBo();
            BeanUtils.copyProperties(saleOrder, orderItemRspData);
            BeanUtils.copyProperties(saleOrder.getStakeholder(), orderItemRspData);
            orderItemRspData.setSaleOrderId(saleOrder.getSaleOrderId());
            List<UocCreateOrderServiceRspSaleOrderItemBo> itemList = UocRu.jsl(saleOrder.getSaleOrderItems(), UocCreateOrderServiceRspSaleOrderItemBo.class);
            orderItemRspData.setItemBoList(itemList);
            orderItemRspData.setSaleOrderNo(saleOrder.getSaleOrderNo());
            orderItemRspData.setOrderSource(saleOrder.getOrderSource());
            orderItemRspData.setAgrId(saleOrder.getAgreementId());
            orderItemRspData.setModelSettle(saleOrder.getModelSettle());
            orderItemRspData.setPayType(saleOrder.getPayType() != null ? Integer.valueOf(saleOrder.getPayType()) : null);
            orderItemRspData.setTotalTransFee(saleOrder.getTotalTransFee());
            orderItemRspData.setTotalGoodsSaleFee(saleOrder.getTotalGoodsSaleFee());
            saleOrderResultList.add(orderItemRspData);
        }
        //审批单创建
        Long auditId = this.createAuditOrder(reqBo, createSaleOrderList);

        UocCreateOrderServiceRspBo rspBo = UocRu.success(UocCreateOrderServiceRspBo.class);
        rspBo.setAuditId(auditId);
        rspBo.setTotalSaleFee(orderResult.getTotalSaleFee());
        rspBo.setTotalPurchaseFee(orderResult.getTotalPurchaseFee());
        rspBo.setOrderId(orderResult.getOrderId());
        rspBo.setOrderNo(orderResult.getOrderNo());
        rspBo.setSaleOrderList(saleOrderResultList);
        return rspBo;


//        //bo转订单do
//        UocOrderDo createDo = convertOrderDo(reqBo);
//
//        //创建订单
//        UocOrderDo createOrderRet = iUocOrderModel.createOrder(createDo);
//        rspBo.setTotalSaleFee(createDo.getTotalSaleFee());
//        rspBo.setTotalPurchaseFee(createDo.getTotalPurchaseFee());
//        rspBo.setSaleOrderList(new ArrayList<>());
//
//        //供应商签约信息
//        JSONObject supSignInfo = reqBo.getJsonObj();
//
//        //创建销售单
//        if (reqBo.getCreateSaleOrder()) {
//            //订单明细转销售单明细(根据销售单明细进行拆单)
//            List<UocSaleOrderItem> uocSaleOrderItemList = orderDo2SaleDo(createOrderRet, reqBo);
//
//            //拆单
//            List<UocSaleOrderDo> splitSaleOrderList = splitSaleOrder(createOrderRet, reqBo, uocSaleOrderItemList, supSignInfo);
//
//            for (UocSaleOrderDo saleOrderDo : splitSaleOrderList) {
//                //创建销售单
//                UocSaleOrderDo saleOrderRet = iUocSaleOrderModel.createSaleOrder(saleOrderDo);
//
//                //设置出参
//                UocCreateOrderServiceRspSaleOrderBo orderItemRspData = new UocCreateOrderServiceRspSaleOrderBo();
//                BeanUtils.copyProperties(saleOrderRet, orderItemRspData);
//                BeanUtils.copyProperties(saleOrderRet.getStakeholder(), orderItemRspData);
//                orderItemRspData.setSaleOrderId(saleOrderRet.getSaleOrderId());
//                List<UocCreateOrderServiceRspSaleOrderItemBo> itemList = UocRu.jsl(saleOrderRet.getSaleOrderItems(), UocCreateOrderServiceRspSaleOrderItemBo.class);
//                orderItemRspData.setItemBoList(itemList);
//                orderItemRspData.setSaleOrderNo(saleOrderRet.getSaleOrderNo());
//                orderItemRspData.setOrderSource(saleOrderRet.getOrderSource());
//                orderItemRspData.setAgrId(saleOrderRet.getAgreementId());
//                orderItemRspData.setPayType(saleOrderRet.getPayType() != null ? Integer.valueOf(saleOrderRet.getPayType()) : null);
//                rspBo.getSaleOrderList().add(orderItemRspData);
//            }
//        }
//
//        rspBo.setOrderId(createDo.getOrderId());
//        rspBo.setOrderNo(createDo.getOrderNo());
//        return rspBo;
    }

    private Long createAuditOrder(UocCreateOrderServiceReqBo reqBo, List<UocSaleOrderDo> createSaleOrderList) {
        Long auditId = IdUtil.nextId();
        UocAuditOrderDo auditDo = UocRu.js(reqBo, UocAuditOrderDo.class);
        auditDo.setAuditOrderId(auditId);
        auditDo.setCreateOperId(reqBo.getUserId().toString());
        auditDo.setCreateOperName(reqBo.getName());
        auditDo.setOrderId(createSaleOrderList.get(0).getOrderId());
        auditDo.setAuditOrderStatus(UocStateConstants.AUDIT_ORDER_STATUS.WAIT_AUDIT);
        List<UocApprovalObj> objList = new ArrayList<>();
        auditDo.setApprovalObjs(objList);
        UocApprovalObj approvalObj = new UocApprovalObj();
        objList.add(approvalObj);
        approvalObj.setObjId(createSaleOrderList.get(0).getOrderId().toString());
        approvalObj.setId(IdUtil.nextId());
        approvalObj.setAuditOrderId(auditDo.getAuditOrderId());
        approvalObj.setOrderId(createSaleOrderList.get(0).getOrderId());
        approvalObj.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        approvalObj.setObjBusiType(UocConstant.OBJ_BUSI_TYPE.ORDER);
        /*for (UocSaleOrderDo saleOrderDo : createSaleOrderList) {
            UocApprovalObj approvalObj = new UocApprovalObj();
            objList.add(approvalObj);
            approvalObj.setObjId(saleOrderDo.getOrderId().toString());
            approvalObj.setId(IdUtil.nextId());
            approvalObj.setAuditOrderId(auditDo.getAuditOrderId());
            approvalObj.setOrderId(reqBo.getOrderId());
            approvalObj.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
            approvalObj.setObjBusiType(UocConstant.OBJ_BUSI_TYPE.ORDER);
        }*/
        UocApprovalLog uocApprovalLog = new UocApprovalLog();
        uocApprovalLog.setAuditOrderId(auditId);
        uocApprovalLog.setId(IdUtil.nextId());
        uocApprovalLog.setOperid(reqBo.getUserId().toString());
        uocApprovalLog.setOperName(reqBo.getName());
        uocApprovalLog.setOperDept(reqBo.getOrgId()+"");
        uocApprovalLog.setCreateTime(new Date());
        uocApprovalLog.setObjNum(objList.size());
        uocApprovalLog.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        uocApprovalLog.setAuditResult(UocConstant.AUDIT_TYPE.CREATE);
        auditDo.setApprovalLog(uocApprovalLog);

        iUocAuditOrderModel.saveAudit(auditDo);
        return auditId;
    }

    /**
     * 将供应商id和结算模式组成一个全新的key值，用于按照供应商+结算模式拆单(只针对于无协议和电商模式)
     *
     * @param saleOrderItemList
     * @param supplierBos
     */
    private void createSplitKey(List<UocSaleOrderItem> saleOrderItemList, List<UocSupplierInfoBo> supplierBos) {
        Map<Long, UocSupplierInfoBo> supplierInfoMap = supplierBos.stream().collect(Collectors.toMap(UocSupplierInfoBo::getSupplierId, item -> item));
        for (UocSaleOrderItem saleOrderItem : saleOrderItemList) {
            UocSupplierInfoBo supplierInfoBo = supplierInfoMap.get(Long.valueOf(saleOrderItem.getSupplierId()));
            if (null == supplierInfoBo) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_SYSTEM_EXCEPTION, "供应商支付配置集合没有包含完所有的商品！");
            }
            String supplierIdModelSettelKey = "";
            if (ObjectUtil.isNotEmpty(supplierInfoBo.getExtPayConfigBos()) && supplierInfoBo.getExtSkuCategoryIds().contains(saleOrderItem.getCommodityTypeId())) {
                supplierIdModelSettelKey = saleOrderItem.getSupplierId() + "_" + supplierInfoBo.getExtPayConfigBos().get(0).getModelSettle();
            } else {
                supplierIdModelSettelKey = saleOrderItem.getSupplierId() + "_" + supplierInfoBo.getPayConfigBos().get(0).getModelSettle();
            }
            saleOrderItem.setSupplierIdModelSettelKey(supplierIdModelSettelKey);
        }
    }


    private List<UocSaleOrderDo> splitSaleOrderNew(UocCreateOrderServiceReqBo reqBo, UocOrderDo orderInfo, List<UocSaleOrderItem> saleOrderItemList) {
        //定义销售单列表
        List<UocSaleOrderDo> saleOrderList = new ArrayList<>();

        //统一拆单逻辑，可以根据迪易采还是项目实现各自拆单逻辑（项目上通过rpc服务调用，获取拆单结果数据）
//        List<List<UocSaleOrderItem>> splitSaleOrderResultList = splitOrder(saleOrderItemList);
        List<UocSaleOrderDo> splitSaleOrderResultList = splitOrder(saleOrderItemList, orderInfo);

        //供应商信息，转化为map，便于后面使用
        List<UocSupplierInfoBo> supplierInfoList = reqBo.getSupplierBos();
        Map<Long, UocSupplierInfoBo> supplierInfoMap = new HashMap<>();
        if (ObjectUtil.isNotEmpty(supplierInfoList)) {
            supplierInfoMap = supplierInfoList.stream().collect(Collectors.toMap(UocSupplierInfoBo::getSupplierId, item -> item));
        }

        //协议信息，转化为map，便于后面使用
        List<UocCreateOrderServiceReqArgPayConfSupBo> agrPayConfigList = reqBo.getAgrPayConfigList();
        Map<String, UocCreateOrderServiceReqArgPayConfSupBo> agrPayConfigMap = new HashMap<>();
        if (ObjectUtil.isNotEmpty(agrPayConfigList)) {
            agrPayConfigMap = agrPayConfigList.stream().collect(Collectors.toMap(UocCreateOrderServiceReqArgPayConfSupBo::getAgrId, item -> item));
        }

        //供应商运费转化为map，便于后面使用
        Map<String, UocSupTransFeeBO> supTransFeeMap = reqBo.getDycUocSupTransFeeBOList().stream().collect(Collectors.toMap(bo -> bo.getSupplierId() + "_" + bo.getAgreementId(), Function.identity()));
        log.debug("transmap:" + JSON.toJSONString(supTransFeeMap));
        //根据订单id查询已入库的三方信息,并组成map，便于后续使用
        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
        uocOrderStakeholderQryBo.setOrderId(orderInfo.getOrderId());
        List<UocOrderStakeholderQryBo> orderStakeholderList = this.iUocOrderModel.qryStakeholderList(uocOrderStakeholderQryBo);
        Map<String, List<UocOrderStakeholderQryBo>> orderStakeholderMap = orderStakeholderList.stream().collect(Collectors.groupingBy(UocOrderStakeholderQryBo::getSupId));
        //根据拆单结果封装生成销售单信息
        Map<String,UocSaleOrderItem> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSkuId, o -> o));

        for (UocSaleOrderDo saleOrderDo : splitSaleOrderResultList) {
            UocSaleOrderDo createSaleOrderDo = JUtil.js(orderInfo, UocSaleOrderDo.class);
            saleOrderList.add(createSaleOrderDo);

            createSaleOrderDo.setExtFields(saleOrderDo.getExtFields());
            if (ObjectUtil.isNotEmpty(saleOrderDo.getExtFields())) {
                createSaleOrderDo.setSaleOrderMapList(JUtil.jsl(saleOrderDo.getExtFields(), UocSaleOrderMap.class));
            }

            List<UocSaleOrderItem> saleOrderItems = saleOrderDo.getSaleOrderItems();
            for (UocSaleOrderItem each : saleOrderItems) {
                List<BaseExtendFieldBo> extFields =  each.getExtFields();
                BeanUtils.copyProperties(saleOrderItemMap.get(each.getSkuId()), each);
                //订单明细扩展数据，可能为空
//                List<BaseExtendFieldBo> extFields = orderItem.getExtFields();
                if (ObjectUtil.isNotEmpty(extFields)) {
                    List<UocSaleItemMap> itemMapList = new ArrayList<>();
                    for (BaseExtendFieldBo extField : extFields) {
                        UocSaleItemMap uocSaleItemMap = new UocSaleItemMap();
                        uocSaleItemMap.setId(IdUtil.nextId());
                        uocSaleItemMap.setOrderId(createSaleOrderDo.getOrderId());
                        uocSaleItemMap.setCreateTime(createSaleOrderDo.getCreateTime());
                        uocSaleItemMap.setCreateOperId(createSaleOrderDo.getCreateOperId());
    
                        uocSaleItemMap.setFieldCode(extField.getFieldCode());
                        uocSaleItemMap.setFieldName(extField.getFieldName());
                        uocSaleItemMap.setFieldValue(extField.getFieldValue());
                        uocSaleItemMap.setRemark(extField.getRemark());
                        itemMapList.add(uocSaleItemMap);
                    }
                    each.setSaleItemMapList(itemMapList);
                }
            }

            createSaleOrderDo.setSaleOrderItems(saleOrderItems);
            createSaleOrderDo.setSaleOrderAccessoryList(orderInfo.getAccessoryList());
            //设置订单来源
            createSaleOrderDo.setOrderSource(saleOrderItems.get(0).getSkuSource());
            //设置三方信息id
            createSaleOrderDo.setStakeholderId(orderStakeholderMap.get(saleOrderItems.get(0).getSupplierId()).get(0).getStakeholderId());
            //设置三方信息
            createSaleOrderDo.setStakeholder(UocRu.js(orderStakeholderMap.get(saleOrderItems.get(0).getSupplierId()).get(0), UocSaleStakeholder.class));
            //设置销售单运费
            String agreementId = StringUtils.isNotBlank(saleOrderItems.get(0).getAgreementId()) ? saleOrderItems.get(0).getAgreementId():"null";
            String transkey = saleOrderItems.get(0).getSupplierId() + "_" + agreementId;
            log.debug("transkey:" + transkey);
            log.debug("transvalue:" + supTransFeeMap.get(transkey));
            createSaleOrderDo.setTotalTransFee(supTransFeeMap.get(transkey).getTotalTransFee());
            //设置商品销售总价
            createSaleOrderDo.setTotalGoodsSaleFee(this.computeSaleOrderTotalSaleFee(saleOrderItems,saleOrderItemMap));
            //设置商品采购总价
            createSaleOrderDo.setTotalGoodsPurchaseFee(this.computeSaleOrderTotalPurchaseFee(saleOrderItems,saleOrderItemMap));
            //设置销售总价
            createSaleOrderDo.setTotalSaleFee(createSaleOrderDo.getTotalGoodsSaleFee().add(createSaleOrderDo.getTotalTransFee()));
            //设置采购总价
            createSaleOrderDo.setTotalPurchaseFee(createSaleOrderDo.getTotalGoodsPurchaseFee().add(createSaleOrderDo.getTotalTransFee()));
            //设置扣款账户
            createSaleOrderDo.setReduceAccount(supTransFeeMap.get(transkey).getReduceAccount());
            //设置扣款账号所属id
            createSaleOrderDo.setDeductionCompanyId(supTransFeeMap.get(transkey).getDeductionCompanyId());
            //设置默认下单结果
            createSaleOrderDo.setCreatedResult(UocConstant.CREATED_RESULT.SUCCESS);
            //如果是电商，默认下单结果是处理中
            if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrderItems.get(0).getSkuSource())) {
                createSaleOrderDo.setCreatedResult(UocConstant.CREATED_RESULT.PROCESSING);
            }
            // 如果是下单时收取 设置生成结算订单管理数据
            if (UocConstant.MONTH_SERVICE_NODE.equals(supplierInfoMap.get(Long.valueOf(saleOrderItems.get(0).getSupplierId())).getMonthReceiveNode())) {
                createSaleOrderDo.setIsCreateServiceFee(true);
            }
            //设置支付配置信息
            if (StringUtils.isNotEmpty(saleOrderItems.get(0).getAgreementId())) {
                //设置支付配置
                List<UocSaleOrderPayConf> payConfigBos = JSONArray.parseArray(JSON.toJSONString(agrPayConfigMap.get(saleOrderItems.get(0).getAgreementId()).getConfBos())).toJavaList(UocSaleOrderPayConf.class);
                //获取协议map
                List<UocOrderAgreement> agrList = orderInfo.getOrderItems().stream().filter(v -> StringUtils.isNotEmpty(v.getAgreementId())).map(UocOrderItem::getAgrBo).collect(Collectors.toList());
                Map<String, UocOrderAgreement> agrMap = agrList.stream().collect(Collectors.toMap(UocOrderAgreement::getAgreementId, Function.identity(), (oldValue, newValue) -> newValue));
                for (UocSaleOrderPayConf payConf : payConfigBos) {
                    BigDecimal totalFee;
                    if (UocDicConstant.USE_TYPE.PUR.equals(payConf.getUserType())) {
                        totalFee = createSaleOrderDo.getTotalSaleFee();
                    } else {
                        totalFee = createSaleOrderDo.getTotalPurchaseFee();
                    }
                    if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(payConf.getPayType())) {
                        //预付款，全给
                        payConf.setPrePayFee(totalFee);
                    } else if (UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(payConf.getPayType())) {
                        //按协议，根据比例
                        if (ObjectUtil.isNotEmpty(payConf.getPrePaySup())) {
                            payConf.setPrePayFee(totalFee.multiply(payConf.getPrePaySup()).multiply(new BigDecimal("0.01")));
                        }
                        if (ObjectUtil.isNotEmpty(payConf.getVerPaySup())) {
                            payConf.setVerPayFee(totalFee.multiply(payConf.getVerPaySup()));
                        }
                        if (ObjectUtil.isNotEmpty(payConf.getPilPaySup())) {
                            payConf.setPilPayFee(totalFee.multiply(payConf.getPilPaySup()));
                        }
                        if (ObjectUtil.isNotEmpty(payConf.getQuaPaySup())) {
                            payConf.setQuaPayFee(totalFee.multiply(payConf.getQuaPaySup()));
                        }
                    } else {
                        //账期，下单时都不付
                        //判断账期是到货付款还是验收付款
                        if (UocDicConstant.PAY_RULE.SPECIFIED_ACCOUNT_DATE.equals(payConf.getPayRule())) {
                            //到货款
                            if (UocDicConstant.PAY_NODE_RULE.ORD_ARRIVE_CALCULATE.equals(payConf.getPayAccountDayRule())) {
                                payConf.setVerPayFee(totalFee);
                                //验收款
                            } else if (UocDicConstant.PAY_NODE_RULE.ORD_ACCEPT_CALCULATE.equals(payConf.getPayAccountDayRule())) {
                                payConf.setPilPayFee(totalFee);
                            }
                        } else {
                            //到货款
                            if (UocDicConstant.PAY_NODE_RULE.ORD_ARRIVE_CALCULATE.equals(payConf.getPayNodeRule())) {
                                payConf.setVerPayFee(totalFee);
                                //验收款
                            } else if (UocDicConstant.PAY_NODE_RULE.ORD_ACCEPT_CALCULATE.equals(payConf.getPayNodeRule())) {
                                payConf.setPilPayFee(totalFee);
                            }
                        }
                    }
                }
                createSaleOrderDo.setSaleOrderPayConfList(payConfigBos);
                //设置结算模式
                createSaleOrderDo.setModelSettle(agrPayConfigMap.get(saleOrderItems.get(0).getAgreementId()).getConfBos().get(0).getModelSettle());
                createSaleOrderDo.setAdjustPrice(agrPayConfigMap.get(saleOrderItems.get(0).getAgreementId()).getAdjustPrice());
                createSaleOrderDo.setAgreementId(saleOrderItems.get(0).getAgreementId());
                createSaleOrderDo.setAgreementNo(saleOrderItems.get(0).getAgreementNo());
                createSaleOrderDo.setAgrDataId(agrMap.get(saleOrderItems.get(0).getAgreementId()).getId());
                createSaleOrderDo.setProDeliveryId(agrPayConfigMap.get(saleOrderItems.get(0).getAgreementId()).getProDeliveryId());
                createSaleOrderDo.setProDeliveryName(agrPayConfigMap.get(saleOrderItems.get(0).getAgreementId()).getProDeliveryName());
            } else {
                /*//设置支付配置
                UocSupplierInfoBo supplierInfoBo = supplierInfoMap.get(Long.valueOf(saleOrderItems.get(0).getSupplierId()));
                //例外的支付配置，需要用例外的支付配置
                List<UocSaleOrderPayConf> payConfigBos;
                if (ObjectUtil.isNotEmpty(supplierInfoBo.getExtSkuCategoryIds()) && supplierInfoBo.getExtSkuCategoryIds().contains(saleOrderItems.get(0).getCommodityTypeId())) {
                    payConfigBos = JSONArray.parseArray(JSON.toJSONString(supplierInfoBo.getExtPayConfigBos())).toJavaList(UocSaleOrderPayConf.class);
                    //设置结算模式
                    createSaleOrderDo.setModelSettle(supplierInfoBo.getExtPayConfigBos().get(0).getModelSettle());
                } else {
                    payConfigBos = JSONArray.parseArray(JSON.toJSONString(supplierInfoBo.getPayConfigBos())).toJavaList(UocSaleOrderPayConf.class);
                    //设置结算模式
                    createSaleOrderDo.setModelSettle(supplierInfoBo.getPayConfigBos().get(0).getModelSettle());
                }
                for (UocSaleOrderPayConf payConf : payConfigBos) {
                    BigDecimal totalFee;
                    if (UocDicConstant.USE_TYPE.PUR.equals(payConf.getUserType())) {
                        totalFee = createSaleOrderDo.getTotalSaleFee();
                    } else {
                        totalFee = createSaleOrderDo.getTotalPurchaseFee();
                    }
                    if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(payConf.getPayType())) {
                        //预付款，全给
                        payConf.setPrePayFee(totalFee);
                    } else if (UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(payConf.getPayType())) {
                        //按协议，根据比例
                        if (ObjectUtil.isNotEmpty(payConf.getPrePaySup())) {
                            payConf.setPrePayFee(totalFee.multiply(payConf.getPrePaySup()).multiply(new BigDecimal("0.01")));
                        }
                        if (ObjectUtil.isNotEmpty(payConf.getVerPaySup())) {
                            payConf.setVerPayFee(totalFee.multiply(payConf.getVerPaySup()));
                        }
                        if (ObjectUtil.isNotEmpty(payConf.getPilPaySup())) {
                            payConf.setPilPayFee(totalFee.multiply(payConf.getPilPaySup()));
                        }
                        if (ObjectUtil.isNotEmpty(payConf.getQuaPaySup())) {
                            payConf.setQuaPayFee(totalFee.multiply(payConf.getQuaPaySup()));
                        }
                    } else {
                        //账期，下单时都不付
                        //判断账期是到货付款还是验收付款
                        if (UocDicConstant.PAY_RULE.SPECIFIED_ACCOUNT_DATE.equals(payConf.getPayRule())) {
                            //到货款
                            if (UocDicConstant.PAY_NODE_RULE.ORD_ARRIVE_CALCULATE.equals(payConf.getPayAccountDayRule())) {
                                payConf.setVerPayFee(totalFee);
                                //验收款
                            } else if (UocDicConstant.PAY_NODE_RULE.ORD_ACCEPT_CALCULATE.equals(payConf.getPayAccountDayRule())) {
                                payConf.setPilPayFee(totalFee);
                            }
                        } else {
                            //到货款
                            if (UocDicConstant.PAY_NODE_RULE.ORD_ARRIVE_CALCULATE.equals(payConf.getPayNodeRule())) {
                                payConf.setVerPayFee(totalFee);
                                //验收款
                            } else if (UocDicConstant.PAY_NODE_RULE.ORD_ACCEPT_CALCULATE.equals(payConf.getPayNodeRule())) {
                                payConf.setPilPayFee(totalFee);
                            }
                        }
                    }
                }
                createSaleOrderDo.setSaleOrderPayConfList(payConfigBos);*/
                //设置结算模式 电商都是贸易
                //createSaleOrderDo.setModelSettle(supplierInfoMap.get(Long.valueOf(saleOrderItems.get(0).getSupplierId())).getPayConfigBos().get(0).getModelSettle());
                createSaleOrderDo.setModelSettle(UocConstant.ModelSettle.MY);
            }
            //供货周期（此处在商品明细维度增加了扩展字段：delivery_cycle）
//            createSaleOrderDo = deliveryCycle(createSaleOrderDo);
            deliveryCycle(createSaleOrderDo);


        }


        return saleOrderList;
    }

    private List<UocSaleOrderDo> splitOrder(List<UocSaleOrderItem> saleOrderItemList,UocOrderDo orderInfo) {
        //定义拆单结果
//        List<List<UocSaleOrderItem>> splitSaleOrderResultList = new ArrayList<>();
        List<UocSaleOrderDo> saleOrderDoList = new ArrayList<>();

        if (!rpcSplitSwitch) {

            //迪易采使用内部拆单逻辑，先根据订单来源拆分数据，由不同订单来源实现类进行处理
            Map<Integer, List<UocSaleOrderItem>> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getSkuSource));
            for (Map.Entry<Integer, List<UocSaleOrderItem>> entry : saleOrderItemMap.entrySet()) {
                UocOrderSourceProcessor instance = this.uocOrderSourceProcessorManager.getInstance(entry.getKey());
                //拆单结果
//                splitSaleOrderResultList.addAll(instance.splitSaleOrder(entry.getValue()));

                for (List<UocSaleOrderItem> uocSaleOrderItems : instance.splitSaleOrder(entry.getValue())) {
                    UocSaleOrderDo createSaleOrderDo = new UocSaleOrderDo();
                    createSaleOrderDo.setSaleOrderItems(uocSaleOrderItems);
                    saleOrderDoList.add(createSaleOrderDo);
                }
            }
        } else {
            //项目，调用外部服务进行拆单
            UocSplitOrderServiceReqBo rpcSplitOrderReqBo = new UocSplitOrderServiceReqBo();
            rpcSplitOrderReqBo.setItemList(JUtil.jsl(saleOrderItemList, UocSplitOrderServiceItemBo.class));
            rpcSplitOrderReqBo.setExtFields(orderInfo.getExtFields());
            log.info("调用rpc拆单服务入参：{}", JSON.toJSONString(rpcSplitOrderReqBo));
            UocSplitOrderServiceRspBo rpcSplitOrderBo = uocSplitOrderServiceExtPt.splitOrder(rpcSplitOrderReqBo);
//            UocSplitOrderServiceRspBo rpcSplitOrderBo = mockTest();
            log.info("调用rpc拆单服务出参：{}", JSON.toJSONString(rpcSplitOrderBo));

            //校验拆单出参
            validateSplitRsp(rpcSplitOrderBo);

            if(null != rpcSplitOrderBo){
                if (BaseRspConstant.RSP_CODE_SUCCESS.equals(rpcSplitOrderBo.getRespCode())) {

                    List<UocSplitOrderServiceSaleOrderBo> splitOrderList = rpcSplitOrderBo.getSplitSaleOrderList();

                    for(UocSplitOrderServiceSaleOrderBo uocSplitOrderServiceSaleOrderBo:splitOrderList){
//                        splitSaleOrderResultList.add(JUtil.jsl(uocSplitOrderServiceSaleOrderBo.getSplitItemList(), UocSaleOrderItem.class));

                        UocSaleOrderDo uocSaleOrderDo =   JUtil.js(uocSplitOrderServiceSaleOrderBo, UocSaleOrderDo.class);

                        uocSaleOrderDo.setSaleOrderItems(JUtil.jsl(uocSplitOrderServiceSaleOrderBo.getSplitItemList(),UocSaleOrderItem.class));

                        saleOrderDoList.add(uocSaleOrderDo);

                    }
//                for (List<UocSplitOrderServiceItemBo> uocSplitOrderServiceItemBos : splitItemList) {
//                    splitSaleOrderResultList.add(JUtil.jsl(uocSplitOrderServiceItemBos, UocSaleOrderItem.class));
//                }
                } else {
                    throw new BaseBusinessException(UocExtRspConstant.RSP_CODE_RPC_SPLIT_ORDER_ERROR, "调用rpc服务拆单失败：" + rpcSplitOrderBo.getRespDesc());
                }
            }
        }

//        return splitSaleOrderResultList;

        return saleOrderDoList;
    }

    private static UocSplitOrderServiceRspBo mockTest() {
        UocSplitOrderServiceRspBo rpcSplitOrderBo;
        rpcSplitOrderBo = JSON.parseObject("{\n" +
                "  \"code\": \"0\",\n" +
                "  \"eventList\": [],\n" +
                "  \"extFields\": [],\n" +
                "  \"message\": \"成功\",\n" +
                "  \"respCode\": \"0000\",\n" +
                "  \"respDesc\": \"成功\",\n" +
                "  \"splitSaleOrderList\": [\n" +
                "    {\n" +
                "      \"agreementId\": \"1147132682782646272\",\n" +
                "      \"agreementNo\": \"\",\n" +
                "      \"extFields\": [\n" +
                "        {\n" +
                "          \"fieldCode\": \"itAgrOrderCode\",\n" +
                "          \"fieldName\": \"\",\n" +
                "          \"fieldValue\": \"1\",\n" +
                "          \"remark\": \"\"\n" +
                "        },\n" +
                "        {\n" +
                "          \"fieldCode\": \"itAgrOrderFlag\",\n" +
                "          \"fieldName\": \"\",\n" +
                "          \"fieldValue\": \"是\",\n" +
                "          \"remark\": \"\"\n" +
                "        },\n" +
                "        {\n" +
                "          \"fieldCode\": \"relevantDeptName\",\n" +
                "          \"fieldName\": \"\",\n" +
                "          \"fieldValue\": \"交行（个性化）运营\",\n" +
                "          \"remark\": \"\"\n" +
                "        },\n" +
                "        {\n" +
                "          \"fieldCode\": \"relevantDeptCode\",\n" +
                "          \"fieldName\": \"\",\n" +
                "          \"fieldValue\": \"扩展字段6\",\n" +
                "          \"remark\": \"\"\n" +
                "        },\n" +
                "        {\n" +
                "          \"fieldCode\": \"relevantDeptId\",\n" +
                "          \"fieldName\": \"\",\n" +
                "          \"fieldValue\": \"1134138067028807680\",\n" +
                "          \"remark\": \"\"\n" +
                "        },\n" +
                "        {\n" +
                "          \"fieldCode\": \"jhAgrDepartment\",\n" +
                "          \"fieldName\": \"\",\n" +
                "          \"fieldValue\": \"交行（个性化）运营\",\n" +
                "          \"remark\": \"\"\n" +
                "        },\n" +
                "        {\n" +
                "          \"fieldCode\": \"jhAgrDepartmentId\",\n" +
                "          \"fieldName\": \"\",\n" +
                "          \"fieldValue\": \"1134138067028807680\",\n" +
                "          \"remark\": \"\"\n" +
                "        }\n" +
                "      ],\n" +
                "      \"orderSource\": 3,\n" +
                "      \"orderSourceStr\": \"\",\n" +
                "      \"splitItemList\": [\n" +
                "        {\n" +
                "          \"agrBo\": {\n" +
                "            \"adjustPrice\": 0,\n" +
                "            \"agreementCode\": 2,\n" +
                "            \"agreementId\": \"1147132682782646272\",\n" +
                "            \"extFields\": [\n" +
                "              {\n" +
                "                \"fieldCode\": \"itAgrOrderCode\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"1\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"itAgrOrderFlag\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"是\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"agrMainExtendJson\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"{}\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"relevantDeptName\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"交行（个性化）运营\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"relevantDeptCode\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"扩展字段6\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"agrMainExtend3\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"IT合同类型名称001\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"relevantDeptId\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"1134138067028807680\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"jhAgrDepartment\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"交行（个性化）运营\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"agrMainExtend7\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"1697444058180702208\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"jhAgrDepartmentId\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"1134138067028807680\",\n" +
                "                \"remark\": \"\"\n" +
                "              }\n" +
                "            ],\n" +
                "            \"producerId\": 33,\n" +
                "            \"scopeType\": 3,\n" +
                "            \"supplierId\": 1137033162682032128,\n" +
                "            \"tradeMode\": 2,\n" +
                "            \"vendorId\": 1137033162682032128\n" +
                "          },\n" +
                "          \"agreementId\": \"1147132682782646272\",\n" +
                "          \"agreementIdItemNo\": \"\",\n" +
                "          \"agreementNo\": \"\",\n" +
                "          \"commodityCode\": \"\",\n" +
                "          \"commodityId\": \"99229212\",\n" +
                "          \"commodityTypeId\": \"10010101\",\n" +
                "          \"extFields\": [\n" +
                "            {\n" +
                "              \"fieldCode\": \"purchasePurposeId\",\n" +
                "              \"fieldName\": \"采购用途(商品明细)\",\n" +
                "              \"fieldValue\": \"893501119366529025\",\n" +
                "              \"remark\": \"\"\n" +
                "            },\n" +
                "            {\n" +
                "              \"fieldCode\": \"purchasePurposeName\",\n" +
                "              \"fieldName\": \"采购用途(商品明细)\",\n" +
                "              \"fieldValue\": \"采购用途0828\",\n" +
                "              \"remark\": \"\"\n" +
                "            }\n" +
                "          ],\n" +
                "          \"orderId\": 1149359463282855936,\n" +
                "          \"orderItemId\": 1149359463282855977,\n" +
                "          \"orderPlanBOList\": [],\n" +
                "          \"planId\": \"\",\n" +
                "          \"planItemId\": \"\",\n" +
                "          \"purchaseCount\": 1.00,\n" +
                "          \"skuCode\": \"6000000188348001\",\n" +
                "          \"skuId\": \"100163884\",\n" +
                "          \"skuMaterialTypeId\": \"null\",\n" +
                "          \"skuName\": \"商品名称1 属性值1\",\n" +
                "          \"skuSource\": 3,\n" +
                "          \"supplierId\": \"1137033162682032128\",\n" +
                "          \"supplierShopId\": \"1134138067028807680\"\n" +
                "        }\n" +
                "      ],\n" +
                "      \"supId\": \"1137033162682032128\"\n" +
                "    },\n" +
                "    {\n" +
                "      \"agreementId\": \"1146023963311218688\",\n" +
                "      \"agreementNo\": \"\",\n" +
                "      \"extFields\": [\n" +
                "        {\n" +
                "          \"fieldCode\": \"itAgrOrderCode\",\n" +
                "          \"fieldName\": \"\",\n" +
                "          \"fieldValue\": \"0\",\n" +
                "          \"remark\": \"\"\n" +
                "        },\n" +
                "        {\n" +
                "          \"fieldCode\": \"itAgrOrderFlag\",\n" +
                "          \"fieldName\": \"\",\n" +
                "          \"fieldValue\": \"否\",\n" +
                "          \"remark\": \"\"\n" +
                "        },\n" +
                "        {\n" +
                "          \"fieldCode\": \"relevantDeptName\",\n" +
                "          \"fieldName\": \"\",\n" +
                "          \"fieldValue\": \"交行（个性化）运营\",\n" +
                "          \"remark\": \"\"\n" +
                "        },\n" +
                "        {\n" +
                "          \"fieldCode\": \"relevantDeptCode\",\n" +
                "          \"fieldName\": \"\",\n" +
                "          \"fieldValue\": \"扩展字段6\",\n" +
                "          \"remark\": \"\"\n" +
                "        },\n" +
                "        {\n" +
                "          \"fieldCode\": \"relevantDeptId\",\n" +
                "          \"fieldName\": \"\",\n" +
                "          \"fieldValue\": \"1134138067028807680\",\n" +
                "          \"remark\": \"\"\n" +
                "        },\n" +
                "        {\n" +
                "          \"fieldCode\": \"jhAgrDepartment\",\n" +
                "          \"fieldName\": \"\",\n" +
                "          \"fieldValue\": \"交行分行采购C部门1\",\n" +
                "          \"remark\": \"\"\n" +
                "        },\n" +
                "        {\n" +
                "          \"fieldCode\": \"jhAgrDepartmentId\",\n" +
                "          \"fieldName\": \"\",\n" +
                "          \"fieldValue\": \"1136694738318024704\",\n" +
                "          \"remark\": \"\"\n" +
                "        }\n" +
                "      ],\n" +
                "      \"orderSource\": 3,\n" +
                "      \"orderSourceStr\": \"\",\n" +
                "      \"splitItemList\": [\n" +
                "        {\n" +
                "          \"agrBo\": {\n" +
                "            \"adjustPrice\": 0,\n" +
                "            \"agreementCode\": 2,\n" +
                "            \"agreementId\": \"1146023963311218688\",\n" +
                "            \"extFields\": [\n" +
                "              {\n" +
                "                \"fieldCode\": \"itAgrOrderCode\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"0\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"itAgrOrderFlag\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"否\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"agrMainExtendJson\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"{}\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"relevantDeptName\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"交行（个性化）运营\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"relevantDeptCode\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"扩展字段6\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"agrMainExtend3\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"IT合同类型名称-0816\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"relevantDeptId\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"1134138067028807680\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"jhAgrDepartment\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"交行分行采购C部门1\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"agrMainExtend7\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"IT合同类型id\",\n" +
                "                \"remark\": \"\"\n" +
                "              },\n" +
                "              {\n" +
                "                \"fieldCode\": \"jhAgrDepartmentId\",\n" +
                "                \"fieldName\": \"\",\n" +
                "                \"fieldValue\": \"1136694738318024704\",\n" +
                "                \"remark\": \"\"\n" +
                "              }\n" +
                "            ],\n" +
                "            \"producerId\": 33,\n" +
                "            \"scopeType\": 3,\n" +
                "            \"supplierId\": 1137033162682032128,\n" +
                "            \"tradeMode\": 2,\n" +
                "            \"vendorId\": 1137033162682032128\n" +
                "          },\n" +
                "          \"agreementId\": \"1146023963311218688\",\n" +
                "          \"agreementIdItemNo\": \"\",\n" +
                "          \"agreementNo\": \"\",\n" +
                "          \"commodityCode\": \"\",\n" +
                "          \"commodityId\": \"99229159\",\n" +
                "          \"commodityTypeId\": \"10010101\",\n" +
                "          \"extFields\": [\n" +
                "            {\n" +
                "              \"fieldCode\": \"purchasePurposeId\",\n" +
                "              \"fieldName\": \"采购用途(商品明细)\",\n" +
                "              \"fieldValue\": \"893501119366529025\",\n" +
                "              \"remark\": \"\"\n" +
                "            },\n" +
                "            {\n" +
                "              \"fieldCode\": \"purchasePurposeName\",\n" +
                "              \"fieldName\": \"采购用途(商品明细)\",\n" +
                "              \"fieldValue\": \"采购用途0828\",\n" +
                "              \"remark\": \"\"\n" +
                "            }\n" +
                "          ],\n" +
                "          \"orderId\": 1149359463282855936,\n" +
                "          \"orderItemId\": 1149359463282855953,\n" +
                "          \"orderPlanBOList\": [],\n" +
                "          \"planId\": \"\",\n" +
                "          \"planItemId\": \"\",\n" +
                "          \"purchaseCount\": 1.00,\n" +
                "          \"skuCode\": \"6000000188102002\",\n" +
                "          \"skuId\": \"100163817\",\n" +
                "          \"skuMaterialTypeId\": \"null\",\n" +
                "          \"skuName\": \"万宝龙鳍型钢笔定制 测试协议订单用（勿动） 属性值2\",\n" +
                "          \"skuSource\": 3,\n" +
                "          \"supplierId\": \"1137033162682032128\",\n" +
                "          \"supplierShopId\": \"1134138067028807680\"\n" +
                "        }\n" +
                "      ],\n" +
                "      \"supId\": \"1137033162682032128\"\n" +
                "    }\n" +
                "  ]\n" +
                "}",UocSplitOrderServiceRspBo.class);
        return rpcSplitOrderBo;
    }

    private void validateSplitRsp(UocSplitOrderServiceRspBo rpcSplitOrderBo) {
        if (ObjectUtil.isEmpty(rpcSplitOrderBo)) {
            throw new BaseBusinessException(UocExtRspConstant.RSP_CODE_RPC_SPLIT_ORDER_ERROR, "调用rpc服务拆单失败：返回出参为空");
        }
        List<UocSplitOrderServiceSaleOrderBo> splitSaleOrderList = rpcSplitOrderBo.getSplitSaleOrderList();
        //过滤掉key，value均相同的数据
        for (UocSplitOrderServiceSaleOrderBo uocSplitOrderServiceSaleOrderBo : splitSaleOrderList) {
            List<BaseExtendFieldBo> extFieldList = uocSplitOrderServiceSaleOrderBo.getExtFields();
            Map<String, BaseExtendFieldBo> map = new LinkedHashMap<>();
            for (BaseExtendFieldBo obj : extFieldList) {
                String key = obj.getFieldCode() + "_" + obj.getFieldValue();
                if (!map.containsKey(key)) {
                    map.put(key, obj);
                }
            }
            uocSplitOrderServiceSaleOrderBo.setExtFields(new ArrayList<>(map.values()));


            //过滤销售单明细中，同key，同value的数据
            List<UocSplitOrderServiceItemBo> splitItemList = uocSplitOrderServiceSaleOrderBo.getSplitItemList();
            for (UocSplitOrderServiceItemBo uocSplitOrderServiceItemBo : splitItemList) {
                Map<String, BaseExtendFieldBo> saleItemMap = new LinkedHashMap<>();
                for (BaseExtendFieldBo obj : uocSplitOrderServiceItemBo.getExtFields()) {
                    String key = obj.getFieldCode() + "_" + obj.getFieldValue();
                    if (!saleItemMap.containsKey(key)) {
                        saleItemMap.put(key, obj);
                    }
                }
                uocSplitOrderServiceItemBo.setExtFields(new ArrayList<>(saleItemMap.values()));
            }


        }

        log.info("调用rpc拆单服务出参(过滤相同key相同value之后)：{}", JSON.toJSONString(rpcSplitOrderBo));

        //销售单扩展字段不能重复
        for (UocSplitOrderServiceSaleOrderBo uocSplitOrderServiceSaleOrderBo : splitSaleOrderList) {
            List<BaseExtendFieldBo> extFieldList = uocSplitOrderServiceSaleOrderBo.getExtFields();
            //把每个扩展对象的filedCode，取出放到set里面进行去重
            Set<String> set = extFieldList.stream().map(BaseExtendFieldBo::getFieldCode).collect(Collectors.toSet());
            if (extFieldList.size() > set.size()) {
                throw new BaseBusinessException(UocExtRspConstant.RSP_CODE_RPC_SPLIT_ORDER_ERROR, "调用rpc服务出参校验失败：销售单维度扩展字段重复");
            }
        }

    }

//    private List<UocSaleOrderDo> splitSaleOrder(UocOrderDo createOrderRet, UocCreateOrderServiceReqBo reqBo, List<UocSaleOrderItem> uocSaleOrderItemList, JSONObject supSignInfo) {
//        List<UocSaleOrderDo> splitSaleOrderList = new ArrayList<>();
//        List<List<UocSaleOrderItem>> splitSaleOrderRet = new ArrayList<>();
//        //先根据订单来源拆分数据，由不同订单来源实现类进行处理
//        Map<Integer, List<UocSaleOrderItem>> saleItemMap = uocSaleOrderItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getSkuSource));
//        for (Map.Entry<Integer, List<UocSaleOrderItem>> entry : saleItemMap.entrySet()) {
//            UocOrderSourceProcessor instance = uocOrderSourceProcessorManager.getInstance(entry.getKey());
//            //拆单结果
//            splitSaleOrderRet.addAll(instance.splitSaleOrder(entry.getValue()));
//        }
//
//        UocOrderStakeholderQryBo qryStakeholderList = new UocOrderStakeholderQryBo();
//        qryStakeholderList.setOrderId(createOrderRet.getOrderId());
//
//        //根据订单id查询已入库的三方信息,并组成map，便于后续使用
//        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = iUocOrderModel.qryStakeholderList(qryStakeholderList);
//        Map<String, List<UocOrderStakeholderQryBo>> supStakeMap = uocOrderStakeholderQryBos.stream().collect(Collectors.groupingBy(UocOrderStakeholderQryBo::getSupId));
//
//        //支付配置保存
//        List<UocCreateOrderServiceReqPayConfSupBo> payConfigList = reqBo.getPayConfigList();
//        Map<String, UocCreateOrderServiceReqPayConfSupBo> payConfMap = new HashMap<>();
//        if (ObjectUtil.isNotEmpty(payConfigList)) {
//            payConfMap = payConfigList.stream().collect(Collectors.toMap(UocCreateOrderServiceReqPayConfSupBo::getSupId, item -> item));
//        }
//
//        List<UocCreateOrderServiceReqArgPayConfSupBo> agrPayConfigList = reqBo.getAgrPayConfigList();
//        Map<String, UocCreateOrderServiceReqArgPayConfSupBo> agrPayConfigMap = new HashMap<>();
//        if (ObjectUtil.isNotEmpty(agrPayConfigList)) {
//            agrPayConfigMap = agrPayConfigList.stream().collect(Collectors.toMap(UocCreateOrderServiceReqArgPayConfSupBo::getAgrId, item -> item));
//        }
//
//        //把保存的协议数据转换成map，方便后续取用
//        List<UocOrderItem> orderItems = createOrderRet.getOrderItems();
//        List<UocOrderAgreement> agrList = orderItems.stream().map(UocOrderItem::getAgrBo).collect(Collectors.());
//        //是否有协议商品
//        boolean hasAgrComm = false;toList
//        for (UocOrderItem orderItem : orderItems) {
//            if (ObjectUtil.isNotEmpty(orderItem.getAgrBo())) {
//                hasAgrComm = true;
//            }
//        }
//        Map<String, UocOrderAgreement> agrMap = new HashMap<>();
//        if (hasAgrComm) {
//            agrMap = agrList.stream().collect(Collectors.toMap(UocOrderAgreement::getAgreementId, item -> item));
//        }
//
//        //至此，拆单执行完毕，根据拆单结果（多个list），组装销售单do对象
//        for (List<UocSaleOrderItem> uocSaleOrderItems : splitSaleOrderRet) {
//            UocSaleOrderDo saleOrderDo = UocRu.js(createOrderRet, UocSaleOrderDo.class);
//            splitSaleOrderList.add(saleOrderDo);
//            String supplierId = uocSaleOrderItems.get(0).getSupplierId();
//            saleOrderDo.setOrderSource(uocSaleOrderItems.get(0).getSkuSource());
//            saleOrderDo.setStakeholderId(supStakeMap.get(supplierId).get(0).getStakeholderId());
//            saleOrderDo.setStakeholder(UocRu.js(supStakeMap.get(supplierId).get(0), UocSaleStakeholder.class));
//            BigDecimal totalSaleFee = getTotalSaleFeeWithSaleItem(uocSaleOrderItems);
//            saleOrderDo.setTotalSaleFee(totalSaleFee);
//            saleOrderDo.setTotalPurchaseFee(getTotalPurchaseFeeWithSaleItem(uocSaleOrderItems));
//            saleOrderDo.setCreatedResult(UocConstant.CREATED_RESULT.SUCCESS);
//            //协议id
//            String agreementId = uocSaleOrderItems.get(0).getAgreementId();
//
//
//            // 供应商收取月度成交服务费节点
//            String monthReceiveNode = supSignInfo.getJSONObject(supplierId).getString(UocConstant.MONTH_SERVICE_NODE_PARAM);
//            // 如果是下单时收取 设置生成结算订单管理数据
//            if (UocConstant.MONTH_SERVICE_NODE.equals(monthReceiveNode)) {
//                saleOrderDo.setIsCreateServiceFee(true);
//            }
//            if (ObjectUtil.isNotEmpty(agreementId)) {
//                //支付配置
//                saleOrderDo.setSaleOrderPayConfList(UocRu.jsl(agrPayConfigMap.get(agreementId).getConfBos(), UocSaleOrderPayConf.class));
//                //如果一个供应商下只有一个配置，则是撮合模式，反之：贸易模式
//                saleOrderDo.setModelSettle(agrPayConfigMap.get(agreementId).getConfBos().size() == 1 ? UocConstant.ModelSettle.CH : UocConstant.ModelSettle.MY);
//            } else {
//                //支付配置
//                saleOrderDo.setSaleOrderPayConfList(UocRu.jsl(payConfMap.get(supplierId).getConfBos(), UocSaleOrderPayConf.class));
//                //如果一个供应商下只有一个配置，则是撮合模式，反之：贸易模式
//                saleOrderDo.setModelSettle(payConfMap.get(supplierId).getConfBos().size() == 1 ? UocConstant.ModelSettle.CH : UocConstant.ModelSettle.MY);
//            }
//
//
//            List<UocSaleOrderPayConf> payConfs = saleOrderDo.getSaleOrderPayConfList();
//            for (UocSaleOrderPayConf payConf : payConfs) {
//                //预付款，全给
//                //按协议，根据比例
//                //账期，0
//                if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(payConf.getPayType())) {
//                    payConf.setPrePayFee(totalSaleFee);
//                } else if (UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(payConf.getPayType())) {
//                    if (ObjectUtil.isNotEmpty(payConf.getPrePaySup())) {
//                        payConf.setPrePayFee(totalSaleFee.multiply(payConf.getPrePaySup()));
//                    }
//                    if (ObjectUtil.isNotEmpty(payConf.getVerPaySup())) {
//                        payConf.setVerPayFee(totalSaleFee.multiply(payConf.getVerPaySup()));
//                    }
//                    if (ObjectUtil.isNotEmpty(payConf.getPilPaySup())) {
//                        payConf.setPilPayFee(totalSaleFee.multiply(payConf.getPilPaySup()));
//                    }
//                    if (ObjectUtil.isNotEmpty(payConf.getQuaPaySup())) {
//                        payConf.setQuaPayFee(totalSaleFee.multiply(payConf.getQuaPaySup()));
//                    }
//                } else {
//                    payConf.setPrePayFee(new BigDecimal(0));
//                    payConf.setVerPayFee(new BigDecimal(0));
//                    payConf.setPilPayFee(new BigDecimal(0));
//                    payConf.setQuaPayFee(new BigDecimal(0));
//                }
//            }
//
//
//            //销售明细
//            saleOrderDo.setSaleOrderItems(uocSaleOrderItems);
//
//            //设置协议数据
//            if (ObjectUtil.isNotEmpty(agreementId)) {
//                UocOrderAgreement uocOrderAgreement = agrMap.get(agreementId);
//                saleOrderDo.setAdjustPrice(uocOrderAgreement.getAdjustPrice());
//                saleOrderDo.setAgreementId(agreementId);
//                saleOrderDo.setAgreementNo(uocSaleOrderItems.get(0).getAgreementNo());
//                saleOrderDo.setAgrDataId(uocOrderAgreement.getId());
//                saleOrderDo.setProDeliveryId(uocOrderAgreement.getProducerId() != null ? uocOrderAgreement.getProducerId().toString() : null);
//                saleOrderDo.setProDeliveryName(uocOrderAgreement.getProducerName());
//            }
//        }
//
//        return splitSaleOrderList;
//
//    }

//    private List<UocSaleOrderItem> orderDo2SaleDo(UocOrderDo createOrderRet, UocCreateOrderServiceReqBo reqBo) {
//        List<UocOrderItem> orderItems = createOrderRet.getOrderItems();
//
//        List<UocSaleOrderItem> saleOrderItemList = new ArrayList<>();
//        for (UocOrderItem orderItem : orderItems) {
//            UocSaleOrderItem saleItemDo = UocRu.js(orderItem, UocSaleOrderItem.class);
//            saleOrderItemList.add(saleItemDo);
//        }
//
//        return saleOrderItemList;
//    }

    /**
     * 计算销售单采购总价
     *
     * @param orderItem
     * @return
     */
    private BigDecimal computeSaleOrderTotalPurchaseFee(List<UocSaleOrderItem> orderItem,Map<String,UocSaleOrderItem> saleOrderItemMap) {
        BigDecimal saleFee = new BigDecimal(0);
        for (UocSaleOrderItem uocOrderItem : orderItem) {
            saleFee = saleFee.add((uocOrderItem.getPurchaseCount().multiply(saleOrderItemMap.get(uocOrderItem.getSkuId()).getPurchasePrice())).setScale(2, RoundingMode.HALF_UP));
        }
        return saleFee;
    }

    /**
     * 计算销售单销售总价
     *
     * @param orderItem
     * @return
     */
    private BigDecimal computeSaleOrderTotalSaleFee(List<UocSaleOrderItem> orderItem,Map<String,UocSaleOrderItem> saleOrderItemMap) {
        BigDecimal totalSaleFee = new BigDecimal(0);
        for (UocSaleOrderItem uocOrderItem : orderItem) {

            totalSaleFee = totalSaleFee.add((uocOrderItem.getPurchaseCount().multiply(saleOrderItemMap.get(uocOrderItem.getSkuId()).getSalePrice())).setScale(2, RoundingMode.HALF_UP));
        }
        return totalSaleFee;
    }

    /**
     * 供货周期
     *
     * @param createSaleOrderDo
     * @return
     */
    private UocSaleOrderDo deliveryCycle(UocSaleOrderDo createSaleOrderDo) {
        if (createSaleOrderDo.getOrderSource().equals(UocConstant.SkuSource.AGR)) {
            List<UocSaleOrderItem> uocSaleOrderItems = createSaleOrderDo.getSaleOrderItems();
            uocSaleOrderItems.forEach(obj -> {
                if (StringUtils.isNotEmpty(obj.getDeliveryTimeDate())) {
                    List<UocSaleItemMap> saleItemMapList = new ArrayList<>();
                    UocSaleItemMap uocSaleItemMap = new UocSaleItemMap();
                    uocSaleItemMap.setFieldCode("delivery_cycle");
                    uocSaleItemMap.setFieldName("供货周期");
                    uocSaleItemMap.setFieldValue(obj.getDeliveryTimeDate());
                    saleItemMapList.add(uocSaleItemMap);
                    obj.setSaleItemMapList(saleItemMapList);
                }
            });
            createSaleOrderDo.setSaleOrderItems(uocSaleOrderItems);
        }
        return createSaleOrderDo;
    }

    /**
     * 描述:bo转订单do
     *
     * @param reqBo 入参
     * @return com.tydic.dyc.oc.model.order.UocOrderDo
     * @author tgy
     * @date 2022/2/24 21:07
     */
//    private UocOrderDo convertOrderDo(UocCreateOrderServiceReqBo reqBo) {
//        //订单数据
//        UocOrderDo orderDo = UocRu.js(reqBo, UocOrderDo.class);
//        orderDo.setCreateOperId(reqBo.getUserId().toString());
//        orderDo.setCreateOperName(reqBo.getName());
//
//        //订单发票信息
//        if (ObjectUtil.isNotEmpty(reqBo.getInvoiceBO())) {
//            orderDo.setUocOrdInvoice(UocRu.js(reqBo.getInvoiceBO(), UocOrdInvoice.class));
//        }
//
//        //收货人地址信息
//        if (ObjectUtil.isNotEmpty(reqBo.getAddressBo())) {
//            orderDo.setReceiverAddress(UocRu.js(reqBo.getAddressBo(), UocOrdLogisticsRela.class));
//        }
//
//        //发票邮寄信息
//        if (ObjectUtil.isNotEmpty(reqBo.getInvoiceAddressBo())) {
//            orderDo.setInvoiceAddress(UocRu.js(reqBo.getInvoiceAddressBo(), UocOrdLogisticsRela.class));
//        }
//
//        //订单附件信息
//        if (ObjectUtil.isNotEmpty(reqBo.getAccessoryList())) {
//            orderDo.setAccessoryList(UocRu.jsl(reqBo.getAccessoryList(), UocOrderAccessory.class));
//        }
//
//        //运营机构
//        orderDo.setOperating(UocRu.js(reqBo.getProfessionalBo(), UocOrderOperating.class));
//
//        //订单明细信息
//        setOrderItems(reqBo, orderDo);
//
//        return orderDo;
//    }


//    private void setOrderItems(UocCreateOrderServiceReqBo reqBo, UocOrderDo orderDo) {
//        List<UocCreateOrderServiceReqCommodityBo> commodityBos = reqBo.getCommodityBos();
//        orderDo.setOrderItems(new ArrayList<>(commodityBos.size()));
//        for (UocCreateOrderServiceReqCommodityBo commodityBo : commodityBos) {
//            UocOrderItem orderItem = UocRu.js(commodityBo, UocOrderItem.class);
//            orderItem.setSupplierId(commodityBo.getSupId());
//            orderItem.setSupplierName(commodityBo.getSupName());
//            orderItem.setItemType(UocDicConstant.ORDER_ITEM_TYPE.SKU);
//            orderDo.getOrderItems().add(orderItem);
//        }
//
//    }


    /**
     *
     * @param reqBo
     */
//    private void verifyCommodityInfo(UocCreateOrderServiceReqBo reqBo){
//
//    }

    /**
     * 参数校验
     * @param reqBo
     */
//    private void verifyParam(UocCreateOrderServiceReqBo reqBo) {
//        if (reqBo == null) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单创建，入参对象不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getUserId())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单创建，当前用户id不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getTotalSaleFee())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单创建，销售总金额不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getTotalPurchaseFee())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单创建，采购总金额不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getCommodityBos())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单创建，商品信息不能为空");
//            //校验各条商品信息
//
//        }
//        if (ObjectUtil.isEmpty(reqBo.getAddressBo())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单创建，收货人地址信息不能为空");
//        }
//
//        BigDecimal realTotalSaleFee = new BigDecimal(0);
//        BigDecimal realTotalPurchaseFee = new BigDecimal(0);
//        for (UocCreateOrderServiceReqCommodityBo commodityBo : reqBo.getCommodityBos()) {
//            validateCommodityBo(commodityBo);
//            BigDecimal singleSalePrice = commodityBo.getSalePrice().multiply(commodityBo.getPurchaseCount());
//            BigDecimal singlePurchasePrice = commodityBo.getPurchasePrice().multiply(commodityBo.getPurchaseCount());
//            realTotalSaleFee = realTotalSaleFee.add(singleSalePrice);
//            realTotalPurchaseFee = realTotalPurchaseFee.add(singlePurchasePrice);
//        }
//
//        if (totalSaleFee.compareTo(realTotalSaleFee) != 0) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售总价格(" + totalSaleFee + ")不等于所有商品总价格(" + realTotalSaleFee + ")");
//        }
//        if (totalPurchaseFee.compareTo(realTotalPurchaseFee) != 0) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "采购总价格(" + totalPurchaseFee + ")不等于所有商品总价格(" + realTotalPurchaseFee + ")");
//        }
//
//        //包含协议商品
//        boolean hasAgrComm = false;
//        for (UocCreateOrderServiceReqCommodityBo commodityBo : reqBo.getCommodityBos()) {
//            if (ObjectUtil.isNotEmpty(commodityBo.getAgreementId())) {
//                hasAgrComm = true;
//                break;
//            }
//        }
//
//        //当包含协议商品时，要校验协议支付配置是否传入了
//        if (hasAgrComm) {
//            if (ObjectUtil.isEmpty(reqBo.getAgrPayConfigList())) {
//                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "当有协议商品时，协议支付配置不能为空");
//            }
//        }
//
//
//        //校验无协议支付配置
//        validateNoArgPayConf(reqBo.getPayConfigList());
//
//        //校验协议支付配置
//        validateArgPayConf(reqBo.getAgrPayConfigList());
//
//        // validateUocCreateOrderServiceReqProfessionalBo(reqBo.getProfessionalBo());
//
//        validateUocCreateOrderServiceReqAddressBo(reqBo.getAddressBo());
//
//        if (ObjectUtil.isNotEmpty(reqBo.getInvoiceAddressBo())) {
//            validateUocCreateOrderServiceReqAddressBo(reqBo.getInvoiceAddressBo());
//        }
//
//        if (ObjectUtil.isNotEmpty(reqBo.getInvoiceBO())) {
//            validateUocCreateOrderServiceReqInvoiceBo(reqBo.getInvoiceBO());
//        }
//
//        if (ObjectUtil.isNotEmpty(reqBo.getAccessoryList())) {
//            for (UocCreateOrderServiceReqAccessoryBo uocCreateOrderServiceReqAccessoryBo : reqBo.getAccessoryList()) {
//                validateUocCreateOrderServiceReqAccessoryBo(uocCreateOrderServiceReqAccessoryBo);
//            }
//        }
//
//        if (ObjectUtil.isNotEmpty(reqBo.getOrderParallelExtList())) {
//            for (UocBaseExtParallelBo uocBaseExtParallelBo : reqBo.getOrderParallelExtList()) {
//                validateUocBaseExtParallelBo(uocBaseExtParallelBo);
//            }
//        }
//
//    }

//    private void validateArgPayConf(List<UocCreateOrderServiceReqArgPayConfSupBo> agrPayConfigList) {
//        if (ObjectUtil.isNotEmpty(agrPayConfigList)) {
//            for (UocCreateOrderServiceReqArgPayConfSupBo uocCreateOrderServiceReqPayConfSupBo : agrPayConfigList) {
//                validateAgrPayConfBo(uocCreateOrderServiceReqPayConfSupBo);
//            }
//        }
//    }

//    private void validateAgrPayConfBo(UocCreateOrderServiceReqArgPayConfSupBo reqBo) {
//        if (reqBo == null) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqArgPayConfSupBo]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getAgrId())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[协议id]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getConfBos())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[供应商配置]不能为空");
//        }
//        for (UocCreateOrderServiceReqPayConfBo confBo : reqBo.getConfBos()) {
//            validatePayConfBo(confBo);
//        }
//    }

//    private void validateNoArgPayConf(List<UocCreateOrderServiceReqPayConfSupBo> reqBo) {
//        if (ObjectUtil.isNotEmpty(reqBo)) {
//            for (UocCreateOrderServiceReqPayConfSupBo uocCreateOrderServiceReqPayConfSupBo : reqBo) {
//                validateNoAgrPayConfBo(uocCreateOrderServiceReqPayConfSupBo);
//            }
//        }
//    }

//    private void validateNoAgrPayConfBo(UocCreateOrderServiceReqPayConfSupBo reqBo) {
//        if (reqBo == null) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqPayConfSupBo]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getSupId())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[供应商id]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getConfBos())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[供应商配置]不能为空");
//        }
//        for (UocCreateOrderServiceReqPayConfBo confBo : reqBo.getConfBos()) {
//            validatePayConfBo(confBo);
//        }
//    }

//    private void validatePayConfBo(UocCreateOrderServiceReqPayConfBo reqBo) {
//        if (reqBo == null) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqPayConfBo]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getModelSettle())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[结算模式]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getPayType())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[付款方式]不能为空");
//        }
//
//    }

//    private void validateUocCreateOrderServiceReqAccessoryBo(UocCreateOrderServiceReqAccessoryBo reqBo) {
//        if (reqBo == null) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqAccessoryBo]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getAccessoryName())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[附件名称]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getAccessoryUrl())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[附件url]不能为空");
//        }
//    }

//    private void validateUocCreateOrderServiceReqInvoiceBo(UocCreateOrderServiceReqInvoiceBo reqBo) {
//        if (reqBo == null) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqInvoiceBo]不能为空");
//        }
//
//    }

//    private void validateUocCreateOrderServiceReqAddressBo(UocCreateOrderServiceReqAddressBo reqBo) {
//        if (reqBo == null) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqAddressBo]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getContactProvinceId())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人省份编号]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getContactProvinceName())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人省份名称]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getContactCityId())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人地市编号]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getContactCityName())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人地市名称]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getContactCountyId())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人区县编号]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getContactCountyName())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人区县名称]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getContactAddress())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[收货人地址]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getContactName())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人名称]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getContactEmail())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人邮件]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getContactMobile())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人手机]不能为空");
//        }
//    }

//    private void validateUocCreateOrderServiceReqProfessionalBo(UocCreateOrderServiceReqProfessionalBo reqBo) {
//        if (reqBo == null) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqProfessionalBo]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getProId())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[运营单位机构id]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getProName())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[运营机构名称]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getProOrgPath())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[运营机构机构树路径]不能为空");
//        }
//    }

//    private void validateCommodityBo(UocCreateOrderServiceReqCommodityBo reqBo) {
//        if (reqBo == null) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqCommodityBo]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getSkuId())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[单品ID]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getSkuName())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[单品名称]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getCommodityId())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[商品id]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getCommodityName())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[商品名称]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getSupId())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[供应商id]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getSupName())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[供应商名称]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getSupplierShopId())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[店铺ID]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getPurchasePrice())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[采购单价]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getSalePrice())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[销售单价]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getPurchaseCount())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[采购数量]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getSkuSource())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[商品来源]不能为空");
//        }
//        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(reqBo.getSkuSource())) {
//            if (ObjectUtil.isEmpty(reqBo.getAgreementId())) {
//                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "协议商品(skuId:" + reqBo.getSkuId() + ")，协议id不能为空");
//            }
//        }
//        if (!ObjectUtil.isEmpty(reqBo.getAgreementId())) {
//            if (ObjectUtil.isEmpty(reqBo.getAgrBo())) {
//                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[协议对象]不能为空");
//            }
//            validateAgrBo(reqBo.getAgrBo());
//            reqBo.setAgreementCode(reqBo.getAgrBo().getAgreementCode().toString());
//        }
//        if (ObjectUtil.isNotEmpty(reqBo.getSaleItemParallelExtList())) {
//            for (UocBaseExtParallelBo uocBaseExtParallelBo : reqBo.getSaleItemParallelExtList()) {
//                validateUocBaseExtParallelBo(uocBaseExtParallelBo);
//            }
//        }
//    }

//    private void validateAgrBo(UocCreateOrderServiceReqAgrBo reqBo) {
//        if (reqBo == null) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqAgrBo]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getAgreementId())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[协议Id]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getAgreementCode())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[协议模式不能为空");
//        }
//        /*if (ObjectUtil.isEmpty(reqBo.getAgreementVersion())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[协议版本号]不能为空");
//        }*/
//        if (ObjectUtil.isEmpty(reqBo.getAdjustPrice())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[0：无，1：事前调价，2：事中调价 默认值：0]不能为空");
//        }
//
//    }

//    private void validateUocBaseExtParallelBo(UocBaseExtParallelBo reqBo) {
//        if (reqBo == null) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocBaseExtParallelBo]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getFieldCode())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[字段编码]不能为空");
//        }
//        if (ObjectUtil.isEmpty(reqBo.getFieldValue())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[字段值]不能为空");
//        }
//    }
}


