/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.importorder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.importorder.IUocImportOrderModel;
import com.tydic.dyc.oc.model.importorder.UocImportOrderDo;
import com.tydic.dyc.oc.service.importorder.UocImportOrderCheckService;
import com.tydic.dyc.oc.service.importorder.bo.UocImportOrderCheckReqBo;
import com.tydic.dyc.oc.service.importorder.bo.UocImportOrderCheckRspBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.importorder.UocImportOrderCheckService"})
public class UocImportOrderCheckServiceImpl
implements UocImportOrderCheckService {
    private static final Logger log = LoggerFactory.getLogger(UocImportOrderCheckServiceImpl.class);
    @Value(value="${uoc.importOrder.threshold:5}")
    private Integer handleThreshold;
    @Autowired
    private IUocImportOrderModel iUocImportOrderModel;

    @PostMapping(value={"dealCheckImportOrder"})
    public UocImportOrderCheckRspBo dealCheckImportOrder(@RequestBody UocImportOrderCheckReqBo reqBo) {
        UocImportOrderCheckRspBo rspBo = new UocImportOrderCheckRspBo();
        UocImportOrderDo checkUocImportOrderDo = new UocImportOrderDo();
        checkUocImportOrderDo.setStatus(UocConstant.IMPORT_ORDER_STATUS.IN_EXECUTION);
        UocImportOrderDo checkImportOrderResult = this.iUocImportOrderModel.checkImportOrderThreshold(checkUocImportOrderDo);
        if (checkImportOrderResult.getCheckThreshold() > this.handleThreshold) {
            throw new BaseBusinessException("100001", "\u6279\u91cf\u4e0b\u5355\u5df2\u8d85\u8fc7\u5904\u7406\u9608\u503c");
        }
        UocImportOrderDo updateUocImportOrderDo = new UocImportOrderDo();
        updateUocImportOrderDo.setImportOrderId(reqBo.getImportOrderId());
        updateUocImportOrderDo.setStatus(UocConstant.IMPORT_ORDER_STATUS.IN_EXECUTION);
        updateUocImportOrderDo.setUpdateUserId(String.valueOf(reqBo.getUserId()));
        updateUocImportOrderDo.setUpdateUserName(reqBo.getName());
        this.iUocImportOrderModel.updateImportOrderInfoStatus(updateUocImportOrderDo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

