/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.cmporder;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.cmporder.IUocCmpOrderModel;
import com.tydic.dyc.oc.model.cmporder.UocCmpOrderDo;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpItemMap;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpOrderItem;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpOrderMap;
import com.tydic.dyc.oc.service.cmporder.UocCreateCmpOrderService;
import com.tydic.dyc.oc.service.cmporder.bo.UocCreateCmpOrderServiceReqBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocCreateCmpOrderServiceReqItemBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocCreateCmpOrderServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.cmporder.UocCreateCmpOrderService"})
public class UocCreateCmpOrderServiceImpl
implements UocCreateCmpOrderService {
    @Autowired
    private IUocCmpOrderModel uocCmpOrderModel;

    @PostMapping(value={"createCmpOrder"})
    public UocCreateCmpOrderServiceRspBo createCmpOrder(@RequestBody UocCreateCmpOrderServiceReqBo reqBo) {
        UocCreateCmpOrderServiceRspBo rspBo = UocRu.success(UocCreateCmpOrderServiceRspBo.class);
        this.validateArg(reqBo);
        UocCmpOrderDo uocCmpOrderDo = this.buildDoByBO(reqBo);
        this.uocCmpOrderModel.createCmpOrder(uocCmpOrderDo);
        rspBo.setCmpOrderNo(uocCmpOrderDo.getCmpOrderNo());
        rspBo.setCmpOrderId(uocCmpOrderDo.getCmpOrderId());
        return rspBo;
    }

    private UocCmpOrderDo buildDoByBO(UocCreateCmpOrderServiceReqBo reqBo) {
        reqBo.setCreateTime(new Date());
        reqBo.setCreateOperName(reqBo.getName());
        reqBo.setCreateOperId(reqBo.getUserId().toString());
        reqBo.setCreateOrgId(String.valueOf(reqBo.getOrgId()));
        reqBo.setCreateOrgName(reqBo.getOrgName());
        UocCmpOrderDo cmpOrderDo = UocRu.js(reqBo, UocCmpOrderDo.class);
        cmpOrderDo.setNotLowPriceReason(reqBo.getNotLowPriceReason());
        for (UocCreateCmpOrderServiceReqItemBo uocCreateCmpOrderServiceReqItemBo : reqBo.getUocCmpOrderItemList()) {
            uocCreateCmpOrderServiceReqItemBo.setCreateTime(new Date());
        }
        List<UocCmpOrderItem> items = UocRu.jsl(reqBo.getUocCmpOrderItemList(), UocCmpOrderItem.class);
        if (!CollectionUtil.isEmpty(items)) {
            Map<String, List> skuMap = reqBo.getUocCmpOrderItemList().stream().collect(Collectors.toMap(UocCreateCmpOrderServiceReqItemBo::getSkuId, UocCreateCmpOrderServiceReqItemBo::getItemParallelExtList));
            for (UocCmpOrderItem item : items) {
                List uocBaseExtParallelBos = skuMap.get(item.getSkuId());
                List<UocCmpItemMap> uocCmpItemMapList = UocRu.jsl(uocBaseExtParallelBos, UocCmpItemMap.class);
                item.setUocCmpItemMapList(uocCmpItemMapList);
            }
        }
        cmpOrderDo.setUocCmpOrderItemList(items);
        if (!CollectionUtil.isEmpty((Collection)reqBo.getParallelExtList())) {
            cmpOrderDo.setUocCmpOrderMapList(UocRu.jsl(reqBo.getParallelExtList(), UocCmpOrderMap.class));
        }
        return cmpOrderDo;
    }

    private void validateArg(UocCreateCmpOrderServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateCmpOrderServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty((Collection)reqBo.getUocCmpOrderItemList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[uocCmpOrderItemList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocCreateCmpOrderServiceReqItemBo uocCreateCmpOrderServiceReqItemBo : reqBo.getUocCmpOrderItemList()) {
            if (!StringUtils.isBlank((CharSequence)uocCreateCmpOrderServiceReqItemBo.getSkuId())) continue;
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5546\u54c1\u660e\u7ec6\u7684skuId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

