/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderItemQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocDeliveryInfoBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocDeliveryItemsBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgCreateShipReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgCreateShipRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderSkuBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocOrderPropertiesUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class UocMsgCreateShipTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocMsgCreateShipTransaction.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocMsgCreateShipRspBo createShip(UocMsgCreateShipReqBo reqBo) {
        rspBo = new UocMsgCreateShipRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u53d1\u8d27\u5355\u3001\u53d1\u8d27\u5355\u660e\u7ec6\u521b\u5efa\u6210\u529fnew");
        rspBo.setFirstDeliverFlag(Boolean.valueOf(true));
        uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getDycUocQryMsgBO().getObjId());
        shipOrderDoList = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        if (ObjectUtil.isNotEmpty(shipOrderDoList)) {
            rspBo.setFirstDeliverFlag(Boolean.valueOf(false));
        }
        uocSaleOrderDo = this.qrySale(reqBo);
        rspBo.setSaleOrderNo(uocSaleOrderDo.getSaleOrderNo());
        rspBo.setArrivalDate(uocSaleOrderDo.getSendTime());
        rspBo.setCreateOperId(uocSaleOrderDo.getCreateOperId());
        if (null == uocSaleOrderDo) {
            rspBo.setRespCode("101002");
            rspBo.setRespDesc("\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u4fe1\u606f!");
            return rspBo;
        }
        if (!"XS_FH_DFH".equals(uocSaleOrderDo.getSaleOrderState()) && !"XS_FH_FHZ".equals(uocSaleOrderDo.getSaleOrderState())) {
            rspBo.setRespCode("101002");
            rspBo.setRespDesc("\u8be5\u9500\u552e\u5355\u72b6\u6001\u4e0d\u5bf9\uff0c\u53ea\u6709\u5f85\u53d1\u8d27\u6216\u53d1\u8d27\u4e2d\u9500\u552e\u5355\u624d\u80fd\u53d1\u8d27");
            return rspBo;
        }
        taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        taskInstQryBo.setObjId(uocSaleOrderDo.getSaleOrderId());
        taskInstQryBo.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        taskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if (ObjectUtil.isNotEmpty(taskInsts)) {
            rspBo.setTaskInstId(taskInsts.get(0).getTaskInstId());
            rspBo.setStepId(taskInsts.get(0).getProcState());
        }
        orderItemQryBoList = new ArrayList<E>();
        UocMsgCreateShipTransaction.log.info("JD_SUPPLIER:{}", (Object)UocOrderPropertiesUtil.getProperty("SUPPLIER_JD_ID"));
        UocMsgCreateShipTransaction.log.info("SUNING_SUPPLIER:{}", (Object)UocOrderPropertiesUtil.getProperty("SUPPLIER_SUNING_ID"));
        UocMsgCreateShipTransaction.log.info("\u6d88\u606fsupNo:{}", (Object)String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo()));
        if (UocOrderPropertiesUtil.getProperty("SUPPLIER_JD_ID").equals(String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo())) || UocOrderPropertiesUtil.getProperty("SUPPLIER_JDVOP_ID").equals(String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo()))) ** GOTO lbl100
        extOrderSaleItemRspBOList = null;
        if (reqBo.getExtOrderInfoBO().getSaleOrderRspBO() != null) {
            extOrderSaleItemRspBOList = reqBo.getExtOrderInfoBO().getSaleOrderRspBO().getSku();
        }
        if (reqBo.getExtOrderInfoBO().getParentSaleOrderRspBO() != null) {
            extOrderSaleItemRspBOList = reqBo.getExtOrderInfoBO().getParentSaleOrderRspBO().getSku();
        }
        skuSendNumMap = new HashMap<String, BigDecimal>();
        map = new HashMap<Long, UocSaleOrderItemQryBo>();
        for (UocDeliveryItemsBO deliveryItemsBO : reqBo.getDeliveryInfoBO().getDeliveryItems()) {
            uocOrdGoodsQryBos = this.getOrdGoodsByExtSkuId(uocSaleOrderDo, deliveryItemsBO);
            for (UocOrderItem uocOrdGoodsQryBo : uocOrdGoodsQryBos) {
                if (!uocOrdGoodsQryBo.getSkuExtSkuId().equals(deliveryItemsBO.getSkuId())) continue;
                skuSendNumMap.put(uocOrdGoodsQryBo.getSkuId(), new BigDecimal(deliveryItemsBO.getNum()));
                ordItemRspBOS = null;
                try {
                    ordItemRspBOS = this.qryOrdItem(uocSaleOrderDo, uocOrdGoodsQryBo.getSkuId());
                }
                catch (Exception e) {
                    rspBo.setRespCode("101002");
                    rspBo.setRespDesc("\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f!");
                    return rspBo;
                }
                if (extOrderSaleItemRspBOList == null) continue;
                for (UocOrderSkuBO extOrderSaleItemRspBO : extOrderSaleItemRspBOList) {
                    for (UocSaleOrderItemQryBo saleOrderItemQryBo : ordItemRspBOS) {
                        if (!extOrderSaleItemRspBO.getSkuId().equals(deliveryItemsBO.getSkuId())) continue;
                        if (extOrderSaleItemRspBO.getTaxPrice() != null) {
                            saleOrderItemQryBo.setTaxPrice(extOrderSaleItemRspBO.getTaxPrice().toString());
                        }
                        if (extOrderSaleItemRspBO.getTax() != null) {
                            saleOrderItemQryBo.setTax(String.valueOf(extOrderSaleItemRspBO.getTax()));
                        }
                        isAllShip = true;
                        if (saleOrderItemQryBo.getPurchaseCount().compareTo(saleOrderItemQryBo.getSendCount()) > 0) {
                            isAllShip = false;
                            map.putIfAbsent(saleOrderItemQryBo.getSaleOrderItemId(), saleOrderItemQryBo);
                        }
                        UocMsgCreateShipTransaction.log.info("\u662f\u5426\u5df2\u5168\u90e8\u53d1\u8d27: {}", (Object)isAllShip);
                        UocMsgCreateShipTransaction.log.info("saleOrderItemQryBo\u91c7\u8d2d\u6570\u91cf: {}\u548c\u53d1\u8d27\u6570\u91cf: {}", (Object)saleOrderItemQryBo.getPurchaseCount(), (Object)saleOrderItemQryBo.getSendCount());
                    }
                }
            }
        }
        if (map.size() > 0) {
            for (Long id : map.keySet()) {
                orderItemQryBoList.add(map.get(id));
            }
        }
        UocMsgCreateShipTransaction.log.info("UocMsgCreateShipService\u4e2d\u9500\u552e\u5355\u660e\u7ec6map: {}", map);
        if (!orderItemQryBoList.isEmpty()) {
            shipOrderId = null;
            try {
                shipOrderQryBo = this.buildShipAndItemData(uocSaleOrderDo, orderItemQryBoList, reqBo.getDeliveryInfoBO(), skuSendNumMap);
                shipOrderId = this.ceateCoreShip(shipOrderQryBo);
                rspBo.setShipOrderNo(shipOrderQryBo.getShipOrderNo());
            }
            catch (Exception e) {
                UocMsgCreateShipTransaction.log.error("\u521b\u5efa\u53d1\u8d27\u5355\u5f02\u5e38\uff1a", (Throwable)e);
                rspBo.setRespCode("101002");
                rspBo.setRespDesc("\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u521b\u5efa\u53d1\u8d27\u5355\u5931\u8d25!" + e.getMessage());
                return rspBo;
            }
            rspBo.setShipOrderId(shipOrderId);
        } else {
            rspBo.setRespCode("101002");
            rspBo.setRespDesc("\u5df2\u7ecf\u5168\u90e8\u53d1\u8d27\uff0c\u65e0\u9700\u53d1\u8d27");
            return rspBo;
lbl100:
            // 1 sources

            UocMsgCreateShipTransaction.log.info("\u4eac\u4e1c\u8ba2\u5355\u53d1\u8d27\u5f00\u59cb");
            if (ObjectUtil.isNotEmpty(shipOrderDoList)) {
                rspBo.setRespCode("101002");
                rspBo.setRespDesc("\u8ba2\u5355\u660e\u7ec6\u5df2\u5168\u90e8\u53d1\u8d27\u5b8c\u6bd5\uff0c\u5df2\u4e0d\u80fd\u518d\u8fdb\u884c\u53d1\u8d27\u64cd\u4f5c");
                return rspBo;
            }
            uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setOrderId(uocSaleOrderDo.getOrderId());
            uocSaleOrderItemQryBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            uocOrderItemQryBoList /* !! */  = new ArrayList<E>();
            try {
                uocOrderItemQryBoList /* !! */  = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            }
            catch (Exception e) {
                rspBo.setRespCode("101002");
                rspBo.setRespDesc("\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f!");
                return rspBo;
            }
            jdCz = 2;
            if (ObjectUtil.isNotEmpty((Object)reqBo.getOrderType()) && reqBo.getOrderType() == 5) {
                jdCz = 1;
            }
            uocSaleOrderDo.setJdCz(jdCz);
            orderItemQryBoList = UocRu.jsl(uocOrderItemQryBoList /* !! */ , UocSaleOrderItemQryBo.class);
            shipOrderId = null;
            deliveryInfoBO = new UocDeliveryInfoBO();
            deliveryInfoBO.setOrderId(String.valueOf(reqBo.getDycUocQryMsgBO().getOrderId()));
            deliveryInfoBO.setPackageId(reqBo.getDycUocQryMsgBO().getOutOrderId());
            shipOrderQryBo = this.buildShipAndItemData(uocSaleOrderDo, orderItemQryBoList, deliveryInfoBO, new HashMap<String, BigDecimal>());
            shipOrderId = this.ceateCoreShip(shipOrderQryBo);
            rspBo.setShipOrderId(shipOrderId);
        }
        uocOrderQueryIndex = new UocOrderQueryIndex();
        uocOrderQueryIndex.setObjId(rspBo.getShipOrderId());
        uocOrderQueryIndex.setOrderSystem(UocDicConstant.OBJ_TYPE.SHIP.toString());
        uocOrderQueryIndex.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        if (!UocOrderPropertiesUtil.getProperty("SUPPLIER_JD_ID").equals(String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo())) && !UocOrderPropertiesUtil.getProperty("SUPPLIER_JDVOP_ID").equals(String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo()))) {
            uocOrderQueryIndex.setOutObjId(reqBo.getDycUocQryMsgBO().getPackageid());
        } else {
            uocOrderQueryIndex.setOutObjId(reqBo.getDycUocQryMsgBO().getOutOrderId());
        }
        uocOrderQueryIndex.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocOrderQueryIndex.setId(IdUtil.nextId());
        this.iUocCommonModel.saveOrderQueryIndex(uocOrderQueryIndex);
        rspBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        rspBo.setOrderSource(uocSaleOrderDo.getOrderSource());
        rspBo.setOrderId(uocSaleOrderDo.getOrderId());
        if (rspBo.getFirstDeliverFlag().booleanValue() && ObjectUtil.isEmpty((Object)uocSaleOrderDo.getUpperOrderId())) {
            uocCommonDo = new UocCommonDo();
            taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
            taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(rspBo.getTaskInstId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(11111L);
            uocCommonDo.setOrderId(reqBo.getOrderId());
            this.iUocCommonModel.dealTask(uocCommonDo);
        }
        finish = this.checkSaleOrderIsFinish(reqBo.getOrderId(), uocSaleOrderDo.getSaleOrderId());
        rspBo.setFinish(Boolean.valueOf(finish));
        if (ObjectUtil.isEmpty((Object)rspBo.getTaskInstId())) {
            throw new BaseBusinessException("100100", "\u7535\u5546\u8ba2\u5355\u6d88\u606f\u5904\u7406|\u751f\u6210\u53d1\u8d27\u5355\u9519\u8bef|\u4efb\u52a1\u5b9e\u4f8bId\u4e3a\u7a7a");
        }
        return rspBo;
    }

    public UocShipOrderQryBo buildShipAndItemData(UocSaleOrderDo uocSaleOrderDo, List<UocSaleOrderItemQryBo> orderItemQryBoList, UocDeliveryInfoBO qryPackageRsp, Map<String, BigDecimal> skuSendNumMap) {
        UocShipOrderQryBo uocCoreOrderShipReqBO = new UocShipOrderQryBo();
        uocCoreOrderShipReqBO.setShipOrderNo(this.genShipCode(uocSaleOrderDo));
        uocCoreOrderShipReqBO.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        uocCoreOrderShipReqBO.setOrderId(uocSaleOrderDo.getOrderId());
        uocCoreOrderShipReqBO.setShipOrderId(IdUtil.nextId());
        uocCoreOrderShipReqBO.setShipOrderState("FH_FH_FH");
        uocCoreOrderShipReqBO.setIsEnclosure(0);
        uocCoreOrderShipReqBO.setCreateTime(new Date());
        if (StringUtils.isBlank((CharSequence)qryPackageRsp.getPackageId())) {
            uocCoreOrderShipReqBO.setShipOrderNoExt(qryPackageRsp.getOrderId());
        } else {
            uocCoreOrderShipReqBO.setShipOrderNoExt(qryPackageRsp.getPackageId());
        }
        uocCoreOrderShipReqBO.setShipCompanyName(qryPackageRsp.getDeliveryName());
        uocCoreOrderShipReqBO.setShipCompanyId(qryPackageRsp.getDeliveryCode());
        uocCoreOrderShipReqBO.setShipTime(DateUtils.strToDateLong((String)qryPackageRsp.getDeliverytime()));
        uocCoreOrderShipReqBO.setShipRemark("\u5916\u90e8\u7535\u5546\u53d1\u8d27");
        ArrayList<UocShipOrderItemQryBo> shipItemList = new ArrayList<UocShipOrderItemQryBo>();
        for (UocSaleOrderItemQryBo saleOrderItemQryBo : orderItemQryBoList) {
            Long saleOrderItemId = saleOrderItemQryBo.getSaleOrderItemId();
            UocShipOrderItemQryBo uocCoreShipItemReqBO = new UocShipOrderItemQryBo();
            uocCoreShipItemReqBO.setShipOrderId(uocCoreOrderShipReqBO.getShipOrderId());
            uocCoreShipItemReqBO.setSaleOrderId(saleOrderItemQryBo.getSaleOrderId());
            uocCoreShipItemReqBO.setShipOrderItemId(IdUtil.nextId());
            uocCoreShipItemReqBO.setSaleOrderItemId(saleOrderItemId);
            uocCoreShipItemReqBO.setOrderId(saleOrderItemQryBo.getOrderId());
            uocCoreShipItemReqBO.setUnitName(saleOrderItemQryBo.getUnitName());
            if (skuSendNumMap.get(saleOrderItemQryBo.getSkuId()) != null) {
                if (saleOrderItemQryBo.getPurchaseCount().compareTo(skuSendNumMap.get(saleOrderItemQryBo.getSkuId())) < 0) {
                    uocCoreShipItemReqBO.setSendCount(saleOrderItemQryBo.getPurchaseCount());
                    skuSendNumMap.put(saleOrderItemQryBo.getSkuId(), skuSendNumMap.get(saleOrderItemQryBo.getSkuId()).subtract(saleOrderItemQryBo.getPurchaseCount()));
                } else {
                    uocCoreShipItemReqBO.setSendCount(skuSendNumMap.get(saleOrderItemQryBo.getSkuId()));
                }
            } else {
                uocCoreShipItemReqBO.setSendCount(saleOrderItemQryBo.getPurchaseCount());
            }
            uocCoreShipItemReqBO.setArriveCount(BigDecimal.ZERO);
            uocCoreShipItemReqBO.setRefuseCount(BigDecimal.ZERO);
            uocCoreShipItemReqBO.setReturnCount(BigDecimal.ZERO);
            uocCoreShipItemReqBO.setInspCount(BigDecimal.ZERO);
            uocCoreShipItemReqBO.setCreateTime(new Date());
            uocCoreShipItemReqBO.setRemark("\u5916\u90e8\u7535\u5546\u53d1\u8d27");
            uocCoreShipItemReqBO.setShipItemState("FH_FH_FH");
            shipItemList.add(uocCoreShipItemReqBO);
        }
        uocCoreOrderShipReqBO.setShipOrderItemBoList(shipItemList);
        uocCoreOrderShipReqBO.setJdCz(uocSaleOrderDo.getJdCz());
        return uocCoreOrderShipReqBO;
    }

    public UocSaleOrderDo qrySale(UocMsgCreateShipReqBo reqBo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBo.getDycUocQryMsgBO().getObjId());
        return this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private boolean checkSaleOrderIsFinish(Long orderId, Long saleOrderId) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(orderId);
        uocSaleOrderItemQryBo.setSaleOrderId(saleOrderId);
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.getCollectCountImplOrderItem(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException("101003", "\u67e5\u8be2\u6570\u91cf\u6c47\u603b\u4e3a\u7a7a");
        }
        UocSaleOrderItem uocSaleOrderItem = uocSaleOrderDo.getSaleOrderItems().get(0);
        if (null == uocSaleOrderItem) {
            throw new BaseBusinessException("101003", "\u67e5\u8be2\u6570\u91cf\u6c47\u603b\u4e3a\u7a7a");
        }
        return uocSaleOrderItem.getPurchaseCount().compareTo(uocSaleOrderItem.getSendCount().add(uocSaleOrderItem.getReturnCount())) == 0;
    }

    private List<UocOrderItem> getOrdGoodsByExtSkuId(UocSaleOrderDo uocSaleOrderDo, UocDeliveryItemsBO deliveryItemsBO) {
        try {
            UocOrderItemQryBo uocOrderItemQryBo = new UocOrderItemQryBo();
            uocOrderItemQryBo.setOrderId(uocSaleOrderDo.getOrderId());
            List<UocOrderItem> uocOrdGoodsQryBos = this.iUocOrderModel.qryOrderItemList(uocOrderItemQryBo);
            if (uocOrdGoodsQryBos == null) {
                throw new BaseBusinessException("101002", "\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u6ca1\u6709\u67e5\u8be2\u5230\u5185\u90e8\u5546\u54c1\u4fe1\u606f");
            }
            return uocOrdGoodsQryBos;
        }
        catch (Exception e) {
            throw new BaseBusinessException("101002", "\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u6ca1\u6709\u67e5\u8be2\u5230\u5185\u90e8\u5546\u54c1\u4fe1\u606f");
        }
    }

    private List<UocSaleOrderItemQryBo> qryOrdItem(UocSaleOrderDo uocSaleOrderDo, String skuId) {
        try {
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setSkuId(skuId);
            uocSaleOrderItemQryBo.setOrderId(uocSaleOrderDo.getOrderId());
            uocSaleOrderItemQryBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            List<UocSaleOrderItem> uocOrderItemQryBoList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(uocOrderItemQryBoList)) {
                throw new BaseBusinessException("101002", "\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f");
            }
            ArrayList<UocSaleOrderItemQryBo> rspBO = new ArrayList();
            rspBO = uocOrderItemQryBoList.stream().map(e -> {
                UocSaleOrderItemQryBo uocOrderItemQryBo1 = (UocSaleOrderItemQryBo)((Object)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UocSaleOrderItemQryBo.class)));
                return uocOrderItemQryBo1;
            }).collect(Collectors.toList());
            return rspBO;
        }
        catch (Exception e2) {
            log.error("\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u65f6\u6570\u636e\u5e93\u5f02\u5e38!", (Throwable)e2);
            throw new BaseBusinessException("101002", "\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u65f6\u6570\u636e\u5e93\u5f02\u5e38!");
        }
    }

    public Long ceateCoreShip(UocShipOrderQryBo uocShipOrderQryBo) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo = (UocShipOrderDo)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)uocShipOrderQryBo)), UocShipOrderDo.class);
        this.judeCount(uocShipOrderQryBo.getShipOrderItemBoList());
        this.computeShipOrderInfo(uocShipOrderDo);
        this.iUocShipOrderModel.createShipOrder(uocShipOrderDo);
        this.updateSaleComputeInfo(uocShipOrderDo);
        ArrayList<UocSaleOrderItem> saleOrderItems = new ArrayList<UocSaleOrderItem>();
        UocSaleOrderDo convertSaleOrderDo = new UocSaleOrderDo();
        convertSaleOrderDo.setJdCz(uocShipOrderQryBo.getJdCz());
        convertSaleOrderDo.setSaleOrderId(uocShipOrderQryBo.getSaleOrderId());
        convertSaleOrderDo.setOrderId(uocShipOrderQryBo.getOrderId());
        for (UocShipOrderItemQryBo item : uocShipOrderQryBo.getShipOrderItemBoList()) {
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setSaleOrderItemId(item.getSaleOrderItemId());
            uocSaleOrderItem.setSendCount(item.getSendCount());
            saleOrderItems.add(uocSaleOrderItem);
        }
        convertSaleOrderDo.setSaleOrderItems(saleOrderItems);
        this.iUocSaleOrderModel.modifyBatchItemSendCount(convertSaleOrderDo);
        convertSaleOrderDo.setSaleOrderState("XS_FH_FHZ");
        this.iUocSaleOrderModel.modifySaleOrderMain(convertSaleOrderDo);
        return uocShipOrderDo.getShipOrderId();
    }

    private void computeShipOrderInfo(UocShipOrderDo uocShipOrderDo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        List<UocSaleOrderItem> uocSaleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        List<UocShipOrderDo> uocShipOrderDoList = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        this.computeShipOrderTransFee(uocShipOrderDo, uocSaleOrderDo, uocSaleOrderItemList, uocShipOrderDoList);
        this.computeShipOrderFee(uocShipOrderDo, uocSaleOrderItemList, uocShipOrderDoList);
    }

    private void computeShipOrderTransFee(UocShipOrderDo uocShipOrderDo, UocSaleOrderDo uocSaleOrderDo, List<UocSaleOrderItem> uocSaleOrderItemList, List<UocShipOrderDo> uocShipOrderDoList) {
        BigDecimal allPurchaseCount = uocSaleOrderItemList.stream().map(UocSaleOrderItem::getPurchaseCount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal allSendCount = uocShipOrderDo.getShipOrderItemBoList().stream().map(UocShipOrderItem::getSendCount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(uocShipOrderDoList) && allPurchaseCount.compareTo(allSendCount) == 0) {
            uocShipOrderDo.setSendTransFee(uocSaleOrderDo.getTotalTransFee());
            return;
        }
        boolean isLast = this.checkShipOrderIsLast(uocShipOrderDo.getOrderId(), uocShipOrderDo.getSaleOrderId(), allSendCount);
        if (isLast) {
            BigDecimal shipSendTransFee = uocSaleOrderDo.getTotalTransFee().subtract(ObjectUtil.isNotEmpty((Object)uocSaleOrderDo.getTotalOccupyTransFee()) ? uocSaleOrderDo.getTotalOccupyTransFee() : BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
            uocShipOrderDo.setSendTransFee(shipSendTransFee);
            return;
        }
        Map<Long, UocSaleOrderItem> itemIdVsSaleOrderItemMap = uocSaleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, po -> po, (k1, k2) -> k2));
        BigDecimal allTotalGoodsWeight = uocSaleOrderItemList.stream().map(UocSaleOrderItem::getTotalGoodsWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal freightUnitPrice = uocSaleOrderDo.getTotalTransFee().divide(allTotalGoodsWeight, 2, RoundingMode.HALF_UP);
        BigDecimal allShipTotalGoodsWeight = new BigDecimal("0");
        for (UocShipOrderItem uocShipOrderItem : uocShipOrderDo.getShipOrderItemBoList()) {
            UocSaleOrderItem uocSaleOrderItem = itemIdVsSaleOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());
            BigDecimal shipTotalGoodsWeight = uocSaleOrderItem.getGoodsWeight().multiply(uocShipOrderItem.getSendCount());
            allShipTotalGoodsWeight = allShipTotalGoodsWeight.add(shipTotalGoodsWeight);
        }
        BigDecimal shipSendTransFee = freightUnitPrice.multiply(allShipTotalGoodsWeight).setScale(2, RoundingMode.HALF_UP);
        uocShipOrderDo.setSendTransFee(shipSendTransFee);
    }

    private void computeShipOrderFee(UocShipOrderDo uocShipOrderDo, List<UocSaleOrderItem> uocSaleOrderItemList, List<UocShipOrderDo> uocShipOrderDoList) {
        BigDecimal allPurchaseCount = uocSaleOrderItemList.stream().map(UocSaleOrderItem::getPurchaseCount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal allSendCount = uocShipOrderDo.getShipOrderItemBoList().stream().map(UocShipOrderItem::getSendCount).reduce(BigDecimal.ZERO, BigDecimal::add);
        Map<Long, UocSaleOrderItem> itemIdVsSaleOrderItemMap = uocSaleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, po -> po, (k1, k2) -> k2));
        List<UocShipOrderItem> uocShipOrderItemList = uocShipOrderDo.getShipOrderItemBoList();
        boolean isLast = this.checkShipOrderIsLast(uocShipOrderDo.getOrderId(), uocShipOrderDo.getSaleOrderId(), allSendCount);
        for (UocShipOrderItem uocShipOrderItem : uocShipOrderItemList) {
            BigDecimal sendPurchaseFee;
            BigDecimal sendSaleFee;
            UocSaleOrderItem uocSaleOrderItem = itemIdVsSaleOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());
            if (CollectionUtils.isEmpty(uocShipOrderDoList) && allPurchaseCount.compareTo(allSendCount) == 0) {
                uocShipOrderItem.setSendSaleFee(uocSaleOrderItem.getSaleFee());
                uocShipOrderItem.setSendPurchaseFee(uocSaleOrderItem.getPurchaseFee());
                continue;
            }
            if (isLast) {
                sendSaleFee = uocSaleOrderItem.getSaleFee().subtract(ObjectUtil.isNotEmpty((Object)uocSaleOrderItem.getTotalSendGoodsSaleFee()) ? uocSaleOrderItem.getTotalSendGoodsSaleFee() : BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                sendPurchaseFee = uocSaleOrderItem.getPurchaseFee().subtract(ObjectUtil.isNotEmpty((Object)uocSaleOrderItem.getTotalSendGoodsPurchaseFee()) ? uocSaleOrderItem.getTotalSendGoodsPurchaseFee() : BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                uocShipOrderItem.setSendSaleFee(sendSaleFee);
                uocShipOrderItem.setSendPurchaseFee(sendPurchaseFee);
                continue;
            }
            sendSaleFee = uocSaleOrderItem.getSalePrice().multiply(uocShipOrderItem.getSendCount()).setScale(2, RoundingMode.HALF_UP);
            sendPurchaseFee = uocSaleOrderItem.getPurchasePrice().multiply(uocShipOrderItem.getSendCount()).setScale(2, RoundingMode.HALF_UP);
            uocShipOrderItem.setSendSaleFee(sendSaleFee);
            uocShipOrderItem.setSendPurchaseFee(sendPurchaseFee);
        }
        uocShipOrderDo.setShipOrderItemBoList(uocShipOrderItemList);
    }

    private void updateSaleComputeInfo(UocShipOrderDo uocShipOrderDo) {
        this.updateSaleOccupyTransFee(uocShipOrderDo);
        this.updateSaleItemSendGoodsFee(uocShipOrderDo);
    }

    private void updateSaleOccupyTransFee(UocShipOrderDo uocShipOrderDo) {
        UocSaleOrderDo updateOccupyTransFee = new UocSaleOrderDo();
        updateOccupyTransFee.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        updateOccupyTransFee.setOrderId(uocShipOrderDo.getOrderId());
        updateOccupyTransFee.setTotalOccupyTransFee(uocShipOrderDo.getSendTransFee());
        this.iUocSaleOrderModel.modifyOccupyTransFee(updateOccupyTransFee);
    }

    private void updateSaleItemSendGoodsFee(UocShipOrderDo uocShipOrderDo) {
        Map<Long, List<UocShipOrderItem>> itemIdVsShipOrderItemMap = uocShipOrderDo.getShipOrderItemBoList().stream().collect(Collectors.groupingBy(UocShipOrderItem::getSaleOrderItemId));
        ArrayList<UocSaleOrderItem> uocSaleOrderItemList = new ArrayList<UocSaleOrderItem>(1);
        for (Map.Entry<Long, List<UocShipOrderItem>> entry : itemIdVsShipOrderItemMap.entrySet()) {
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            BigDecimal allSendSaleFee = entry.getValue().stream().map(UocShipOrderItem::getSendSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal allSendPurchaseFee = entry.getValue().stream().map(UocShipOrderItem::getSendPurchaseFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            uocSaleOrderItem.setSaleOrderItemId(entry.getKey());
            uocSaleOrderItem.setTotalSendGoodsSaleFee(allSendSaleFee);
            uocSaleOrderItem.setTotalSendGoodsPurchaseFee(allSendPurchaseFee);
            uocSaleOrderItemList.add(uocSaleOrderItem);
        }
        UocSaleOrderDo updateItemSendGoodsFee = new UocSaleOrderDo();
        updateItemSendGoodsFee.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        updateItemSendGoodsFee.setOrderId(uocShipOrderDo.getOrderId());
        updateItemSendGoodsFee.setSaleOrderItems(uocSaleOrderItemList);
        this.iUocSaleOrderModel.modifyItemTotalSendGoodsFee(updateItemSendGoodsFee);
    }

    private boolean checkShipOrderIsLast(Long orderId, Long saleOrderId, BigDecimal allSendCount) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(saleOrderId);
        uocSaleOrderItemQryBo.setOrderId(orderId);
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.getCollectCountImplOrderItem(uocSaleOrderItemQryBo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException("8888", "\u67e5\u8be2\u6570\u91cf\u6c47\u603b\u4e3a\u7a7a");
        }
        UocSaleOrderItem uocSaleOrderItem = uocSaleOrderDo.getSaleOrderItems().get(0);
        return uocSaleOrderItem.getPurchaseCount().compareTo(uocSaleOrderItem.getSendCount().add(allSendCount)) == 0;
    }

    public void judeCount(List<UocShipOrderItemQryBo> shipItemList) {
        for (UocShipOrderItemQryBo item : shipItemList) {
            if (null == item.getSendCount()) {
                item.setSendCount(new BigDecimal(0));
            }
            if (null == item.getArriveCount()) {
                item.setArriveCount(new BigDecimal(0));
            }
            if (null == item.getRefuseCount()) {
                item.setRefuseCount(new BigDecimal(0));
            }
            if (null == item.getReturnCount()) {
                item.setReturnCount(new BigDecimal(0));
            }
            if (null != item.getInspCount()) continue;
            item.setInspCount(new BigDecimal(0));
        }
    }

    public String genShipCode(UocSaleOrderDo uocSaleOrderDo) {
        UocShipOrderDo shipOrderDo = new UocShipOrderDo();
        shipOrderDo.setOrderSource(uocSaleOrderDo.getOrderSource());
        shipOrderDo = this.iUocShipOrderModel.getShipOrderNo(shipOrderDo);
        return shipOrderDo.getShipOrderNo();
    }
}

