/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderCheckAccountQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderCheckAccount;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderSyncCheckStatusReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderSyncCheckStatusRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UocOrderSyncCheckStatusTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocOrderSyncCheckStatusTransaction.class);
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private UocEsSyncManager uocEsSyncManager;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocInspOrderModel uocInspOrderModel;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocOrderSyncCheckStatusRspBo dealSyncCheckStatus(UocOrderSyncCheckStatusReqBo reqBo) {
        this.validateArg(reqBo);
        UocOrderSyncCheckStatusRspBo rspBo = UocRu.success(UocOrderSyncCheckStatusRspBo.class);
        UocOrderCheckAccountQryBo uocOrderCheckAccountQryBo = new UocOrderCheckAccountQryBo();
        uocOrderCheckAccountQryBo.setObjId(reqBo.getObjId());
        uocOrderCheckAccountQryBo.setObjType(reqBo.getObjType());
        UocOrderCheckAccount uocOrderCheckAccount = this.iUocOrderModel.qryCheckInfo(uocOrderCheckAccountQryBo);
        if (null != uocOrderCheckAccount) {
            UocOrderCheckAccount update = new UocOrderCheckAccount();
            update.setId(uocOrderCheckAccount.getId());
            update.setCheckState(reqBo.getCheckState());
            this.iUocOrderModel.updateCheckInfo(update);
        } else {
            UocOrderCheckAccount insert = UocRu.js(reqBo, UocOrderCheckAccount.class);
            insert.setId(IdUtil.nextId());
            this.iUocOrderModel.createCheckInfo(insert);
        }
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setInspOrderId(reqBo.getObjId());
        UocInspOrderDo uocInspOrderDo = this.uocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
        rspBo.setOrderId(uocInspOrderDo.getOrderId());
        return rspBo;
    }

    private void validateArg(UocOrderSyncCheckStatusReqBo reqBo) {
        if (null == reqBo.getCheckState()) {
            throw new BaseBusinessException("100001", "checkState\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getObjId()) {
            throw new BaseBusinessException("100001", "objId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getObjType()) {
            throw new BaseBusinessException("100001", "objType\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("UOC_ORD_CHECK_STATE");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    private void syncEs(UocOrderCheckAccount uocOrderCheckAccount) {
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        uocEsSyncManagerSaveDataReqBo.setObjId(uocOrderCheckAccount.getObjId());
        JSONObject jsonObj = new JSONObject();
        Map<String, Map<String, String>> dic = this.getDic();
        Map<String, String> checkStateMap = dic.get("UOC_ORD_CHECK_STATE");
        jsonObj.put("checkState", (Object)uocOrderCheckAccount.getCheckState());
        jsonObj.put("checkStateStr", (Object)checkStateMap.get(Convert.toStr((Object)uocOrderCheckAccount.getCheckState())));
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getInspOrderIndex());
        this.uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }
}

