package com.tydic.dyc.oc.model.importorder.qrybo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题：UocImportOrderItemQryDetailBo
 * 描述：导入订单记录明细BO
 **/
@Data
public class UocImportOrderItemQryDetailBo implements Serializable {

	private static final long serialVersionUID =  7641723650791193139L;

	/**
	 * 记录明细ID
	 */
	private Long importOrderItemId;

	/**
	 * 记录ID
	 */
	private Long importOrderId;

	/**
	 * 商品编码
	 */
	private String skuCode;

	/**
	 * 商品名称
	 */
	private String skuName;

	/**
	 * 采购数量
	 */
	private BigDecimal purchaseCount;

	/**
	 * 供应商ID
	 */
	private String supplierId;

	/**
	 * 供应商名称
	 */
	private String supplierName;

	/**
	 * 明细信息JSON
	 */
	private String dataJson;

	/**
	 * 失败描述
	 */
	private String failReason;

	/**
	 * 创建人ID
	 */
	private String createUserId;

	/**
	 * 创建人名称
	 */
	private String createUserName;

	/**
	 * 创建时间
	 */
	private Date createTime;

	/**
	 * 更新人ID
	 */
	private String updateUserId;

	/**
	 * 更新人名称
	 */
	private String updateUserName;

	/**
	 * 更新时间
	 */
	private Date updateTime;

	/**
	 * 备注
	 */
	private String remark;

}
