package com.tydic.dyc.oc.service.common;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.order.sub.UocTodo;
import com.tydic.dyc.oc.service.common.bo.UocSaveTodoInfoReqBo;
import com.tydic.dyc.oc.service.common.bo.UocSaveTodoInfoRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 描述: 〈领域服务-保存待办数据 实现〉
 * @author : 王久鑫
 * @date : 2022/10/27 14:05
 */
@HTServiceImpl
public class UocSaveTodoInfoServiceImpl implements UocSaveTodoInfoService{
    @Autowired
    private IUocCommonModel uocCommonModel;
    @Override
    public UocSaveTodoInfoRspBo saveTodoInfo(UocSaveTodoInfoReqBo uocSaveTodoInfoReqBo) {
        validateArgs(uocSaveTodoInfoReqBo);
        UocTodo uocTodo = new UocTodo();
        BeanUtils.copyProperties(uocSaveTodoInfoReqBo,uocTodo);
        uocCommonModel.saveTodoInfo(uocTodo);
        UocSaveTodoInfoRspBo rspBO = new UocSaveTodoInfoRspBo();
        rspBO.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBO;
    }
    private void validateArgs(UocSaveTodoInfoReqBo uocSaveTodoInfoReqBo){
        if (null == uocSaveTodoInfoReqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocSaveTodoInfoReqBo.getTodoId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参待办ID不能为空");
        }
        if (null == uocSaveTodoInfoReqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == uocSaveTodoInfoReqBo.getBusiId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参业务ID不能为空");
        }
    }
}
