package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderAndStopProcessServiceReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderAndStopProcessServiceRspBO;
import com.tydic.dyc.oc.transactionservice.UocCancelSaleOrderAndStopProcessTransaction;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述: 〈领域服务-取消销售单并终止订单流程实现〉
 * @author : yuhao
 * @date : 2022/7/20 18:05
 */
@HTServiceImpl
public class UocCancelSaleOrderAndStopProcessServiceImpl implements UocCancelSaleOrderAndStopProcessService{
    
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private UocCancelSaleOrderAndStopProcessTransaction uocCancelSaleOrderAndStopProcessTransaction;
    /**
     * 取消销售单并终止订单流程
     *
     * @param reqBO
     * @return
     */
    @Override
    public UocCancelSaleOrderAndStopProcessServiceRspBO cancelSaleOrderAndStopProcess(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO) {
    
        UocCancelSaleOrderAndStopProcessServiceRspBO rspBO =  uocCancelSaleOrderAndStopProcessTransaction.cancelSaleOrderAndStopProcess(reqBO);
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBO.getRespCode())) {
            //本地线程同步es
            syncEs(reqBO, rspBO);
        }
        //返回结果
        return rspBO;
    }
    
    private void syncEs(UocCancelSaleOrderAndStopProcessServiceReqBO reqBo, UocCancelSaleOrderAndStopProcessServiceRspBO rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(rspBo.getSaleOrderIds())) {
            for (Long saleOrderId : rspBo.getSaleOrderIds()) {
                SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
                orderBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
                orderBo.setOrderId(reqBo.getOrderId());
                orderBo.setObjId(saleOrderId);
                orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(orderBo);
            }
        }
        SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
        orderBo.setIndexName(uocIndexConfig.getOrderIndex());
        orderBo.setOrderId(reqBo.getOrderId());
        orderBo.setObjId(reqBo.getOrderId());
        orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(orderBo);
        
        /*if(ObjectUtil.isNotEmpty(rspBo.getAuditOrderIdList())){
            for (Long auditOrderId : rspBo.getAuditOrderIdList()) {
                SyncEsRunnableBo auditOrderBo = new SyncEsRunnableBo();
                auditOrderBo.setIndexName(uocIndexConfig.getApprovalOrderPlusIndex());
                auditOrderBo.setOrderId(reqBo.getOrderId());
                auditOrderBo.setObjId(auditOrderId);
                auditOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(auditOrderBo);
            }
        }*/
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }

    
    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO){
        if(null == reqBO){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if(null == reqBO.getUserId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "当前操作人id不能为空");
        }
        if(StringUtils.isEmpty(reqBO.getName())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "当前操作人名称不能为空");
        }
        if(null == reqBO.getOrderId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "订单id不能为空");
        }
        if(null == reqBO.getSaleOrderId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "销售单id不能为空");
        }
    }

}
