package com.tydic.dyc.oc.service.order;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.order.bo.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderAuditBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 标题:UocGetOrderAllDetailServiceImpl
 * 说明:
 * 时间:2022/5/19 16:23
 *
 * @author 童垣杰
 */
@Slf4j
@HTServiceImpl
public class UocGetOrderAllDetailServiceImpl implements UocGetOrderAllDetailService{

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    private static final String DEFAULT_PAY_TYPE = "2";
    private static final String DEFAULT_PAY_TYPE_STR = "帐期支付";

    @Override
    public UocGetOrderAllDetailServiceRspBo getOrderAllDetail(UocGetOrderAllDetailServiceReqBo reqBo) {
        //1.入参校验
        val(reqBo);

        //2.查询主订单信息
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        UocOrderDo orderDo = iUocOrderModel.qryOrderBy(uocOrderDo);
        if (orderDo == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_THREE_DATA_NULL, "未查询到 [ orderId = "+reqBo.getOrderId()+" ]，对应的订单信息！");
        }
        //将主订单信息封装入反参
        UocGetOrderAllDetailServiceRspBo rspBo = UocRu.js(orderDo, UocGetOrderAllDetailServiceRspBo.class);
        //查询审批流程数据
        UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = this.getAuditProcInst(orderDo, UocDicConstant.OBJ_TYPE.ORDER);
        //设置审批流程数据
        rspBo.setAuditProcInst(auditProcInst);
        //查询审批单
        List<UocAuditOrderDo> auditOrderList = getAuditOrderList(orderDo.getOrderId(), orderDo.getOrderId(), UocDicConstant.OBJ_TYPE.ORDER);
        rspBo.setAuditOrderBoList(UocRu.jsl(auditOrderList, UocSaleOrderAuditBO.class));

        // 付款方式
        rspBo.setPayType(DEFAULT_PAY_TYPE);
        rspBo.setPayTypeStr(DEFAULT_PAY_TYPE_STR);

        //3.查询收货地址信息
        UocOrdLogisticsRelaQryBo uocOrdLogisticsRelaQryBo = new UocOrdLogisticsRelaQryBo();
        uocOrdLogisticsRelaQryBo.setOrderId(reqBo.getOrderId());
        uocOrdLogisticsRelaQryBo.setContactId(orderDo.getContactId());
        log.info("查询收货地址信息入参,{}",uocOrdLogisticsRelaQryBo.toString());
        UocOrdLogisticsRela uocOrdLogisticsRela = iUocOrderModel.qryOrderLogisticsRela(uocOrdLogisticsRelaQryBo);
        //将收货地址封装入反参 一个整单对应一条地址
        rspBo.setLogisticsBo(UocRu.js(uocOrdLogisticsRela,UocGetOrderAllDetailServiceRspOrderLogisticsBo.class));

        //4.查询三方信息
        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
        uocOrderStakeholderQryBo.setOrderId(reqBo.getOrderId());
        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = iUocOrderModel.qryStakeholderList(uocOrderStakeholderQryBo);
        //封装三方信息
        rspBo.setSaleStakeBos(UocRu.jsl(uocOrderStakeholderQryBos, UocGetOrderAllDetailServiceRspSaleStakeBo.class));
        rspBo.setPurCompanyName(uocOrderStakeholderQryBos.get(0).getPurCompanyName());

        //5.查询附件信息
        UocOrderAccessoryQryBo accessoryQryBo = new UocOrderAccessoryQryBo();
        accessoryQryBo.setObjId(reqBo.getOrderId());
        accessoryQryBo.setOrderId(reqBo.getOrderId());
        accessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        List<UocOrderAccessory> orderAccessoryList = iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        //封装附件信息
        rspBo.setAccessoryBos(UocRu.jsl(orderAccessoryList, UocGetOrderAllDetailServiceRspAccessoryBo.class));

        //6.查询商品详情
        UocSaleOrderItemQryBo uocOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocOrderItemQryBo.setOrderId(reqBo.getOrderId());
        List<UocSaleOrderItem> uocOrderItems = iUocSaleOrderModel.getSaleOrderItemList(uocOrderItemQryBo);
        //封装商品信息
        //每条商品清单的商品金额自己算
        List<UocGetOrderAllDetailServiceRspOrderCommInfoBo> commInfoBos = UocRu.jsl(uocOrderItems, UocGetOrderAllDetailServiceRspOrderCommInfoBo.class);
        Map<String, String> supMap = rspBo.getSaleStakeBos().stream().collect(Collectors.toMap(UocGetOrderAllDetailServiceRspSaleStakeBo::getSupId,UocGetOrderAllDetailServiceRspSaleStakeBo::getSupName));
        for (UocGetOrderAllDetailServiceRspOrderCommInfoBo commInfoBo : commInfoBos) {
            commInfoBo.setSupplierName(supMap.get(commInfoBo.getSupplierId()));
            if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(commInfoBo.getSkuSource())) {
                commInfoBo.setSkuCode(commInfoBo.getSkuExtSkuId());
            }
            /*BigDecimal saleFee = new BigDecimal(commInfoBo.getSalePrice()).multiply(commInfoBo.getPurchaseCount());
            BigDecimal purchaseFee = commInfoBo.getPurchasePrice().multiply(commInfoBo.getPurchaseCount());
            commInfoBo.setSaleFee(saleFee);
            commInfoBo.setPurchaseFee(purchaseFee);*/

            //7.从saleOrderItem获取比选单号，取第一个就行。量很小，可循环
            /*UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setOrderId(commInfoBo.getOrderId());
            uocSaleOrderItemQryBo.setOrderItemId(commInfoBo.getOrderItemId());
            UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
            uocSaleOrderItemQryBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderItems().get(0).getSaleOrderId());
            String cmpOrderNo = uocSaleOrderDo.getSaleOrderItems().get(0).getCmpOrderNo();
            //封装比选单号
            commInfoBo.setCmpOrderNo(cmpOrderNo);
            commInfoBo.setNoCmpReason(uocSaleOrderDo.getSaleOrderItems().get(0).getNoCmpReason());*/
        }
        rspBo.setCommInfoBos(commInfoBos);

        //7.从销售单获取支付状态，采购计划
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
//        uocSaleOrderDo.setSaleOrderId(rspBo.getCommInfoBos().get(0).getSaleOrderId());
//        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
        List<UocSaleOrderDo> saleOrderList = iUocSaleOrderModel.getSaleOrderList(uocSaleOrderQryBo);

        if (CollectionUtil.isNotEmpty(saleOrderList)) {
            UocSaleOrderDo saleOrderMain = saleOrderList.get(0);
            BeanUtils.copyProperties(saleOrderMain, rspBo);
            //封装支付状态，采购计划
            rspBo.setPayState(saleOrderMain.getPayState().toString());
            rspBo.setPurchaseMode(saleOrderMain.getPurchaseMode());
            rspBo.setCancelOperName(saleOrderMain.getCancelOperName());
            rspBo.setCancelTime(saleOrderMain.getCancelTime());
            rspBo.setCancelReason(saleOrderMain.getCancelReason());
            rspBo.setApplicationName(saleOrderMain.getApplicationName());
            rspBo.setApplicationTheme(saleOrderMain.getApplicationTheme());
            rspBo.setApplicationType(saleOrderMain.getApplicationType());
            rspBo.setApplicationDept(saleOrderMain.getApplicationDept());
            rspBo.setPurchaseAppType(saleOrderMain.getPurchaseAppType());
            rspBo.setReduceAccount(saleOrderMain.getReduceAccount());
            rspBo.setApplicationCode(saleOrderMain.getApplicationCode());
            rspBo.setAuditFlowKey(saleOrderMain.getAuditFlowKey());
            rspBo.setOldParentOrderCode(saleOrderMain.getOldParentOrderCode());
            rspBo.setTotalOccupyTransFee(saleOrderMain.getTotalOccupyTransFee());

            rspBo.setTotalGoodsSaleFee(saleOrderList.stream().map(UocSaleOrderDo::getTotalGoodsSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add));
            rspBo.setTotalGoodsPurchaseFee(saleOrderList.stream().map(UocSaleOrderDo::getTotalGoodsPurchaseFee).reduce(BigDecimal.ZERO, BigDecimal::add));
            rspBo.setTotalTransFee(saleOrderList.stream().map(UocSaleOrderDo::getTotalTransFee).reduce(BigDecimal.ZERO, BigDecimal::add));
            rspBo.setTotalSaleFee(rspBo.getTotalGoodsSaleFee().add(rspBo.getTotalTransFee()));
            rspBo.setTotalPurchaseFee(rspBo.getTotalGoodsPurchaseFee().add(rspBo.getTotalTransFee()));
        }
        //查询审批状态
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        List<UocApprovalObj> approvalObjList = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
       
        if(ObjectUtil.isNotEmpty(approvalObjList)){
            UocAuditOrderQryBo auditOrderQryBo = new UocAuditOrderQryBo();
            auditOrderQryBo.setAuditOrderId(approvalObjList.get(0).getAuditOrderId());
            UocAuditOrderDo uocAuditOrderDo = iUocAuditOrderModel.qryAuditOrder(auditOrderQryBo);
            rspBo.setAuditOrderStatus(uocAuditOrderDo.getAuditOrderStatus());
        }
        //8. 翻译
        transelate(rspBo);

        return rspBo;
    }

    /**
     * 查询审批流程任务实例
     *
     * @param orderDo
     * @param objType
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getAuditProcInst(UocOrderDo orderDo, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        //查询销售单对应的审批单id
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(orderDo.getOrderId());
        //销售单
        if (UocDicConstant.OBJ_TYPE.SALE.equals(objType)) {
            //uocApprovalObjQryBo.setObjId(orderDo.getSaleOrderId() + "");
            uocApprovalObjQryBo.setObjType(objType);
        } else {//整单
            uocApprovalObjQryBo.setObjId(orderDo.getOrderId() + "");
            uocApprovalObjQryBo.setObjType(objType);
        }
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (ObjectUtil.isNotEmpty(uocApprovalObjs)) {
            List<Long> auditOrderIds = uocApprovalObjs.stream().map(UocApprovalObj::getAuditOrderId).collect(Collectors.toList());
            //查询审批单对应的任务
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setOrderId(orderDo.getOrderId());
            taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            taskInstQryBo.setObjIdList(auditOrderIds);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocApprovalObjQryBo uocApprovalObjQryBo1 = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo1.setAuditOrderId(each.getObjId());
                    List<UocApprovalObj> uocApprovalObjs1 = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo1);
                    Integer objBusiType = uocApprovalObjs1.get(0).getObjBusiType();
                    each.setObjBusiType(objBusiType);
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    if (ObjectUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDeal = uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDeal.getDealId();
                        String dealName = uocOrderTaskDeal.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    String auditDealResultQryKey = each.getDealId() + "_" + each.getObjBusiType();
                    if (each.getDealResult() != null) {
                        auditDealResultQryKey = auditDealResultQryKey + "_" + each.getDealResult();
                    }
                    each.setAuditDealResultQryKey(auditDealResultQryKey);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });
                procInst.setTaskList(taskBoList);
                //取审批未结束的审批实例Id
                String procInstId = CollectionUtils.isEmpty(uocOrderTaskInsts) ? "" : uocOrderTaskInsts.get(0).getProcInstId();
                if (org.apache.commons.lang3.StringUtils.isNotBlank(procInstId)) {
                    procInst.setProcInstId(procInstId);
                }
            }

        }
        return procInst;
    }

    /**
     * 查询审批单
     *
     * @return java.util.List<com.tydic.dyc.oc.model.audit.sub.UocAuditOrder>
     */
    private List<UocAuditOrderDo> getAuditOrderList(Long orderId, Long objId, Integer objType) {
        UocApprovalObjQryBo obj = new UocApprovalObjQryBo();
        obj.setOrderId(orderId);
        obj.setObjId(Convert.toStr(objId));
        obj.setObjType(objType);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(obj);
        log.info("查询uocApprovalObjs：{}",JSON.toJSONString(uocApprovalObjs));
        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
            return new ArrayList<>();
        }
        List<Long> auditOrderIdList = new ArrayList<>();
        uocApprovalObjs.forEach(uocApprovalObj -> auditOrderIdList.add(uocApprovalObj.getAuditOrderId()));
        List<UocAuditOrderDo> uocAuditOrderDoList = new ArrayList<>();
        UocAuditOrderQryBo auditOrderQryBo = new UocAuditOrderQryBo();
        auditOrderQryBo.setOrderId(orderId);
        auditOrderQryBo.setAuditOrderIdList(auditOrderIdList);
        List<UocAuditOrder> uocAuditOrders = iUocAuditOrderModel.qryAuditOrderList(auditOrderQryBo);
        log.info("查询uocAuditOrders：{}",JSON.toJSONString(uocAuditOrders));

        if (ObjectUtil.isNotEmpty(uocAuditOrders)) {
            uocAuditOrders.forEach(uocAuditOrder -> {
                // 查询流程实例
                UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
                procInstQryBo.setObjId(uocAuditOrder.getAuditOrderId());
                procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
                procInstQryBo.setOrderId(orderId);
                procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(procInstQryBo);
                log.info("查询uocOrderProcInsts：{}",JSON.toJSONString(uocOrderProcInsts));

                if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
                    uocAuditOrder.setProcInstId(uocOrderProcInsts.get(0).getProcInstId());
                }
            });
            uocAuditOrderDoList = UocRu.jsl(uocAuditOrders, UocAuditOrderDo.class);
            Map<Long, List<UocApprovalObj>> approvalObjMap = uocApprovalObjs.stream().collect(Collectors.groupingByConcurrent(UocApprovalObj::getAuditOrderId));
            uocAuditOrderDoList.forEach(each -> {
                each.setApprovalObjs(approvalObjMap.get(each.getAuditOrderId()));
            });
        }
        return uocAuditOrderDoList;
    }

    private void transelate(UocGetOrderAllDetailServiceRspBo rspBo) {
        Map<String, Map<String, String>> dic = getDic();
        if (rspBo.getPayState() != null) {
            String payStateStr = dic.get(UocDicConstant.PAY_STATE.P_CODE).get(rspBo.getPayState());
            rspBo.setPayStateStr(payStateStr);
        }
        if (rspBo.getOrderState() != null) {
            String orderStateStr = dic.get(UocDicConstant.ORDER_STATE.P_CODE).get(rspBo.getOrderState());
            rspBo.setOrderStateStr(orderStateStr);
        }
        if (rspBo.getPurchaseMode() != null) {
            String purchaseModeStr = dic.get(UocDicConstant.PURCHASE_MODE.P_CODE).get(rspBo.getPurchaseMode().toString());
            rspBo.setPurchaseModeStr(purchaseModeStr);
        }
        if (rspBo.getPayType() != null) {
            String payTypeStr = dic.get(UocDicConstant.PAY_TYPE.P_CODE).get(rspBo.getPayType());
            rspBo.setPayTypeStr(payTypeStr);
        }
        //审批单状态
        if (rspBo.getAuditOrderStatus() != null) {
            String auditOrderStatusStr = dic.get(UocDicConstant.ORDER_STATE.P_CODE).get(rspBo.getAuditOrderStatus());
            rspBo.setAuditOrderStatusStr(auditOrderStatusStr);
        }
        //采购类型
        if (StringUtils.hasText(rspBo.getApplicationType())) {
            String applicationTypeStr = dic.get(UocDicConstant.APPLICATION_TYPE.P_CODE).get(rspBo.getApplicationType());
            rspBo.setApplicationTypeStr(applicationTypeStr);
        }
        //申请类型
        if (StringUtils.hasText(rspBo.getPurchaseAppType())) {
            String purchaseAppTypeStr = dic.get(UocDicConstant.PURCHASE_APP_TYPE.P_CODE).get(rspBo.getPurchaseAppType());
            rspBo.setPurchaseAppTypeStr(purchaseAppTypeStr);
        }
        //扣款账户
        if (StringUtils.hasText(rspBo.getReduceAccount())) {
            String reduceAccountStr = dic.get(UocDicConstant.REDUCE_ACCOUNT.P_CODE).get(rspBo.getReduceAccount());
            rspBo.setReduceAccountStr(reduceAccountStr);
        }
    }

    private void val(UocGetOrderAllDetailServiceReqBo reqBo){
        if (reqBo == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能不为空");
        }
        if (StringUtils.isEmpty(reqBo.getOrderId())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参【orderId】不能为空");
        }
    }

    /**
     * 查询字典
     */
    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.PAY_STATE.P_CODE);
        pCodes.add(UocDicConstant.PURCHASE_MODE.P_CODE);
        pCodes.add(UocDicConstant.ORDER_STATE.P_CODE);
        pCodes.add(UocDicConstant.PAY_TYPE.P_CODE);
        pCodes.add(UocDicConstant.PURCHASE_APP_TYPE.P_CODE);
        pCodes.add(UocDicConstant.APPLICATION_TYPE.P_CODE);
        //扣款账户
        pCodes.add(UocDicConstant.REDUCE_ACCOUNT.P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }
}
