package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocResoveEsPreOrderServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocResoveEsPreOrderServiceReqSkuBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocResoveEsPreOrderServiceRspBo;
import com.tydic.dyc.oc.transactionservice.UocResoveEsPreOrderTransaction;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 描述: 〈领域服务-电商预定单下单成功处理服务 实现〉
 * @author : yuhao
 * @date : 2022/8/1 11:05
 */
@HTServiceImpl
@Slf4j
public class UocResoveEsPreOrderServiceImpl implements UocResoveEsPreOrderService{

    @Autowired
    private UocResoveEsPreOrderTransaction uocResoveEsPreOrderTransaction;

    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocResoveEsPreOrderServiceRspBo dealEsPreOrder(UocResoveEsPreOrderServiceReqBo reqBo) {
        UocResoveEsPreOrderServiceRspBo rspBo = uocResoveEsPreOrderTransaction.dealEsPreOrder(reqBo);
        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocResoveEsPreOrderServiceReqBo reqBo, UocResoveEsPreOrderServiceRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        //同步销售单
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(rspBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);

        //同步订单
        SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
        orderBo.setIndexName(uocIndexConfig.getOrderIndex());
        orderBo.setOrderId(reqBo.getOrderId());
        orderBo.setObjId(reqBo.getOrderId());
        orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(orderBo);

        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}


