package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.transactionservice.UocUpdateSaleOrderStateTransaction;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderStateServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderStateServiceRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述: 〈领域服务-销售单状态更新 实现〉
 * @author : yuhao
 * @date : 2022/7/20 13:27
 */
@HTServiceImpl
public class UocUpdateSaleOrderStateServiceImpl implements UocUpdateSaleOrderStateService {

   @Autowired
   private UocUpdateSaleOrderStateTransaction uocUpdateSaleOrderStateTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Override
    public UocUpdateSaleOrderStateServiceRspBo updateSaleOrderState(UocUpdateSaleOrderStateServiceReqBo reqBo) {
        UocUpdateSaleOrderStateServiceRspBo rspBo = uocUpdateSaleOrderStateTransaction.updateSaleOrderState(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地线程同步es
            syncEs(reqBo, rspBo);
        }

        return rspBo;
    }

    private void syncEs(UocUpdateSaleOrderStateServiceReqBo reqBo, UocUpdateSaleOrderStateServiceRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
        orderBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        orderBo.setOrderId(reqBo.getOrderId());
        orderBo.setObjId(reqBo.getSaleOrderId());
        orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(orderBo);

        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }

}


