package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderItemQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocMsgCreateShipService;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocOrderPropertiesUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/*
 * @Author lsl
 * @Description //TODO 电商订单消息处理，用于生成发货单
 * @Date 16:30 2022/4/12
 * @Param
 * @return
 */
@Slf4j
@Component
public class UocMsgCreateShipTransaction {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocMsgCreateShipRspBo createShip(UocMsgCreateShipReqBo reqBo) {
        UocMsgCreateShipRspBo rspBo = new UocMsgCreateShipRspBo();
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc("发货单、发货单明细创建成功new");

        //默认是第一次发货
        rspBo.setFirstDeliverFlag(true);
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getDycUocQryMsgBO().getObjId());
        List<UocShipOrderDo> shipOrderDoList = iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        //如果查询到发货信息，则说明不是第一次发货
        if (ObjectUtil.isNotEmpty(shipOrderDoList)) {
            rspBo.setFirstDeliverFlag(false);
        }


        //查询销售订单信息
        UocSaleOrderDo uocSaleOrderDo = qrySale(reqBo);
        rspBo.setSaleOrderNo(uocSaleOrderDo.getSaleOrderNo());
        rspBo.setArrivalDate(uocSaleOrderDo.getSendTime());
        rspBo.setCreateOperId(uocSaleOrderDo.getCreateOperId());
        if (null == uocSaleOrderDo) {
            rspBo.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
            rspBo.setRespDesc("订单发货通知业务失败：未查询到销售订单信息!");
            return rspBo;
        }
        //只有待发货或发货中的订单才能发货
        if (!(UocStateConstants.SaleOrder.XS_FH_DFH.equals(uocSaleOrderDo.getSaleOrderState()) || UocStateConstants.SaleOrder.XS_FH_FHZ.equals(uocSaleOrderDo.getSaleOrderState()))) {
            rspBo.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
            rspBo.setRespDesc("该销售单状态不对，只有待发货或发货中销售单才能发货");
            return rspBo;
        }

        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        taskInstQryBo.setObjId(uocSaleOrderDo.getSaleOrderId());
        taskInstQryBo.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        //查询订单任务实例
        List<UocOrderTaskInst> taskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if (ObjectUtil.isNotEmpty(taskInsts)) {
            rspBo.setTaskInstId(taskInsts.get(0).getTaskInstId());
            rspBo.setStepId(taskInsts.get(0).getProcState());
        }
        //查询销售订单明细信息
        List<UocSaleOrderItemQryBo> orderItemQryBoList = new ArrayList<>();
        log.info("JD_SUPPLIER:{}", UocOrderPropertiesUtil.getProperty("SUPPLIER_JD_ID"));
        log.info("SUNING_SUPPLIER:{}", UocOrderPropertiesUtil.getProperty("SUPPLIER_SUNING_ID"));
        log.info("消息supNo:{}", String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo()));
        //非京东苏宁单
        if (!UocOrderPropertiesUtil.getProperty("SUPPLIER_JD_ID").equals(String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo()))
                && !UocOrderPropertiesUtil.getProperty("SUPPLIER_JDVOP_ID").equals(String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo()))) {
            //查询电商订单信息中的商品信息
            List<UocOrderSkuBO> extOrderSaleItemRspBOList = null;
            if (reqBo.getExtOrderInfoBO().getSaleOrderRspBO() != null) {
                extOrderSaleItemRspBOList = reqBo.getExtOrderInfoBO().getSaleOrderRspBO().getSku();
            }
            if (reqBo.getExtOrderInfoBO().getParentSaleOrderRspBO() != null) {
                extOrderSaleItemRspBOList = reqBo.getExtOrderInfoBO().getParentSaleOrderRspBO().getSku();
            }
            //定义商品ID和发货数量对应关系Map
            Map<String, BigDecimal> skuSendNumMap = new HashMap<>();

            Map<Long, UocSaleOrderItemQryBo> map = new HashMap<>();

            for (UocDeliveryItemsBO deliveryItemsBO : reqBo.getDeliveryInfoBO().getDeliveryItems()) {
                List<UocOrderItem> uocOrdGoodsQryBos = getOrdGoodsByExtSkuId(uocSaleOrderDo, deliveryItemsBO);

                for (UocOrderItem uocOrdGoodsQryBo : uocOrdGoodsQryBos) {
                    if (uocOrdGoodsQryBo.getSkuExtSkuId().equals(deliveryItemsBO.getSkuId())) {
                        skuSendNumMap.put(uocOrdGoodsQryBo.getSkuId(), new BigDecimal(deliveryItemsBO.getNum()));

                        List<UocSaleOrderItemQryBo> ordItemRspBOS = null;
                        try {
                            ordItemRspBOS = qryOrdItem(uocSaleOrderDo, uocOrdGoodsQryBo.getSkuId());
                        } catch (Exception e) {
                            rspBo.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
                            rspBo.setRespDesc("订单发货通知业务失败：未查询到销售订单明细信息!");
                            return rspBo;
                        }
                        if (extOrderSaleItemRspBOList != null) {
                            for (UocOrderSkuBO extOrderSaleItemRspBO : extOrderSaleItemRspBOList) {
                                for (UocSaleOrderItemQryBo saleOrderItemQryBo : ordItemRspBOS) {//商城的销售单明细信息
                                    if (extOrderSaleItemRspBO.getSkuId().equals(deliveryItemsBO.getSkuId())) {
//                            if (extOrderSaleItemRspBO.getNakedPrice() != null) {
//                                ordItemRspBO.setNakedPrice(extOrderSaleItemRspBO.getNakedPrice().longValue());
//                            }
                                        if (extOrderSaleItemRspBO.getTaxPrice() != null) {
                                            saleOrderItemQryBo.setTaxPrice(extOrderSaleItemRspBO.getTaxPrice().toString());
                                        }
                                        if (extOrderSaleItemRspBO.getTax() != null) {
                                            saleOrderItemQryBo.setTax(String.valueOf(extOrderSaleItemRspBO.getTax()));
                                        }

                                        Boolean isAllShip = true;
                                        //判断是否已全部发货,防止重复发货
                                        if (saleOrderItemQryBo.getPurchaseCount().compareTo(saleOrderItemQryBo.getSendCount()) > 0) {
                                            isAllShip = false;
                                            map.putIfAbsent(saleOrderItemQryBo.getSaleOrderItemId(), saleOrderItemQryBo);
                                        }
                                        log.info("是否已全部发货: {}", isAllShip);
                                        log.info("saleOrderItemQryBo采购数量: {}和发货数量: {}", saleOrderItemQryBo.getPurchaseCount(), saleOrderItemQryBo.getSendCount());
                                    }
                                }
                            }
                        }
                    }
                }

            }
            if (map.size() > 0) {
                for (Long id : map.keySet()) {
                    orderItemQryBoList.add(map.get(id));
                }
            }
            log.info("UocMsgCreateShipService中销售单明细map: {}", map);
            //只有当有发货的明细时才执行发货
            if (!orderItemQryBoList.isEmpty()) {
                //构建发货单入参
                Long shipOrderId = null;
                try {
                    UocShipOrderQryBo shipOrderQryBo = buildShipAndItemData(uocSaleOrderDo, orderItemQryBoList, reqBo.getDeliveryInfoBO(), skuSendNumMap);
                    shipOrderId = ceateCoreShip(shipOrderQryBo);
                    rspBo.setShipOrderNo(shipOrderQryBo.getShipOrderNo());
                } catch (Exception e) {
                    log.error("创建发货单异常：", e);
                    //处理完发货消息后更新msgPool中的执行状态为执行失败
//                    UocDMsgPoolQryBo qryBo = new UocDMsgPoolQryBo();
//                    qryBo.setMsgId(reqBo.getDycUocQryMsgBO().getMsgId());
//
//                    UocDMsgPoolQryBo  msgPoolQryBo = iUocOrderModel.getModelByMsgId(qryBo);
//                    msgPoolQryBo.setFailureCount(qryBo.getFailureCount() + 1);
//                    msgPoolQryBo.setRunResult(0);//执行失败
//                    msgPoolQryBo.setMsgId(reqBo.getDycUocQryMsgBO().getMsgId());
//                    iUocOrderModel.updateMsgPoolById(qryBo);
                    rspBo.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
                    rspBo.setRespDesc("订单发货通知业务失败：创建发货单失败!" + e.getMessage());
                    return rspBo;
                }
                rspBo.setShipOrderId(shipOrderId);
            } else {
                rspBo.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
                rspBo.setRespDesc("已经全部发货，无需发货");
                return rspBo;
            }
        } else {
            log.info("京东订单发货开始");
            //京东苏宁单
            if (ObjectUtil.isNotEmpty(shipOrderDoList)) {
                rspBo.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
                rspBo.setRespDesc("订单明细已全部发货完毕，已不能再进行发货操作");
                return rspBo;
            }
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setOrderId(uocSaleOrderDo.getOrderId());
            uocSaleOrderItemQryBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());

            List<UocSaleOrderItem> uocOrderItemQryBoList = new ArrayList<>();
            try {
                uocOrderItemQryBoList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            } catch (Exception e) {
                rspBo.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
                rspBo.setRespDesc("订单发货通知业务失败：未查询到销售订单明细信息!");
                return rspBo;
            }
            //判断是不是厂直订单:1是厂直；2:京配
            Integer jdCz = 2;
            if (ObjectUtil.isNotEmpty(reqBo.getOrderType()) && reqBo.getOrderType() == 5) {
                jdCz = 1;
            }
            uocSaleOrderDo.setJdCz(jdCz);
            orderItemQryBoList = UocRu.jsl(uocOrderItemQryBoList, UocSaleOrderItemQryBo.class);

            Long shipOrderId = null;

            UocDeliveryInfoBO deliveryInfoBO = new UocDeliveryInfoBO();
            deliveryInfoBO.setOrderId(String.valueOf(reqBo.getDycUocQryMsgBO().getOrderId()));
            deliveryInfoBO.setPackageId(reqBo.getDycUocQryMsgBO().getOutOrderId());
            UocShipOrderQryBo shipOrderQryBo = buildShipAndItemData(uocSaleOrderDo, orderItemQryBoList, deliveryInfoBO, new HashMap<>());
            shipOrderId = ceateCoreShip(shipOrderQryBo);
            rspBo.setShipOrderId(shipOrderId);
        }
        //处理完发货消息后更新msgPool中的执行状态为已执行
//        UocDMsgPoolQryBo qryBo = new UocDMsgPoolQryBo();
//        qryBo.setId(reqBo.getDycUocQryMsgBO().getId());
//        qryBo.setRunResult(1);//执行成功
//        iUocOrderModel.updateMsgPoolById(qryBo);

        UocOrderQueryIndex uocOrderQueryIndex = new UocOrderQueryIndex();
        uocOrderQueryIndex.setObjId(rspBo.getShipOrderId());
        uocOrderQueryIndex.setOrderSystem(UocDicConstant.OBJ_TYPE.SHIP.toString());
        uocOrderQueryIndex.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        if (!UocOrderPropertiesUtil.getProperty("SUPPLIER_JD_ID").equals(String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo()))
                && !UocOrderPropertiesUtil.getProperty("SUPPLIER_JDVOP_ID").equals(String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo()))) {
            uocOrderQueryIndex.setOutObjId(reqBo.getDycUocQryMsgBO().getPackageid());
        } else {
            uocOrderQueryIndex.setOutObjId(reqBo.getDycUocQryMsgBO().getOutOrderId());
        }
        uocOrderQueryIndex.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocOrderQueryIndex.setId(IdUtil.nextId());
        iUocCommonModel.saveOrderQueryIndex(uocOrderQueryIndex);

        rspBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());//返回销售单id
        rspBo.setOrderSource(uocSaleOrderDo.getOrderSource());//返回订单来源
        rspBo.setOrderId(uocSaleOrderDo.getOrderId());

        // 如果是第一次发货提交任务,并且非京东的，或者非京东的子销售单
        if (rspBo.getFirstDeliverFlag() && ObjectUtil.isEmpty(uocSaleOrderDo.getUpperOrderId())) {
            UocCommonDo uocCommonDo = new UocCommonDo();
            List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(rspBo.getTaskInstId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(11111L);
            uocCommonDo.setOrderId(reqBo.getOrderId());
            iUocCommonModel.dealTask(uocCommonDo);
        }

        boolean finish = checkSaleOrderIsFinish(reqBo.getOrderId(), uocSaleOrderDo.getSaleOrderId());
        rspBo.setFinish(finish);

        if (ObjectUtil.isEmpty(rspBo.getTaskInstId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SYSTEM_EXCEPTION, "电商订单消息处理|生成发货单错误|任务实例Id为空");
        }

        return rspBo;
    }

    public UocShipOrderQryBo buildShipAndItemData(UocSaleOrderDo uocSaleOrderDo, List<UocSaleOrderItemQryBo> orderItemQryBoList, UocDeliveryInfoBO qryPackageRsp, Map<String, BigDecimal> skuSendNumMap) {
        UocShipOrderQryBo uocCoreOrderShipReqBO = new UocShipOrderQryBo();

        uocCoreOrderShipReqBO.setShipOrderNo(genShipCode(uocSaleOrderDo));

        uocCoreOrderShipReqBO.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        uocCoreOrderShipReqBO.setOrderId(uocSaleOrderDo.getOrderId());

        uocCoreOrderShipReqBO.setShipOrderId(IdUtil.nextId());

        uocCoreOrderShipReqBO.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_FH);
        //已发货
//        uocCoreOrderShipReqBO.setShipStatus(UocConstant.SHIP_ORDER_STATUS.DELIVERED);
        //不包含附件
        uocCoreOrderShipReqBO.setIsEnclosure(0);
//        uocCoreOrderShipReqBO.setCreateOperId(createOperId);
        uocCoreOrderShipReqBO.setCreateTime(new Date());
        if (StringUtils.isBlank(qryPackageRsp.getPackageId())) {
            uocCoreOrderShipReqBO.setShipOrderNoExt(qryPackageRsp.getOrderId());//外部发货单id
        } else {
            uocCoreOrderShipReqBO.setShipOrderNoExt(qryPackageRsp.getPackageId());
        }
        uocCoreOrderShipReqBO.setShipCompanyName(qryPackageRsp.getDeliveryName());//物流公司名称
        uocCoreOrderShipReqBO.setShipCompanyId(qryPackageRsp.getDeliveryCode());//物流公司编码
        uocCoreOrderShipReqBO.setShipTime(DateUtils.strToDateLong(qryPackageRsp.getDeliverytime()));
        uocCoreOrderShipReqBO.setShipRemark("外部电商发货");
        List<UocShipOrderItemQryBo> shipItemList = new ArrayList<>();
        for (UocSaleOrderItemQryBo saleOrderItemQryBo : orderItemQryBoList) {
            Long saleOrderItemId = saleOrderItemQryBo.getSaleOrderItemId();
            UocShipOrderItemQryBo uocCoreShipItemReqBO = new UocShipOrderItemQryBo();
            uocCoreShipItemReqBO.setShipOrderId(uocCoreOrderShipReqBO.getShipOrderId());
            uocCoreShipItemReqBO.setSaleOrderId(saleOrderItemQryBo.getSaleOrderId());
            uocCoreShipItemReqBO.setShipOrderItemId(IdUtil.nextId());
            uocCoreShipItemReqBO.setSaleOrderItemId(saleOrderItemId);
            uocCoreShipItemReqBO.setOrderId(saleOrderItemQryBo.getOrderId());
            uocCoreShipItemReqBO.setUnitName(saleOrderItemQryBo.getUnitName());
            if (skuSendNumMap.get(saleOrderItemQryBo.getSkuId()) != null) {
                if (saleOrderItemQryBo.getPurchaseCount().compareTo(skuSendNumMap.get(saleOrderItemQryBo.getSkuId())) < 0) {
                    uocCoreShipItemReqBO.setSendCount(saleOrderItemQryBo.getPurchaseCount());
                    skuSendNumMap.put(saleOrderItemQryBo.getSkuId(), skuSendNumMap.get(saleOrderItemQryBo.getSkuId()).subtract(saleOrderItemQryBo.getPurchaseCount()));
                } else {
                    uocCoreShipItemReqBO.setSendCount(skuSendNumMap.get(saleOrderItemQryBo.getSkuId()));
                }
            } else {
                uocCoreShipItemReqBO.setSendCount(saleOrderItemQryBo.getPurchaseCount());
            }
            uocCoreShipItemReqBO.setArriveCount(BigDecimal.ZERO);
            uocCoreShipItemReqBO.setRefuseCount(BigDecimal.ZERO);
            uocCoreShipItemReqBO.setReturnCount(BigDecimal.ZERO);
            uocCoreShipItemReqBO.setInspCount(BigDecimal.ZERO);
            uocCoreShipItemReqBO.setCreateTime(new Date());
            uocCoreShipItemReqBO.setRemark("外部电商发货");
            uocCoreShipItemReqBO.setShipItemState(UocStateConstants.ShipOrder.FH_FH_FH);

            shipItemList.add(uocCoreShipItemReqBO);
        }
        uocCoreOrderShipReqBO.setShipOrderItemBoList(shipItemList);
        uocCoreOrderShipReqBO.setJdCz(uocSaleOrderDo.getJdCz());
        return uocCoreOrderShipReqBO;
    }

    /*
     * @Author lsl
     * @Description //TODO 查询销售订单信息
     * @Date 16:36 2022/4/12
     * @Param [reqBo]
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    public UocSaleOrderDo qrySale(UocMsgCreateShipReqBo reqBo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBo.getDycUocQryMsgBO().getObjId());
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private boolean checkSaleOrderIsFinish(Long orderId, Long saleOrderId) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(orderId);
        uocSaleOrderItemQryBo.setSaleOrderId(saleOrderId);
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.getCollectCountImplOrderItem(uocSaleOrderItemQryBo);
        if (org.springframework.util.CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR, "查询数量汇总为空");
        }
        UocSaleOrderItem uocSaleOrderItem = uocSaleOrderDo.getSaleOrderItems().get(0);
        if (null == uocSaleOrderItem) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR, "查询数量汇总为空");
        }
        //采购数量 = 发货数量 + 退货数量 则发货完成
        if (uocSaleOrderItem.getPurchaseCount().compareTo(uocSaleOrderItem.getSendCount().add(uocSaleOrderItem.getReturnCount())) == 0) {
            return true;
        }
        return false;
    }

    /**
     * 根据外部SKUID查询内部SKUID信息
     *
     * @param
     * @param deliveryItemsBO 外部商品信息
     * @return OrdGoodsPO
     */
    private List<UocOrderItem> getOrdGoodsByExtSkuId(UocSaleOrderDo uocSaleOrderDo, UocDeliveryItemsBO deliveryItemsBO) {
        try {
            UocOrderItemQryBo uocOrderItemQryBo = new UocOrderItemQryBo();
            uocOrderItemQryBo.setOrderId(uocSaleOrderDo.getOrderId());

            List<UocOrderItem> uocOrdGoodsQryBos = iUocOrderModel.qryOrderItemList(uocOrderItemQryBo);
            if (uocOrdGoodsQryBos == null) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "订单发货通知业务失败：没有查询到内部商品信息");
            }
            return uocOrdGoodsQryBos;
        } catch (Exception e) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "订单发货通知业务失败：没有查询到内部商品信息");
        }
    }

    /*
     * @Author lsl
     * @Description //TODO 查询销售订单明细信息
     * @Date 17:43 2022/4/12
     * @Param [ordSalePO, skuId]
     * @return java.util.List<OrdItemPO>
     */
    private List<UocSaleOrderItemQryBo> qryOrdItem(UocSaleOrderDo uocSaleOrderDo, String skuId) {
        try {
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setSkuId(skuId);
            uocSaleOrderItemQryBo.setOrderId(uocSaleOrderDo.getOrderId());
            uocSaleOrderItemQryBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            List<UocSaleOrderItem> uocOrderItemQryBoList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            if (CollectionUtils.isEmpty(uocOrderItemQryBoList)) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "订单发货通知业务失败：未查询到销售订单明细信息");
            }
            List<UocSaleOrderItemQryBo> rspBO = new ArrayList<>();
            rspBO = uocOrderItemQryBoList.stream().map(e -> {
                UocSaleOrderItemQryBo uocOrderItemQryBo1 = JSONObject.parseObject(JSON.toJSONString(e), UocSaleOrderItemQryBo.class);
                return uocOrderItemQryBo1;
            }).collect(Collectors.toList());

            return rspBO;
        } catch (Exception e) {
            log.error("订单发货通知业务失败：查询销售订单明细时数据库异常!", e);
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "订单发货通知业务失败：查询销售订单明细时数据库异常!");
        }
    }

    /*
     * @Author lsl
     * @Description //TODO 创建发货单
     * @Date 19:39 2022/4/12
     * @Param [uocShipOrderQryBo]
     * @return java.lang.Long
     */
    public Long ceateCoreShip(UocShipOrderQryBo uocShipOrderQryBo) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
//        BeanUtils.copyProperties(uocShipOrderQryBo,uocShipOrderDo);
        uocShipOrderDo = JSONObject.parseObject(JSON.toJSONString(uocShipOrderQryBo), UocShipOrderDo.class);
//        uocShipOrderDo.setShipOrderId(IdUtil.nextId());//发货单ID
        judeCount(uocShipOrderQryBo.getShipOrderItemBoList());

        //调用计算发货单信息
        this.computeShipOrderInfo(uocShipOrderDo);

        //创建发货单和发货单明细
        iUocShipOrderModel.createShipOrder(uocShipOrderDo);

        //调用修改销售单计算信息
        this.updateSaleComputeInfo(uocShipOrderDo);

        List<UocSaleOrderItem> saleOrderItems = new ArrayList<>();
        UocSaleOrderDo convertSaleOrderDo = new UocSaleOrderDo();
        convertSaleOrderDo.setJdCz(uocShipOrderQryBo.getJdCz());
        convertSaleOrderDo.setSaleOrderId(uocShipOrderQryBo.getSaleOrderId());
        convertSaleOrderDo.setOrderId(uocShipOrderQryBo.getOrderId());
        //修改销售订单发货明细数量
        for (UocShipOrderItemQryBo item : uocShipOrderQryBo.getShipOrderItemBoList()) {
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setSaleOrderItemId(item.getSaleOrderItemId());
            uocSaleOrderItem.setSendCount(item.getSendCount());
            saleOrderItems.add(uocSaleOrderItem);

        }
        convertSaleOrderDo.setSaleOrderItems(saleOrderItems);

        iUocSaleOrderModel.modifyBatchItemSendCount(convertSaleOrderDo);
        convertSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_FH_FHZ);
        //更新销售单状态为发货中
        iUocSaleOrderModel.modifySaleOrderMain(convertSaleOrderDo);

        return uocShipOrderDo.getShipOrderId();
    }

    /**
     * 计算发货单信息
     */
    private void computeShipOrderInfo(UocShipOrderDo uocShipOrderDo) {
        //定义查询销售单主体参数
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        //设置订单ID
        uocSaleOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
        //设置销售单ID
        uocSaleOrderQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        //调用查询销售单主体
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);

        //定义查询销售单明细参数
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        //设置订单ID
        uocSaleOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        //设置销售单ID
        uocSaleOrderItemQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        //调用查询销售单明细
        List<UocSaleOrderItem> uocSaleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);

        //定义发货单列表查询参数
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        //设置订单ID
        uocShipOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
        //设置销售单ID
        uocShipOrderQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        //调用发货单列表查询
        List<UocShipOrderDo> uocShipOrderDoList = iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);

        //调用计算发货单运费
        this.computeShipOrderTransFee(uocShipOrderDo, uocSaleOrderDo, uocSaleOrderItemList, uocShipOrderDoList);

        //调用计算发货单金额
        this.computeShipOrderFee(uocShipOrderDo, uocSaleOrderItemList, uocShipOrderDoList);
    }

    /**
     * 计算发货单运费
     */
    private void computeShipOrderTransFee(UocShipOrderDo uocShipOrderDo, UocSaleOrderDo uocSaleOrderDo, List<UocSaleOrderItem> uocSaleOrderItemList, List<UocShipOrderDo> uocShipOrderDoList) {
        //获取销售单明细 所有采购数量
        BigDecimal allPurchaseCount = uocSaleOrderItemList.stream().map(UocSaleOrderItem::getPurchaseCount).reduce(BigDecimal.ZERO, BigDecimal::add);

        //获取发货单明细 所有发货数量
        BigDecimal allSendCount = uocShipOrderDo.getShipOrderItemBoList().stream().map(UocShipOrderItem::getSendCount).reduce(BigDecimal.ZERO, BigDecimal::add);


        //判断是否没有运费
        if (uocSaleOrderDo.getTotalTransFee().compareTo(BigDecimal.ZERO) == 0) {
            //设置发货单运费
            uocShipOrderDo.setSendTransFee(BigDecimal.ZERO);

            return;
        }

        //判断是否只有一次发货
        if (CollectionUtils.isEmpty(uocShipOrderDoList) && allPurchaseCount.compareTo(allSendCount) == 0) {
            //设置发货单运费
            uocShipOrderDo.setSendTransFee(uocSaleOrderDo.getTotalTransFee());

            return;
        }

        //校验是否是最后一个发货单
        boolean isLast = this.checkShipOrderIsLast(uocShipOrderDo.getOrderId(), uocShipOrderDo.getSaleOrderId(), allSendCount);

        //判断是否是最后一个发货单
        if (isLast) {
            //计算发货单运费 = 销售单运费 - 销售单占用运费
            BigDecimal shipSendTransFee = uocSaleOrderDo.getTotalTransFee().subtract(ObjectUtil.isNotEmpty(uocSaleOrderDo.getTotalOccupyTransFee()) ? uocSaleOrderDo.getTotalOccupyTransFee() : BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);

            //设置发货单运费
            uocShipOrderDo.setSendTransFee(shipSendTransFee);

            return ;
        }

        //获取销售单明细ID Vs 销售单明细 Map
        Map<Long, UocSaleOrderItem> itemIdVsSaleOrderItemMap = uocSaleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, po -> po, (k1, k2) -> k2));

        //获取销售单明细 所有商品总重量
        BigDecimal allTotalGoodsWeight = uocSaleOrderItemList.stream().map(UocSaleOrderItem::getTotalGoodsWeight).reduce(BigDecimal.ZERO, BigDecimal::add);

        //获取销售单商品 运费单价 = 总运费 / 所有商品总重量
        BigDecimal freightUnitPrice = uocSaleOrderDo.getTotalTransFee().divide(allTotalGoodsWeight, 2, RoundingMode.HALF_UP);

        //获取发货单明细 所有商品总重量
        BigDecimal allShipTotalGoodsWeight = new BigDecimal("0");
        //遍历发货单明细
        for (UocShipOrderItem uocShipOrderItem : uocShipOrderDo.getShipOrderItemBoList()) {
            //获取当前发货单明细对应的销售单明细
            UocSaleOrderItem uocSaleOrderItem = itemIdVsSaleOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());

            //计算当前发货单明细 商品总重量 = 商品重量 * 发货数量
            BigDecimal shipTotalGoodsWeight = uocSaleOrderItem.getGoodsWeight().multiply(uocShipOrderItem.getSendCount());

            //计算发货单明细 所有商品总重量
            allShipTotalGoodsWeight = allShipTotalGoodsWeight.add(shipTotalGoodsWeight);
        }

        //计算发货单运费 = 运费单价 * 发货单明细 所有商品总重量
        BigDecimal shipSendTransFee = freightUnitPrice.multiply(allShipTotalGoodsWeight).setScale(2, RoundingMode.HALF_UP);

        //设置发货单运费
        uocShipOrderDo.setSendTransFee(shipSendTransFee);
    }

    /**
     * 计算发货单金额
     */
    private void computeShipOrderFee(UocShipOrderDo uocShipOrderDo, List<UocSaleOrderItem> uocSaleOrderItemList, List<UocShipOrderDo> uocShipOrderDoList) {
        //获取销售单明细 所有采购数量
        BigDecimal allPurchaseCount = uocSaleOrderItemList.stream().map(UocSaleOrderItem::getPurchaseCount).reduce(BigDecimal.ZERO, BigDecimal::add);

        //获取发货单明细 所有发货数量
        BigDecimal allSendCount = uocShipOrderDo.getShipOrderItemBoList().stream().map(UocShipOrderItem::getSendCount).reduce(BigDecimal.ZERO, BigDecimal::add);

        //获取销售单明细ID Vs 销售单明细 Map
        Map<Long, UocSaleOrderItem> itemIdVsSaleOrderItemMap = uocSaleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, po -> po, (k1, k2) -> k2));

        //获取发货单明细集合
        List<UocShipOrderItem> uocShipOrderItemList = uocShipOrderDo.getShipOrderItemBoList();

        //校验是否是最后一个发货单
        boolean isLast = this.checkShipOrderIsLast(uocShipOrderDo.getOrderId(), uocShipOrderDo.getSaleOrderId(), allSendCount);

        //遍历发货单明细集合
        for (UocShipOrderItem uocShipOrderItem : uocShipOrderItemList) {
            //获取当前发货单明细对应的销售单明细
            UocSaleOrderItem uocSaleOrderItem = itemIdVsSaleOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());

            //判断是否只有一次发货
            if (org.springframework.util.CollectionUtils.isEmpty(uocShipOrderDoList) && allPurchaseCount.compareTo(allSendCount) == 0) {
                //设置发货明细销售金额
                uocShipOrderItem.setSendSaleFee(uocSaleOrderItem.getSaleFee());
                //设置发货明细采购金额
                uocShipOrderItem.setSendPurchaseFee(uocSaleOrderItem.getPurchaseFee());

                continue;
            }

            //判断是否是最后一个发货单
            if (isLast) {
                //计算发货明细销售金额 = 销售总金额 - 已发货明细销售金额
                BigDecimal sendSaleFee = uocSaleOrderItem.getSaleFee().subtract(ObjectUtil.isNotEmpty(uocSaleOrderItem.getTotalSendGoodsSaleFee()) ? uocSaleOrderItem.getTotalSendGoodsSaleFee() : BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);
                //计算发货明细采购金额 = 采购总金额 - 已发货明细采购金额
                BigDecimal sendPurchaseFee = uocSaleOrderItem.getPurchaseFee().subtract(ObjectUtil.isNotEmpty(uocSaleOrderItem.getTotalSendGoodsPurchaseFee()) ? uocSaleOrderItem.getTotalSendGoodsPurchaseFee() : BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP);

                //设置发货明细销售金额
                uocShipOrderItem.setSendSaleFee(sendSaleFee);
                //设置发货明细采购金额
                uocShipOrderItem.setSendPurchaseFee(sendPurchaseFee);

                continue;
            }

            //计算发货明细销售金额 = 销售单价金额 * 发货数量
            BigDecimal sendSaleFee = uocSaleOrderItem.getSalePrice().multiply(uocShipOrderItem.getSendCount()).setScale(2, RoundingMode.HALF_UP);
            //计算发货明细采购金额 = 采购单价金额 * 发货数量
            BigDecimal sendPurchaseFee = uocSaleOrderItem.getPurchasePrice().multiply(uocShipOrderItem.getSendCount()).setScale(2, RoundingMode.HALF_UP);

            //设置发货明细销售金额
            uocShipOrderItem.setSendSaleFee(sendSaleFee);
            //设置发货明细采购金额
            uocShipOrderItem.setSendPurchaseFee(sendPurchaseFee);
        }

        //设置发货单明细
        uocShipOrderDo.setShipOrderItemBoList(uocShipOrderItemList);
    }

    /**
     * 修改销售单计算信息
     */
    private void updateSaleComputeInfo(UocShipOrderDo uocShipOrderDo) {
        //修改销售单已占用运费
        this.updateSaleOccupyTransFee(uocShipOrderDo);

        //修改销售单明细发货商品金额
        this.updateSaleItemSendGoodsFee(uocShipOrderDo);
    }

    /**
     * 修改销售单已占用运费
     */
    private void updateSaleOccupyTransFee(UocShipOrderDo uocShipOrderDo) {
        //定义修改销售单已占用运费参数
        UocSaleOrderDo updateOccupyTransFee = new UocSaleOrderDo();
        //设置销售单ID
        updateOccupyTransFee.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        //设置订单ID
        updateOccupyTransFee.setOrderId(uocShipOrderDo.getOrderId());
        //设置已占用运费
        updateOccupyTransFee.setTotalOccupyTransFee(uocShipOrderDo.getSendTransFee());
        //调用修改销售单占用运费
        this.iUocSaleOrderModel.modifyOccupyTransFee(updateOccupyTransFee);
    }

    /**
     * 修改销售单明细发货商品金额
     */
    private void updateSaleItemSendGoodsFee(UocShipOrderDo uocShipOrderDo) {
        //获取销售单明细ID Vs 发货单明细 Map
        Map<Long, List<UocShipOrderItem>> itemIdVsShipOrderItemMap = uocShipOrderDo.getShipOrderItemBoList().stream().collect(Collectors.groupingBy(UocShipOrderItem::getSaleOrderItemId));

        //定义销售单明细集合
        List<UocSaleOrderItem> uocSaleOrderItemList = new ArrayList<>(1);

        //遍历销售单明细ID Vs 发货单明细 Map
        for (Map.Entry<Long, List<UocShipOrderItem>> entry : itemIdVsShipOrderItemMap.entrySet()) {
            //定义销售单明细对象
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();

            //获取当前发货单明细 所有发货明细销售金额
            BigDecimal allSendSaleFee = entry.getValue().stream().map(UocShipOrderItem::getSendSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            //获取当前发货单明细 所有发货明细采购金额
            BigDecimal allSendPurchaseFee = entry.getValue().stream().map(UocShipOrderItem::getSendPurchaseFee).reduce(BigDecimal.ZERO, BigDecimal::add);

            //设置销售单明细ID
            uocSaleOrderItem.setSaleOrderItemId(entry.getKey());
            //设置已发货明细销售金额
            uocSaleOrderItem.setTotalSendGoodsSaleFee(allSendSaleFee);
            //设置已发货明细采购金额
            uocSaleOrderItem.setTotalSendGoodsPurchaseFee(allSendPurchaseFee);

            //添加到销售单明细集合
            uocSaleOrderItemList.add(uocSaleOrderItem);
        }

        //定义修改销售单明细发货商品金额参数
        UocSaleOrderDo updateItemSendGoodsFee = new UocSaleOrderDo();
        //设置销售单ID
        updateItemSendGoodsFee.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        //设置订单ID
        updateItemSendGoodsFee.setOrderId(uocShipOrderDo.getOrderId());
        //设置销售单明细集合
        updateItemSendGoodsFee.setSaleOrderItems(uocSaleOrderItemList);
        //调用修改销售单明细已发货明细金额
        this.iUocSaleOrderModel.modifyItemTotalSendGoodsFee(updateItemSendGoodsFee);
    }

    /**
     * 校验是否是最后一个发货单
     * @param orderId 订单ID
     * @param saleOrderId 销售单ID
     * @param allSendCount 所有发货数量
     * @return 是否最后一次发货
     */
    private boolean checkShipOrderIsLast(Long orderId, Long saleOrderId, BigDecimal allSendCount) {
        //定义查询明细各种数量汇总参数
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        //设置销售单ID
        uocSaleOrderItemQryBo.setSaleOrderId(saleOrderId);
        //设置订单ID
        uocSaleOrderItemQryBo.setOrderId(orderId);
        //调用查询明细各种数量汇总
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.getCollectCountImplOrderItem(uocSaleOrderItemQryBo);

        if (CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException(BaseRspConstant.RSP_CODE_FAIL, "查询数量汇总为空");
        }

        //获取当前销售单明细数量汇总
        UocSaleOrderItem uocSaleOrderItem = uocSaleOrderDo.getSaleOrderItems().get(0);

        return uocSaleOrderItem.getPurchaseCount().compareTo(uocSaleOrderItem.getSendCount().add(allSendCount)) == 0;
    }

    /*
     * @Author lsl
     * @Description //TODO 当发货数量为空时，设置默认值0
     * @Date 19:20 2022/4/12
     * @Param [shipItemList]
     * @return void
     */
    public void judeCount(List<UocShipOrderItemQryBo> shipItemList) {
        for (UocShipOrderItemQryBo item : shipItemList) {
            if (null == item.getSendCount()) {
                item.setSendCount(new BigDecimal(0));
            }
            if (null == item.getArriveCount()) {
                item.setArriveCount(new BigDecimal(0));
            }
            if (null == item.getRefuseCount()) {
                item.setRefuseCount(new BigDecimal(0));
            }
            if (null == item.getReturnCount()) {
                item.setReturnCount(new BigDecimal(0));
            }
            if (null == item.getInspCount()) {
                item.setInspCount(new BigDecimal(0));
            }
        }
    }

    /*
     * @Author lsl
     * @Description //TODO 生成发货单编码
     * @Date 10:52 2022/4/20
     * @Param [uocSaleOrderDo]
     * @return java.lang.String
     */
    public String genShipCode(UocSaleOrderDo uocSaleOrderDo) {
        UocShipOrderDo shipOrderDo = new UocShipOrderDo();
        shipOrderDo.setOrderSource(uocSaleOrderDo.getOrderSource());
        shipOrderDo = iUocShipOrderModel.getShipOrderNo(shipOrderDo);
        return shipOrderDo.getShipOrderNo();
    }
}
