package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocArriveInfoBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgCreateVoterReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgCreateVoterRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * @Author lsl
 * @Description //TODO 电商订单消息处理，用于处理妥投、拒收状态修改接口实现
 * @Date 16:30 2022/4/12
 * @Param
 * @return
 */
@Component
@Slf4j
public class UocMsgCreateVoterTransaction {
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocMsgCreateVoterRspBo createVoter(UocMsgCreateVoterReqBo reqBo) {
        log.info("妥投拒收状态修改接口参数为：{}",reqBo.toString());
        UocMsgCreateVoterRspBo rspBo = new UocMsgCreateVoterRspBo();
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        createCoreVoter(reqBo,rspBo);
        log.info("妥投拒收状态修改接口返回参数为：{}",rspBo.toString());
        if(!StringUtils.isBlank(rspBo.getTaskInstId())){
            // 提交任务
            UocCommonDo uocCommonDo = new UocCommonDo();
            List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(rspBo.getTaskInstId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(11111l);
            uocCommonDo.setOrderId(reqBo.getOrderId());
            iUocCommonModel.dealTask(uocCommonDo);
        }
        return rspBo;
    }
    /*
     * @Author lsl
     * @Description //TODO
     * @Date 11:02 2022/4/15
     * @Param [reqBo]
     * @return com.tydic.dyc.oc.service.domainservice.bo.DycUocMsgCreateVoterRspBo
     */
    public void createCoreVoter(UocMsgCreateVoterReqBo reqBo, UocMsgCreateVoterRspBo rspBo){
        try {
            delieveredCoreReject(reqBo,rspBo);
        } catch (Exception e) {
            rspBo.setRespCode(UocRspConstants.RSP_CODE_FAIL);
            rspBo.setRespDesc(e.getMessage());
        }
        
    }
    /*
     * @Author lsl
     * @Description //TODO 子超市订单妥投拒收业务服务核心方法
     * @Date 11:10 2022/4/15
     * @Param [reqBo]
     * @return com.tydic.dyc.oc.service.domainservice.bo.DycUocMsgCreateVoterRspBo
     */
    public void delieveredCoreReject(UocMsgCreateVoterReqBo reqBo,UocMsgCreateVoterRspBo rspBO){
        //入参校验
        validateArg(reqBo);
        //通过外部发货单ID查询内部订单和发货单的ID信息
        UocOrderQueryIndexQryBo uocOrderQueryIndexQryBo = new UocOrderQueryIndexQryBo();
        

        uocOrderQueryIndexQryBo.setOutObjId(reqBo.getDycUocQryMsgBO().getOutOrderId());
        uocOrderQueryIndexQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        List<UocOrderQueryIndex>  uocOrderQueryIndexList = iUocOrderModel.qryOrderQueryIndexList(uocOrderQueryIndexQryBo);
        
        if(ObjectUtil.isEmpty(uocOrderQueryIndexList)){
            rspBO.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
            rspBO.setRespDesc("未查询到外部订单[" + reqBo.getDycUocQryMsgBO().getOutOrderId() + "对应的关联信息");
            return;
        }

        //查询当前进行妥投或拒收业务的发货单
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(uocOrderQueryIndexList.get(0).getOrderId());
        uocShipOrderQryBo.setShipOrderId(uocOrderQueryIndexList.get(0).getObjId());
        List<UocShipOrderDo> shipOrderDoList =  iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        if(ObjectUtil.isEmpty(shipOrderDoList)){
            rspBO.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
            rspBO.setRespDesc("电子超市订单妥投拒收业务服务失败，未查询到发货单信息!");
            return;
        }
        UocShipOrderDo uocShipOrderDo = shipOrderDoList.get(0);

        // 电商发货单如果不为已发货，不能消费妥投消息，防止重复消费
        if (!UocStateConstants.ShipOrder.FH_FH_FH.equals(uocShipOrderDo.getShipOrderState())) {
            rspBO.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
            rspBO.setRespDesc("发货单不为已发货，不能消费妥投消息!");
            return;
        }
        //查询销售订单并验证其状态是否是已发货(不验证状态)
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocSaleOrderDo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        uocSaleOrderDo = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if(uocSaleOrderDo == null ){
            rspBO.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
            rspBO.setRespDesc("未查询到外部订单[" + reqBo.getDycUocQryMsgBO().getOutOrderId() + "对应的销售订单信息");
            return;
        }
    
        Long saleVoucherId = uocSaleOrderDo.getSaleOrderId();//销售单id
        Long orderId = uocSaleOrderDo.getOrderId();//订单ID
        Long shipVoucherId = uocShipOrderDo.getShipOrderId();//发货单id
    
        //更新到货数量
        try {
            executeArriveRegist(reqBo,uocShipOrderDo,rspBO);
        } catch (Exception e) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, e.getMessage());
        }
        
        //判断是否全部到货
        boolean isAllReceive = judgeIsAllReceive(orderId,saleVoucherId);
        //判断是否全部拒收
        BigDecimal totalRefuseAmout = new BigDecimal(0);//拒收金额
        
        boolean isAllRefuse = judgeIsAllRefuse(orderId,totalRefuseAmout,saleVoucherId);
        
        UocOrderStakeholderQryBo stakeholderQryBo = new UocOrderStakeholderQryBo();
        stakeholderQryBo.setStakeholderId(uocSaleOrderDo.getStakeholderId());
        List<UocOrderStakeholderQryBo> stakeholderQryBoList = iUocOrderModel.qryStakeholderList(stakeholderQryBo);
        String purOrgId = stakeholderQryBoList.get(0).getPurOrgId();
        
        try{
            UocSaleOrderDo saleOrderDo = new UocSaleOrderDo();
            saleOrderDo.setSaleOrderId(saleVoucherId);
            saleOrderDo.setOrderId(orderId);
            saleOrderDo.setUpdateTime(new Date());
            UocShipOrderDo shipOrderDo = new UocShipOrderDo();
            shipOrderDo.setShipOrderId(shipVoucherId);
            shipOrderDo.setOrderId(orderId);
            shipOrderDo.setReceiverTime(new Date());
            if(isAllReceive && reqBo.getDycUocQryMsgBO().getMsgState().equals(1)){//妥投并且全部到货
                saleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_DH_DH);
                shipOrderDo.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_YSH);//发货单已到货
                iUocShipOrderModel.modifyShipOrderMain(shipOrderDo);
                iUocSaleOrderModel.modifySaleOrderMain(saleOrderDo);
            }else if(reqBo.getDycUocQryMsgBO().getMsgState().equals(1) && !isAllReceive){//妥投并且没有全部到货（发货+ 拒收 ！=采购）
                shipOrderDo.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_YSH);//发货单已到货
                iUocShipOrderModel.modifyShipOrderMain(shipOrderDo);
            } else if(reqBo.getDycUocQryMsgBO().getMsgState().equals(2) && isAllRefuse){//拒收
                saleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_DH_JS);
                shipOrderDo.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_JS);
                iUocShipOrderModel.modifyShipOrderMain(shipOrderDo);
                iUocSaleOrderModel.modifySaleOrderMain(saleOrderDo);
            }else if (reqBo.getDycUocQryMsgBO().getMsgState().equals(2) && !isAllRefuse) {
                shipOrderDo.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_JS);
                iUocShipOrderModel.modifyShipOrderMain(shipOrderDo);
            }
            //到货数量 + 拒收数量 = 采购数量
            if(isAllReceive){
                UocSaleOrderItemQryBo saleOrderItemQryBo = new UocSaleOrderItemQryBo();
                saleOrderItemQryBo.setOrderId(orderId);
                saleOrderItemQryBo.setSaleOrderId(saleVoucherId);
                List<UocSaleOrderItem> saleOrderItems = iUocSaleOrderModel.getSaleOrderItemList(saleOrderItemQryBo);
                BigDecimal totalPurchaseCount = new BigDecimal(0);
                BigDecimal totalArriveCount = new BigDecimal(0);
                BigDecimal totalRefuseCount = new BigDecimal(0);
                for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
                    totalPurchaseCount = totalPurchaseCount.add(saleOrderItem.getPurchaseCount());
                    totalArriveCount = totalArriveCount.add(saleOrderItem.getArriveCount());
                    totalRefuseCount = totalRefuseCount.add(saleOrderItem.getRefuseCount());
                }
                // 部分到货且部分拒收 订单才是部分到货XS_DH_BFDH
                if(!(totalRefuseCount.compareTo(BigDecimal.ZERO)==0) && !(totalArriveCount.compareTo(BigDecimal.ZERO)==0)){
                    saleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_DH_BFDH);
                }
                iUocSaleOrderModel.modifySaleOrderMain(saleOrderDo);
            }
            
        }catch (Exception e){
            log.error("更新销售单状态异常: {}",e);
            rspBO.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
            rspBO.setRespDesc("更新销售单状态异常!");
            return;
        }
        rspBO.setSaleOrderId(saleVoucherId);
        rspBO.setShipOrderId(uocShipOrderDo.getShipOrderId());
        rspBO.setOrderId(orderId);
        rspBO.setTotalRefuseAmout(totalRefuseAmout);
        rspBO.setPurOrgId(purOrgId);
        
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        taskInstQryBo.setObjId(uocShipOrderDo.getShipOrderId());
        taskInstQryBo.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        //查询订单任务实例
        List<UocOrderTaskInst> taskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if(ObjectUtil.isNotEmpty(taskInsts)){
            rspBO.setTaskInstId(taskInsts.get(0).getTaskInstId());
            rspBO.setStepId(taskInsts.get(0).getProcState());
        }
        
        
        //处理完妥投消息后更新msgPool中的执行状态为已执行
//        UocDMsgPoolQryBo qryBo = new UocDMsgPoolQryBo();
//        qryBo.setId(reqBo.getDycUocQryMsgBO().getId());
//        qryBo.setRunResult(1);//执行成功
//        iUocOrderModel.updateMsgPoolById(qryBo);
    }
    /*
     * @Author lsl
     * @Description //TODO 判断是否全部到货
     * @Date 15:49 2022/4/15
     * @Param [reqBo, queryIndexQryBo, uocShipOrderDo]
     * @return void
     */
    public boolean judgeIsAllReceive(Long orderId,Long saleVoucherId){
        boolean isAllReceive = true;
        UocSaleOrderItemQryBo saleOrderItemQryBo = new UocSaleOrderItemQryBo();
        saleOrderItemQryBo.setOrderId(orderId);
        saleOrderItemQryBo.setSaleOrderId(saleVoucherId);
        List<UocSaleOrderItem> saleOrderItems = iUocSaleOrderModel.getSaleOrderItemList(saleOrderItemQryBo);
        
        if (saleOrderItems == null || saleOrderItems.isEmpty()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "电子超市订单妥投拒收业务服务失败:" +
                    "为查询到销售订单明细信息!");
        }
        //判断是否是全部到货逻辑
        BigDecimal totalPurchaseCount = new BigDecimal(0);
        BigDecimal totalArriveCount = new BigDecimal(0);
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            totalPurchaseCount = totalPurchaseCount.add(saleOrderItem.getPurchaseCount());
            //每个订单明细的到货数量
            BigDecimal arriveCount = saleOrderItem.getArriveCount().add(saleOrderItem.getRefuseCount());
            totalArriveCount = totalArriveCount.add(arriveCount);
        }
        if (totalArriveCount.compareTo(totalPurchaseCount)!=0) {
            isAllReceive = false;
        }
        
        log.info("------------------------是否是全部到货状态值：" + isAllReceive);
        return isAllReceive;
        
        
    }
    
    
    /*
     * @Author lsl
     * @Description //TODO 判断是否全部拒收
     * @Date 15:49 2022/4/15
     * @Param [reqBo, queryIndexQryBo, uocShipOrderDo]
     * @return void
     */
    public boolean judgeIsAllRefuse(Long orderId,BigDecimal totalRefuseAmout,Long saleVoucherId){
        boolean isAllRefuse = true;
        UocSaleOrderItemQryBo saleOrderItemQryBo = new UocSaleOrderItemQryBo();
        saleOrderItemQryBo.setOrderId(orderId);
        saleOrderItemQryBo.setSaleOrderId(saleVoucherId);
        List<UocSaleOrderItem> saleOrderItems = iUocSaleOrderModel.getSaleOrderItemList(saleOrderItemQryBo);
        
        if (saleOrderItems == null || saleOrderItems.isEmpty()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "电子超市订单妥投拒收业务服务失败:" +
                    "为查询到销售订单明细信息!");
        }
        //判断是否是全部拒收逻辑
        BigDecimal totalPurchaseCount = new BigDecimal(0);
        BigDecimal totalRefuseCount = new BigDecimal(0);
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {

//            log.info(saleOrderItem.getSaleOrderItemId()+"采购数量："+saleOrderItem.getPurchaseCount()+"拒收数量："+saleOrderItem.getRefuseCount());
            
            totalPurchaseCount = totalPurchaseCount.add(saleOrderItem.getPurchaseCount());
            //每个订单明细的拒收数量
            totalRefuseCount = totalRefuseCount.add(saleOrderItem.getRefuseCount());
            totalRefuseAmout = totalRefuseAmout.add(saleOrderItem.getRefuseCount().multiply(saleOrderItem.getSalePrice().setScale(2)));
        }
//        if (!totalRefuseCount.equals(totalPurchaseCount)) {
//            isAllRefuse = false;
//        }
        
        if (totalRefuseCount.compareTo(totalPurchaseCount)!=0) {
            isAllRefuse = false;
        }


//        log.info("------------------------是否是全部拒收状态值：" + isAllRefuse);
        return isAllRefuse;
    }
    /*
     * @Author lsl
     * @Description //TODO 执行到货登记
     * @Date 11:31 2022/4/15
     * @Param
     * @return
     */
    public void executeArriveRegist(UocMsgCreateVoterReqBo reqBo, UocShipOrderDo uocShipOrderDo,UocMsgCreateVoterRspBo rspBo){
        //查询发货明细，封装到货拒收情况BOList
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        List<UocArriveInfoBO> arriveInfoBOList = new ArrayList<>();
        uocShipOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        UocShipOrderDo uocShipOrderDo1 = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        
        List<UocShipOrderItem> shipOrderItemBoList = uocShipOrderDo1.getShipOrderItemBoList();
        boolean notArrive = false;
        for(UocShipOrderItem shipOrderItem: shipOrderItemBoList){
            UocArriveInfoBO arriveInfoBO = new UocArriveInfoBO();//到货信息BO
            
            if(reqBo.getDycUocQryMsgBO().getMsgState().equals(2)){
                //如果是拒收
                arriveInfoBO.setRejectCount(shipOrderItem.getSendCount());
                arriveInfoBO.setShipItemId(shipOrderItem.getShipOrderItemId());
                
            }else if(reqBo.getDycUocQryMsgBO().getMsgState().equals(1)){
                //如果是妥投
                arriveInfoBO.setArriveCount(shipOrderItem.getSendCount());
                arriveInfoBO.setShipItemId(shipOrderItem.getShipOrderItemId());
                if (shipOrderItem.getArriveCount() != null) {
                    if (shipOrderItem.getSendCount().compareTo(shipOrderItem.getArriveCount()) <= 0) {
                        notArrive = true;
                    }
                }
                
            }
            arriveInfoBOList.add(arriveInfoBO);
        }
        
        if (!notArrive) {
            //更新拒收数量和发货数量到货数量
            arriveRegist(uocShipOrderDo,arriveInfoBOList,rspBo);
            //更新发货单的到货时间
            updateShipArriveTime(uocShipOrderDo.getOrderId(),uocShipOrderDo.getShipOrderId());
            
        }
        
        
    }
    /*
     * @Author lsl
     * @Description //TODO 更新拒收数量和发货数量到货数量
     * @Date 14:25 2022/4/15
     * @Param [orderId, shipOrderId]
     * @return void
     */
    public void arriveRegist(UocShipOrderDo uocShipOrderDo,List<UocArriveInfoBO> arriveInfoBOList,UocMsgCreateVoterRspBo rspBO){
        //判断同一明细的到货数量+拒收数量必须小于等于发货数量
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        UocShipOrderDo shipOrderItemDo = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        List<UocShipOrderItem>  ordShipItemList = shipOrderItemDo.getShipOrderItemBoList();
        for(UocShipOrderItem shipOrderItem :ordShipItemList){
            BigDecimal totalCount = new BigDecimal(0);
            totalCount = totalCount.add(shipOrderItem.getArriveCount()).add(shipOrderItem.getRefuseCount());
            if (totalCount.compareTo(shipOrderItem.getSendCount()) >= 0) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "电商妥投进行到货登记发货明细【到货数量+拒收数量>=发货数量】！");
            }
        }
        //更新拒收和到货数量
        for(UocArriveInfoBO bo: arriveInfoBOList){
            UocShipOrderDo shipArriveDo = new UocShipOrderDo();
//            List<Long> shipOrderItemIdList = new ArrayList<>();
//            shipArriveDo.setShipOrderItemIdList(shipOrderItemIdList);
            
            List<UocShipOrderItem> shipOrderItemBoList = new ArrayList<>();
            
            shipArriveDo.setShipOrderItemBoList(shipOrderItemBoList);

//            shipOrderItemIdList.add(bo.getShipItemId());
            if(bo.getArriveCount() != null){//到货数量
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setArriveCount(bo.getArriveCount());
                uocShipOrderItem.setShipItemState(UocStateConstants.ShipOrder.FH_FH_YSH);
                uocShipOrderItem.setShipOrderItemId(bo.getShipItemId());
                shipOrderItemBoList.add(uocShipOrderItem);
                
            }
            if (bo.getRejectCount() != null) {//拒收数量
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setRefuseCount(bo.getRejectCount());
                uocShipOrderItem.setShipItemState(UocStateConstants.ShipOrder.FH_FH_JS);
                uocShipOrderItem.setShipOrderItemId(bo.getShipItemId());
                uocShipOrderItem.setShipOrderItemId(bo.getShipItemId());
                shipOrderItemBoList.add(uocShipOrderItem);
            }
            
            //更新到货数量和拒收数量
            iUocShipOrderModel.modifyItemArriveCount(shipArriveDo);

//            UocShipOrderDo shiItemDo = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
            
            uocShipOrderItemQryBo.setShipOrderItemId(bo.getShipItemId());
            List<UocShipOrderItem> shipOrderItemList =  iUocShipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);

//            Long saleOrderItemId = shipOrderItemBoList1.get(0).getSaleOrderItemId();
            
            for(UocShipOrderItem shipOrderItem: shipOrderItemList){
                Long saleOrderItemId = shipOrderItem.getSaleOrderItemId();
                log.info("更新销售单明细为 {} 的到货数量" ,saleOrderItemId);
                
                UocSaleOrderDo saleOrderDo = new UocSaleOrderDo();
                saleOrderDo.setOrderId(uocShipOrderDo.getOrderId());
                List<UocSaleOrderItem> saleItemList = new ArrayList<>();
                saleOrderDo.setSaleOrderItems(saleItemList);
                
                if(bo.getArriveCount() != null){//到货数量
                    UocSaleOrderItem saleOrderItem = new UocSaleOrderItem();
                    saleOrderItem.setArriveCount(bo.getArriveCount());
                    saleOrderItem.setSaleOrderItemId(saleOrderItemId);
                    saleItemList.add(saleOrderItem);
                    
                }
                if (bo.getRejectCount() != null) {//拒收数量
                    UocSaleOrderItem saleOrderItem = new UocSaleOrderItem();
                    saleOrderItem.setRefuseCount(bo.getRejectCount());
                    saleOrderItem.setSaleOrderItemId(saleOrderItemId);
                    saleItemList.add(saleOrderItem);
                }
                
                //更新uoc_sale_order_item
                iUocSaleOrderModel.updateSaleItemArriveAccount(saleOrderDo);
            }
            
            
        }
    }
    /*
     * @Author lsl
     * @Description //TODO 更新发货单的到货时间
     * @Date 11:49 2022/4/15
     * @Param [orderId, shipOrderId]
     * @return void
     */
    public void updateShipArriveTime(Long orderId,Long shipOrderId){
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderId(orderId);
        uocShipOrderDo.setShipOrderId(shipOrderId);
        uocShipOrderDo.setArriveTime(new Date());
        
        iUocShipOrderModel.modifyShipArrivtime(uocShipOrderDo);
    }
    /**
     * 入参校验
     *
     * @param reqBO 入参对象
     */
    private void validateArg(UocMsgCreateVoterReqBo reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "电子超市订单妥投拒收业务服务入参reqBO不能为空");
        }
        if (StringUtils.isBlank(reqBO.getDycUocQryMsgBO().getOutOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "电子超市订单妥投拒收业务服务入参属性【outOrderId】不能为空");
        }
        if (reqBO.getDycUocQryMsgBO().getSupNo() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "电子超市订单妥投拒收业务服务入参属性【supNo】不能为空");
        }
        if (reqBO.getDycUocQryMsgBO().getMsgState() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "电子超市订单妥投拒收业务服务入参属性【msgState】不能为空");
        }
    }
}
