package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题:UocEsSyncApproval
 * 说明:审批单同步es
 * 时间:2022/4/22 上午11:31
 * 作者:罗有
 */

@Slf4j
@Service
public class UocEsSyncApproval implements IUocEsSync {

    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Override
    public String indexName() {
        return uocIndexConfig.getApprovalOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
        iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
        UocAuditOrderDo uocAuditOrderDo = getUocAuditOrderDo(reqBo);
        if (null == uocAuditOrderDo) {
            return iUocEsSyncQryRspBo;
        }
        Map<String, Map<String, String>> dicMap = getDic();
        List<UocApprovalObj> uocApprovalObjList = getAuditOrderObjList(reqBo);
        JSONObject auditOrderJson = JSON.parseObject(JSON.toJSONString(uocAuditOrderDo, SerializerFeature.WriteMapNullValue));
        if (!CollectionUtils.isEmpty(uocApprovalObjList)) {
            UocApprovalObj uocApprovalObj = uocApprovalObjList.get(0);
            if(UocDicConstant.OBJ_TYPE.SALE.equals(uocApprovalObj.getObjType())) {
                UocSaleOrderDo saleOrder = getSaleOrder(uocApprovalObj);
                if (null != saleOrder) {
                    Map<String, String> payType = dicMap.get(UocDicConstant.PAY_TYPE.P_CODE);
                    Map<String, String> saleOrderState = dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE);
                    saleOrder.setSaleOrderStateStr(saleOrderState.get(saleOrder.getSaleOrderState()));
                    saleOrder.setPayTypeStr(payType.get(saleOrder.getPayType()));
                    saleOrder.setModelSettleStr(null != saleOrder.getModelSettle() ?
                            dicMap.get(UocDicConstant.MODEL_SETTLE.P_CODE).get(saleOrder.getModelSettle() != null ? saleOrder.getModelSettle().toString() : saleOrder.getModelSettle()) : "");
                    List<UocSaleOrderItem> uocSaleOrderItemList = getListSaleOrderItem(uocApprovalObj);
                    saleOrder.setSaleOrderItems(uocSaleOrderItemList);
//                    auditOrderJson.put(UocConstant.ES_MAIN_OTHER.UOC_SALE_ORDER_ITEM, JSON.parseArray(JSON.toJSONString(saleOrder.getSaleOrderItems())));
                    if (ObjectUtil.isNotEmpty(saleOrder.getStakeholder())) {
                        auditOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_ID, saleOrder.getStakeholder().getSupId());
                        auditOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_NAME, saleOrder.getStakeholder().getSupName());
                        auditOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_ID, saleOrder.getStakeholder().getPurOrgId());
                        auditOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_NAME, saleOrder.getStakeholder().getPurOrgName());
                        auditOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_ID, saleOrder.getStakeholder().getProId());
                        auditOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_USER_ID, saleOrder.getStakeholder().getPurUserId());
                    }

                    //协议信息
                    //拉横协议信息
//                    if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrder.getOrderSource())) {
//                        //查询协议信息
//                        List<UocOrderAgreement> agreementOrderList = getAgreementOrderList(saleOrder);
//                        //协议信息
//                        if (ObjectUtil.isNotEmpty(agreementOrderList)) {
//                            putAgreementInfo(agreementOrderList, auditOrderJson);
//                        }
//                    }
                    auditOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_ORDER_INFO, saleOrder);
                }
            }
            //查询业务流程实例
            UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = getProcInst(uocApprovalObj, false);
            auditOrderJson.put(UocConstant.ES_MAIN_OTHER.BUSI_PROC_INST, ObjectUtil.isNotEmpty(busiProcInst.getProcInstId()) ? busiProcInst.getProcInstId() : "");
            auditOrderJson.put(UocConstant.ES_MAIN_OTHER.BUSI_TASK_INST, ObjectUtil.isNotEmpty(busiProcInst.getTaskList()) ? busiProcInst.getTaskList() : new ArrayList<>());
            //查询业务流程实例
            UocGetSaleOrderDetailServiceRspPorcBo auditBusiProcInst = getProcInst(uocApprovalObj, true);
            auditOrderJson.put(UocConstant.ES_MAIN_OTHER.AUDIT_PROC_INST, ObjectUtil.isNotEmpty(auditBusiProcInst.getProcInstId()) ? auditBusiProcInst.getProcInstId() : "");
            auditOrderJson.put(UocConstant.ES_MAIN_OTHER.AUDIT_TASK_INST, ObjectUtil.isNotEmpty(auditBusiProcInst.getTaskList()) ? auditBusiProcInst.getTaskList() : new ArrayList<>());
        }

        iUocEsSyncQryRspBo.setJsonObj(auditOrderJson);
        return iUocEsSyncQryRspBo;
    }

    private UocAuditOrderDo getUocAuditOrderDo(IUocEsSyncQryReqBo reqBo) {
        UocAuditOrderQryBo uocAuditOrderQryBo = new UocAuditOrderQryBo();
        uocAuditOrderQryBo.setAuditOrderId(reqBo.getObjId());
        uocAuditOrderQryBo.setOrderId(reqBo.getOrderId());
        return iUocAuditOrderModel.qryAuditOrder(uocAuditOrderQryBo);
    }

    /**
     * 协议单列表查询
     *
     * @param saleOrder
     * @return java.util.List<com.tydic.dyc.oc.model.saleorder.sub.UocOrderAgreement></>
     */
    private List<UocOrderAgreement> getAgreementOrderList(UocSaleOrderDo saleOrder) {
        UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
        uocOrderAgreementQryBo.setOrderId(saleOrder.getOrderId());
        uocOrderAgreementQryBo.setId(saleOrder.getAgrDataId());
        return iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
    }

    /**
     * 拉横协议信息
     *
     * @param agreementOrderList
     * @param saleOrderObj
     */
    private void putAgreementInfo(List<UocOrderAgreement> agreementOrderList, JSONObject saleOrderObj) {
        UocOrderAgreement agreement = agreementOrderList.get(0);
        //协议模式
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AGR_CODE, agreement.getAgreementCode());
        //平台协议编号
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.PLA_AGR_CODE, agreement.getPlaAgreementCode());
        //协议名称
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AGR_NAME, agreement.getAgreementName());
    }

    private List<UocApprovalObj> getAuditOrderObjList(IUocEsSyncQryReqBo reqBo) {
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setAuditOrderId(reqBo.getObjId());
        return iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
    }

    private UocSaleOrderDo getSaleOrder(UocApprovalObj uocApprovalObj) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(Convert.toLong(uocApprovalObj.getObjId()));
        uocSaleOrderQryBo.setOrderId(uocApprovalObj.getOrderId());
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private List<UocSaleOrderItem> getListSaleOrderItem(UocApprovalObj uocApprovalObj) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(Convert.toLong(uocApprovalObj.getObjId()));
        uocSaleOrderItemQryBo.setOrderId(uocApprovalObj.getOrderId());
        return iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.SALE_ORD_STATE.P_CODE);
        pCodes.add(UocDicConstant.PAY_TYPE.P_CODE);
        pCodes.add(UocDicConstant.MODEL_SETTLE.P_CODE);
        pCodes.add(UocConstant.AUDIT_TYPE.P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    /**
     * 查询流程任务实例
     *
     * @param uocApprovalObj
     * @param isAudit
     * @return UocGetSaleOrderDetailServiceRspPorcBo
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(UocApprovalObj uocApprovalObj, Boolean isAudit) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjType(uocApprovalObj.getObjType());
        }
        procInstQryBo.setObjId(Convert.toLong(uocApprovalObj.getObjId()));
        procInstQryBo.setOrderId(uocApprovalObj.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            List<Integer> finishTagList = new ArrayList<>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
            taskInstQryBo.setFinishTagList(finishTagList);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }

}
