package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderObjQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCancelReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCancelRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题：类名称:UocAfterOrderCancelServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/6 16:11
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocAfterOrderCancelServiceImpl implements UocAfterOrderCancelService {
    @Autowired
    private IUocAfOrderModel afOrderModel;

    @Autowired
    private IUocInspOrderModel inspOrderModel;

    @Autowired
    private IUocSaleOrderModel saleOrderModel;
    @Autowired
    private IUocOrderModel orderModel;


    @Autowired
    private IUocShipOrderModel shipOrderModel;

    @Override
    public UocAfterOrderCancelRspBo cancelAfterOrder(UocAfterOrderCancelReqBo reqBo) {
        UocAfterOrderCancelRspBo rspBo = UocRu.success(UocAfterOrderCancelRspBo.class);
        //参数校验
        validateArg(reqBo);
        //查询售后单信息
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setOrderId(reqBo.getOrderId());
        uocAfOrderQryBo.setAfOrderId(reqBo.getAfOrderId());
        UocAfOrder uocAfOrder = afOrderModel.getAfOrderById(uocAfOrderQryBo);

        if (ObjectUtil.isEmpty(uocAfOrder)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询售后单信息为空");
        }
        Integer servType = uocAfOrder.getServType();
        Integer servState = uocAfOrder.getServState();
        if (!UocDicConstant.SERVICE_STATE.SUMIT_APPLICATION.equals(servState)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "售后单不可取消");

        }
        //修改售后状态
        UocAfOrderDo uocAfOrderDo = new UocAfOrderDo();
        uocAfOrderDo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderDo.setOrderId(reqBo.getOrderId());
        uocAfOrderDo.setServState(UocDicConstant.SERVICE_STATE.CANCEL);
        uocAfOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.CANCELED);
        uocAfOrderDo.setUpdateTime(new Date());
        uocAfOrderDo.setCancelTime(new Date());
        uocAfOrderDo.setCancelOperId(String.valueOf(reqBo.getUserId()));
        uocAfOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        afOrderModel.modifyAfOrderState(uocAfOrderDo);
        List<UocAfOrderItem> afOrderItemList = afOrderModel.getAfOrderItemList(UocRu.js(reqBo, UocAfOrderItemQryBo.class));

        if (UocDicConstant.SERVICE_STATE.REMARK_COMPLATE.equals(servState) && UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(servType)) {
            //修改发货单明细，销售单明细退货数量
            updateItemAndShipReturnCount(afOrderItemList, reqBo, rspBo);
        } else {
            //修改发货单明细，销售单明细在途数量
            updateItemAndShipAfterServringCount(afOrderItemList, reqBo, rspBo);

        }

        UocSaleOrderDo saleOrderDetail = getSaleOrderDetail(uocAfOrder.getOrderId(), uocAfOrder.getSaleOrderId());

        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
        uocOrderStakeholderQryBo.setOrderId(reqBo.getOrderId());
        uocOrderStakeholderQryBo.setStakeholderId(saleOrderDetail.getStakeholderId());
        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = orderModel.qryStakeholderList(uocOrderStakeholderQryBo);
        String supId = uocOrderStakeholderQryBos.get(0).getSupId();

        UocAfOrderItem uocAfOrderItem = afOrderItemList.get(0);
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(uocAfOrderItem.getOrderId());
        uocShipOrderItemQryBo.setShipOrderItemId(uocAfOrderItem.getShipItemId());
        List<UocShipOrderItem> shipOrderItemList = shipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);

        //调用修改发货单计算信息
        this.updateShipComputeInfo(uocAfOrder, afOrderItemList, shipOrderItemList.get(0).getShipOrderId());

        rspBo.setSaleOrderId(uocAfOrder.getSaleOrderId());
        rspBo.setShipOrderId(shipOrderItemList.get(0).getShipOrderId());
        rspBo.setExtAfId(uocAfOrder.getExtAfId());
        rspBo.setSupId(supId);
        return rspBo;
    }

    /**
     * 修改发货单计算信息
     */
    private void updateShipComputeInfo(UocAfOrder uocAfOrder, List<UocAfOrderItem> uocAfOrderItemList, Long shipOrderId) {
        //判断服务类型是否为退货
        if (!UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(uocAfOrder.getServType())) {
            return;
        }

        //调用修改发货单占用运费
        this.updateShipOccupyTransFee(uocAfOrder, shipOrderId);

        //调用修改发货单明细已退货明细金额
        this.updateShipItemReturnSendFee(uocAfOrder, uocAfOrderItemList, shipOrderId);
    }

    /**
     * 修改发货单占用运费
     */
    private void updateShipOccupyTransFee(UocAfOrder uocAfOrder, Long shipOrderId) {
        //定义修改发货单已占用运费参数
        UocShipOrderDo updateOccupyTransFee = new UocShipOrderDo();
        //设置销售单ID
        updateOccupyTransFee.setShipOrderId(shipOrderId);
        //设置订单ID
        updateOccupyTransFee.setOrderId(uocAfOrder.getOrderId());
        //设置已占用运费 返还占用运费 正数转换为负数
        updateOccupyTransFee.setSendOccupyTransFee(uocAfOrder.getReturnTransFee().negate());
        //调用修改发货单占用运费
        this.shipOrderModel.modifyOccupyTransFee(updateOccupyTransFee);
    }

    /**
     * 修改发货单明细已退货明细金额
     */
    private void updateShipItemReturnSendFee(UocAfOrder uocAfOrder, List<UocAfOrderItem> uocAfOrderItemList, Long shipOrderId) {
        //获取发货单明细ID Vs 售后单明细 Map
        Map<Long, List<UocAfOrderItem>> shipItemIdVsAfOrderItemMap = uocAfOrderItemList.stream().collect(Collectors.groupingBy(UocAfOrderItem::getShipItemId));

        //定义发货单明细集合
        List<UocShipOrderItem> uocShipOrderItemList = new ArrayList<>(1);

        //遍历发货单明细ID Vs 售后单明细 Map
        for (Map.Entry<Long, List<UocAfOrderItem>> entry : shipItemIdVsAfOrderItemMap.entrySet()) {
            //定义发货单明细对象
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();

            //获取当前售后单明细 所有销售退款金额
            BigDecimal allRetSaleFee = entry.getValue().stream().map(UocAfOrderItem::getRetSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            //获取当前售后单明细 所有采购退款金额
            BigDecimal allRetPurchaseFee = entry.getValue().stream().map(UocAfOrderItem::getRetPurchaseFee).reduce(BigDecimal.ZERO, BigDecimal::add);

            //设置发货单明细ID
            uocShipOrderItem.setShipOrderItemId(entry.getKey());
            //设置已退货明细销售金额 返还已退货明细金额 正数转换为负数
            uocShipOrderItem.setRetrunSendSaleFee(allRetSaleFee.negate());
            //设置已退货明细采购金额 返还已退货明细金额 正数转换为负数
            uocShipOrderItem.setRetrunSendPurchaseFee(allRetPurchaseFee.negate());

            //添加到发货单明细集合
            uocShipOrderItemList.add(uocShipOrderItem);
        }

        //定义修改发货单明细已退款明细金额参数
        UocShipOrderDo updateItemReturnSendFee = new UocShipOrderDo();
        //设置发货单ID
        updateItemReturnSendFee.setShipOrderId(shipOrderId);
        //设置订单ID
        updateItemReturnSendFee.setOrderId(uocAfOrder.getOrderId());
        //设置发货单明细集合
        updateItemReturnSendFee.setShipOrderItemBoList(uocShipOrderItemList);
        //调用修改发货单明细已退款明细金额
        this.shipOrderModel.modifyItemReturnSendFee(updateItemReturnSendFee);
    }

    private void updateItemAndShipAfterServringCount(List<UocAfOrderItem> afOrderItemList, UocAfterOrderCancelReqBo reqBo, UocAfterOrderCancelRspBo rspBo) {
        for (UocAfOrderItem uocAfOrderItem : afOrderItemList) {
            Long inspItemId = uocAfOrderItem.getInspItemId();
            Long orderItemId = uocAfOrderItem.getSaleItemId();
            Long orderId = uocAfOrderItem.getOrderId();
            Long shipItemId = uocAfOrderItem.getShipItemId();
            BigDecimal returnCount = uocAfOrderItem.getReturnCount();

            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(orderId);
            uocSaleOrderItem.setSaleOrderItemId(orderItemId);
            uocSaleOrderItem.setAfterServingCount(returnCount.negate());
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(ObjectUtil.isEmpty(reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
            saleOrderModel.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setOrderId(orderId);
            uocShipOrderItem.setShipOrderItemId(shipItemId);
            uocShipOrderItem.setAfterServingCount(returnCount.negate());
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(ObjectUtil.isEmpty(reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
            shipOrderModel.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
//        if (ObjectUtil.isNotEmpty(inspItemId)) {
//            UocInspOrderItem uocInspOrderItem = new UocInspOrderItem();
//            uocInspOrderItem.setOrderId(uocAfOrderItem.getOrderId());
//            uocInspOrderItem.setInspOrderItemId(inspItemId);
//            uocInspOrderItem.setReturnCount(uocAfOrderItem.getReturnCount());
//            uocInspOrderItem.setUpdateTime(new Date());
//            uocInspOrderItem.setUpdateOperId(ObjectUtil.isEmpty(reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
//            inspOrderModel.modifySaleOrderItemReturningCount(uocInspOrderItem);
//            //出参es同步
//            List<Long> inspOrderIdList = rspBo.getInspOrderIdList();
//            UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
//            UocInspOrderDo listInspOrderItem = inspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
//            inspOrderIdList.add(listInspOrderItem.getInspOrderId());
//        }
        }
    }

    private void updateItemAndShipReturnCount(List<UocAfOrderItem> uocAfOrderItemList, UocAfterOrderCancelReqBo reqBo, UocAfterOrderCancelRspBo rspBo) {
        for (UocAfOrderItem uocAfOrderItem : uocAfOrderItemList) {
            Long inspItemId = uocAfOrderItem.getInspItemId();
            Long orderItemId = uocAfOrderItem.getSaleItemId();
            Long orderId = uocAfOrderItem.getOrderId();
            Long shipItemId = uocAfOrderItem.getShipItemId();
            BigDecimal returnCount = uocAfOrderItem.getReturnCount();

            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(orderId);
            uocSaleOrderItem.setSaleOrderItemId(orderItemId);
            uocSaleOrderItem.setReturnCount(returnCount.negate());
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(ObjectUtil.isEmpty(reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
            saleOrderModel.modifySaleOrderItemReturningCount(uocSaleOrderItem);
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setOrderId(orderId);
            uocShipOrderItem.setShipOrderItemId(shipItemId);
            uocShipOrderItem.setReturnCount(returnCount.negate());
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(ObjectUtil.isEmpty(reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
            shipOrderModel.modifyShipOrderItemReturningCount(uocShipOrderItem);
//        if (ObjectUtil.isNotEmpty(inspItemId)) {
//            UocInspOrderItem uocInspOrderItem = new UocInspOrderItem();
//            uocInspOrderItem.setOrderId(uocAfOrderItem.getOrderId());
//            uocInspOrderItem.setInspOrderItemId(inspItemId);
//            uocInspOrderItem.setReturnCount(uocAfOrderItem.getReturnCount());
//            uocInspOrderItem.setUpdateTime(new Date());
//            uocInspOrderItem.setUpdateOperId(ObjectUtil.isEmpty(reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
//            inspOrderModel.modifySaleOrderItemReturningCount(uocInspOrderItem);
//            //出参es同步
//            List<Long> inspOrderIdList = rspBo.getInspOrderIdList();
//            UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
//            UocInspOrderDo listInspOrderItem = inspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
//            inspOrderIdList.add(listInspOrderItem.getInspOrderId());
//        }
        }

    }

    private UocSaleOrderDo getSaleOrderDetail(Long orderId,Long saleOrderId){
        UocSaleOrderQryBo qrySaleOrderQryBo = new UocSaleOrderQryBo();
        qrySaleOrderQryBo.setSaleOrderId(saleOrderId);
        qrySaleOrderQryBo.setOrderId(orderId);
        UocSaleOrderDo uocSaleOrderDo = saleOrderModel.qrySaleOrder(qrySaleOrderQryBo);
        return uocSaleOrderDo;
    }

    private void validateArg(UocAfterOrderCancelReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocAfterOrderCancelReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAfOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[售后单ID]不能为空");
        }
    }
}
