package com.tydic.dyc.oc.service.importorder;

import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.importorder.IUocImportOrderModel;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderQryListReqBo;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderQryListRspBo;
import com.tydic.dyc.oc.service.importorder.bo.UocImportOrderListQryReqBo;
import com.tydic.dyc.oc.service.importorder.bo.UocImportOrderListQryRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：UocImportOrderListQryServiceImpl
 * 描述：导入订单记录列表分页查询接口实现类
 */
@Slf4j
@HTServiceImpl
public class UocImportOrderListQryServiceImpl implements UocImportOrderListQryService {

    /**
     * 导入订单记录领域方法服务
     */
    @Autowired
    private IUocImportOrderModel iUocImportOrderModel;

    /**
     * 导入订单记录列表分页查询
     */
    @Override
    public UocImportOrderListQryRspBo qryImportOrderList(UocImportOrderListQryReqBo reqBo) {
        //入参转换
        UocImportOrderQryListReqBo uocImportOrderQryListReqBo = UocRu.js(reqBo, UocImportOrderQryListReqBo.class);

        //调用导入订单记录领域方法服务，导入订单记录列表分页查询
        UocImportOrderQryListRspBo uocImportOrderQryListRspBo = this.iUocImportOrderModel.qryImportOrderList(uocImportOrderQryListReqBo);

        //出参转换
        UocImportOrderListQryRspBo rspBo = UocRu.js(uocImportOrderQryListRspBo, UocImportOrderListQryRspBo.class);

        //出参
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);

        return rspBo;
    }

}
