package com.tydic.dyc.oc.service.insporder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.insporder.bo.UocGetInspOrderInfoServiceReqBo;
import com.tydic.dyc.oc.service.insporder.bo.UocGetInspOrderInfoServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 描述: 〈领域服务-验收信息查询〉
 *
 * @author : gaoqh
 * @date : 2023/2/2 11:37
 */
@Slf4j
@HTServiceImpl
public class UocGetInspOrderInfoServiceImpl implements UocGetInspOrderInfoService {
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocGetInspOrderInfoServiceRspBo getInspOrderInfo(UocGetInspOrderInfoServiceReqBo reqBo) {
        //参数校验
        validateParam(reqBo);
        UocGetInspOrderInfoServiceRspBo rspBo = new UocGetInspOrderInfoServiceRspBo();
        //查询验收单附件列表
        UocOrderAccessoryQryBo accessoryQryBo = new UocOrderAccessoryQryBo();
        accessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        accessoryQryBo.setObjId(reqBo.getObjId());
        List<UocOrderAccessory> accessoryList = iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        if (ObjectUtil.isNotEmpty(accessoryList)) {
            // 验收附件 附件类型分组
            Map<Integer, List<UocOrderAccessory>> accessoryMaps =
                    accessoryList.stream().collect(Collectors.groupingBy(UocOrderAccessory::getAttachmentType));
            // 附件 验收照片
            List<UocOrderAccessory> accessoryPicList = accessoryMaps.get(UocAttachementTypeConstants.ACCEPTANCE_PICTURE);
            if (ObjectUtil.isNotEmpty(accessoryPicList)) {
                List<UocBaseOrderAccessoryDetailBo> uocBaseAccessoryDetailBoList = UocRu.jsl(accessoryPicList, UocBaseOrderAccessoryDetailBo.class);
                rspBo.setAttchList(uocBaseAccessoryDetailBoList);
            }
            // 其他 验收报告
            List<UocOrderAccessory> accessoryOtherList = accessoryMaps.get(UocAttachementTypeConstants.ACCEPTANCE_OTHER);
            if (ObjectUtil.isNotEmpty(accessoryOtherList)) {
                List<UocBaseOrderAccessoryDetailBo> uocBaseOrderAccessoryDetailBoList = UocRu.jsl(accessoryOtherList, UocBaseOrderAccessoryDetailBo.class);
                rspBo.setAttchOtherList(uocBaseOrderAccessoryDetailBoList);
            }
        }
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setInspOrderId(reqBo.getObjId());
        uocInspOrderQryBo.setOrderId(reqBo.getOrderId());
        UocInspOrderDo uocInspOrderDo = iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
        if (ObjectUtil.isNotNull(uocInspOrderDo)) {
                rspBo.setRemark(uocInspOrderDo.getRemark());
                rspBo.setOtherRemark(uocInspOrderDo.getOtherRemark());
        }
        return rspBo;
    }

    /**
     * 参数校验
     *
     * @param reqBo
     */
    private void validateParam(UocGetInspOrderInfoServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty(reqBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getObjId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "单据id不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单id不能为空");
        }
    }
}
