package com.tydic.dyc.oc.transactionservice;

import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspEstimateSaleItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocReceiveItInspOrderNoItemReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocReceiveItInspOrderNoItemRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:UocArrvaITAcceptanceByNoItemTransaction
 * 说明:
 * 时间:2023/8/26 16:50
 * 作者:田桂银
 */
@Slf4j
@Component
public class UocArrvaITAcceptanceByNoItemTransaction {
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    /**
     * 全部验收完成
     */
    private static final String OP_FLAG_YES = "1";
    /**
     * 未全部验收完成
     */
    private static final String OP_FLAG_NO = "0";
    /**
     * 订单来源-电商
     */
    private static final String EC_IMPORT = "2";
    /**
     * 全部-供应商ID
     */
    private static final String SUP_NO = "0";

    //是否入参校验
    @Value("${uoc.createOrderSettleRelInfo:true}")
    private boolean createOrderSettleRelInfo;



    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocReceiveItInspOrderNoItemRspBo dealItArrvalAcceptance(UocReceiveItInspOrderNoItemReqBo reqBo) {
        //参数校验
        this.verifyParam(reqBo);
        //查询验收对应得销售单主体、明细
        UocSaleOrderDo saleOrderMainInfo = this.querySaleOrderMainInfo(reqBo);
        //按规则估算验收明细中的采购数量
        List<UocCreateInspEstimateSaleItemBo> itemBoList = this.estimateSaleITemInspCount(reqBo, saleOrderMainInfo);
        reqBo.setSaleOrderItemList(itemBoList);
        //更新销售单信息
        this.updateSaleOrderInfo(reqBo, saleOrderMainInfo.getSaleOrderItems());
        //创建验收单
        Long inspOrderId = this.createInspOrder(reqBo, saleOrderMainInfo.getSaleOrderItems());
        //创建订单结算关联数据
        this.createOrderSettleRelInfo(reqBo, inspOrderId);
        //判断是否完结并更新销售单状态和提交销售单任务
        Boolean inspFinish = determineFinishAndUpdateSaleState(reqBo);
        //返回结果
        UocReceiveItInspOrderNoItemRspBo rspBo = UocRu.success(UocReceiveItInspOrderNoItemRspBo.class);
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        rspBo.setFinish(inspFinish);
        rspBo.setOpFlag(inspFinish ? OP_FLAG_YES : OP_FLAG_NO);
        rspBo.setInspOrderId(inspOrderId);
        return rspBo;
    }

    private List estimateSaleITemInspCount(UocReceiveItInspOrderNoItemReqBo reqBo, UocSaleOrderDo saleOrderMainInfo) {
        //1 比例计算（验收金额/订单金额）
        BigDecimal inspectionMoney = new BigDecimal(reqBo.getInspMoney());
        BigDecimal inspectionRate =inspectionMoney.divide(saleOrderMainInfo.getTotalSaleFee(),8,RoundingMode.HALF_UP);
        log.info("本次IT工作台验收比例："+inspectionRate);
        //2 估算采购数量
        List<UocCreateInspEstimateSaleItemBo> itemBoList = new ArrayList<>();
        //计算n-1的采购数量，小计之和
        BigDecimal tmpTotal = new BigDecimal(0);
        //获取类别先排序
        List<UocSaleOrderItem> saleOrderItems = saleOrderMainInfo.getSaleOrderItems();
        for (int i = 0; i < saleOrderItems.size(); i++) {
            UocSaleOrderItem saleOrderItem = saleOrderItems.get(i);
            UocCreateInspEstimateSaleItemBo estimateSaleItemBo = UocRu.js(saleOrderItem, UocCreateInspEstimateSaleItemBo.class);
            if (i == saleOrderItems.size() - 1 && saleOrderItems.size() > 1) {
                //最后一条验收明细，估算数量 = 验收金额减去前n-1小计之和的结果，再除以单价所得
                BigDecimal lastItemSaleFee = saleOrderMainInfo.getTotalSaleFee().subtract(tmpTotal);
                estimateSaleItemBo.setInspCount(lastItemSaleFee.divide(saleOrderItem.getSalePrice()).setScale(2, RoundingMode.HALF_UP));
            } else {
                //前n-1条验收验收，估算数量 = 明细条数 * 验收比例。
                estimateSaleItemBo.setInspCount(saleOrderItem.getPurchaseCount().multiply(inspectionRate).setScale(2, RoundingMode.HALF_UP));
                //前n-1条明细
                tmpTotal = tmpTotal.add(saleOrderItem.getSaleFee().multiply(inspectionRate));
            }
            itemBoList.add(estimateSaleItemBo);
        }
        return itemBoList;
    }

    private Boolean determineFinishAndUpdateSaleState(UocReceiveItInspOrderNoItemReqBo reqBo) {
        if (reqBo.getInspFinish()) {
            //前端传入验收完成时，才需要更新销售单状态到验收或者部分验收
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
            uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            //更新销售单状态
            this.updateSaleOrderState(saleOrderItemList, reqBo);
            return true;
        } else {
            return false;
        }

    }


    private Long createInspOrder(UocReceiveItInspOrderNoItemReqBo reqBo, List<UocSaleOrderItem> saleOrderItems) {

        Map<Long, UocSaleOrderItem> uocSaleOrderItemMap = saleOrderItems.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        //组装验收单数据
        UocInspOrderDo createInspOrderDo = new UocInspOrderDo();
        //生产验收单id
        Long inspOrderId = IdUtil.nextId();
        //设置订单id
        createInspOrderDo.setOrderId(saleOrderItems.get(0).getOrderId());
        //设置销售单id
        createInspOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        //设置验收单id
        createInspOrderDo.setInspOrderId(inspOrderId);
//        //设置备注
//        createInspOrderDo.setRemark(reqBo.getRemark());
//        //设置其他备注
//        createInspOrderDo.setOtherRemark(reqBo.getOtherRemark());
        //设置验收单编号
        createInspOrderDo.setInspOrderNo(getInspOrderNo(reqBo));
        //设置验收单状态
        createInspOrderDo.setInspOrderState(UocStateConstants.InspOrder.YS_YS_YS);
        //设置验收人名称
        createInspOrderDo.setInspOper(reqBo.getInspOperId());
        //设置创建人id
        createInspOrderDo.setCreateOperId(reqBo.getInspOperId());
        //设置创建时间
        createInspOrderDo.setCreateTime(new Date());
        //设置开票标识
        createInspOrderDo.setInvoiceTag(UocConstant.INVOICE_TAG.NO);
/*        //设置验收人电话
        createInspOrderDo.setInspOperPhone(reqBo.getCellphone());
        //设置租户ID
        createInspOrderDo.setTenantId(reqBo.getTenantId());*/
        //设置采购金额
//        createInspOrderDo.setTotalPurchaseFee(BigDecimal.ZERO);
        //设置销售金额
//        createInspOrderDo.setTotalSaleFee(BigDecimal.ZERO);
        //定义需要创建的发货验收关系集合
        List<UocShipInspRel> uocShipInspRelList = new ArrayList<>();
        //定义需要创建的验收明细集合
        List<UocInspOrderItem> uocInspOrderItemList = new ArrayList<>();

        //组装发货验收关系
        Map<Long, UocCreateInspEstimateSaleItemBo> inspItemBOMap = reqBo.getSaleOrderItemList().stream().collect(Collectors.toMap(UocCreateInspEstimateSaleItemBo::getSaleOrderItemId, e -> e));

        saleOrderItems.forEach(uocSaleOrderItem -> {
            UocInspOrderItem createInspOrderItem = new UocInspOrderItem();
            //设置订单id
            createInspOrderItem.setOrderId(uocSaleOrderItem.getOrderId());
            //设置销售单id
            createInspOrderItem.setSaleOrderId(reqBo.getSaleOrderId());
            //设置验收单id
            createInspOrderItem.setInspOrderId(createInspOrderDo.getInspOrderId());
            //设置验收单明细id
            createInspOrderItem.setInspOrderItemId(IdUtil.nextId());
            //设置验收数量
            createInspOrderItem.setInspCount(inspItemBOMap.get(uocSaleOrderItem.getSaleOrderItemId()).getInspCount());
            //设置剩余验收数量
            createInspOrderItem.setRemainInspCount(inspItemBOMap.get(uocSaleOrderItem.getSaleOrderItemId()).getInspCount());
            //设置初始验收数量
            createInspOrderItem.setInitInspCount(inspItemBOMap.get(uocSaleOrderItem.getSaleOrderItemId()).getInspCount());
            //设置销售单明细id
            createInspOrderItem.setSaleOrderItemId(uocSaleOrderItem.getSaleOrderItemId());
            //设置计量单位
            createInspOrderItem.setUnitName(uocSaleOrderItem.getUnitName());
            //设置创建时间
            createInspOrderItem.setCreateTime(new Date());
            //设置创建人id
            createInspOrderItem.setCreateOperId(reqBo.getInspOperId());
            uocInspOrderItemList.add(createInspOrderItem);

        });
        //设置验收发货关系
        createInspOrderDo.setUocShipInspRelList(uocShipInspRelList);
        //设置验收明细
        createInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        //设置允许变更时限
        //createInspOrderDo.setAllowChngTime(this.getInspAllowChngTime(reqBo));
        //组装附件信息
        List<UocOrderAccessory> uocOrderAccessoryList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(reqBo.getOrderAccessoryBoList())) {
            reqBo.getOrderAccessoryBoList().forEach(obj -> {
                UocOrderAccessory uocOrderAccessory = new UocOrderAccessory();
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setOrderId(saleOrderItems.get(0).getOrderId());
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
                uocOrderAccessory.setObjId(inspOrderId);
                uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.ACCEPTANCE);
                uocOrderAccessory.setAccessoryUrl(obj.getAccessoryUrl());
                uocOrderAccessory.setAccessoryName(obj.getAccessoryName());
                uocOrderAccessoryList.add(uocOrderAccessory);
            });
        }
        createInspOrderDo.setUocOrderAccessoryList(uocOrderAccessoryList);

        //计算验收销售/采购金额
     /* BigDecimal inspSaleMoney = BigDecimal.ZERO;
        BigDecimal inspPurchaseMoney = BigDecimal.ZERO;
       for (UocInspOrderItem uocInspOrderItem : uocInspOrderItemList) {
            UocSaleOrderItem saleOrderItem = uocSaleOrderItemMap.get(uocInspOrderItem.getSaleOrderItemId());
            if (null != saleOrderItem.getSalePrice() && null != saleOrderItem.getPurchaseCount()) {
                BigDecimal inspSalFee = saleOrderItem.getSalePrice().multiply(uocInspOrderItem.getInspCount());
                inspSaleMoney = inspSaleMoney.add(inspSalFee);
            }
            if (null != saleOrderItem.getPurchasePrice() && null != saleOrderItem.getPurchaseCount()) {
                BigDecimal purSalFee = saleOrderItem.getPurchasePrice().multiply(uocInspOrderItem.getInspCount());

                inspPurchaseMoney = inspPurchaseMoney.add(purSalFee);
            }
        }
        createInspOrderDo.setTotalSaleFee(inspSaleMoney);
        createInspOrderDo.setTotalPurchaseFee(inspPurchaseMoney);*/
        BigDecimal inspectionMoney = new BigDecimal(reqBo.getInspMoney());;
        createInspOrderDo.setTotalSaleFee(inspectionMoney);
        createInspOrderDo.setTotalPurchaseFee(inspectionMoney);
        //创建验收单
        this.iUocInspOrderModel.createInspOrder(createInspOrderDo);

        return inspOrderId;
    }

    /**
     * 更新销售单信息
     *
     * @param reqBo
     * @param
     */
    private void updateSaleOrderInfo(UocReceiveItInspOrderNoItemReqBo reqBo, List<UocSaleOrderItem> saleOrderItems) {
     UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        //设置订单id
        updateSaleOrderDo.setOrderId(reqBo.getOrderId());
        //设置销售单id
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        //设置更新人id
        updateSaleOrderDo.setUpdateOperId(reqBo.getInspOperId());
        //设置更新人名称
        updateSaleOrderDo.setUpdateOperName(reqBo.getInspOperName());
        //设置更新时间
        updateSaleOrderDo.setUpdateTime(new Date());
        //组装需要更新的销售单明细
        Map<Long, UocSaleOrderItem> dbSaleItemMap = saleOrderItems.stream().
                collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        //校验数量
        for (UocCreateInspEstimateSaleItemBo uocCreateInspOrderReqSaleItemBo : reqBo.getSaleOrderItemList()) {
            UocSaleOrderItem dbSaleItem = dbSaleItemMap.get(uocCreateInspOrderReqSaleItemBo.getSaleOrderItemId());
            if (dbSaleItem == null) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "销售单明细id[" + uocCreateInspOrderReqSaleItemBo.getSaleOrderItemId() + "]不存在");
            } else {
                if (dbSaleItem.getAcceptanceCount().add(uocCreateInspOrderReqSaleItemBo.getInspCount()).compareTo(dbSaleItem.getPurchaseCount()) > 0) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "销售单明细id[" + uocCreateInspOrderReqSaleItemBo.getSaleOrderItemId() + "]验收数量超过购买数量[" + dbSaleItem.getPurchaseCount() + "]了");
                }
            }
        }


        List<UocSaleOrderItem> updateItemList = new ArrayList<>();
        for (UocCreateInspEstimateSaleItemBo value : reqBo.getSaleOrderItemList()) {
            UocSaleOrderItem updateItemDo = new UocSaleOrderItem();
            updateItemDo.setSaleOrderItemId(value.getSaleOrderItemId());
            updateItemDo.setAcceptanceCount(value.getInspCount());
            updateItemList.add(updateItemDo);
        }

        //设置销售单明细
        updateSaleOrderDo.setSaleOrderItems(updateItemList);
        //更新销售单明细验收数量和超验数量
        this.iUocSaleOrderModel.modifyBatchItemInspCount(updateSaleOrderDo);
    }

    /**
     * 更新销售单状态，如发货单存在拒收或者有部分验收则销售单为部分验收，全部验收为已验收
     */
    private void updateSaleOrderState(List<UocSaleOrderItem> saleOrderItemList, UocReceiveItInspOrderNoItemReqBo reqBo) {
        //组装需要更新的销售单信息
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        //设置订单id
        updateSaleOrderDo.setOrderId(reqBo.getOrderId());
        //设置销售单id
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        //设置更新人id
        updateSaleOrderDo.setUpdateOperId(reqBo.getInspOperId());
        //设置更新时间
        updateSaleOrderDo.setUpdateTime(new Date());
        //设置更新人名称
        updateSaleOrderDo.setUpdateOperName(reqBo.getInspOperName());
        //设置销售单的状态
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            //全部销售单明细验收完成，状态为已验收，其它为部分验收（拒收的状态，在拒收服务上完成）
            //验收完成明细数量
            int acceptanceCompleteItemCount = 0;
            for (UocSaleOrderItem uocSaleOrderItem : saleOrderItemList) {
                if (uocSaleOrderItem.getPurchaseCount().compareTo(uocSaleOrderItem.getAcceptanceCount()) == 0) {
                    acceptanceCompleteItemCount++;
                }
            }
            if (acceptanceCompleteItemCount == saleOrderItemList.size()) {
                //全部验收
                updateSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_YS_YS);
            } else {
                //部分验收
                updateSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_YS_BFYS);
            }
        }
        if (StringUtils.isNotEmpty(updateSaleOrderDo.getSaleOrderState())) {
            this.iUocSaleOrderModel.updateSaleStatusAndProCode(updateSaleOrderDo);
        }
    }


/*    *//**
     * 获取验收单时效配置
     *
     * @param reqBo
     *//*
    private Date getInspAllowChngTime(UocReceiveItInspOrderNoItemReqBo reqBo) {
        //查询销售单
        UocSaleOrderQryBo saleOrderQryBo = new UocSaleOrderQryBo();
        saleOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        saleOrderQryBo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.qrySaleOrder(saleOrderQryBo);
        //查询时效类配置
        UocConfEffectiveQryBo uocConfEffectiveQryBo = new UocConfEffectiveQryBo();
        uocConfEffectiveQryBo.setEffectiveCode(UocConstant.EffectiveCode.TIME_LIMIT_FOR_ABNORMAL_ORDER_CHANGES);
        List<UocConfEffective> rows = this.iUocOrderModel.qryListPageConfEffective(uocConfEffectiveQryBo).getRows();
        Date allowChngTime = null;

        if (ObjectUtil.isNotEmpty(rows)) {
            //将时效配置转化为map
            Map<String, UocConfEffective> confEffectiveMap = rows.stream().collect(Collectors.toMap(o -> o.getBusinessTypeCode() + o.getSupplierNo(), Function.identity()));
            //找到对应配置的时效配置
            if (null != saleOrderMain) {
                String key = null;
                if (null != saleOrderMain.getStakeholder()) {
                    key = saleOrderMain.getOrderSource() + saleOrderMain.getStakeholder().getSupId();
                } else {
                    key = String.valueOf(saleOrderMain.getOrderSource()) + reqBo.getSupId();
                }
                if (ObjectUtil.isNotNull(confEffectiveMap.get(key))) {
                    allowChngTime = new Date(confEffectiveMap.get(key).getAging());
                } else {
                    allowChngTime = new Date(confEffectiveMap.get(saleOrderMain.getOrderSource() + SUP_NO).getAging());
                }
            } else {
                allowChngTime = new Date(confEffectiveMap.get(EC_IMPORT + SUP_NO).getAging());
            }
        }

        return allowChngTime;
    }*/

    /**
     * 获取验收单编号
     */
    private String getInspOrderNo(UocReceiveItInspOrderNoItemReqBo reqBo) {
        UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
        querySaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        querySaleOrderDo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(querySaleOrderDo);
        if (null != saleOrderMain) {
            UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
            uocInspOrderDo.setOrderSource(saleOrderMain.getOrderSource());
            UocInspOrderDo inspOrderNo = this.iUocInspOrderModel.getInspOrderNo(uocInspOrderDo);
            if (null != inspOrderNo) {
                return inspOrderNo.getInspOrderNo();
            } else {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "生成验收单编号失败");
            }
        } else {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "生成验收单编号失败，查询销售单数据为空");
        }
    }

    /**
     * 创建订单结算关联数据
     *
     * @param reqBo
     * @param inspOrderId
     */
    private void createOrderSettleRelInfo(UocReceiveItInspOrderNoItemReqBo reqBo, Long inspOrderId) {
        if (createOrderSettleRelInfo) {
            UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
            querySaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
            querySaleOrderDo.setOrderId(reqBo.getOrderId());
            UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(querySaleOrderDo);
            if (null != saleOrderMain) {
                //生产服务费结算关联数据
                this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.SERVICE_CHARGE);
                if (UocConstant.ModelSettle.MY.equals(saleOrderMain.getModelSettle())) {
                    //贸易模式：
                    //生成普通开票关联数据
                    this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.COMMON_INVOICE);
                    //生成上游开票关联数据
                    this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.UP_INVOICE);
                } else if (UocConstant.ModelSettle.CH.equals(saleOrderMain.getModelSettle())) {
                    //撮合模式：
                    //生成下游撮合开票关联数据
                    this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.CH_INVOICE);
                } else {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "生产订单结算关联数据失败：错误的结算模式");
                }
            } else {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "生产订单结算关联数据失败：查询销售单单为空");
            }
        }

    }

    /**
     * 生成外部关联数据
     *
     * @param reqBo
     * @param inspOrderId
     * @param relType
     */
    private void createRelInfo(UocReceiveItInspOrderNoItemReqBo reqBo, Long inspOrderId, Integer relType) {
        UocOrderRel createOrderRel = new UocOrderRel();
        //设置数据id
        createOrderRel.setId(IdUtil.nextId());
        //设置关联状态
        createOrderRel.setRelStatus(UocDicConstant.REL_STATUS.UN_SUBMITTED);
        //设置关联类型
        createOrderRel.setRelType(relType);
        //设置订单ID
        createOrderRel.setOrderId(reqBo.getOrderId());
        //设置关联对象id
        createOrderRel.setObjId(inspOrderId);
        //设置关联对象类型
        createOrderRel.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        this.iUocOrderModel.createRelInfo(createOrderRel);
    }

    /**
     * 参数校验
     *
     * @param reqBo
     */
    private void verifyParam(UocReceiveItInspOrderNoItemReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }
        if (null == reqBo.getInspOperId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参验收人ID为空");
        }
    }

    /**
     * 查询销售单信息
     * @param reqBo
     * @return
     */
    private UocSaleOrderDo querySaleOrderMainInfo(UocReceiveItInspOrderNoItemReqBo reqBo){
        UocSaleOrderQryBo uocSaleOrderQryBo = UocRu.js(reqBo, UocSaleOrderQryBo.class);
        UocSaleOrderDo saleOrderMainInfo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        if (null != saleOrderMainInfo) {
            //查询明细
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            uocSaleOrderItemQryBo.setOrderId(saleOrderMainInfo.getOrderId());
            UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
            if (null != uocSaleOrderDo && !CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
                //先排序再赋值（为计算预估最后一条数量使用）
                saleOrderMainInfo.setSaleOrderItems(uocSaleOrderDo.getSaleOrderItems().stream().sorted(Comparator.comparing(UocSaleOrderItem::getSaleOrderItemId))
                        .collect(Collectors.toList()));
            } else {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "获取销售明细为空");
            }
            return saleOrderMainInfo;
        } else {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "获取销售订单主体信息为空");
        }
    }
    /**
     * 查询销售的ID对应的销售单明细
     *
     * @param reqBo
     * @return
     */
    private List<UocSaleOrderItem> getSaleOrderItemInfos(UocReceiveItInspOrderNoItemReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        //设置销售单id
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        //设置订单id
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
        if (null != uocSaleOrderDo && !CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            return uocSaleOrderDo.getSaleOrderItems();
        } else {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "获取销售明细为空");
        }
    }
}


