package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocObjNoConstants;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.*;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.service.domainservice.UocMsgSplitOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocMoneyUtil;
import com.tydic.dyc.oc.utils.UocOrderPropertiesUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

@Component
@Slf4j
public class UocMsgSplitOrderTransaction{
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Autowired
    private IUocCommonModel iUocCommonModel;
    
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    
    @Autowired
    private UocCommonRepository uocCommonRepository;
    
    @Value("${shipOerId:1}")
    private String shipOperId;
    
    @Value("${shipOerName:admin}")
    private String shipOperName;

    @Value("${SPLIT_ORDER_SUPPLIER_IDS:100055,100054,100057}")
    private List<String> splitOrderSupplierIds;
    
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocMsgSplitOrderRspBo splitOrder(UocMsgSplitOrderReqBo reqBo) {
        UocMsgSplitOrderRspBo rspBo = UocRu.success(UocMsgSplitOrderRspBo.class);
        //查询销售订单信息
        UocSaleOrderDo uocSaleOrderDo = qrySale(reqBo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "订单拆单通知业务失败：未查询到销售订单信息!");
        }
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        taskInstQryBo.setObjId(uocSaleOrderDo.getSaleOrderId());
        taskInstQryBo.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        //查询订单任务实例
        List<UocOrderTaskInst> taskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        
        if (ObjectUtil.isEmpty(taskInsts)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "订单拆单通知业务失败：未查询到任务表信息!");
        }
        
        taskInsts = taskInsts.stream().sorted(Comparator.comparing(UocOrderTaskInst::getCreateTime).reversed()).collect(Collectors.toList());
        
        log.info("父单的流程数据：{}", JSON.toJSONString(taskInsts));
        if (ObjectUtil.isNotEmpty(taskInsts)) {
            rspBo.setTaskInstId(taskInsts.get(0).getTaskInstId());
            rspBo.setStepId(taskInsts.get(0).getProcState());
            rspBo.setProcInstId(taskInsts.get(0).getProcInstId());
        }
        int count = 0;
        UocGetJDSplitOrderBO uocGetJDSplitOrderBO = reqBo.getUocGetJDSplitOrderBO();
        if (ObjectUtil.isEmpty(uocGetJDSplitOrderBO)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "订单拆单通知业务失败：没有拆单消息!");
        }
        //子单列表
        List<UocChildSaleOrderBO> childSaleOrderBOList = uocGetJDSplitOrderBO.getCOrder();
        
        //查询到外部子单id
        List<String> outId = new ArrayList<>();
        for (UocChildSaleOrderBO orderBO : childSaleOrderBOList) {
            if(ObjectUtil.isNotEmpty(orderBO.getJdOrderId())){
                outId.add(String.valueOf(orderBO.getJdOrderId()));
            }
            if(ObjectUtil.isNotEmpty(orderBO.getOrderId())){
                outId.add(String.valueOf(orderBO.getOrderId()));
            }
        }
        // 该逻辑去掉，否则京东会有订单积压
//        while (iterator.hasNext()) {
//            UocChildSaleOrderBO uocChildSaleOrderBO =  iterator.next();
//            if(!(uocChildSaleOrderBO.getJdOrderState() >= 7)){
//                throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR,"订单拆单通知业务失败：有子订单没有完成拆单，不予进行操作!");
//            }
//        }
        List<UocCreateOrderServiceRspSaleOrderBo> saleOrderList = new ArrayList<>();
        
        UocOrderQueryIndexQryBo qryBo = new UocOrderQueryIndexQryBo();
        qryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        qryBo.setOrderId(uocSaleOrderDo.getOrderId());
        List<UocOrderQueryIndex> queryIndexList = iUocOrderModel.qryOrderQueryIndexList(qryBo);
        log.info("外部关联数据：{}",JSON.toJSONString(queryIndexList));
        //过滤掉非京东的订单
        queryIndexList = queryIndexList.stream().filter(e -> {
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setOrderId(e.getOrderId());
            uocSaleOrderQryBo.setSaleOrderId(e.getObjId());
            UocSaleOrderDo uocSaleOrderDo1 = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
            //父单号不等于当前的销售单号 过滤掉
            Long upperOrderId = uocSaleOrderDo1.getUpperOrderId();
            if(splitOrderSupplierIds.contains(uocSaleOrderDo1.getStakeholder().getSupId())){
//            if("100055".equals(uocSaleOrderDo1.getStakeholder().getSupId()) || "100057".equals(uocSaleOrderDo1.getStakeholder().getSupId())){
                if(upperOrderId == null){
                    // upperOrderId为空说明是第一个父单
                    if(!reqBo.getDycUocQryMsgBO().getObjId().equals(uocSaleOrderDo1.getSaleOrderId())){
                        //如果不等，说明这个query表的这个记录不是消息表中对应的销售单
                        return false;
                    }
                } else if(!reqBo.getDycUocQryMsgBO().getObjId().equals(upperOrderId)){
                    return  false;
                }
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        
        List<String> outNo = new ArrayList<>();
        for (UocOrderQueryIndex idx : queryIndexList) {
            outNo.add(idx.getOutObjId());
            if (!outId.contains(idx.getOutObjId())) {
                UocSaleOrderDo uocSaleOrderDo1 = new UocSaleOrderDo();
                uocSaleOrderDo1.setOrderId(idx.getOrderId());
                uocSaleOrderDo1.setSaleOrderId(idx.getObjId());
                uocSaleOrderDo1.setSaleOrderState(UocStateConstants.SaleOrder.XS_SPLIT);
                try {
                    //如果该销售单拆过单，则更新状态为已拆单. TODO 这里需要同步es
                    iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo1);
                    
                    UocOrderProcInstQryBo instQryBo = new UocOrderProcInstQryBo();
                    instQryBo.setOrderId(idx.getOrderId());
                    instQryBo.setObjId(idx.getObjId());
                    List<UocOrderProcInst> uocOrderProcInstList = iUocOrderModel.qryOrderProcInstList(instQryBo);
//                    uocSaleOrderDo1.setProcInstId(uocOrderProcInstList.get(0).getProcInstId());
                    saleOrderList.add(UocRu.js(uocSaleOrderDo1, UocCreateOrderServiceRspSaleOrderBo.class));
                } catch (Exception ignored) {
                    log.error("二次拆单的订单处理失败:" + JSON.toJSONString(idx));
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "二次拆单的订单处理失败!");
                }
            }
        }

        log.info("待生成的子单列表：{}",JSON.toJSONString(childSaleOrderBOList));

        List<Long> shipOrderIdList = new ArrayList<>();

        //定义销售单创建业务对象集合
        List<UocCreateOrdByOrdSplitBO> uocCreateOrdByOrdSplitBOList = new ArrayList<>(1);

        for (UocChildSaleOrderBO childSaleOrderRspBO : childSaleOrderBOList) {
            
            if (outNo.contains(childSaleOrderRspBO.getOrderId())) {
                continue;
            }

            UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO = new UocCreateOrdByOrdSplitBO();
            uocCreateOrdByOrdSplitBO.setUocChildSaleOrderBO(childSaleOrderRspBO);
            uocCreateOrdByOrdSplitBO.setOrderId(uocSaleOrderDo.getOrderId());
            uocCreateOrdByOrdSplitBO.setSaleId(uocSaleOrderDo.getSaleOrderId());
            uocCreateOrdByOrdSplitBO.setCount(count);

            //添加到销售单创建业务对象集合
            uocCreateOrdByOrdSplitBOList.add(uocCreateOrdByOrdSplitBO);

            count++;
        }

        //判断销售单创建业务对象集合不为空
        if (!CollectionUtils.isEmpty(uocCreateOrdByOrdSplitBOList)) {
            //定义拆单已占用运费
            BigDecimal splitOrderOccupyTotalTransFee = new BigDecimal("0");

            for (int i = 0; i < uocCreateOrdByOrdSplitBOList.size(); i++) {
                UocCreateOrderServiceRspSaleOrderBo serviceRspSaleOrderBo = new UocCreateOrderServiceRspSaleOrderBo();

                UocSplitCoreOrderBo uocSplitCoreOrderBo = splitCoreOrder(uocCreateOrdByOrdSplitBOList.get(i), i + 1, uocCreateOrdByOrdSplitBOList.size(), splitOrderOccupyTotalTransFee);

                //设置拆单已占用运费
                splitOrderOccupyTotalTransFee = uocSplitCoreOrderBo.getSplitOccupyTotalTransFee();

                serviceRspSaleOrderBo.setSaleOrderId(uocSplitCoreOrderBo.getNewSaleOrderId());
                serviceRspSaleOrderBo.setOrderId(uocSaleOrderDo.getOrderId());

                saleOrderList.add(serviceRspSaleOrderBo);

                String supNo = String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo());

                if(UocOrderPropertiesUtil.getProperty("SUPPLIER_SUNING_ID").equals(supNo)){
                    log.info("生成苏宁发货单,对应销售单id：{}",serviceRspSaleOrderBo.getSaleOrderId());
                    Long shipOrderId = ceateCoreShip(serviceRspSaleOrderBo);
                    shipOrderIdList.add(shipOrderId);
                }
            }
        }
        
        //组装返回参数
        rspBo.setOrderId(uocSaleOrderDo.getOrderId());
        rspBo.setSaleOrderList(saleOrderList);
        rspBo.setShipOrderIdList(shipOrderIdList);
        Iterator<UocChildSaleOrderBO> iterator = childSaleOrderBOList.iterator();
        
        Boolean splitOver = true;
        if(UocOrderPropertiesUtil.getProperty("SUPPLIER_JD_ID").equals(String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo()))){
            while (iterator.hasNext()) {
                UocChildSaleOrderBO uocChildSaleOrderBO = iterator.next();
                if (!(uocChildSaleOrderBO.getJdOrderState() >= 7)) {
                    splitOver = false;
                }
            }
        }
        if (splitOver || "E0006".equalsIgnoreCase(taskInsts.get(0).getProcState())) {
            UocCommonDo uocCommonDo = new UocCommonDo();
            List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(rspBo.getTaskInstId());//e0006 （父单）
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(11111L);
            uocCommonDo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
            log.info("拆单流转原订单的任务,{}", JSON.toJSONString(uocCommonDo));
            iUocCommonModel.dealTask(uocCommonDo);
        }
        
        
        //处理完拆单消息后更新msgPool中的执行状态为已执行
//        UocDMsgPoolQryBo qryBo1 = new UocDMsgPoolQryBo();
//        qryBo1.setId(reqBo.getDycUocQryMsgBO().getId());
//        qryBo1.setRunResult(1);//执行成功
//        iUocOrderModel.updateMsgPoolById(qryBo1);
        return rspBo;
    }
    /*
     * @Author lsl
     * @Description //TODO 生成苏宁发货单
     * @Date 15:41 2023/9/12
     * @Param [uocShipOrderQryBo]
     * @return java.lang.Long
     */
    public Long ceateCoreShip(UocCreateOrderServiceRspSaleOrderBo reqBo){
        
        Long shipOrderId = IdUtil.nextId();
        log.info("发货单id：{}",shipOrderId);
        UocSaleOrderQryBo saleOrderQryBo = new UocSaleOrderQryBo();
        
        saleOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        saleOrderQryBo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(saleOrderQryBo);
    
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        List<UocSaleOrderItem>  saleOrderItemInfos =iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        
        //更新销售单状态
        uocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_FH_FHZ);
        iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        
        //更新销售单明细发货数量
        UocSaleOrderDo convertSaleOrderDo = new UocSaleOrderDo();
        convertSaleOrderDo.setOrderId(reqBo.getOrderId());
        convertSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItems = new ArrayList<>();
        for (UocSaleOrderItem item: saleOrderItemInfos){
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setSaleOrderItemId(item.getSaleOrderItemId());
            uocSaleOrderItem.setSendCount(item.getPurchaseCount());
            saleOrderItems.add(uocSaleOrderItem);
        }
        convertSaleOrderDo.setSaleOrderItems(saleOrderItems);
        iUocSaleOrderModel.modifyBatchItemSendCount(convertSaleOrderDo);
        
        //生成发货单外部关联表数据
        UocOrderQueryIndex uocOrderQueryIndex = new UocOrderQueryIndex();
        uocOrderQueryIndex.setObjId(shipOrderId);
        uocOrderQueryIndex.setOrderSystem(UocDicConstant.OBJ_TYPE.SHIP.toString());
        uocOrderQueryIndex.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        uocOrderQueryIndex.setOutObjId(uocSaleOrderDo.getSaleOrderNoExt());
        uocOrderQueryIndex.setOrderId(uocSaleOrderDo.getOrderId());
        uocOrderQueryIndex.setId(IdUtil.nextId());
        iUocCommonModel.saveOrderQueryIndex(uocOrderQueryIndex);
        
        
        //组装发货单信息
        UocShipOrderDo createShipOrderDo = JSONObject.parseObject(JSON.toJSONString(reqBo),UocShipOrderDo.class);
        //设置发货单状态
        createShipOrderDo.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_FH);
        //设置发货人id
        createShipOrderDo.setShipOperId(shipOperId);
        //设置发货单创建人
        createShipOrderDo.setCreateOperId(shipOperId);
        //设置发货单创建时间
        createShipOrderDo.setCreateTime(new Date());
        //设置发货单id
        createShipOrderDo.setShipOrderId(shipOrderId);
        //设置供应商id
        createShipOrderDo.setSupNo(saleOrderItemInfos.get(0).getSupplierId());
        //设置发货单编号
        //生成发货单编号
        String shipOrderNo = this.getShipOrderNo(uocSaleOrderDo.getOrderSource());
        createShipOrderDo.setShipOrderNo(shipOrderNo);
        //外部发货单编号
        createShipOrderDo.setShipOrderNoExt(uocSaleOrderDo.getSaleOrderNoExt());
        //设置发货单明细
        List<UocShipOrderItem> uocShipOrderItemList = new ArrayList<>();
        saleOrderItemInfos.forEach(uocSaleOrderItem -> {
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            Long shipOrderItemId = IdUtil.nextId();
            
            uocShipOrderItem.setShipOrderItemId(shipOrderItemId);
            uocShipOrderItem.setSendCount(uocSaleOrderItem.getPurchaseCount());
            //设置发货单id
            uocShipOrderItem.setShipOrderId(shipOrderId);
            //设置订单id
            uocShipOrderItem.setOrderId(reqBo.getOrderId());
            //设置销售单id
            uocShipOrderItem.setSaleOrderId(reqBo.getSaleOrderId());
            //设置销售单明细id
            uocShipOrderItem.setSaleOrderItemId(uocSaleOrderItem.getSaleOrderItemId());
            //设置计量单位
            uocShipOrderItem.setUnitName(uocSaleOrderItem.getUnitName());
            //设置创建人id
            uocShipOrderItem.setCreateOperId(shipOperId);
            //设置创建时间
            uocShipOrderItem.setCreateTime(new Date());
            //设置发货单明细id
            uocShipOrderItem.setShipOrderItemId(IdUtil.nextId());
            uocShipOrderItemList.add(uocShipOrderItem);
        });
        createShipOrderDo.setShipOrderItemBoList(uocShipOrderItemList);
        //创建发货单和发货单明细
        iUocShipOrderModel.createShipOrder(createShipOrderDo);
        
        
        return shipOrderId;
    }
    
    /**
     * 获取发货单编号
     * @param orderSource
     * @return
     */
    private String getShipOrderNo(Integer orderSource){
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderSource(orderSource);
        uocShipOrderDo = this.iUocShipOrderModel.getShipOrderNo(uocShipOrderDo);
        if(null != uocShipOrderDo){
            return uocShipOrderDo.getShipOrderNo();
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "生成发货单编号失败");
        }
    }
    
    /*
     * @Author lsl
     * @Description //TODO 查询销售订单信息
     * @Date 16:36 2022/4/12
     * @Param [reqBo]
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    public UocSaleOrderDo qrySale(UocMsgSplitOrderReqBo reqBo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBo.getDycUocQryMsgBO().getObjId());
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }
    
    /*
     * @Author lsl
     * @Description //TODO 拆单核心服务
     * @Date 11:29 2022/4/13
     * @Param [orderId, saleOrderId, childSaleOrderRspBO, count]
     * @return void
     */
    public UocSplitCoreOrderBo splitCoreOrder(UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO, int nowSortNum, int totalSortLength, BigDecimal splitOccupyTotalTransFee) {

        UocSplitCoreOrderBo uocSplitCoreOrderBo = new UocSplitCoreOrderBo();

//        buildSaleAndItemParam(uocCreateOrdByOrdSplitBO);
        //外部子订单信息
        UocChildSaleOrderBO childSaleOrderRspBO = uocCreateOrdByOrdSplitBO.getUocChildSaleOrderBO();
        Long totalFee = 0L;
        Long freight = null;
        Long newSaleOrderId = IdUtil.nextId();
        try {
            //订单总金额（不含运费）
            totalFee = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getOrderPrice());
            //运费
            freight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getFreight());
            if (freight == null) {
                freight = 0L;
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("通过拆单创建子订单时异常：转换订单费用错误!");
        }
        
        UocSaleOrderQryBo uocSaleOrderBo = new UocSaleOrderQryBo();
        uocSaleOrderBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        uocSaleOrderBo.setSaleOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
        UocSaleOrderDo saleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderBo);
        //新销售订单id
        saleOrderDo.setSaleOrderId(newSaleOrderId);
        //父销售订单id（原销售订单id）
        saleOrderDo.setUpperOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
//        saleOrderDo.setSaleOrderNo(saleOrderDo.getSaleOrderNo() + "-" +  uocCreateOrdByOrdSplitBO.getCount());
//        saleOrderDo.setSaleOrderNoExt(String.valueOf(childSaleOrderRspBO.getOrderId()));
        if(ObjectUtil.isNotEmpty(childSaleOrderRspBO.getJdOrderId())){
            saleOrderDo.setSaleOrderNoExt(String.valueOf(childSaleOrderRspBO.getJdOrderId()));
        }
        if(ObjectUtil.isNotEmpty(childSaleOrderRspBO.getOrderId())){
            saleOrderDo.setSaleOrderNoExt(String.valueOf(childSaleOrderRspBO.getOrderId()));
        }
        
        try {
            saleOrderDo.setTotalSaleFee(MoneyUtils.Long2BigDecimal(totalFee));
            saleOrderDo.setTotalPurchaseFee(MoneyUtils.Long2BigDecimal(totalFee));
            saleOrderDo.setTotalTransFee(MoneyUtils.Long2BigDecimal(freight));
        } catch (Exception e) {
            e.printStackTrace();
            log.error("通过拆单创建子订单时异常：转换订单费用错误!");
        }
        //销售单明细表
        List<UocOrderSkuBO> exSkuList = childSaleOrderRspBO.getSku(); //外部单品列表
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
        List<UocSaleOrderItem> saleItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        List<UocSaleOrderItem> newSaleItemList = new ArrayList<>();
        BigDecimal totalSaleFee = BigDecimal.ZERO;
        for (UocSaleOrderItem saleOrderItem : saleItemList) {
            Long newSaleOrderItemId = IdUtil.nextId();
            for (UocOrderSkuBO extSkuBo : exSkuList) {
//                if(saleOrderItem.getSkuExtSkuId().equals(extSkuBo.getSkuId())){
//                    saleOrderItem.setPurchaseCount(new BigDecimal(extSkuBo.getNum()));
//                }
                if (saleOrderItem.getSkuExtSkuId().equals(extSkuBo.getSkuId())) {
                    UocSaleOrderItem newUocSaleOrderItem = JSONObject.parseObject(JSON.toJSONString(saleOrderItem), UocSaleOrderItem.class);
                    newUocSaleOrderItem.setPurchaseCount(new BigDecimal(extSkuBo.getNum()));
                    newUocSaleOrderItem.setSaleOrderId(newSaleOrderId);
                    newUocSaleOrderItem.setSaleOrderItemId(newSaleOrderItemId);
                    
                    //销售单明细扩展
                    UocSaleItemMapQryBo uocSaleItemMapQryBo = new UocSaleItemMapQryBo();
                    uocSaleItemMapQryBo.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                    List<UocSaleItemMap> saleItemMapList =  iUocSaleOrderModel.getSaleOrderItemMapList(uocSaleItemMapQryBo);
                    
                    List<UocSaleItemMap> newSaleItemMapList  = new ArrayList<>();
                    for (UocSaleItemMap saleItemMap:saleItemMapList){
                        UocSaleItemMap newSaleItemMap = JSONObject.parseObject(JSON.toJSONString(saleItemMap),UocSaleItemMap.class);
                        
                        newSaleItemMap.setId(IdUtil.nextId());
                        newSaleItemMap.setSaleOrderItemId(newSaleOrderItemId);
                        newSaleItemMap.setSaleOrderId(newSaleOrderId);
                        newSaleItemMap.setCreateTime(new Date());
                        newSaleItemMapList.add(newSaleItemMap);
                    }
                    //子销售单明细扩展
                    newUocSaleOrderItem.setSaleItemMapList(newSaleItemMapList);
                    
                    newSaleItemList.add(newUocSaleOrderItem);
                    totalSaleFee = totalSaleFee.add(newUocSaleOrderItem.getSaleFee());
                }
            }
        }
        saleOrderDo.setSaleOrderItems(newSaleItemList);
//        saleOrderDo.setTotalSaleFee(totalSaleFee);
        Integer isJdCz = 2;
        //如果京东的子订单接口返回orderType = 5 ,代表厂家直送订单
        if (ObjectUtil.isNotEmpty(childSaleOrderRspBO.getOrderType()) && childSaleOrderRspBO.getOrderType() == 5) {
            isJdCz = 1;
        }
        saleOrderDo.setJdCz(isJdCz);
        saleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_FH_DFH);
        
        //查询父单扩展表
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
        //父销售单id
        uocSaleOrderMapQryBo.setSaleOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
        
        List<UocSaleOrderMap> saleOrderMapList =  iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
        
        List<UocSaleOrderMap> newSaleOrderMapList = new ArrayList<>();
        for (UocSaleOrderMap saleOrderMap:saleOrderMapList){
            UocSaleOrderMap newSaleOrderMap = JSONObject.parseObject(JSON.toJSONString(saleOrderMap),UocSaleOrderMap.class);
            
            newSaleOrderMap.setId(IdUtil.nextId());
            newSaleOrderMap.setCreateTime(new Date());
            //子销售单id
            newSaleOrderMap.setSaleOrderId(newSaleOrderId);
            newSaleOrderMapList.add(newSaleOrderMap);
        }
        // 子销售单扩展表
        saleOrderDo.setSaleOrderMapList(newSaleOrderMapList);
        saleOrderDo.setSplitCreateOrder(true);
        
        //查询父销售单附件
        UocOrderAccessoryQryBo accessoryQryBo = new UocOrderAccessoryQryBo();
        accessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        accessoryQryBo.setObjId(uocCreateOrdByOrdSplitBO.getSaleId());
        accessoryQryBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        
        List<UocOrderAccessory> accessoryList = iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        saleOrderDo.setSaleOrderAccessoryList(accessoryList);
        saleOrderDo.setSaleOrderNo(genRequestCode(saleOrderDo));

        //调用计算拆单运费
        this.computeSplitOrderTransFee(uocSplitCoreOrderBo, uocCreateOrdByOrdSplitBO, saleOrderDo, nowSortNum, totalSortLength, splitOccupyTotalTransFee);

        iUocSaleOrderModel.createSaleOrder(saleOrderDo);
        
        UocOrderQueryIndex uocOrderQueryIndex = new UocOrderQueryIndex();
        uocOrderQueryIndex.setObjId(newSaleOrderId);
        uocOrderQueryIndex.setOrderSystem(UocDicConstant.OBJ_TYPE.SALE.toString());
        uocOrderQueryIndex.setObjType(UocDicConstant.OBJ_TYPE.SALE);
//        uocOrderQueryIndex.setOutObjId(String.valueOf(childSaleOrderRspBO.getOrderId()));
        if(ObjectUtil.isNotEmpty(childSaleOrderRspBO.getJdOrderId())){
            uocOrderQueryIndex.setOutObjId(String.valueOf(childSaleOrderRspBO.getJdOrderId()));
        }
        if(ObjectUtil.isNotEmpty(childSaleOrderRspBO.getOrderId())){
            uocOrderQueryIndex.setOutObjId(String.valueOf(childSaleOrderRspBO.getJdOrderId()));
        }
        uocOrderQueryIndex.setOrderId(saleOrderDo.getOrderId());
        uocOrderQueryIndex.setId(IdUtil.nextId());
        iUocCommonModel.saveOrderQueryIndex(uocOrderQueryIndex);
        
        //销毁父订单
        try {
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setSaleOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
            uocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_SPLIT);
            uocSaleOrderDo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
            iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        } catch (Exception e) {
            log.error("拆单失败:删除父订单异常!:" + e.getMessage());
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "拆单失败:删除父订单异常!");
            
        }

        //设置新销售单ID
        uocSplitCoreOrderBo.setNewSaleOrderId(newSaleOrderId);
        
        return uocSplitCoreOrderBo;
    }

    /**
     * 计算拆单运费
     */
    private void computeSplitOrderTransFee(UocSplitCoreOrderBo uocSplitCoreOrderBo, UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO, UocSaleOrderDo saveUocSaleOrderDo, int nowSortNum, int totalSortLength, BigDecimal splitOccupyTotalTransFee) {
        //定义查询销售单主体参数
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        //设置订单ID
        uocSaleOrderQryBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        //设置销售单ID
        uocSaleOrderQryBo.setSaleOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
        //调用查询销售单主体
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);

        //定义查询销售单明细参数
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        //设置订单ID
        uocSaleOrderItemQryBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        //设置销售单ID
        uocSaleOrderItemQryBo.setSaleOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
        //调用查询销售单明细
        List<UocSaleOrderItem> uocSaleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);

        //获取原始销售单 单品ID Vs 销售单明细 Map
        Map<String, UocSaleOrderItem> skuIdVsSaleOrderItemMap = uocSaleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSkuId, po -> po, (k1, k2) -> k2));

        //获取原始销售单明细 所有商品总重量
        BigDecimal allTotalGoodsWeight = uocSaleOrderItemList.stream().map(UocSaleOrderItem::getTotalGoodsWeight).reduce(BigDecimal.ZERO, BigDecimal::add);

        //遍历拆单后的销售单
        for (UocSaleOrderItem saleOrderItem : saveUocSaleOrderDo.getSaleOrderItems()) {
            //获取当前单品原始销售单明细
            UocSaleOrderItem uocSaleOrderItem = skuIdVsSaleOrderItemMap.get(saleOrderItem.getSkuId());

            //设置商品重量
            uocSaleOrderItem.setGoodsWeight(uocSaleOrderItem.getGoodsWeight());

            //计算商品总重量
            BigDecimal totalGoodsWeight = uocSaleOrderItem.getGoodsWeight().multiply(uocSaleOrderItem.getPurchaseCount()).setScale(2, RoundingMode.HALF_UP);

            //设置商品总重量
            uocSaleOrderItem.setTotalGoodsWeight(totalGoodsWeight);
        }

        //设置原始父订单编号
        saveUocSaleOrderDo.setOldParentOrderCode(uocSaleOrderDo.getSaleOrderNo());

        //判断是否没有运费
        if (uocSaleOrderDo.getTotalTransFee().compareTo(BigDecimal.ZERO) == 0) {
            //设置运费
            saveUocSaleOrderDo.setTotalTransFee(BigDecimal.ZERO);

            //设置拆单已占用运费
            uocSplitCoreOrderBo.setSplitOccupyTotalTransFee(BigDecimal.ZERO);

            return;
        }

        //判断是否只有一个拆单
        if (totalSortLength == 1) {
            //设置运费 = 原始运费
            saveUocSaleOrderDo.setTotalTransFee(uocSaleOrderDo.getTotalTransFee());

            //设置拆单已占用运费
            uocSplitCoreOrderBo.setSplitOccupyTotalTransFee(uocSaleOrderDo.getTotalTransFee());

            return;
        }

        //判断是否是最后一个拆单
        if (nowSortNum == totalSortLength) {
            //设置运费 = 原始运费 - 已占用运费
            BigDecimal totalTransFee = uocSaleOrderDo.getTotalTransFee().subtract(splitOccupyTotalTransFee).setScale(2, RoundingMode.HALF_UP);

            //设置运费
            saveUocSaleOrderDo.setTotalTransFee(totalTransFee);

            //设置拆单已占用运费
            uocSplitCoreOrderBo.setSplitOccupyTotalTransFee(splitOccupyTotalTransFee.add(totalTransFee));

            return;
        }


        //获取拆单后的销售单明细 所有商品总重量
        BigDecimal allSplitTotalGoodsWeight = saveUocSaleOrderDo.getSaleOrderItems().stream().map(UocSaleOrderItem::getTotalGoodsWeight).reduce(BigDecimal.ZERO, BigDecimal::add);

        //计算运费 = 原始运费 / 所有商品总重量 * 拆单后所有商品总重量
        BigDecimal totalTransFee = uocSaleOrderDo.getTotalTransFee().divide(allTotalGoodsWeight, 2, RoundingMode.HALF_UP).multiply(allSplitTotalGoodsWeight).setScale(2, RoundingMode.HALF_UP);

        //设置运费
        saveUocSaleOrderDo.setTotalTransFee(totalTransFee);

        //设置拆单已占用运费
        uocSplitCoreOrderBo.setSplitOccupyTotalTransFee(splitOccupyTotalTransFee.add(totalTransFee));

    }
    
    
    /*
     * @Author lsl
     * @Description //TODO 构建附件信息
     * @Date 17:21 2022/4/13
     * @Param
     * @return
     */
    public void buildAccessort(Long newOrderId, UocOrderDo uocOrderDo, Long orderId) {
        UocOrderAccessoryQryBo accessoryQryBo = new UocOrderAccessoryQryBo();
        accessoryQryBo.setOrderId(orderId);
        List<UocOrderAccessory> accessoryList = iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        if (ObjectUtil.isNotEmpty(accessoryList)) {
            List<UocOrderAccessory> accessories = new ArrayList<>();
            for (UocOrderAccessory accessory : accessoryList) {
                accessory.setOrderId(newOrderId);
                accessory.setId(IdUtil.nextId());
                //时间
                accessory.setCreateTime(new Date());
                if (accessory.getObjType().equals(1)) {
                    accessory.setObjId(null);
                }
                accessories.add(accessory);
            }
            uocOrderDo.setAccessoryList(accessories);
        }
    }
    
    /*
     * @Author lsl
     * @Description //TODO 构建地址联系人参数
     * @Date 17:24 2022/4/13
     * @Param
     * @return
     */
    public void buildLogisticsRelaParam(Long newOrderId, UocOrderDo uocOrderDo, Long orderId) {
        UocOrdLogisticsRelaQryBo logisticsRelaQryBo = new UocOrdLogisticsRelaQryBo();
        logisticsRelaQryBo.setOrderId(orderId);
        UocOrdLogisticsRela uocOrdLogisticsRela = iUocOrderModel.qryOrderLogisticsRela(logisticsRelaQryBo);
        if (null != uocOrdLogisticsRela) {
            uocOrdLogisticsRela.setContactId(IdUtil.nextId());
            uocOrdLogisticsRela.setOrderId(newOrderId);
        }
        uocOrderDo.setReceiverAddress(uocOrdLogisticsRela);
    }
    
    /*
     * @Author lsl
     * @Description //TODO 构建订单扩展参数
     * @Date 17:27 2022/4/13
     * @Param
     * @return
     */
    public void buildOrderMapExtParam(Long newOrderId, UocOrderDo uocOrderDo, Long orderId) {
        UocOrderMapQryBo orderMapQryBo = new UocOrderMapQryBo();
        orderMapQryBo.setOrderId(orderId);
        List<UocOrderMap> uocOrderMaps = iUocOrderModel.qryOrderMapList(orderMapQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderMaps)) {
            List<UocOrderMap> poList = new ArrayList<>();
            for (UocOrderMap orderMap : uocOrderMaps) {
                orderMap.setId(IdUtil.nextId());
                orderMap.setOrderId(newOrderId);
                poList.add(orderMap);
            }
            uocOrderDo.setOrderExt(poList);
        }
    }
    
    /*
     * @Author lsl
     * @Description //TODO 构建销售及销售明细表
     * @Date 17:30 2022/4/13
     * @Param
     * @return
     */
    public void buildSaleAndItemParam(Long newOrderId, UocSaleOrderDo saleOrderQryDo, UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO) {
        UocChildSaleOrderBO childSaleOrderRspBO = uocCreateOrdByOrdSplitBO.getUocChildSaleOrderBO();
        Long totalFee = 0L;
        Long baseFreight = null;
        Long freight = null;
        try {
            totalFee = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getOrderPrice());
            baseFreight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getBaseFreight());
            if (baseFreight == null) {
                baseFreight = 0L;
            }
            freight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getFreight());
            if (freight == null) {
                freight = 0L;
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("通过拆单创建子订单时异常：转换订单费用错误!");
        }
        
        try {
            UocSaleOrderQryBo uocSaleOrderBo = new UocSaleOrderQryBo();
            uocSaleOrderBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
            saleOrderQryDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderBo);
            saleOrderQryDo.setOrderId(newOrderId);
            saleOrderQryDo.setSaleOrderId(IdUtil.nextId());
            saleOrderQryDo.setSaleOrderNo("");
            saleOrderQryDo.setTotalSaleFee(MoneyUtils.Long2BigDecimal(totalFee));
            saleOrderQryDo.setTotalPurchaseFee(MoneyUtils.Long2BigDecimal(totalFee));
            saleOrderQryDo.setTotalTransFee(MoneyUtils.Long2BigDecimal(baseFreight));
            saleOrderQryDo.setTotalTransFee(MoneyUtils.Long2BigDecimal(baseFreight + freight));
        } catch (Exception e) {
            e.printStackTrace();
            log.error("通过拆单创建子订单时异常：转换订单费用错误!");
        }
//        saleOrderQryDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_CJ_CJ);
        
        //销售单明细表
        List<UocOrderSkuBO> exSkuList = childSaleOrderRspBO.getSku(); //外部单品列表
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        List<UocSaleOrderItem> saleItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        for (UocSaleOrderItem saleOrderItem : saleItemList) {
            Long saleOrderItemId = IdUtil.nextId();
            for (UocOrderSkuBO extSkuBo : exSkuList) {
                if (saleOrderItem.getSkuExtSkuId().equals(extSkuBo.getSkuId())) {
                    saleOrderItem.setPurchaseCount(new BigDecimal(extSkuBo.getNum()));
                }
            }
            saleOrderItem.setOrderId(newOrderId);
            saleOrderItem.setSaleOrderItemId(saleOrderItemId);
        }
        saleOrderQryDo.setSaleOrderItems(saleItemList);
    }
    
    /*
     * @Author lsl
     * @Description //TODO 构建支付配置表
     * @Date 17:35 2022/4/13
     * @Param
     * @return
     */
    public void buildPayConfig(Long newOrderId, UocSaleOrderDo saleOrderQryDo, Long orderId) {
        UocSaleOrderPayConfQryBo payConfQryBo = new UocSaleOrderPayConfQryBo();
        payConfQryBo.setOrderId(orderId);
        List<UocSaleOrderPayConf> payConfList = iUocSaleOrderModel.getSaleOrderPayConfList(payConfQryBo);
        if (ObjectUtil.isEmpty(payConfList)) {
            return;
        }
        UocSaleOrderPayConf uocSaleOrderPayConf = payConfList.get(0);
        uocSaleOrderPayConf.setId(IdUtil.nextId());
        uocSaleOrderPayConf.setOrderId(newOrderId);
        if (ObjectUtil.isNotEmpty(uocSaleOrderPayConf.getPrePayFee())) {
            BigDecimal preFee = saleOrderQryDo.getTotalSaleFee().divide(saleOrderQryDo.getTotalSaleFee(), 2, BigDecimal.ROUND_UP).
                    multiply(uocSaleOrderPayConf.getPrePayFee()).setScale(2, BigDecimal.ROUND_UP);
            preFee = preFee.multiply(new BigDecimal(10000));
            uocSaleOrderPayConf.setPrePayFee(preFee);
        }
        saleOrderQryDo.getSaleOrderPayConfList().add(uocSaleOrderPayConf);
    }
    private String genRequestCode(UocSaleOrderDo saleOrderDo) {
        return uocCommonRepository.getOrderNoSingle(UocObjNoConstants.SALE_ORDER_NO + "_" + saleOrderDo.getOrderSource());
    }
}
