/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.UocAdjustPriceService;
import com.tydic.dyc.oc.service.saleorder.bo.UocAdjustPriceItemBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocAdjustPriceReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocAdjustPriceRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocAdjustPriceService"})
public class UocAdjustPriceServiceImpl
implements UocAdjustPriceService {
    private static final Logger log = LoggerFactory.getLogger(UocAdjustPriceServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @PostMapping(value={"dealAdjustPrice"})
    public UocAdjustPriceRspBO dealAdjustPrice(@RequestBody UocAdjustPriceReqBO reqBO) {
        UocAdjustPriceRspBO rspBO = new UocAdjustPriceRspBO();
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBO.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo saleOrder = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (UocDicConstant.ADJUST_OPER_TYPE.TYPE_1.equals(reqBO.getOperType())) {
            this.doSupAdjust(reqBO, saleOrder);
            this.commitTask(reqBO);
        }
        if (UocDicConstant.ADJUST_OPER_TYPE.TYPE_2.equals(reqBO.getOperType())) {
            this.doProAdjust(reqBO, saleOrder);
            this.commitTask(reqBO);
        }
        if (UocDicConstant.ADJUST_OPER_TYPE.TYPE_3.equals(reqBO.getOperType())) {
            this.doPurAdjust(reqBO, saleOrder);
            this.commitTask(reqBO);
            if (1 == reqBO.getAdjustResult()) {
                this.checkStartAudit(reqBO, rspBO);
            }
        }
        return rspBO;
    }

    private void checkStartAudit(UocAdjustPriceReqBO reqBO, UocAdjustPriceRspBO rspBO) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBO.getOrderId());
        List<UocSaleOrderDo> saleOrderList = this.iUocSaleOrderModel.getSaleOrderList(uocSaleOrderQryBo);
        Boolean allOverFlag = false;
        if (!CollectionUtils.isEmpty(saleOrderList) && saleOrderList.size() == 1) {
            allOverFlag = true;
            log.debug("allOverFlag1" + allOverFlag);
        } else {
            List withOutOwnSaleOrderList = saleOrderList.stream().filter(bo -> !bo.getSaleOrderId().equals(reqBO.getSaleOrderId())).collect(Collectors.toList());
            log.debug("allOverFlag22" + JSON.toJSONString(withOutOwnSaleOrderList));
            allOverFlag = withOutOwnSaleOrderList.stream().allMatch(bo -> "XS_SP_SPZ".equals(bo.getSaleOrderState()) || "XS_QX_QX".equals(bo.getSaleOrderState()) || "XS_XD_SB".equals(bo.getSaleOrderState()));
            log.debug("allOverFlag2" + allOverFlag);
        }
        log.debug("allOverFlag" + allOverFlag);
        if (allOverFlag.booleanValue()) {
            UocApprovalObjQryBo selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
            selectuocApprovalObjQryBo.setOrderId(reqBO.getOrderId());
            List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(selectuocApprovalObjQryBo);
            if (CollectionUtils.isEmpty(uocApprovalObjs)) {
                throw new BaseBusinessException("101005", "\u67e5\u8be2\u5ba1\u6279\u4efb\u52a1\u5bf9\u8c61\u8868\u4e3a\u7a7a\uff01");
            }
            rspBO.setAuditId(uocApprovalObjs.get(0).getAuditOrderId());
            rspBO.setAuditFlowKey(saleOrderList.get(0).getAuditFlowKey());
            rspBO.setApplicationDeptId(saleOrderList.get(0).getApplicationDeptId());
            rspBO.setApplicationType(saleOrderList.get(0).getApplicationType());
            rspBO.setPurchaseMode(saleOrderList.get(0).getPurchaseMode());
            BigDecimal totalSaleFee = saleOrderList.stream().map(UocSaleOrderDo::getTotalSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            rspBO.setTotalSaleFee(totalSaleFee);
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
            List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            BigDecimal maxGoodsSaleFee = saleOrderItemList.stream().map(UocSaleOrderItem::getSalePrice).max(BigDecimal::compareTo).get();
            rspBO.setMaxGoodsSaleFee(maxGoodsSaleFee);
        }
    }

    private void commitTask(UocAdjustPriceReqBO reqBO) {
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        task.setTaskId(reqBO.getTaskId());
        taskInfos.add(task);
        uocCommonDo.setCompleteTaskInfos(taskInfos);
        uocCommonDo.setUserId(reqBO.getUserId());
        uocCommonDo.setOrderId(reqBO.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }

    private void doPurAdjust(UocAdjustPriceReqBO reqBO, UocSaleOrderDo saleOrder) {
        if (!"XS_PUR_ADJUST".equals(saleOrder.getSaleOrderState())) {
            throw new BaseBusinessException("100001", "\u8be5\u72b6\u6001\u4e0d\u80fd\u8fdb\u884c\u91c7\u8d2d\u8c03\u4ef7");
        }
        if (0 == reqBO.getAdjustResult()) {
            this.dealRejuectAdjust(reqBO, saleOrder);
        } else {
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setOrderId(saleOrder.getOrderId());
            uocSaleOrderDo.setSaleOrderId(saleOrder.getSaleOrderId());
            uocSaleOrderDo.setAdjustPriceOperId(reqBO.getUserId().toString());
            uocSaleOrderDo.setAdjustPriceOperName(reqBO.getName());
            uocSaleOrderDo.setPurAdjustConfirmTime(new Date());
            this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        }
    }

    private void doProAdjust(UocAdjustPriceReqBO reqBO, UocSaleOrderDo saleOrder) {
        if (!"XS_PRO_ADJUST".equals(saleOrder.getSaleOrderState())) {
            throw new BaseBusinessException("100001", "\u8be5\u72b6\u6001\u4e0d\u80fd\u8fdb\u884c\u8fd0\u8425\u8c03\u4ef7");
        }
        if (0 == reqBO.getAdjustResult()) {
            this.dealRejuectAdjust(reqBO, saleOrder);
        } else {
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setOrderId(saleOrder.getOrderId());
            uocSaleOrderDo.setSaleOrderId(saleOrder.getSaleOrderId());
            uocSaleOrderDo.setAdjustPriceOperId(reqBO.getUserId().toString());
            uocSaleOrderDo.setAdjustPriceOperName(reqBO.getName());
            uocSaleOrderDo.setProAdjustTime(new Date());
            if (UocDicConstant.MODEL_SETTLE.TRADE.equals(saleOrder.getModelSettle())) {
                BigDecimal totalSaleFee = saleOrder.getTotalSaleFee();
                BigDecimal totalGoodsSaleFee = saleOrder.getTotalGoodsSaleFee();
                uocSaleOrderDo.setAdjustTotalSaleFee(totalSaleFee);
                uocSaleOrderDo.setAdjustTotalGoodsSaleFee(totalGoodsSaleFee);
                BigDecimal adjustTotalSaleFee = BigDecimal.ZERO;
                UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
                uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
                uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
                List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
                Map adjustPriceItemMap = reqBO.getUocAdjustPriceItemBOList().stream().collect(Collectors.toMap(UocAdjustPriceItemBO::getSaleOrderItemId, Function.identity()));
                UocSaleOrderDo updateSaleOrderItemDo = new UocSaleOrderDo();
                ArrayList<UocSaleOrderItem> updateSaleOrderItems = new ArrayList<UocSaleOrderItem>();
                for (UocSaleOrderItem saleOrderItem : saleOrderItemList) {
                    UocAdjustPriceItemBO uocAdjustPriceItemBO = (UocAdjustPriceItemBO)adjustPriceItemMap.get(saleOrderItem.getSaleOrderItemId());
                    UocSaleOrderItem updateSaleOrderItem = new UocSaleOrderItem();
                    updateSaleOrderItem.setOrderId(saleOrderItem.getOrderId());
                    updateSaleOrderItem.setSaleOrderId(saleOrderItem.getSaleOrderId());
                    updateSaleOrderItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                    updateSaleOrderItem.setAdjustSaleReason(uocAdjustPriceItemBO.getAdjustSaleReason());
                    updateSaleOrderItem.setAdjustSalePriceRange(uocAdjustPriceItemBO.getAdjustSalePriceRange());
                    BigDecimal salePrice = saleOrderItem.getSalePrice();
                    BigDecimal saleFee = saleOrderItem.getSaleFee();
                    updateSaleOrderItem.setAdjustSalePrice(salePrice);
                    updateSaleOrderItem.setAdjustSaleFee(saleFee);
                    BigDecimal adjustSaleFee = uocAdjustPriceItemBO.getAdjustSalePrice().multiply(saleOrderItem.getPurchaseCount()).setScale(2, RoundingMode.HALF_UP);
                    updateSaleOrderItem.setSaleFee(adjustSaleFee);
                    updateSaleOrderItem.setSalePrice(uocAdjustPriceItemBO.getAdjustSalePrice());
                    updateSaleOrderItems.add(updateSaleOrderItem);
                    adjustTotalSaleFee = adjustTotalSaleFee.add(adjustSaleFee);
                }
                updateSaleOrderItemDo.setSaleOrderItems(updateSaleOrderItems);
                this.iUocSaleOrderModel.updateSaleItemWithOutSkuId(updateSaleOrderItemDo);
                uocSaleOrderDo.setTotalGoodsSaleFee(adjustTotalSaleFee);
                uocSaleOrderDo.setTotalSaleFee(adjustTotalSaleFee.add(saleOrder.getTotalTransFee()));
            }
            this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        }
    }

    private void dealRejuectAdjust(UocAdjustPriceReqBO reqBO, UocSaleOrderDo saleOrder) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(saleOrder.getOrderId());
        uocSaleOrderDo.setSaleOrderId(saleOrder.getSaleOrderId());
        uocSaleOrderDo.setTotalTransFee(saleOrder.getAdjustTransFee());
        uocSaleOrderDo.setAdjustTransFee(null);
        uocSaleOrderDo.setAdjustTransFeeRange(null);
        uocSaleOrderDo.setAdjustTransReason(null);
        uocSaleOrderDo.setAdjustPriceOperId(reqBO.getUserId().toString());
        uocSaleOrderDo.setAdjustPriceOperName(reqBO.getName());
        uocSaleOrderDo.setSupAdjustTime(null);
        uocSaleOrderDo.setProAdjustTime(null);
        uocSaleOrderDo.setPurAdjustConfirmTime(null);
        uocSaleOrderDo.setTotalSaleFee(saleOrder.getAdjustTotalSaleFee());
        uocSaleOrderDo.setTotalPurchaseFee(saleOrder.getAdjustTotalPurchaseFee());
        uocSaleOrderDo.setAdjustTotalSaleFee(null);
        uocSaleOrderDo.setAdjustTotalPurchaseFee(null);
        uocSaleOrderDo.setTotalGoodsSaleFee(saleOrder.getAdjustTotalGoodsSaleFee());
        uocSaleOrderDo.setTotalGoodsPurchaseFee(saleOrder.getAdjustTotalGoodsPurchaseFee());
        uocSaleOrderDo.setAdjustTotalGoodsPurchaseFee(null);
        uocSaleOrderDo.setAdjustTotalGoodsSaleFee(null);
        this.iUocSaleOrderModel.modifySaleOrderAdjust(uocSaleOrderDo);
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        UocSaleOrderDo updateSaleOrderItemDo = new UocSaleOrderDo();
        ArrayList<UocSaleOrderItem> updateSaleOrderItems = new ArrayList<UocSaleOrderItem>();
        for (UocSaleOrderItem saleOrderItem : saleOrderItemList) {
            UocSaleOrderItem updateSaleOrderItem = new UocSaleOrderItem();
            updateSaleOrderItem.setOrderId(saleOrderItem.getOrderId());
            updateSaleOrderItem.setSaleOrderId(saleOrderItem.getSaleOrderId());
            updateSaleOrderItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            updateSaleOrderItem.setAdjustSaleReason(null);
            updateSaleOrderItem.setAdjustSalePriceRange(null);
            updateSaleOrderItem.setAdjustPurchaseReason(null);
            updateSaleOrderItem.setAdjustPurchasePriceRange(null);
            updateSaleOrderItem.setPurchasePrice(saleOrderItem.getAdjustPurchasePrice());
            updateSaleOrderItem.setSalePrice(saleOrderItem.getAdjustSalePrice());
            updateSaleOrderItem.setAdjustSalePrice(null);
            updateSaleOrderItem.setAdjustPurchasePrice(null);
            updateSaleOrderItem.setPurchaseFee(saleOrderItem.getAdjustPurchaseFee());
            updateSaleOrderItem.setSaleFee(saleOrderItem.getAdjustSaleFee());
            updateSaleOrderItem.setAdjustSaleFee(null);
            updateSaleOrderItem.setAdjustPurchaseFee(null);
            updateSaleOrderItems.add(updateSaleOrderItem);
        }
        updateSaleOrderItemDo.setSaleOrderItems(updateSaleOrderItems);
        this.iUocSaleOrderModel.updateSaleItemAdjust(updateSaleOrderItemDo);
    }

    private void doSupAdjust(UocAdjustPriceReqBO reqBO, UocSaleOrderDo saleOrder) {
        if (!"XS_SUP_ADJUST".equals(saleOrder.getSaleOrderState())) {
            throw new BaseBusinessException("100001", "\u8be5\u72b6\u6001\u4e0d\u80fd\u8fdb\u884c\u4f9b\u5e94\u5546\u8c03\u4ef7");
        }
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(saleOrder.getOrderId());
        uocSaleOrderDo.setSaleOrderId(saleOrder.getSaleOrderId());
        BigDecimal totalTransFee = saleOrder.getTotalTransFee();
        uocSaleOrderDo.setTotalTransFee(reqBO.getAdjustTransFee());
        uocSaleOrderDo.setAdjustTransFee(totalTransFee);
        uocSaleOrderDo.setAdjustTransFeeRange(reqBO.getAdjustTransFeeRange());
        uocSaleOrderDo.setAdjustTransReason(reqBO.getAdjustTransReason());
        uocSaleOrderDo.setAdjustPriceOperId(reqBO.getUserId().toString());
        uocSaleOrderDo.setAdjustPriceOperName(reqBO.getName());
        uocSaleOrderDo.setSupAdjustTime(new Date());
        BigDecimal totalPurchaseFee = saleOrder.getTotalPurchaseFee();
        BigDecimal totalGoodsPurchaseFee = saleOrder.getTotalGoodsPurchaseFee();
        uocSaleOrderDo.setAdjustTotalPurchaseFee(totalPurchaseFee);
        uocSaleOrderDo.setAdjustTotalGoodsPurchaseFee(totalGoodsPurchaseFee);
        if (UocDicConstant.MODEL_SETTLE.MATCH.equals(saleOrder.getModelSettle())) {
            uocSaleOrderDo.setAdjustTotalSaleFee(totalPurchaseFee);
            uocSaleOrderDo.setAdjustTotalGoodsSaleFee(totalGoodsPurchaseFee);
        }
        BigDecimal adjustTotalPurchaseFee = BigDecimal.ZERO;
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        Map adjustPriceItemMap = reqBO.getUocAdjustPriceItemBOList().stream().collect(Collectors.toMap(UocAdjustPriceItemBO::getSaleOrderItemId, Function.identity()));
        UocSaleOrderDo updateSaleOrderItemDo = new UocSaleOrderDo();
        ArrayList<UocSaleOrderItem> updateSaleOrderItems = new ArrayList<UocSaleOrderItem>();
        for (UocSaleOrderItem saleOrderItem : saleOrderItemList) {
            UocAdjustPriceItemBO uocAdjustPriceItemBO = (UocAdjustPriceItemBO)adjustPriceItemMap.get(saleOrderItem.getSaleOrderItemId());
            UocSaleOrderItem updateSaleOrderItem = new UocSaleOrderItem();
            updateSaleOrderItem.setOrderId(saleOrderItem.getOrderId());
            updateSaleOrderItem.setSaleOrderId(saleOrderItem.getSaleOrderId());
            updateSaleOrderItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            updateSaleOrderItem.setAdjustPurchaseReason(uocAdjustPriceItemBO.getAdjustPurchaseReason());
            updateSaleOrderItem.setAdjustPurchasePriceRange(uocAdjustPriceItemBO.getAdjustPurchasePriceRange());
            BigDecimal purchasePrice = saleOrderItem.getPurchasePrice();
            BigDecimal purchaseFee = saleOrderItem.getPurchaseFee();
            updateSaleOrderItem.setAdjustPurchasePrice(purchasePrice);
            updateSaleOrderItem.setAdjustPurchaseFee(purchaseFee);
            if (UocDicConstant.MODEL_SETTLE.MATCH.equals(saleOrder.getModelSettle())) {
                updateSaleOrderItem.setAdjustSalePrice(purchasePrice);
                updateSaleOrderItem.setAdjustSaleFee(purchaseFee);
                updateSaleOrderItem.setAdjustSaleReason(uocAdjustPriceItemBO.getAdjustPurchaseReason());
                updateSaleOrderItem.setAdjustSalePriceRange(uocAdjustPriceItemBO.getAdjustPurchasePriceRange());
            }
            BigDecimal adjustPurchseFee = uocAdjustPriceItemBO.getAdjustPurchasePrice().multiply(saleOrderItem.getPurchaseCount()).setScale(2, RoundingMode.HALF_UP);
            updateSaleOrderItem.setPurchaseFee(adjustPurchseFee);
            updateSaleOrderItem.setPurchasePrice(uocAdjustPriceItemBO.getAdjustPurchasePrice());
            if (UocDicConstant.MODEL_SETTLE.MATCH.equals(saleOrder.getModelSettle())) {
                updateSaleOrderItem.setSaleFee(adjustPurchseFee);
                updateSaleOrderItem.setSalePrice(uocAdjustPriceItemBO.getAdjustPurchasePrice());
            }
            updateSaleOrderItems.add(updateSaleOrderItem);
            adjustTotalPurchaseFee = adjustTotalPurchaseFee.add(adjustPurchseFee);
        }
        updateSaleOrderItemDo.setSaleOrderItems(updateSaleOrderItems);
        this.iUocSaleOrderModel.updateSaleItemWithOutSkuId(updateSaleOrderItemDo);
        uocSaleOrderDo.setTotalGoodsPurchaseFee(adjustTotalPurchaseFee);
        uocSaleOrderDo.setTotalPurchaseFee(adjustTotalPurchaseFee.add(reqBO.getAdjustTransFee()));
        if (UocDicConstant.MODEL_SETTLE.MATCH.equals(saleOrder.getModelSettle())) {
            uocSaleOrderDo.setTotalGoodsSaleFee(adjustTotalPurchaseFee);
            uocSaleOrderDo.setTotalSaleFee(adjustTotalPurchaseFee.add(reqBO.getAdjustTransFee()));
        }
        this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
    }
}

