/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.saleorder.UocResoveEsPreOrderService;
import com.tydic.dyc.oc.service.saleorder.bo.UocResoveEsPreOrderServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocResoveEsPreOrderServiceRspBo;
import com.tydic.dyc.oc.transactionservice.UocResoveEsPreOrderTransaction;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocResoveEsPreOrderService"})
public class UocResoveEsPreOrderServiceImpl
implements UocResoveEsPreOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocResoveEsPreOrderServiceImpl.class);
    @Autowired
    private UocResoveEsPreOrderTransaction uocResoveEsPreOrderTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"dealEsPreOrder"})
    public UocResoveEsPreOrderServiceRspBo dealEsPreOrder(@RequestBody UocResoveEsPreOrderServiceReqBo reqBo) {
        UocResoveEsPreOrderServiceRspBo rspBo = this.uocResoveEsPreOrderTransaction.dealEsPreOrder(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocResoveEsPreOrderServiceReqBo reqBo, UocResoveEsPreOrderServiceRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(rspBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);
        SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
        orderBo.setIndexName(this.uocIndexConfig.getOrderIndex());
        orderBo.setOrderId(reqBo.getOrderId());
        orderBo.setObjId(reqBo.getOrderId());
        orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(orderBo);
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

