/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocResoveEsPreOrderServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocResoveEsPreOrderServiceReqSkuBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocResoveEsPreOrderServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class UocResoveEsPreOrderTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocResoveEsPreOrderTransaction.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Value(value="${dyc.system.name:DYC}")
    private String systemName;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocResoveEsPreOrderServiceRspBo dealEsPreOrder(UocResoveEsPreOrderServiceReqBo reqBo) {
        UocResoveEsPreOrderServiceRspBo rspBo = UocRu.success(UocResoveEsPreOrderServiceRspBo.class);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSku())) {
            UocSaleOrderDo updatSaleItemBo = this.assembleUpdateDo(reqBo);
            this.iUocSaleOrderModel.updateSaleItemWithOutSkuId(updatSaleItemBo);
        }
        if (UocConstant.CREATED_RESULT.FAILED.equals(reqBo.getCreatedResult())) {
            UocSaleOrderDo updateExtOrderIdDo = new UocSaleOrderDo();
            updateExtOrderIdDo.setOrderId(reqBo.getOrderId());
            updateExtOrderIdDo.setSaleOrderId(reqBo.getSaleOrderId());
            updateExtOrderIdDo.setCreatedResult(reqBo.getCreatedResult());
            updateExtOrderIdDo.setSaleOrderState("XS_XD_SB");
            updateExtOrderIdDo.setCancelReason(reqBo.getCancelReason());
            this.iUocSaleOrderModel.modifySaleOrderMain(updateExtOrderIdDo);
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
            List<UocSaleOrderDo> saleOrderList = this.iUocSaleOrderModel.getSaleOrderList(uocSaleOrderQryBo);
            Boolean allOverFlag = saleOrderList.stream().allMatch(bo -> "XS_QX_QX".equals(bo.getSaleOrderState()) || "XS_XD_SB".equals(bo.getSaleOrderState()));
            if (allOverFlag.booleanValue()) {
                UocOrderDo updateOrder = new UocOrderDo();
                updateOrder.setOrderId(reqBo.getOrderId());
                updateOrder.setOrderState("3");
                updateOrder.setDelTag(1);
                this.iUocOrderModel.updateOrderState(updateOrder);
            }
            rspBo.setOrderId(reqBo.getOrderId());
            rspBo.setSaleOrderId(reqBo.getSaleOrderId());
            rspBo.setOutOrderId(reqBo.getOutOrderId());
            return rspBo;
        }
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
        List<UocSaleOrderDo> saleOrderList = this.iUocSaleOrderModel.getSaleOrderList(uocSaleOrderQryBo);
        Boolean aduitFlag = false;
        if (!CollectionUtils.isEmpty(saleOrderList) && saleOrderList.size() == 1) {
            aduitFlag = true;
            log.debug("aduitFlag1" + aduitFlag);
        } else {
            List saleOrderExeistSelfList = saleOrderList.stream().filter(bo -> !bo.getSaleOrderId().equals(reqBo.getSaleOrderId()) && !"XS_QX_QX".equals(bo.getSaleOrderState()) && !"XS_XD_SB".equals(bo.getSaleOrderState())).collect(Collectors.toList());
            log.debug("aduitFlag2" + JSON.toJSONString(saleOrderExeistSelfList));
            if (!CollectionUtils.isEmpty(saleOrderExeistSelfList)) {
                aduitFlag = saleOrderExeistSelfList.stream().allMatch(bo -> 1 == bo.getCreatedResult());
                log.debug("aduitFlag3" + JSON.toJSONString(saleOrderExeistSelfList));
                if (aduitFlag.booleanValue() && 2 == ((UocSaleOrderDo)((Object)saleOrderExeistSelfList.get(0))).getSaleOrderType()) {
                    aduitFlag = saleOrderExeistSelfList.stream().noneMatch(bo -> UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(bo.getOrderSource()));
                    log.debug("aduitFlag4" + JSON.toJSONString(saleOrderExeistSelfList));
                }
            }
        }
        log.debug("aduitFlag" + aduitFlag);
        if (aduitFlag.booleanValue()) {
            UocApprovalObjQryBo selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
            selectuocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
            List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(selectuocApprovalObjQryBo);
            if (CollectionUtils.isEmpty(uocApprovalObjs)) {
                throw new BaseBusinessException("101005", "\u67e5\u8be2\u5ba1\u6279\u4efb\u52a1\u5bf9\u8c61\u8868\u4e3a\u7a7a\uff01");
            }
            rspBo.setAuditId(uocApprovalObjs.get(0).getAuditOrderId());
            rspBo.setAuditFlowKey(saleOrderList.get(0).getAuditFlowKey());
            rspBo.setApplicationDeptId(saleOrderList.get(0).getApplicationDeptId());
            rspBo.setApplicationType(saleOrderList.get(0).getApplicationType());
            rspBo.setPurchaseMode(saleOrderList.get(0).getPurchaseMode());
            BigDecimal totalSaleFee = saleOrderList.stream().map(UocSaleOrderDo::getTotalSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            rspBo.setTotalSaleFee(totalSaleFee);
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
            List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            BigDecimal maxGoodsSaleFee = saleOrderItemList.stream().map(UocSaleOrderItem::getSalePrice).max(BigDecimal::compareTo).get();
            rspBo.setMaxGoodsSaleFee(maxGoodsSaleFee);
        }
        UocSaleOrderDo updateExtOrderIdDo = new UocSaleOrderDo();
        updateExtOrderIdDo.setOrderId(reqBo.getOrderId());
        updateExtOrderIdDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateExtOrderIdDo.setSaleOrderNoExt(reqBo.getOutOrderId());
        updateExtOrderIdDo.setCreatedResult(reqBo.getCreatedResult());
        this.iUocSaleOrderModel.modifySaleOrderMain(updateExtOrderIdDo);
        UocOrderQueryIndex index = new UocOrderQueryIndex();
        index.setId(IdUtil.nextId());
        index.setOrderId(reqBo.getOrderId());
        index.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        index.setObjId(reqBo.getSaleOrderId());
        index.setOutObjId(reqBo.getOutOrderId());
        this.iUocCommonModel.saveOrderQueryIndex(index);
        rspBo.setOrderId(reqBo.getOrderId());
        rspBo.setSaleOrderId(reqBo.getSaleOrderId());
        rspBo.setOutOrderId(reqBo.getOutOrderId());
        return rspBo;
    }

    private UocSaleOrderDo assembleUpdateDo(UocResoveEsPreOrderServiceReqBo reqBo) {
        UocSaleOrderDo updateSaleItemBo = new UocSaleOrderDo();
        updateSaleItemBo.setOrderId(reqBo.getOrderId());
        updateSaleItemBo.setSaleOrderId(reqBo.getSaleOrderId());
        List sku = reqBo.getSku();
        ArrayList<UocSaleOrderItem> saleItemList = new ArrayList<UocSaleOrderItem>();
        updateSaleItemBo.setSaleOrderItems(saleItemList);
        for (UocResoveEsPreOrderServiceReqSkuBo skuBo : sku) {
            UocSaleOrderItem item = new UocSaleOrderItem();
            item.setSkuExtSkuId(skuBo.getSkuId());
            item.setOrderId(reqBo.getOrderId());
            item.setSaleOrderId(reqBo.getSaleOrderId());
            if (null != skuBo.getTax()) {
                item.setTax(new BigDecimal(skuBo.getTax()));
            }
            item.setTaxPrice(skuBo.getTaxPrice());
            item.setNakedPrice(skuBo.getNakedPrice());
            item.setFailReason(skuBo.getFailReason());
            saleItemList.add(item);
        }
        return updateSaleItemBo;
    }
}

