/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.importorder.UocImportOrderDo;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderAgreementInfoQryDetailBo;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderItemQryDetailBo;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderQryDetailReqBo;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderQryDetailRspBo;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderQryListBo;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderQryListReqBo;
import com.tydic.dyc.oc.model.importorder.qrybo.UocImportOrderQryListRspBo;
import com.tydic.dyc.oc.model.importorder.sub.UocImportOrderItem;
import com.tydic.dyc.oc.repository.UocImportOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocImportOrderAgreementInfoMapper;
import com.tydic.dyc.oc.repository.dao.UocImportOrderItemMapper;
import com.tydic.dyc.oc.repository.dao.UocImportOrderMapper;
import com.tydic.dyc.oc.repository.po.UocImportOrderAgreementInfoPO;
import com.tydic.dyc.oc.repository.po.UocImportOrderItemPO;
import com.tydic.dyc.oc.repository.po.UocImportOrderPO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocImportOrderRepositoryImpl
implements UocImportOrderRepository {
    private static final Logger log = LoggerFactory.getLogger(UocImportOrderRepositoryImpl.class);
    @Autowired
    private UocImportOrderMapper uocImportOrderMapper;
    @Autowired
    private UocImportOrderItemMapper uocImportOrderItemMapper;
    @Autowired
    private UocImportOrderAgreementInfoMapper uocImportOrderAgreementInfoMapper;

    public UocImportOrderDo addImportOrder(UocImportOrderDo uocImportOrderDo) {
        UocImportOrderPO addUocImportOrder = (UocImportOrderPO)UocRu.js((Object)uocImportOrderDo, UocImportOrderPO.class);
        addUocImportOrder.setImportOrderId(IdUtil.nextId());
        addUocImportOrder.setStatus(UocConstant.IMPORT_ORDER_STATUS.IN_STORE);
        addUocImportOrder.setCreateTime(new Date());
        this.uocImportOrderMapper.insert(addUocImportOrder);
        List addUocImportOrderItemList = UocRu.jsl((List)uocImportOrderDo.getImportOrderItemList(), UocImportOrderItemPO.class);
        for (UocImportOrderItemPO addUocImportOrderItem : addUocImportOrderItemList) {
            addUocImportOrderItem.setImportOrderItemId(IdUtil.nextId());
            addUocImportOrderItem.setImportOrderId(addUocImportOrder.getImportOrderId());
            addUocImportOrderItem.setCreateUserId(uocImportOrderDo.getCreateUserId());
            addUocImportOrderItem.setCreateUserName(uocImportOrderDo.getCreateUserName());
            addUocImportOrderItem.setCreateTime(new Date());
        }
        this.uocImportOrderItemMapper.insertBatch(addUocImportOrderItemList);
        UocImportOrderDo addImportOrderResult = new UocImportOrderDo();
        addImportOrderResult.setImportOrderId(addUocImportOrder.getImportOrderId());
        return addImportOrderResult;
    }

    public UocImportOrderDo checkImportOrderThreshold(UocImportOrderDo uocImportOrderDo) {
        UocImportOrderPO checkUocImportOrder = (UocImportOrderPO)UocRu.js((Object)uocImportOrderDo, UocImportOrderPO.class);
        int checkBy = this.uocImportOrderMapper.getCheckBy(checkUocImportOrder);
        UocImportOrderDo checkImportOrderResult = new UocImportOrderDo();
        checkImportOrderResult.setCheckThreshold(Integer.valueOf(checkBy));
        return checkImportOrderResult;
    }

    public void updateImportOrderInfoStatus(UocImportOrderDo uocImportOrderDo) {
        UocImportOrderPO uocImportOrderSet = (UocImportOrderPO)UocRu.js((Object)uocImportOrderDo, UocImportOrderPO.class);
        uocImportOrderSet.setUpdateTime(new Date());
        UocImportOrderPO uocImportOrderWhere = new UocImportOrderPO();
        uocImportOrderWhere.setImportOrderId(uocImportOrderDo.getImportOrderId());
        this.uocImportOrderMapper.updateBy(uocImportOrderSet, uocImportOrderWhere);
    }

    public void updateImportOrder(UocImportOrderDo uocImportOrderDo) {
        UocImportOrderPO uocImportOrderSet = (UocImportOrderPO)UocRu.js((Object)uocImportOrderDo, UocImportOrderPO.class);
        uocImportOrderSet.setUpdateTime(new Date());
        UocImportOrderPO uocImportOrderWhere = new UocImportOrderPO();
        uocImportOrderWhere.setImportOrderId(uocImportOrderDo.getImportOrderId());
        this.uocImportOrderMapper.updateBy(uocImportOrderSet, uocImportOrderWhere);
        if (!CollectionUtils.isEmpty((Collection)uocImportOrderDo.getImportOrderItemList())) {
            for (UocImportOrderItem uocImportOrderItem : uocImportOrderDo.getImportOrderItemList()) {
                UocImportOrderItemPO uocImportOrderItemSet = (UocImportOrderItemPO)UocRu.js((Object)uocImportOrderItem, UocImportOrderItemPO.class);
                uocImportOrderItem.setUpdateUserId(uocImportOrderDo.getUpdateUserId());
                uocImportOrderItem.setUpdateUserName(uocImportOrderDo.getUpdateUserName());
                uocImportOrderItemSet.setUpdateTime(new Date());
                UocImportOrderItemPO uocImportOrderItemWhere = new UocImportOrderItemPO();
                uocImportOrderItemWhere.setImportOrderItemId(uocImportOrderItem.getImportOrderItemId());
                this.uocImportOrderItemMapper.updateBy(uocImportOrderItemSet, uocImportOrderItemWhere);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)uocImportOrderDo.getImportOrderAgreementInfoList())) {
            List addUocImportOrderAgreementInfoList = UocRu.jsl((List)uocImportOrderDo.getImportOrderAgreementInfoList(), UocImportOrderAgreementInfoPO.class);
            for (UocImportOrderAgreementInfoPO uocImportOrderAgreementInfoPO : addUocImportOrderAgreementInfoList) {
                uocImportOrderAgreementInfoPO.setImportOrderAgreementInfoId(IdUtil.nextId());
                uocImportOrderAgreementInfoPO.setImportOrderId(uocImportOrderDo.getImportOrderId());
                uocImportOrderAgreementInfoPO.setCreateUserId(uocImportOrderDo.getUpdateUserId());
                uocImportOrderAgreementInfoPO.setCreateUserName(uocImportOrderDo.getUpdateUserName());
                uocImportOrderAgreementInfoPO.setCreateTime(new Date());
            }
            this.uocImportOrderAgreementInfoMapper.insertBatch(addUocImportOrderAgreementInfoList);
        }
    }

    public UocImportOrderQryDetailRspBo qryImportOrderDetail(UocImportOrderQryDetailReqBo uocImportOrderQryDetailReqBo) {
        UocImportOrderPO queryUocImportOrder = (UocImportOrderPO)UocRu.js((Object)uocImportOrderQryDetailReqBo, UocImportOrderPO.class);
        UocImportOrderPO uocImportOrderPO = this.uocImportOrderMapper.getModelBy(queryUocImportOrder);
        UocImportOrderQryDetailRspBo rspBo = (UocImportOrderQryDetailRspBo)UocRu.js((Object)uocImportOrderPO, UocImportOrderQryDetailRspBo.class);
        UocImportOrderItemPO queryUocImportOrderItem = new UocImportOrderItemPO();
        queryUocImportOrderItem.setImportOrderId(uocImportOrderPO.getImportOrderId());
        List<UocImportOrderItemPO> uocImportOrderItemPOList = this.uocImportOrderItemMapper.getList(queryUocImportOrderItem);
        if (!CollectionUtils.isEmpty(uocImportOrderItemPOList)) {
            rspBo.setImportOrderItemList(UocRu.jsl(uocImportOrderItemPOList, UocImportOrderItemQryDetailBo.class));
        }
        UocImportOrderAgreementInfoPO queryUocImportOrderAgreementInfo = new UocImportOrderAgreementInfoPO();
        queryUocImportOrderAgreementInfo.setImportOrderId(uocImportOrderPO.getImportOrderId());
        List<UocImportOrderAgreementInfoPO> uocImportOrderAgreementInfoPOList = this.uocImportOrderAgreementInfoMapper.getList(queryUocImportOrderAgreementInfo);
        if (!CollectionUtils.isEmpty(uocImportOrderAgreementInfoPOList)) {
            rspBo.setImportOrderAgreementInfoList(UocRu.jsl(uocImportOrderAgreementInfoPOList, UocImportOrderAgreementInfoQryDetailBo.class));
        }
        return rspBo;
    }

    public UocImportOrderQryListRspBo qryImportOrderList(UocImportOrderQryListReqBo reqBo) {
        UocImportOrderQryListRspBo rspBo = new UocImportOrderQryListRspBo();
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        UocImportOrderPO qryUocImportOrderListPage = (UocImportOrderPO)UocRu.js((Object)reqBo, UocImportOrderPO.class);
        qryUocImportOrderListPage.setCreateUserId(String.valueOf(reqBo.getUserId()));
        qryUocImportOrderListPage.setOrderBy("create_time DESC");
        List<UocImportOrderPO> listPage = this.uocImportOrderMapper.getListPage(qryUocImportOrderListPage, (Page<UocImportOrderPO>)page);
        if (CollectionUtils.isEmpty(listPage)) {
            rspBo.setPageNo(reqBo.getPageNo());
            rspBo.setRecordsTotal(0);
            rspBo.setTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        List uocImportOrderQryListBoList = UocRu.jsl(listPage, UocImportOrderQryListBo.class);
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRows(uocImportOrderQryListBoList);
        return rspBo;
    }
}

