package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.repository.po.UocShipOrderPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocShipOrderMapper
 * 说明:发货单
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocShipOrderMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocShipOrderPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocShipOrderPo uocShipOrderPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocShipOrderPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocShipOrderPo uocShipOrderPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocShipOrderPo set, @Param("where") UocShipOrderPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocShipOrderPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocShipOrderPo uocShipOrderPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocShipOrderPo 参数对象
	 * @return UocShipOrderPo 结果对象
	 */
	UocShipOrderPo getModelBy(UocShipOrderPo uocShipOrderPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocShipOrderPo 参数对象
	 * @return List<UocShipOrderPo> 结果对象
	 */
	List<UocShipOrderPo> getList(UocShipOrderPo uocShipOrderPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocShipOrderPo 参数对象
	 * @param page 分页参数
	 * @return List<UocShipOrderPo> 结果对象
	 */
	List<UocShipOrderPo> getListPage(UocShipOrderPo uocShipOrderPo, Page<UocShipOrderPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocShipOrderPo> list);

	void updateShipStatus(UocShipOrderPo uocShipOrderPo);

	void updateStatChngShipStatus(UocShipOrderPo uocShipOrderPo);

    void modifyShipOrderItemAfterServingCount(UocShipOrderItem uocShipOrderItem);

    void modifyShipOrderItemReturningCount(UocShipOrderItem uocShipOrderItem);
    
    List<UocShipOrderPo> getCheckVoterOrders(UocShipOrderPo record);
    
    List<UocShipOrderPo> getCheckRefuseOrders(UocShipOrderPo record);

	/**
	 * 修改发货单占用运费
	 */
	void modifyOccupyTransFee(@Param("set") UocShipOrderPo set, @Param("where") UocShipOrderPo where);

	/**
	 * 修改销售单明细已发货明细金额
	 */
	void modifyItemReturnSendFee(@Param("po") UocShipOrderItem uocShipOrderItem, @Param("list") List<UocShipOrderItem> list);
}
