package com.tydic.dyc.oc.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.importorder.UocImportOrderDo;
import com.tydic.dyc.oc.model.importorder.qrybo.*;
import com.tydic.dyc.oc.model.importorder.sub.UocImportOrderItem;
import com.tydic.dyc.oc.repository.UocImportOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocImportOrderAgreementInfoMapper;
import com.tydic.dyc.oc.repository.dao.UocImportOrderItemMapper;
import com.tydic.dyc.oc.repository.dao.UocImportOrderMapper;
import com.tydic.dyc.oc.repository.po.UocImportOrderAgreementInfoPO;
import com.tydic.dyc.oc.repository.po.UocImportOrderItemPO;
import com.tydic.dyc.oc.repository.po.UocImportOrderPO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Slf4j
@Service
public class UocImportOrderRepositoryImpl implements UocImportOrderRepository {

    /**
     * 导入订单记录表Mapper
     */
    @Autowired
    private UocImportOrderMapper uocImportOrderMapper;

    /**
     * 导入订单记录明细表Mapper
     */
    @Autowired
    private UocImportOrderItemMapper uocImportOrderItemMapper;

    /**
     * 导入订单记录协议信息表Mapper
     */
    @Autowired
    private UocImportOrderAgreementInfoMapper uocImportOrderAgreementInfoMapper;

    /**
     * 导入订单记录新增
     */
    @Override
    public UocImportOrderDo addImportOrder(UocImportOrderDo uocImportOrderDo) {
        //定义导入订单记录新增对象，参数转换
        UocImportOrderPO addUocImportOrder = UocRu.js(uocImportOrderDo, UocImportOrderPO.class);
        //设置记录ID
        addUocImportOrder.setImportOrderId(IdUtil.nextId());
        //设置状态，1入库
        addUocImportOrder.setStatus(UocConstant.IMPORT_ORDER_STATUS.IN_STORE);
        //设置创建时间
        addUocImportOrder.setCreateTime(new Date());
        //调用导入订单记录表Mapper，插入单条数据
        this.uocImportOrderMapper.insert(addUocImportOrder);

        //定义导入订单记录明细新增对象集合，参数转换
        List<UocImportOrderItemPO> addUocImportOrderItemList = UocRu.jsl(uocImportOrderDo.getImportOrderItemList(), UocImportOrderItemPO.class);
        //遍历赋值
        for (UocImportOrderItemPO addUocImportOrderItem : addUocImportOrderItemList) {
            //设置记录明细ID
            addUocImportOrderItem.setImportOrderItemId(IdUtil.nextId());
            //设置记录ID
            addUocImportOrderItem.setImportOrderId(addUocImportOrder.getImportOrderId());
            //设置创建人ID
            addUocImportOrderItem.setCreateUserId(uocImportOrderDo.getCreateUserId());
            //设置创建人名称
            addUocImportOrderItem.setCreateUserName(uocImportOrderDo.getCreateUserName());
            //设置创建时间
            addUocImportOrderItem.setCreateTime(new Date());
        }
        //调用导入订单记录明细表Mapper，批量插入数据
        this.uocImportOrderItemMapper.insertBatch(addUocImportOrderItemList);

        //定义导入订单记录新增返回对象
        UocImportOrderDo addImportOrderResult = new UocImportOrderDo();
        //设置记录ID
        addImportOrderResult.setImportOrderId(addUocImportOrder.getImportOrderId());

        return addImportOrderResult;
    }

    /**
     * 校验导入订单记录阈值量
     */
    @Override
    public UocImportOrderDo checkImportOrderThreshold(UocImportOrderDo uocImportOrderDo) {
        //定义校验导入订单记录阈值量查询对象，参数转换
        UocImportOrderPO checkUocImportOrder = UocRu.js(uocImportOrderDo, UocImportOrderPO.class);
        //调用导入订单记录表Mapper，根据条件校验有多少条数据
        int checkBy = this.uocImportOrderMapper.getCheckBy(checkUocImportOrder);

        //定义校验导入订单记录阈值量返回对象
        UocImportOrderDo checkImportOrderResult = new UocImportOrderDo();
        //设置校验阈值
        checkImportOrderResult.setCheckThreshold(checkBy);

        return checkImportOrderResult;
    }

    /**
     * 导入订单记录状态修改
     */
    @Override
    public void updateImportOrderInfoStatus(UocImportOrderDo uocImportOrderDo) {
        //定义导入订单记录状态修改Set，参数转换
        UocImportOrderPO uocImportOrderSet = UocRu.js(uocImportOrderDo, UocImportOrderPO.class);
        //设置更新时间
        uocImportOrderSet.setUpdateTime(new Date());

        //定义导入订单记录状态修改Where
        UocImportOrderPO uocImportOrderWhere = new UocImportOrderPO();
        //设置记录ID
        uocImportOrderWhere.setImportOrderId(uocImportOrderDo.getImportOrderId());

        //调用导入订单记录表Mapper，根据条件更新数据
        this.uocImportOrderMapper.updateBy(uocImportOrderSet, uocImportOrderWhere);
    }

    /**
     * 导入订单记录更新
     */
    @Override
    public void updateImportOrder(UocImportOrderDo uocImportOrderDo) {
        //定义导入订单记录修改Set，参数转换
        UocImportOrderPO uocImportOrderSet = UocRu.js(uocImportOrderDo, UocImportOrderPO.class);
        //设置更新时间
        uocImportOrderSet.setUpdateTime(new Date());
        //定义导入订单记录修改Where
        UocImportOrderPO uocImportOrderWhere = new UocImportOrderPO();
        //设置记录ID
        uocImportOrderWhere.setImportOrderId(uocImportOrderDo.getImportOrderId());
        //调用导入订单记录表Mapper，根据条件更新数据
        this.uocImportOrderMapper.updateBy(uocImportOrderSet, uocImportOrderWhere);

        //更新导入订单记录明细
        if (!CollectionUtils.isEmpty(uocImportOrderDo.getImportOrderItemList())) {
            for (UocImportOrderItem uocImportOrderItem : uocImportOrderDo.getImportOrderItemList()) {
                //定义导入订单记录明细状态修改Set，参数转换
                UocImportOrderItemPO uocImportOrderItemSet = UocRu.js(uocImportOrderItem, UocImportOrderItemPO.class);
                //设置更新人ID
                uocImportOrderItem.setUpdateUserId(uocImportOrderDo.getUpdateUserId());
                //设置更新人名称
                uocImportOrderItem.setUpdateUserName(uocImportOrderDo.getUpdateUserName());
                //设置更新时间
                uocImportOrderItemSet.setUpdateTime(new Date());
                //定义导入订单记录明细状态修改Where
                UocImportOrderItemPO uocImportOrderItemWhere = new UocImportOrderItemPO();
                //设置记录明细ID
                uocImportOrderItemWhere.setImportOrderItemId(uocImportOrderItem.getImportOrderItemId());
                //调用导入订单记录明细表Mapper，根据条件更新数据
                this.uocImportOrderItemMapper.updateBy(uocImportOrderItemSet, uocImportOrderItemWhere);
            }
        }

        //新增导入订单记录协议信息
        if (!CollectionUtils.isEmpty(uocImportOrderDo.getImportOrderAgreementInfoList())) {
            //定义导入订单记录协议信息新增对象，参数转换
            List<UocImportOrderAgreementInfoPO> addUocImportOrderAgreementInfoList = UocRu.jsl(uocImportOrderDo.getImportOrderAgreementInfoList(), UocImportOrderAgreementInfoPO.class);
            //遍历赋值
            for (UocImportOrderAgreementInfoPO uocImportOrderAgreementInfoPO : addUocImportOrderAgreementInfoList) {
                //设置记录协议信息ID
                uocImportOrderAgreementInfoPO.setImportOrderAgreementInfoId(IdUtil.nextId());
                //设置记录ID
                uocImportOrderAgreementInfoPO.setImportOrderId(uocImportOrderDo.getImportOrderId());
                //设置创建人ID
                uocImportOrderAgreementInfoPO.setCreateUserId(uocImportOrderDo.getUpdateUserId());
                //设置创建人名称
                uocImportOrderAgreementInfoPO.setCreateUserName(uocImportOrderDo.getUpdateUserName());
                //设置创建时间
                uocImportOrderAgreementInfoPO.setCreateTime(new Date());
            }
            //调用导入订单记录协议信息表Mapper，批量插入数据
            this.uocImportOrderAgreementInfoMapper.insertBatch(addUocImportOrderAgreementInfoList);
        }
    }

    /**
     * 导入订单记录详情查询
     */
    @Override
    public UocImportOrderQryDetailRspBo qryImportOrderDetail(UocImportOrderQryDetailReqBo uocImportOrderQryDetailReqBo) {
        //定义导入订单记录查询对象，参数转换
        UocImportOrderPO queryUocImportOrder = UocRu.js(uocImportOrderQryDetailReqBo, UocImportOrderPO.class);
        //调用导入订单记录表Mapper，根据条件查询单条数据
        UocImportOrderPO uocImportOrderPO = this.uocImportOrderMapper.getModelBy(queryUocImportOrder);

        //设置导入订单记录，数据转换
        UocImportOrderQryDetailRspBo rspBo = UocRu.js(uocImportOrderPO, UocImportOrderQryDetailRspBo.class);

        //定义导入订单记录明细查询对象
        UocImportOrderItemPO queryUocImportOrderItem = new UocImportOrderItemPO();
        //设置记录ID
        queryUocImportOrderItem.setImportOrderId(uocImportOrderPO.getImportOrderId());
        //调用导入订单记录明细表Mapper，根据条件查询列表数据
        List<UocImportOrderItemPO> uocImportOrderItemPOList = this.uocImportOrderItemMapper.getList(queryUocImportOrderItem);

        if (!CollectionUtils.isEmpty(uocImportOrderItemPOList)) {
            //设置导入订单记录明细集合，数据转换
            rspBo.setImportOrderItemList(UocRu.jsl(uocImportOrderItemPOList, UocImportOrderItemQryDetailBo.class));
        }

        //定义导入订单记录协议信息查询对象
        UocImportOrderAgreementInfoPO queryUocImportOrderAgreementInfo = new UocImportOrderAgreementInfoPO();
        //设置记录ID
        queryUocImportOrderAgreementInfo.setImportOrderId(uocImportOrderPO.getImportOrderId());
        //导入订单记录协议信息表Mapper，根据条件查询列表数据
        List<UocImportOrderAgreementInfoPO> uocImportOrderAgreementInfoPOList = this.uocImportOrderAgreementInfoMapper.getList(queryUocImportOrderAgreementInfo);

        if (!CollectionUtils.isEmpty(uocImportOrderAgreementInfoPOList)) {
            //设置导入订单记录协议信息集合，数据转换
            rspBo.setImportOrderAgreementInfoList(UocRu.jsl(uocImportOrderAgreementInfoPOList, UocImportOrderAgreementInfoQryDetailBo.class));
        }

        return rspBo;
    }

    /**
     * 导入订单记录列表分页查询
     */
    @Override
    public UocImportOrderQryListRspBo qryImportOrderList(UocImportOrderQryListReqBo reqBo) {
        //定义出参对象
        UocImportOrderQryListRspBo rspBo = new UocImportOrderQryListRspBo();

        //设置分页参数
        Page<UocImportOrderPO> page = new Page<>(reqBo.getPageNo(), reqBo.getPageSize());

        //入参条件参数转换
        UocImportOrderPO qryUocImportOrderListPage = UocRu.js(reqBo, UocImportOrderPO.class);
        //设置创建人ID
        qryUocImportOrderListPage.setCreateUserId(String.valueOf(reqBo.getUserId()));
        //设置排序
        qryUocImportOrderListPage.setOrderBy("create_time DESC");

        //调用根据条件分页查询订单快照列表数据
        List<UocImportOrderPO> listPage = this.uocImportOrderMapper.getListPage(qryUocImportOrderListPage, page);

        if (CollectionUtils.isEmpty(listPage)) {
            rspBo.setPageNo(reqBo.getPageNo());
            rspBo.setRecordsTotal(0);
            rspBo.setTotal(0);
            rspBo.setRows(new ArrayList<>());
            return rspBo;
        }

        //导入订单记录列表数据转换
        List<UocImportOrderQryListBo> uocImportOrderQryListBoList = UocRu.jsl(listPage, UocImportOrderQryListBo.class);

        //出参
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRows(uocImportOrderQryListBoList);

        return rspBo;
    }

    /**
     * 导入订单记录主体信息更新
     */
    @Override
    public void updateImportOrderMainInfo(UocImportOrderDo uocImportOrderDo) {
        //定义导入订单记录修改Set，参数转换
        UocImportOrderPO uocImportOrderSet = UocRu.js(uocImportOrderDo, UocImportOrderPO.class);
        //设置更新时间
        uocImportOrderSet.setUpdateTime(new Date());
        //定义导入订单记录修改Where
        UocImportOrderPO uocImportOrderWhere = new UocImportOrderPO();
        //设置记录ID
        uocImportOrderWhere.setImportOrderId(uocImportOrderDo.getImportOrderId());

        //调用导入订单记录表Mapper，根据条件更新数据
        this.uocImportOrderMapper.updateBy(uocImportOrderSet, uocImportOrderWhere);
    }
}
