package com.tydic.dyc.oc.repository.po;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocSaleOrderPo
 * 说明:销售订单
 * 时间:2022-06-01 19:46
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocSaleOrderPo implements Serializable {
	private static final long serialVersionUID = 3306741159243794740L;

	//销售单id")
	private Long saleOrderId;

	//订单id")
	private Long orderId;

	//三方信息id")
	private Long stakeholderId;

	//父订单id")
	private Long upperOrderId;

	//销售单编码")
	private String saleOrderNo;

	//外部销售单编码")
	private String saleOrderNoExt;

	//销售单名称")
	private String saleOrderName;

	//销售单类型")
	private Integer saleOrderType;

	//订单状态")
	private String saleOrderState;

	//销售单单说明")
	private String saleOrderDesc;

	//订单来源  1 自营单品   2 电商导入   3 协议生成    ")
	private Integer orderSource;

	//支付类型")
	private Integer payMod;

	//支付方式")
	private String payType;

	//销售金额")
	private BigDecimal totalSaleFee;

	//采购金额")
	private BigDecimal totalPurchaseFee;

	//优惠金额")
	private BigDecimal totalActShareFee;

	//运费")
	private BigDecimal totalTransFee;

	//实付金额")
	private BigDecimal usedFee;

	//实付积分")
	private BigDecimal usedIntegral;

	//合同编号")
	private String contractNo;

	//支付状态")
	private Integer payState;

	//环节编码")
	private String procState;

	//税率")
	private String taxRate;

	//竣工标志             1 竣工             0 在途")
	private Integer finishFlag;

	//租户ID")
	private String tenantId;

	//协议数据id")
	private Long agrDataId;

	//协议id")
	private String agreementId;

	//协议编号")
	private String agreementNo;

	//送货时间")
	private Date sendTime;

	//送货时间 开始")
	private Date sendTimeStart;

	//送货时间 结束")
	private Date sendTimeEnd;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//创建人名称")
	private String createOperName;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新人名称")
	private String updateOperName;

	//更新工号")
	private String updateOperId;

	//撤单申请时间")
	private Date cancelRequestTime;

	//撤单申请时间 开始")
	private Date cancelRequestTimeStart;

	//撤单申请时间 结束")
	private Date cancelRequestTimeEnd;

	//撤单时间")
	private Date cancelTime;

	//撤单时间 开始")
	private Date cancelTimeStart;

	//撤单时间 结束")
	private Date cancelTimeEnd;

	//撤单工号")
	private String cancelOperId;

	//撤单人名称")
	private String cancelOperName;

	//撤单原因")
	private String cancelReason;

	//撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	//取消原因标识，0用户主动取消，1审批时限自动取消，2审批驳回取消")
	private Integer cancelReasonFlag;

	//取消订单申请同意拒绝原因")
	private String cancelReplyContent;

	//取消订单申请同意拒绝原因时间")
	private Date cancelReplyTime;

	//取消订单申请同意拒绝原因时间 开始")
	private Date cancelReplyTimeStart;

	//取消订单申请同意拒绝原因时间 结束")
	private Date cancelReplyTimeEnd;

	//竣工时间")
	private Date finishTime;

	//竣工时间 开始")
	private Date finishTimeStart;

	//竣工时间 结束")
	private Date finishTimeEnd;

	//逾期时间")
	private Date expTime;

	//逾期时间 开始")
	private Date expTimeStart;

	//逾期时间 结束")
	private Date expTimeEnd;

	//调价机制：0：无，1：事前调价，2：事中调价 默认值：0")
	private Integer adjustPrice;

	//调价人id")
	private String adjustPriceOperId;

	//调价人名称")
	private String adjustPriceOperName;

	//调价时间")
	private Date adjustPriceTime;

	//调价时间 开始")
	private Date adjustPriceTimeStart;

	//调价时间 结束")
	private Date adjustPriceTimeEnd;

	//结算模式 2:撮合 1:贸易")
	private Integer modelSettle;

	//采购类别             1 物资             2 施工             3 服务             ")
	private Integer purchaseType;

	//采购模式  1计划，2非计划")
	private Integer purchaseMode;

	//供应商拒单原因")
	private String rejectReason;

	//供应商拒单时间")
	private Date rejectTime;

	//供应商拒单时间 开始")
	private Date rejectTimeStart;

	//供应商拒单时间 结束")
	private Date rejectTimeEnd;

	//供应商拒单人")
	private String rejectOperId;

	//供应商拒单人名称")
	private String rejectOperName;

	//是否已关闭尾差 1是 0否")
	private Integer closePennyDiff;

	//备注")
	private String remark;

	//删除标志1已删除")
	private Integer delTag;

	//协议经办人id（配送专责）")
	private String proDeliveryId;

	//协议经办人名字（配送专责）")
	private String proDeliveryName;

	//订单创建结果 0创建中，1成功，2失败")
	private Integer createdResult;

	//是否京东长直，1是，0否，默认0")
	private Integer jdCz;

	//排序")
	private String orderBy;

	//订单idList")
	private List<Long> orderIdList;

	//供应商ID")
	private Long supId;

	//总金额")
	private BigDecimal totalFee;

	//总数量")
	private Integer totalCount;

	//任务id")
	private String taskId;

	//完结标识")
    private String finishTag;
	
	//销售单状态列表")
    private List<String> saleOrderStateList;

	 //@DocField(value = "归档表后缀")
	private String dataAchiveTabSuffix;
    
    //销售订单idList")
    private List<Long> saleOrderIdList;
    
    //议价单id
    private Long bargainingId;

	/**
	 * 铺货单位ID
	 */
	private String managementOrgId;
	/**
	 * 铺货单位名称
	 */
	private String managementOrgName;

	/**
	 * 申请人
	 */
	private String applicationName;

	/**
	 * 申请主题
	 */
	private String applicationTheme;

	/**
	 * 申请类型 1.部门申请 2.项目申请
	 */
	private String applicationType;

	/**
	 * 申请部门/项目名称
	 */
	private String applicationDept;

	/**
	 * 采购类型 1.MRO 2.非MRO
	 */
	private String purchaseAppType;

	/**
	 * 扣款账户
	 */
	private String reduceAccount;

	/**
	 * 申请单号
	 */
	private String applicationCode;

	/**
	 * 已占用运费
	 */
	private BigDecimal totalOccupyTransFee;

	/**
	 * 原始父订单编号
	 */
	private String oldParentOrderCode;

	/**
	 * 商品销售总金额
	 */
	private BigDecimal totalGoodsSaleFee;

	/**
	 * 商品采购总金额
	 */
	private BigDecimal totalGoodsPurchaseFee;

	/**
	 * 主订单编号
	 */
	private String orderNo;

	/**
	 * 审批流编码
	 */
	private String auditFlowKey;
	/**
	 * 申请部门/项目Id
	 */
	private Long applicationDeptId;
	/**
	 * 扣款帐户所属企业id
	 */
	private Long deductionCompanyId;

	/**
	 * 预算ID
	 */
	private Long quotaId;

	/**
	 * 采购方案id
	 */
	private String proSchemeId;
	/**
	 * 项目Id
	 */
	private String projectId;

	/**
	 * 项目编号
	 */
	private String projectNo;

	/**
	 * 项目名称
	 */
	private String projectName;

	/**
	 * 采购方案编号
	 */
	private String proSchemeNo;

	/**
	 * 采购方案名称
	 */
	private String proSchemeName;

	/**
	 * 标段id
	 */
	private String proSchemeLotId;

	/**
	 * 标段编号
	 */
	private String proSchemeLotNo;

	/**
	 * 标段名称
	 */
	private String proSchemeLotName;

	/**
	 * 供应商调价时间
	 */
	private Date supAdjustTime;

	/**
	 * 运营方调价时间
	 */
	private Date proAdjustTime;

	/**
	 * 采购方确认调价时间
	 */
	private Date purAdjustConfirmTime;

	/**
	 * 调价前销售总金额
	 */
	private BigDecimal adjustTotalSaleFee;

	/**
	 * 调价前采购总金额
	 */
	private BigDecimal adjustTotalPurchaseFee;

	/**
	 * 调价前商品销售总金额
	 */
	private BigDecimal adjustTotalGoodsSaleFee;

	/**
	 * 调价前商品采购总金额
	 */
	private BigDecimal adjustTotalGoodsPurchaseFee;

	/**
	 * 调价前运费
	 */
	private BigDecimal adjustTransFee;

	/**
	 * 运费调价幅度
	 */
	private BigDecimal adjustTransFeeRange;

	/**
	 * 运费调价原因
	 */
	private String adjustTransReason;

	/**
	 * 申请人id
	 */
	private String applicationUserId;
    
}
