package com.tydic.dyc.oc.repository.po;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocShipOrderItemPo
 * 说明:发货明细
 * 时间:2022-05-13 13:45
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocShipOrderItemPo implements Serializable {
	private static final long serialVersionUID = -5105669703283919805L;

	//发货明细id")
	private Long shipOrderItemId;

	//订单id")
	private Long orderId;

	//销售单id")
	private Long saleOrderId;

	//销售明细id")
	private Long saleOrderItemId;

	//发货单id")
	private Long shipOrderId;

	//明细状态")
	private String shipItemState;

	//计量单位")
	private String unitName;

	//发货数量")
	private BigDecimal sendCount;

	//到货数量             供应商到货登记时预留字段")
	private BigDecimal arriveCount;

	//拒收数量")
	private BigDecimal refuseCount;

	//退货数量")
	private BigDecimal returnCount;

	//验收数量")
	private BigDecimal inspCount;

	//售后在途数量")
	private BigDecimal afterServingCount;

	//异常变更在途数量")
	private BigDecimal chngingCount;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//备注")
	private String remark;

	//删除标志1已删除")
	private Integer delTag;

	//扩展字段")
	private String extField1;

	//扩展字段")
	private String extField2;

	//扩展字段")
	private String extField3;

	//扩展字段")
	private String extField4;

	//扩展字段")
	private String extField5;

	//排序")
	private String orderBy;

	//发货单IDList")
	private List<Long> shipOrderIdList;

	//发货单明细IDList")
	private List<Long> shipOrderItemIdList;

	//订单IDList")
	private List<Long> orderIdList;

	//销售单明细IDList")
	private List<Long> saleOrderItemIdList;
	 //@DocField(value = "归档表后缀")
	private String dataAchiveTabSuffix;

	/**
	 * 已退货明细销售金额
	 */
	private BigDecimal retrunSendSaleFee;

	/**
	 * 已退货明细采购金额
	 */
	private BigDecimal retrunSendPurchaseFee;

	/**
	 * 发货明细销售金额
	 */
	private BigDecimal sendSaleFee;

	/**
	 * 发货明细采购金额
	 */
	private BigDecimal sendPurchaseFee;
}
