/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.base.config.thread;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.config.thread.DycThreadPoolExecutor;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.stereotype.Component;

@Component
public class SaasThreadPool {
    private static final Logger log = LoggerFactory.getLogger(SaasThreadPool.class);
    private ThreadPoolExecutor executor = null;
    @Value(value="${uoc.thread.corePoolSize:4}")
    int corePoolSize;
    @Value(value="${uoc.thread.maximumPoolSize:50}")
    int maximumPoolSize;
    @Value(value="${uoc.thread.keepAliveTime:60}")
    long keepAliveTime;
    @Value(value="${uoc.thread.blockingCapacity:100}")
    private int blockingCapacity;
    @Autowired
    private AutowireCapableBeanFactory beanFactory;

    @PostConstruct
    public void initThreadPoolExecutor() {
        if (ObjectUtil.isEmpty((Object)this.executor)) {
            log.info("saas\u521b\u5efa\u7ebf\u7a0b\u6c60\uff0c\u6838\u5fc3\uff1a{}\uff0c\u6700\u5927\u6838\u5fc3\uff1a{}", (Object)this.corePoolSize, (Object)this.maximumPoolSize);
            this.executor = new DycThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.blockingCapacity), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());
        }
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    public void executeRunnable(Runnable runnable) {
        if (runnable == null) {
            throw new BaseBusinessException("102001", "\u4f7f\u7528\u7ebf\u7a0b\u6c60\u521b\u5efa\u7ebf\u7a0b\u65f6\uff0c\u5165\u53c2Runnable\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.beanFactory.autowireBean((Object)runnable);
        this.executor.execute(runnable);
    }
}

