/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.base.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.constants.IncConstant;
import com.tydic.dyc.base.utils.bo.DycImportTemplateUtilBo;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ExcelReadUtil {
    public static final Integer PLUS = 1;
    public static final Integer MINUS = 2;

    public static List<JSONObject> readExcel(String url, String importTemplateStr, Integer isException) throws Exception {
        int i;
        ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>();
        URL excelUrl = new URL(url);
        Workbook workbook = ExcelReadUtil.getWorkBook(excelUrl.openStream(), url);
        ArrayList<String> title = new ArrayList<String>();
        Sheet sheet = workbook.getSheetAt(0);
        List templateBOs = JSON.parseArray((String)importTemplateStr, DycImportTemplateUtilBo.class);
        int end = templateBOs.size();
        ArrayList data = new ArrayList();
        int count = 0;
        for (Row row : sheet) {
            if (ExcelReadUtil.isBlankRow(row)) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (i = 0; i < end; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) {
                    arrayList.add("");
                    continue;
                }
                Object obj = ExcelReadUtil.getValue(cell);
                if (count == 0) {
                    title.add(String.valueOf(obj).trim());
                    continue;
                }
                if (count < 1) continue;
                arrayList.add(String.valueOf(obj).trim());
            }
            if (count >= 1) {
                data.add(arrayList);
            }
            ++count;
        }
        HashMap<String, Integer> dateMapIndex = new HashMap<String, Integer>();
        block2: for (DycImportTemplateUtilBo dycImportTemplateUtilBo : templateBOs) {
            for (i = 0; i < title.size(); ++i) {
                if (!((String)title.get(i)).equals(dycImportTemplateUtilBo.getFieldName())) continue;
                dateMapIndex.put(dycImportTemplateUtilBo.getFieldNameEng(), i);
                continue block2;
            }
        }
        for (List list : data) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("isError", (Object)false);
            for (DycImportTemplateUtilBo bo : templateBOs) {
                Integer sheetKey = (Integer)dateMapIndex.get(bo.getFieldNameEng());
                if (sheetKey == null || sheetKey >= list.size()) continue;
                String content = (String)list.get(sheetKey);
                if (bo.getIsMustFill().booleanValue()) {
                    if (null == content || "".equals(content) || "null".equals(content)) {
                        ExcelReadUtil.makeError(isException, jsonObject, "\u5bfc\u5165\u3010" + bo.getFieldName() + "\u3011\u5fc5\u586b\uff01");
                        break;
                    }
                } else if (null == content || "".equals(content) || "null".equals(content)) {
                    content = !StringUtils.isEmpty((Object)bo.getDefaultValue()) ? bo.getDefaultValue() : null;
                }
                if (!StringUtils.isEmpty((Object)content) && bo.getObjType() != null) {
                    if (PLUS.equals(bo.getObjType())) {
                        if (bo.getIsDecimal() != null) {
                            if (IncConstant.General.YES.equals(bo.getIsDecimal())) {
                                if (!ExcelReadUtil.isLegal(content, "^[0-9]*\\.?[0-9]+").booleanValue()) {
                                    ExcelReadUtil.makeError(isException, jsonObject, bo.getFieldName() + "\u975e\u6cd5\u8f93\u5165");
                                    break;
                                }
                            } else if (!ExcelReadUtil.isLegal(content, "[0-9]*").booleanValue()) {
                                ExcelReadUtil.makeError(isException, jsonObject, bo.getFieldName() + "\u975e\u6cd5\u8f93\u5165");
                                break;
                            }
                        } else if (!ExcelReadUtil.isLegal(content, "[0-9]*").booleanValue()) {
                            ExcelReadUtil.makeError(isException, jsonObject, bo.getFieldName() + "\u975e\u6cd5\u8f93\u5165");
                            break;
                        }
                        content = new BigDecimal(content).stripTrailingZeros().toPlainString();
                    } else if (MINUS.equals(bo.getObjType())) {
                        if (bo.getIsDecimal() != null) {
                            if (IncConstant.General.YES.equals(bo.getIsDecimal())) {
                                if (!ExcelReadUtil.isLegal(content, "^[-]?[0-9]*\\.?[0-9]+").booleanValue()) {
                                    ExcelReadUtil.makeError(isException, jsonObject, bo.getFieldName() + "\u5b58\u5728\u975e\u6cd5\u8f93\u5165");
                                    break;
                                }
                            } else if (!ExcelReadUtil.isLegal(content, "[-]?[0-9]*").booleanValue()) {
                                ExcelReadUtil.makeError(isException, jsonObject, bo.getFieldName() + "\u975e\u6cd5\u8f93\u5165");
                                break;
                            }
                        } else if (!ExcelReadUtil.isLegal(content, "[-]?[0-9]*").booleanValue()) {
                            ExcelReadUtil.makeError(isException, jsonObject, bo.getFieldName() + "\u975e\u6cd5\u8f93\u5165");
                            break;
                        }
                        content = new BigDecimal(content).stripTrailingZeros().toPlainString();
                    }
                }
                if (bo.getDigits() != null) {
                    content = ExcelReadUtil.formatNumber(content, bo.getDigits());
                }
                jsonObject.put(bo.getFieldNameEng(), (Object)content);
            }
            jsonObjectList.add(jsonObject);
        }
        if (CollectionUtils.isEmpty(jsonObjectList)) {
            throw new ZTBusinessException("\u5bfc\u5165\u7684\u5185\u5bb9\u4e3a\u7a7a");
        }
        return jsonObjectList;
    }

    public static boolean isBlankRow(Row row) {
        boolean isEmptyRow = true;
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            if (row.getCell(i) != null) {
                if (row.getCell(i).getCellType() == CellType.STRING && !"".equals(row.getCell(i).getStringCellValue())) {
                    isEmptyRow = false;
                    break;
                }
                if (row.getCell(i).getCellType() != CellType.BLANK) {
                    isEmptyRow = false;
                    break;
                }
            }
            if (!isEmptyRow) break;
        }
        return isEmptyRow;
    }

    public static Workbook getWorkBook(InputStream inputStream, String url) throws IOException {
        Object workbook = url.toLowerCase().endsWith("xls") ? new HSSFWorkbook(inputStream) : new XSSFWorkbook(inputStream);
        return workbook;
    }

    public static Object getValue(Cell cell) {
        Object obj = null;
        switch (cell.getCellTypeEnum()) {
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case ERROR: {
                obj = cell.getErrorCellValue();
                break;
            }
            case NUMERIC: {
                cell.setCellType(CellType.STRING);
                obj = cell.getStringCellValue();
                break;
            }
            case STRING: {
                obj = cell.getStringCellValue();
                break;
            }
            case FORMULA: {
                if (cell.getCachedFormulaResultType().equals((Object)CellType.FORMULA)) {
                    cell.setCellType(CellType.STRING);
                    obj = cell.getStringCellValue();
                    break;
                }
                if (!cell.getCachedFormulaResultType().equals((Object)CellType.STRING)) break;
                obj = cell.getStringCellValue();
                break;
            }
        }
        return obj;
    }

    public static Boolean isLegal(String content, String regex) {
        try {
            content = new BigDecimal(content).stripTrailingZeros().toPlainString();
        }
        catch (Exception e) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(content).matches();
    }

    public static void makeError(Integer isException, JSONObject jsonObject, String details) {
        if (IncConstant.General.YES.equals(isException)) {
            throw new ZTBusinessException(details);
        }
        jsonObject.put("isError", (Object)true);
        jsonObject.put("errorDetails", (Object)details);
    }

    public static String formatNumber(String content, Integer digits) {
        String str = String.valueOf(Math.pow(10.0, digits.intValue())).replace("1", "");
        DecimalFormat df = new DecimalFormat("0." + str);
        content = df.format(content);
        if (content.endsWith("." + str)) {
            content = content.substring(0, content.lastIndexOf("." + str));
        }
        return content;
    }
}

